# Generated by Django 3.2.12 on 2022-03-15 08:53

from django.db import migrations, models

try:
    from wagtail import __version__ as WAGTAIL_VERSION
    import wagtail.core.fields
except ImportError:
    WAGTAIL_VERSION = False


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='CookieConsentLog',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('consent_token', models.CharField(max_length=50, unique=True, verbose_name='Chiave consenso')),
                ('consent_url', models.URLField(verbose_name='Consenso Cookie Url')),
                ('consent_date_time', models.DateTimeField(auto_now_add=True, verbose_name='Data e Ora')),
                ('consent_user_agent', models.TextField(verbose_name='User Agent')),
                ('consent_anonymize_ip', models.CharField(max_length=20, verbose_name='IP Anonymize')),
                ('consent_cookie', models.TextField(verbose_name='Lista cookie accettati')),
            ],
            options={
                'verbose_name_plural': 'Cookie Log',
                'ordering': ['-consent_date_time'],
            },
        ),
        migrations.CreateModel(
            name='CookieScript',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('cookie_name', models.CharField(max_length=200, verbose_name='Nome')),
                ('cookie_type', models.IntegerField(choices=[(0, 'Tecnici/Necessari'), (1, 'Statistiche'), (2, 'Marketing')], default=1, verbose_name='Tipologia')),
                ('cookie_script', models.TextField(verbose_name='Script JS')),
            ],
            options={
                'verbose_name_plural': 'Cookie Scripts',
                'ordering': ['cookie_type'],
            },
        ),
    ]
