import setuptools
from setuptools import find_packages
from setuptools.command.build_py import build_py as build_py_orig
import pathlib


class CustomBuildPy(build_py_orig):
    """
    subclass build_py so that we collect no .py files inside the built pip package
    this is done by overriding build_packages method with a noop
    """
    def build_packages(self):
        pass


with open("README.md", "r") as fh:
    long_description = fh.read()


with open('./requirements.txt', 'r') as requirements:
    requirements_buffer = requirements.read().split("\n")

with open(str(pathlib.Path(__file__).parent.absolute()) + "/monolithcaching/version.py", "r") as fh:
    version = fh.read().split("=")[1].replace("'", "")


directives = {
    'language_level': 3,
    'always_allow_keywords': True
}

setuptools.setup(
    name="monolithcaching",
    version=version,
    author="Maxwell Flitton",
    author_email="maxwell@monolithai.com",
    description="Python package for monolithcaching",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/MonolithAILtd/caching",
    install_requires=requirements_buffer,
    packages=find_packages(exclude=("tests",)),
    classifiers=[
        "Development Status :: 4 - Beta",
        "Programming Language :: Python :: 3",
        "Operating System :: OS Independent",
    ],
    python_requires='>=3',
    tests_require=['pytest'],
    entry_points={
        'console_scripts': [
            'caching-hello = monolithcaching.console_commands.hello:print_logo',
        ],
    }
)
