# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2.1
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class DocumentSecurityStore(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, certificates=None, crls=None, ocsps=None):
        """
        DocumentSecurityStore - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'certificates': 'list[str]',
            'crls': 'list[str]',
            'ocsps': 'list[str]'
        }

        self.attribute_map = {
            'certificates': 'certificates',
            'crls': 'crls',
            'ocsps': 'ocsps'
        }

        self._certificates = certificates
        self._crls = crls
        self._ocsps = ocsps

    @property
    def certificates(self):
        """
        Gets the certificates of this DocumentSecurityStore.
        

        :return: The certificates of this DocumentSecurityStore.
        :rtype: list[str]
        """
        return self._certificates

    @certificates.setter
    def certificates(self, certificates):
        """
        Sets the certificates of this DocumentSecurityStore.
        

        :param certificates: The certificates of this DocumentSecurityStore.
        :type: list[str]
        """

        self._certificates = certificates

    @property
    def crls(self):
        """
        Gets the crls of this DocumentSecurityStore.
        

        :return: The crls of this DocumentSecurityStore.
        :rtype: list[str]
        """
        return self._crls

    @crls.setter
    def crls(self, crls):
        """
        Sets the crls of this DocumentSecurityStore.
        

        :param crls: The crls of this DocumentSecurityStore.
        :type: list[str]
        """

        self._crls = crls

    @property
    def ocsps(self):
        """
        Gets the ocsps of this DocumentSecurityStore.
        

        :return: The ocsps of this DocumentSecurityStore.
        :rtype: list[str]
        """
        return self._ocsps

    @ocsps.setter
    def ocsps(self, ocsps):
        """
        Sets the ocsps of this DocumentSecurityStore.
        

        :param ocsps: The ocsps of this DocumentSecurityStore.
        :type: list[str]
        """

        self._ocsps = ocsps

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
