# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': '.'}

packages = \
['lm_scorer',
 'lm_scorer.bin',
 'lm_scorer.models',
 'lm_scorer.models.abc',
 'tests',
 'tests.integration',
 'tests.unit',
 'tests.unit.models',
 'tests.unit.models.abc']

package_data = \
{'': ['*']}

install_requires = \
['pip>=20.0.0', 'torch>=1.4.0,<2.0.0', 'transformers>=2.9.0,<3.0.0']

entry_points = \
{'console_scripts': ['lm-scorer = lm_scorer.bin.cli:run']}

setup_kwargs = {
    'name': 'lm-scorer',
    'version': '0.4.0',
    'description': 'Language Model based sentences scoring library',
    'long_description': '<h1 align="center">\n  <b>lm-scorer</b>\n</h1>\n<p align="center">\n  <!-- PyPi -->\n  <a href="https://pypi.org/project/lm-scorer">\n    <img src="https://img.shields.io/pypi/v/lm-scorer.svg" alt="PyPi version" />\n  </a>\n  <a href="https://colab.research.google.com/github/simonepri/lm-scorer/blob/master/examples/lm_scorer.ipynb">\n    <img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open in Colab" />\n  </a>\n  <br />\n  <!-- Lint -->\n  <a href="https://github.com/simonepri/lm-scorer/actions?query=workflow:lint+branch:master">\n    <img src="https://github.com/simonepri/lm-scorer/workflows/lint/badge.svg?branch=master" alt="Lint status" />\n  </a>\n  <!-- Test - macOS -->\n  <a href="https://github.com/simonepri/lm-scorer/actions?query=workflow:test-macos+branch:master">\n    <img src="https://github.com/simonepri/lm-scorer/workflows/test-macos/badge.svg?branch=master" alt="Test macOS status" />\n  </a>\n  <!-- Test - Ubuntu -->\n  <a href="https://github.com/simonepri/lm-scorer/actions?query=workflow:test-ubuntu+branch:master">\n    <img src="https://github.com/simonepri/lm-scorer/workflows/test-ubuntu/badge.svg?branch=master" alt="Test Ubuntu status" />\n  </a>\n  <br />\n  <!-- Code style -->\n  <a href="https://github.com/ambv/black">\n    <img src="https://img.shields.io/badge/code%20style-black-000000.svg" alt="Code style" />\n  </a>\n  <!-- Linter -->\n  <a href="https://github.com/PyCQA/pylint">\n    <img src="https://img.shields.io/badge/linter-pylint-ce963f.svg" alt="Linter" />\n  </a>\n  <!-- Types checker -->\n  <a href="https://github.com/PyCQA/pylint">\n    <img src="https://img.shields.io/badge/types%20checker-mypy-296db2.svg" alt="Types checker" />\n  </a>\n  <!-- Test runner -->\n  <a href="https://github.com/pytest-dev/pytest">\n    <img src="https://img.shields.io/badge/test%20runner-pytest-449bd6.svg" alt="Test runner" />\n  </a>\n  <!-- Task runner -->\n  <a href="https://github.com/illBeRoy/taskipy">\n    <img src="https://img.shields.io/badge/task%20runner-taskipy-abe63e.svg" alt="Task runner" />\n  </a>\n  <!-- Build tool -->\n  <a href="https://github.com/python-poetry/poetry">\n    <img src="https://img.shields.io/badge/build%20system-poetry-4e5dc8.svg" alt="Build tool" />\n  </a>\n  <br />\n  <!-- License -->\n  <a href="https://github.com/simonepri/lm-scorer/tree/master/license">\n    <img src="https://img.shields.io/github/license/simonepri/lm-scorer.svg" alt="Project license" />\n  </a>\n</p>\n<p align="center">\n  📃 Language Model based sentences scoring library\n</p>\n\n## Synopsis\n\nThis package provides a simple programming interface to score sentences using different ML [language models](wiki:language-model).\n\nA simple [CLI](#cli) is also available for quick prototyping.  \nYou can run it locally or on directly on Colab using [this notebook][colab:lm-scorer].\n\nDo you believe that this is *useful*?\nHas it *saved you time*?\nOr maybe you simply *like it*?  \nIf so, [support this work with a Star ⭐️][start].\n\n## Install\n\n```bash\npip install lm-scorer\n```\n\n## Usage\n\n```python\nimport torch\nfrom lm_scorer.models.auto import AutoLMScorer as LMScorer\n\n# Available models\nlist(LMScorer.supported_model_names())\n# => ["gpt2", "gpt2-medium", "gpt2-large", "gpt2-xl", distilgpt2"]\n\n# Load model to cpu or cuda\ndevice = "cuda:0" if torch.cuda.is_available() else "cpu"\nscorer = LMScorer.from_pretrained("gpt2", device=device)\n\n# Return token probabilities (provide log=True to return log probabilities)\nscorer.tokens_score("I like this package.")\n# => (scores, ids, tokens)\n# scores = [0.018321, 0.0066431, 0.080633, 0.00060745, 0.27772, 0.0036381]\n# ids    = [40,       588,       428,      5301,       13,      50256]\n# tokens = ["I",      "Ġlike",   "Ġthis",  "Ġpackage", ".",     "<|endoftext|>"]\n\n# Compute sentence score as the product of tokens\' probabilities\nscorer.sentence_score("I like this package.", reduce="prod")\n# => 6.0231e-12\n\n# Compute sentence score as the mean of tokens\' probabilities\nscorer.sentence_score("I like this package.", reduce="mean")\n# => 0.064593\n\n# Compute sentence score as the geometric mean of tokens\' probabilities\nscorer.sentence_score("I like this package.", reduce="gmean")\n# => 0.013489\n\n# Compute sentence score as the harmonic mean of tokens\' probabilities\nscorer.sentence_score("I like this package.", reduce="hmean")\n# => 0.0028008\n\n# NB: Computations are done in log space so they should be numerically stable.\n```\n\n## CLI\n\n<img src="https://github.com/simonepri/lm-scorer/raw/master/media/cli.gif" alt="lm-scorer cli" width="225" align="right"/>\n\nThe pip package includes a CLI that you can use to score sentences.\n\n```\nusage: lm-scorer [-h] [--model-name MODEL_NAME] [--tokens] [--log-prob]\n                 [--reduce REDUCE] [--cuda CUDA] [--debug]\n                 sentences-file-path\n\nGet sentences probability using a language model.\n\npositional arguments:\n  sentences-file-path   A file containing sentences to score, one per line. If\n                        - is given as filename it reads from stdin instead.\n\noptional arguments:\n  -h, --help            show this help message and exit\n  --model-name MODEL_NAME, -m MODEL_NAME\n                        The pretrained language model to use. Can be one of:\n                        gpt2, gpt2-medium, gpt2-large, gpt2-xl, distilgpt2.\n  --tokens, -t          If provided it provides the probability of each token\n                        of each sentence.\n  --log-prob, -lp       If provided log probabilities are returned instead.\n  --reduce REDUCE, -r REDUCE\n                        Reduce strategy applied on token probabilities to get\n                        the sentence score. Available strategies are: prod,\n                        mean, gmean, hmean.\n  --cuda CUDA           If provided it runs the model on the given cuda\n                        device.\n  --debug               If provided it provides additional logging in case of\n                        errors.\n```\n\n\n## Development\n\nYou can install this library locally for development using the commands below.\nIf you don\'t have it already, you need to install [poetry](https://python-poetry.org/docs/#installation) first.\n\n```bash\n#\xa0Clone the repo\ngit clone https://github.com/simonepri/lm-scorer\n#\xa0CD into the created folder\ncd lm-scorer\n# Create a virtualenv and install the required dependencies using poetry\npoetry install\n```\n\nYou can then run commands inside the virtualenv by using `poetry run COMMAND`.  \nAlternatively, you can open a shell inside the virtualenv using `poetry shell`.\n\n\nIf you wish to contribute to this project, run the following commands locally before opening a PR and check that no error is reported (warnings are fine).\n\n```bash\n# Run the code formatter\npoetry run task format\n# Run the linter\npoetry run task lint\n# Run the static type checker\npoetry run task types\n# Run the tests\npoetry run task test\n```\n\n\n## Authors\n\n- **Simone Primarosa** - [simonepri][github:simonepri]\n\nSee also the list of [contributors][contributors] who participated in this project.\n\n\n## License\n\nThis project is licensed under the MIT License - see the [license][license] file for details.\n\n\n\n<!-- Links -->\n\n[start]: https://github.com/simonepri/lm-scorer#start-of-content\n[license]: https://github.com/simonepri/lm-scorer/tree/master/license\n[contributors]: https://github.com/simonepri/lm-scorer/contributors\n\n[colab:lm-scorer]: https://colab.research.google.com/github/simonepri/lm-scorer/blob/master/examples/lm_scorer.ipynb\n\n[wiki:language-model]: https://en.wikipedia.org/wiki/Language_model\n\n[github:simonepri]: https://github.com/simonepri\n',
    'author': 'Simone Primarosa',
    'author_email': 'simonepri@outlook.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/simonepri/lm-scorer#readme',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<3.8',
}


setup(**setup_kwargs)
