# DO NOT EDIT! This file is automatically generated
import datetime
import typing

from commercetools.types._abstract import _BaseType
from commercetools.types._common import (
    BaseResource,
    Reference,
    ReferenceTypeId,
    ResourceIdentifier,
)
from commercetools.types._order import Order, StagedOrderUpdateAction

if typing.TYPE_CHECKING:
    from ._cart import (
        CartOrigin,
        CartReference,
        CustomLineItem,
        DiscountCodeInfo,
        ExternalLineItemTotalPrice,
        ExternalTaxAmountDraft,
        ExternalTaxRateDraft,
        InventoryMode,
        ItemShippingDetailsDraft,
        LineItem,
        RoundingMode,
        ShippingInfo,
        ShippingRateInput,
        ShippingRateInputDraft,
        TaxCalculationMode,
        TaxedPrice,
        TaxMode,
        TaxPortionDraft,
    )
    from ._cart_discount import CartDiscountReference
    from ._channel import ChannelResourceIdentifier
    from ._common import (
        Address,
        CreatedBy,
        LastModifiedBy,
        LocalizedString,
        Money,
        TypedMoney,
    )
    from ._customer_group import CustomerGroupReference, CustomerGroupResourceIdentifier
    from ._discount_code import DiscountCodeReference
    from ._error import ErrorObject
    from ._message import MessagePayload
    from ._order import (
        DeliveryItem,
        ItemState,
        OrderReference,
        OrderState,
        ParcelDraft,
        ParcelMeasurements,
        PaymentInfo,
        PaymentState,
        ReturnInfo,
        ReturnItemDraft,
        ReturnPaymentState,
        ReturnShipmentState,
        ShipmentState,
        SyncInfo,
        TrackingData,
    )
    from ._payment import PaymentResourceIdentifier
    from ._shipping_method import ShippingMethodResourceIdentifier, ShippingRateDraft
    from ._shopping_list import ShoppingListResourceIdentifier
    from ._state import StateReference, StateResourceIdentifier
    from ._store import StoreKeyReference
    from ._tax_category import TaxCategoryResourceIdentifier
    from ._type import (
        CustomFields,
        CustomFieldsDraft,
        FieldContainer,
        TypeResourceIdentifier,
    )
__all__ = [
    "OrderEdit",
    "OrderEditAddStagedActionAction",
    "OrderEditApplied",
    "OrderEditApply",
    "OrderEditDraft",
    "OrderEditNotProcessed",
    "OrderEditPagedQueryResponse",
    "OrderEditPreviewFailure",
    "OrderEditPreviewSuccess",
    "OrderEditReference",
    "OrderEditResourceIdentifier",
    "OrderEditResult",
    "OrderEditSetCommentAction",
    "OrderEditSetCustomFieldAction",
    "OrderEditSetCustomTypeAction",
    "OrderEditSetKeyAction",
    "OrderEditSetStagedActionsAction",
    "OrderEditUpdate",
    "OrderEditUpdateAction",
    "OrderExcerpt",
    "StagedOrder",
    "StagedOrderAddCustomLineItemAction",
    "StagedOrderAddDeliveryAction",
    "StagedOrderAddDiscountCodeAction",
    "StagedOrderAddItemShippingAddressAction",
    "StagedOrderAddLineItemAction",
    "StagedOrderAddParcelToDeliveryAction",
    "StagedOrderAddPaymentAction",
    "StagedOrderAddReturnInfoAction",
    "StagedOrderAddShoppingListAction",
    "StagedOrderChangeCustomLineItemMoneyAction",
    "StagedOrderChangeCustomLineItemQuantityAction",
    "StagedOrderChangeLineItemQuantityAction",
    "StagedOrderChangeOrderStateAction",
    "StagedOrderChangePaymentStateAction",
    "StagedOrderChangeShipmentStateAction",
    "StagedOrderChangeTaxCalculationModeAction",
    "StagedOrderChangeTaxModeAction",
    "StagedOrderChangeTaxRoundingModeAction",
    "StagedOrderImportCustomLineItemStateAction",
    "StagedOrderImportLineItemStateAction",
    "StagedOrderRemoveCustomLineItemAction",
    "StagedOrderRemoveDeliveryAction",
    "StagedOrderRemoveDiscountCodeAction",
    "StagedOrderRemoveItemShippingAddressAction",
    "StagedOrderRemoveLineItemAction",
    "StagedOrderRemoveParcelFromDeliveryAction",
    "StagedOrderRemovePaymentAction",
    "StagedOrderSetBillingAddressAction",
    "StagedOrderSetCountryAction",
    "StagedOrderSetCustomFieldAction",
    "StagedOrderSetCustomLineItemCustomFieldAction",
    "StagedOrderSetCustomLineItemCustomTypeAction",
    "StagedOrderSetCustomLineItemShippingDetailsAction",
    "StagedOrderSetCustomLineItemTaxAmountAction",
    "StagedOrderSetCustomLineItemTaxRateAction",
    "StagedOrderSetCustomShippingMethodAction",
    "StagedOrderSetCustomTypeAction",
    "StagedOrderSetCustomerEmailAction",
    "StagedOrderSetCustomerGroupAction",
    "StagedOrderSetCustomerIdAction",
    "StagedOrderSetDeliveryAddressAction",
    "StagedOrderSetDeliveryItemsAction",
    "StagedOrderSetLineItemCustomFieldAction",
    "StagedOrderSetLineItemCustomTypeAction",
    "StagedOrderSetLineItemPriceAction",
    "StagedOrderSetLineItemShippingDetailsAction",
    "StagedOrderSetLineItemTaxAmountAction",
    "StagedOrderSetLineItemTaxRateAction",
    "StagedOrderSetLineItemTotalPriceAction",
    "StagedOrderSetLocaleAction",
    "StagedOrderSetOrderNumberAction",
    "StagedOrderSetOrderTotalTaxAction",
    "StagedOrderSetParcelItemsAction",
    "StagedOrderSetParcelMeasurementsAction",
    "StagedOrderSetParcelTrackingDataAction",
    "StagedOrderSetReturnPaymentStateAction",
    "StagedOrderSetReturnShipmentStateAction",
    "StagedOrderSetShippingAddressAction",
    "StagedOrderSetShippingAddressAndCustomShippingMethodAction",
    "StagedOrderSetShippingAddressAndShippingMethodAction",
    "StagedOrderSetShippingMethodAction",
    "StagedOrderSetShippingMethodTaxAmountAction",
    "StagedOrderSetShippingMethodTaxRateAction",
    "StagedOrderSetShippingRateInputAction",
    "StagedOrderTransitionCustomLineItemStateAction",
    "StagedOrderTransitionLineItemStateAction",
    "StagedOrderTransitionStateAction",
    "StagedOrderUpdateItemShippingAddressAction",
    "StagedOrderUpdateSyncInfoAction",
]


class OrderEdit(BaseResource):
    #: :class:`str`
    id: str
    #: :class:`int`
    version: int
    #: :class:`datetime.datetime` `(Named` ``createdAt`` `in Commercetools)`
    created_at: datetime.datetime
    #: :class:`datetime.datetime` `(Named` ``lastModifiedAt`` `in Commercetools)`
    last_modified_at: datetime.datetime
    #: Optional :class:`commercetools.types.LastModifiedBy` `(Named` ``lastModifiedBy`` `in Commercetools)`
    last_modified_by: typing.Optional["LastModifiedBy"]
    #: Optional :class:`commercetools.types.CreatedBy` `(Named` ``createdBy`` `in Commercetools)`
    created_by: typing.Optional["CreatedBy"]
    #: Optional :class:`str`
    key: typing.Optional[str]
    #: :class:`commercetools.types.OrderReference`
    resource: "OrderReference"
    #: List of :class:`commercetools.types.StagedOrderUpdateAction` `(Named` ``stagedActions`` `in Commercetools)`
    staged_actions: typing.List["StagedOrderUpdateAction"]
    #: Optional :class:`commercetools.types.CustomFields`
    custom: typing.Optional["CustomFields"]
    #: :class:`commercetools.types.OrderEditResult`
    result: "OrderEditResult"
    #: Optional :class:`str`
    comment: typing.Optional[str]

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        resource: "OrderReference",
        staged_actions: typing.List["StagedOrderUpdateAction"],
        result: "OrderEditResult",
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        key: typing.Optional[str] = None,
        custom: typing.Optional["CustomFields"] = None,
        comment: typing.Optional[str] = None
    ) -> None:
        self.id = id
        self.version = version
        self.created_at = created_at
        self.last_modified_at = last_modified_at
        self.last_modified_by = last_modified_by
        self.created_by = created_by
        self.key = key
        self.resource = resource
        self.staged_actions = staged_actions
        self.custom = custom
        self.result = result
        self.comment = comment
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
        )

    def __repr__(self) -> str:
        return (
            "OrderEdit(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, key=%r, resource=%r, staged_actions=%r, custom=%r, result=%r, comment=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.key,
                self.resource,
                self.staged_actions,
                self.custom,
                self.result,
                self.comment,
            )
        )


class OrderEditApply(_BaseType):
    #: :class:`int` `(Named` ``editVersion`` `in Commercetools)`
    edit_version: int
    #: :class:`int` `(Named` ``resourceVersion`` `in Commercetools)`
    resource_version: int

    def __init__(self, *, edit_version: int, resource_version: int) -> None:
        self.edit_version = edit_version
        self.resource_version = resource_version
        super().__init__()

    def __repr__(self) -> str:
        return "OrderEditApply(edit_version=%r, resource_version=%r)" % (
            self.edit_version,
            self.resource_version,
        )


class OrderEditDraft(_BaseType):
    #: Optional :class:`str`
    key: typing.Optional[str]
    #: :class:`commercetools.types.OrderReference`
    resource: "OrderReference"
    #: Optional list of :class:`commercetools.types.StagedOrderUpdateAction` `(Named` ``stagedActions`` `in Commercetools)`
    staged_actions: typing.Optional[typing.List["StagedOrderUpdateAction"]]
    #: Optional :class:`commercetools.types.CustomFieldsDraft`
    custom: typing.Optional["CustomFieldsDraft"]
    #: Optional :class:`str`
    comment: typing.Optional[str]
    #: Optional :class:`bool` `(Named` ``dryRun`` `in Commercetools)`
    dry_run: typing.Optional[bool]

    def __init__(
        self,
        *,
        resource: "OrderReference",
        key: typing.Optional[str] = None,
        staged_actions: typing.Optional[typing.List["StagedOrderUpdateAction"]] = None,
        custom: typing.Optional["CustomFieldsDraft"] = None,
        comment: typing.Optional[str] = None,
        dry_run: typing.Optional[bool] = None
    ) -> None:
        self.key = key
        self.resource = resource
        self.staged_actions = staged_actions
        self.custom = custom
        self.comment = comment
        self.dry_run = dry_run
        super().__init__()

    def __repr__(self) -> str:
        return (
            "OrderEditDraft(key=%r, resource=%r, staged_actions=%r, custom=%r, comment=%r, dry_run=%r)"
            % (
                self.key,
                self.resource,
                self.staged_actions,
                self.custom,
                self.comment,
                self.dry_run,
            )
        )


class OrderEditPagedQueryResponse(_BaseType):
    #: :class:`int`
    limit: int
    #: :class:`int`
    count: int
    #: Optional :class:`int`
    total: typing.Optional[int]
    #: :class:`int`
    offset: int
    #: List of :class:`commercetools.types.OrderEdit`
    results: typing.Sequence["OrderEdit"]

    def __init__(
        self,
        *,
        limit: int,
        count: int,
        offset: int,
        results: typing.Sequence["OrderEdit"],
        total: typing.Optional[int] = None
    ) -> None:
        self.limit = limit
        self.count = count
        self.total = total
        self.offset = offset
        self.results = results
        super().__init__()

    def __repr__(self) -> str:
        return (
            "OrderEditPagedQueryResponse(limit=%r, count=%r, total=%r, offset=%r, results=%r)"
            % (self.limit, self.count, self.total, self.offset, self.results)
        )


class OrderEditReference(Reference):
    #: Optional :class:`commercetools.types.OrderEdit`
    obj: typing.Optional["OrderEdit"]

    def __init__(self, *, id: str, obj: typing.Optional["OrderEdit"] = None) -> None:
        self.obj = obj
        super().__init__(type_id=ReferenceTypeId.ORDER_EDIT, id=id)

    def __repr__(self) -> str:
        return "OrderEditReference(type_id=%r, id=%r, obj=%r)" % (
            self.type_id,
            self.id,
            self.obj,
        )


class OrderEditResourceIdentifier(ResourceIdentifier):
    def __init__(
        self, *, id: typing.Optional[str] = None, key: typing.Optional[str] = None
    ) -> None:
        super().__init__(type_id=ReferenceTypeId.ORDER_EDIT, id=id, key=key)

    def __repr__(self) -> str:
        return "OrderEditResourceIdentifier(type_id=%r, id=%r, key=%r)" % (
            self.type_id,
            self.id,
            self.key,
        )


class OrderEditResult(_BaseType):
    #: :class:`str`
    type: str

    def __init__(self, *, type: str) -> None:
        self.type = type
        super().__init__()

    def __repr__(self) -> str:
        return "OrderEditResult(type=%r)" % (self.type,)


class OrderEditUpdate(_BaseType):
    #: :class:`int`
    version: int
    #: List of :class:`commercetools.types.OrderEditUpdateAction`
    actions: typing.List["OrderEditUpdateAction"]
    #: Optional :class:`bool` `(Named` ``dryRun`` `in Commercetools)`
    dry_run: typing.Optional[bool]

    def __init__(
        self,
        *,
        version: int,
        actions: typing.List["OrderEditUpdateAction"],
        dry_run: typing.Optional[bool] = None
    ) -> None:
        self.version = version
        self.actions = actions
        self.dry_run = dry_run
        super().__init__()

    def __repr__(self) -> str:
        return "OrderEditUpdate(version=%r, actions=%r, dry_run=%r)" % (
            self.version,
            self.actions,
            self.dry_run,
        )


class OrderEditUpdateAction(_BaseType):
    #: :class:`str`
    action: str

    def __init__(self, *, action: str) -> None:
        self.action = action
        super().__init__()

    def __repr__(self) -> str:
        return "OrderEditUpdateAction(action=%r)" % (self.action,)


class OrderExcerpt(_BaseType):
    #: :class:`commercetools.types.TypedMoney` `(Named` ``totalPrice`` `in Commercetools)`
    total_price: "TypedMoney"
    #: Optional :class:`commercetools.types.TaxedPrice` `(Named` ``taxedPrice`` `in Commercetools)`
    taxed_price: typing.Optional["TaxedPrice"]
    #: :class:`int`
    version: int

    def __init__(
        self,
        *,
        total_price: "TypedMoney",
        version: int,
        taxed_price: typing.Optional["TaxedPrice"] = None
    ) -> None:
        self.total_price = total_price
        self.taxed_price = taxed_price
        self.version = version
        super().__init__()

    def __repr__(self) -> str:
        return "OrderExcerpt(total_price=%r, taxed_price=%r, version=%r)" % (
            self.total_price,
            self.taxed_price,
            self.version,
        )


class StagedOrder(Order):
    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        line_items: typing.List["LineItem"],
        custom_line_items: typing.List["CustomLineItem"],
        total_price: "TypedMoney",
        order_state: "OrderState",
        sync_info: typing.List["SyncInfo"],
        last_message_sequence_number: int,
        origin: "CartOrigin",
        refused_gifts: typing.List["CartDiscountReference"],
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        completed_at: typing.Optional[datetime.datetime] = None,
        order_number: typing.Optional[str] = None,
        customer_id: typing.Optional[str] = None,
        customer_email: typing.Optional[str] = None,
        anonymous_id: typing.Optional[str] = None,
        store: typing.Optional["StoreKeyReference"] = None,
        taxed_price: typing.Optional["TaxedPrice"] = None,
        shipping_address: typing.Optional["Address"] = None,
        billing_address: typing.Optional["Address"] = None,
        tax_mode: typing.Optional["TaxMode"] = None,
        tax_rounding_mode: typing.Optional["RoundingMode"] = None,
        customer_group: typing.Optional["CustomerGroupReference"] = None,
        country: typing.Optional[str] = None,
        state: typing.Optional["StateReference"] = None,
        shipment_state: typing.Optional["ShipmentState"] = None,
        payment_state: typing.Optional["PaymentState"] = None,
        shipping_info: typing.Optional["ShippingInfo"] = None,
        return_info: typing.Optional[typing.List["ReturnInfo"]] = None,
        discount_codes: typing.Optional[typing.List["DiscountCodeInfo"]] = None,
        cart: typing.Optional["CartReference"] = None,
        custom: typing.Optional["CustomFields"] = None,
        payment_info: typing.Optional["PaymentInfo"] = None,
        locale: typing.Optional[str] = None,
        inventory_mode: typing.Optional["InventoryMode"] = None,
        tax_calculation_mode: typing.Optional["TaxCalculationMode"] = None,
        shipping_rate_input: typing.Optional["ShippingRateInput"] = None,
        item_shipping_addresses: typing.Optional[typing.List["Address"]] = None
    ) -> None:
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            completed_at=completed_at,
            order_number=order_number,
            customer_id=customer_id,
            customer_email=customer_email,
            anonymous_id=anonymous_id,
            store=store,
            line_items=line_items,
            custom_line_items=custom_line_items,
            total_price=total_price,
            taxed_price=taxed_price,
            shipping_address=shipping_address,
            billing_address=billing_address,
            tax_mode=tax_mode,
            tax_rounding_mode=tax_rounding_mode,
            customer_group=customer_group,
            country=country,
            order_state=order_state,
            state=state,
            shipment_state=shipment_state,
            payment_state=payment_state,
            shipping_info=shipping_info,
            sync_info=sync_info,
            return_info=return_info,
            discount_codes=discount_codes,
            last_message_sequence_number=last_message_sequence_number,
            cart=cart,
            custom=custom,
            payment_info=payment_info,
            locale=locale,
            inventory_mode=inventory_mode,
            origin=origin,
            tax_calculation_mode=tax_calculation_mode,
            shipping_rate_input=shipping_rate_input,
            item_shipping_addresses=item_shipping_addresses,
            refused_gifts=refused_gifts,
        )

    def __repr__(self) -> str:
        return (
            "StagedOrder(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, completed_at=%r, order_number=%r, customer_id=%r, customer_email=%r, anonymous_id=%r, store=%r, line_items=%r, custom_line_items=%r, total_price=%r, taxed_price=%r, shipping_address=%r, billing_address=%r, tax_mode=%r, tax_rounding_mode=%r, customer_group=%r, country=%r, order_state=%r, state=%r, shipment_state=%r, payment_state=%r, shipping_info=%r, sync_info=%r, return_info=%r, discount_codes=%r, last_message_sequence_number=%r, cart=%r, custom=%r, payment_info=%r, locale=%r, inventory_mode=%r, origin=%r, tax_calculation_mode=%r, shipping_rate_input=%r, item_shipping_addresses=%r, refused_gifts=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.completed_at,
                self.order_number,
                self.customer_id,
                self.customer_email,
                self.anonymous_id,
                self.store,
                self.line_items,
                self.custom_line_items,
                self.total_price,
                self.taxed_price,
                self.shipping_address,
                self.billing_address,
                self.tax_mode,
                self.tax_rounding_mode,
                self.customer_group,
                self.country,
                self.order_state,
                self.state,
                self.shipment_state,
                self.payment_state,
                self.shipping_info,
                self.sync_info,
                self.return_info,
                self.discount_codes,
                self.last_message_sequence_number,
                self.cart,
                self.custom,
                self.payment_info,
                self.locale,
                self.inventory_mode,
                self.origin,
                self.tax_calculation_mode,
                self.shipping_rate_input,
                self.item_shipping_addresses,
                self.refused_gifts,
            )
        )


class StagedOrderAddCustomLineItemAction(StagedOrderUpdateAction):
    #: :class:`commercetools.types.Money`
    money: "Money"
    #: :class:`commercetools.types.LocalizedString`
    name: "LocalizedString"
    #: Optional :class:`int`
    quantity: typing.Optional[int]
    #: :class:`str`
    slug: str
    #: Optional :class:`commercetools.types.TaxCategoryResourceIdentifier` `(Named` ``taxCategory`` `in Commercetools)`
    tax_category: typing.Optional["TaxCategoryResourceIdentifier"]
    #: Optional :class:`commercetools.types.CustomFieldsDraft`
    custom: typing.Optional["CustomFieldsDraft"]
    #: Optional :class:`commercetools.types.ExternalTaxRateDraft` `(Named` ``externalTaxRate`` `in Commercetools)`
    external_tax_rate: typing.Optional["ExternalTaxRateDraft"]

    def __init__(
        self,
        *,
        money: "Money",
        name: "LocalizedString",
        slug: str,
        quantity: typing.Optional[int] = None,
        tax_category: typing.Optional["TaxCategoryResourceIdentifier"] = None,
        custom: typing.Optional["CustomFieldsDraft"] = None,
        external_tax_rate: typing.Optional["ExternalTaxRateDraft"] = None
    ) -> None:
        self.money = money
        self.name = name
        self.quantity = quantity
        self.slug = slug
        self.tax_category = tax_category
        self.custom = custom
        self.external_tax_rate = external_tax_rate
        super().__init__(action="addCustomLineItem")

    def __repr__(self) -> str:
        return (
            "StagedOrderAddCustomLineItemAction(action=%r, money=%r, name=%r, quantity=%r, slug=%r, tax_category=%r, custom=%r, external_tax_rate=%r)"
            % (
                self.action,
                self.money,
                self.name,
                self.quantity,
                self.slug,
                self.tax_category,
                self.custom,
                self.external_tax_rate,
            )
        )


class StagedOrderAddDeliveryAction(StagedOrderUpdateAction):
    #: Optional list of :class:`commercetools.types.DeliveryItem`
    items: typing.Optional[typing.List["DeliveryItem"]]
    #: Optional :class:`commercetools.types.Address`
    address: typing.Optional["Address"]
    #: Optional list of :class:`commercetools.types.ParcelDraft`
    parcels: typing.Optional[typing.List["ParcelDraft"]]

    def __init__(
        self,
        *,
        items: typing.Optional[typing.List["DeliveryItem"]] = None,
        address: typing.Optional["Address"] = None,
        parcels: typing.Optional[typing.List["ParcelDraft"]] = None
    ) -> None:
        self.items = items
        self.address = address
        self.parcels = parcels
        super().__init__(action="addDelivery")

    def __repr__(self) -> str:
        return (
            "StagedOrderAddDeliveryAction(action=%r, items=%r, address=%r, parcels=%r)"
            % (self.action, self.items, self.address, self.parcels)
        )


class StagedOrderAddDiscountCodeAction(StagedOrderUpdateAction):
    #: :class:`str`
    code: str

    def __init__(self, *, code: str) -> None:
        self.code = code
        super().__init__(action="addDiscountCode")

    def __repr__(self) -> str:
        return "StagedOrderAddDiscountCodeAction(action=%r, code=%r)" % (
            self.action,
            self.code,
        )


class StagedOrderAddItemShippingAddressAction(StagedOrderUpdateAction):
    #: :class:`commercetools.types.Address`
    address: "Address"

    def __init__(self, *, address: "Address") -> None:
        self.address = address
        super().__init__(action="addItemShippingAddress")

    def __repr__(self) -> str:
        return "StagedOrderAddItemShippingAddressAction(action=%r, address=%r)" % (
            self.action,
            self.address,
        )


class StagedOrderAddLineItemAction(StagedOrderUpdateAction):
    #: Optional :class:`commercetools.types.CustomFieldsDraft`
    custom: typing.Optional["CustomFieldsDraft"]
    #: Optional :class:`commercetools.types.ChannelResourceIdentifier` `(Named` ``distributionChannel`` `in Commercetools)`
    distribution_channel: typing.Optional["ChannelResourceIdentifier"]
    #: Optional :class:`commercetools.types.ExternalTaxRateDraft` `(Named` ``externalTaxRate`` `in Commercetools)`
    external_tax_rate: typing.Optional["ExternalTaxRateDraft"]
    #: Optional :class:`str` `(Named` ``productId`` `in Commercetools)`
    product_id: typing.Optional[str]
    #: Optional :class:`int` `(Named` ``variantId`` `in Commercetools)`
    variant_id: typing.Optional[int]
    #: Optional :class:`str`
    sku: typing.Optional[str]
    #: Optional :class:`int`
    quantity: typing.Optional[int]
    #: Optional :class:`commercetools.types.ChannelResourceIdentifier` `(Named` ``supplyChannel`` `in Commercetools)`
    supply_channel: typing.Optional["ChannelResourceIdentifier"]
    #: Optional :class:`commercetools.types.Money` `(Named` ``externalPrice`` `in Commercetools)`
    external_price: typing.Optional["Money"]
    #: Optional :class:`commercetools.types.ExternalLineItemTotalPrice` `(Named` ``externalTotalPrice`` `in Commercetools)`
    external_total_price: typing.Optional["ExternalLineItemTotalPrice"]
    #: Optional :class:`commercetools.types.ItemShippingDetailsDraft` `(Named` ``shippingDetails`` `in Commercetools)`
    shipping_details: typing.Optional["ItemShippingDetailsDraft"]

    def __init__(
        self,
        *,
        custom: typing.Optional["CustomFieldsDraft"] = None,
        distribution_channel: typing.Optional["ChannelResourceIdentifier"] = None,
        external_tax_rate: typing.Optional["ExternalTaxRateDraft"] = None,
        product_id: typing.Optional[str] = None,
        variant_id: typing.Optional[int] = None,
        sku: typing.Optional[str] = None,
        quantity: typing.Optional[int] = None,
        supply_channel: typing.Optional["ChannelResourceIdentifier"] = None,
        external_price: typing.Optional["Money"] = None,
        external_total_price: typing.Optional["ExternalLineItemTotalPrice"] = None,
        shipping_details: typing.Optional["ItemShippingDetailsDraft"] = None
    ) -> None:
        self.custom = custom
        self.distribution_channel = distribution_channel
        self.external_tax_rate = external_tax_rate
        self.product_id = product_id
        self.variant_id = variant_id
        self.sku = sku
        self.quantity = quantity
        self.supply_channel = supply_channel
        self.external_price = external_price
        self.external_total_price = external_total_price
        self.shipping_details = shipping_details
        super().__init__(action="addLineItem")

    def __repr__(self) -> str:
        return (
            "StagedOrderAddLineItemAction(action=%r, custom=%r, distribution_channel=%r, external_tax_rate=%r, product_id=%r, variant_id=%r, sku=%r, quantity=%r, supply_channel=%r, external_price=%r, external_total_price=%r, shipping_details=%r)"
            % (
                self.action,
                self.custom,
                self.distribution_channel,
                self.external_tax_rate,
                self.product_id,
                self.variant_id,
                self.sku,
                self.quantity,
                self.supply_channel,
                self.external_price,
                self.external_total_price,
                self.shipping_details,
            )
        )


class StagedOrderAddParcelToDeliveryAction(StagedOrderUpdateAction):
    #: :class:`str` `(Named` ``deliveryId`` `in Commercetools)`
    delivery_id: str
    #: Optional :class:`commercetools.types.ParcelMeasurements`
    measurements: typing.Optional["ParcelMeasurements"]
    #: Optional :class:`commercetools.types.TrackingData` `(Named` ``trackingData`` `in Commercetools)`
    tracking_data: typing.Optional["TrackingData"]
    #: Optional list of :class:`commercetools.types.DeliveryItem`
    items: typing.Optional[typing.List["DeliveryItem"]]

    def __init__(
        self,
        *,
        delivery_id: str,
        measurements: typing.Optional["ParcelMeasurements"] = None,
        tracking_data: typing.Optional["TrackingData"] = None,
        items: typing.Optional[typing.List["DeliveryItem"]] = None
    ) -> None:
        self.delivery_id = delivery_id
        self.measurements = measurements
        self.tracking_data = tracking_data
        self.items = items
        super().__init__(action="addParcelToDelivery")

    def __repr__(self) -> str:
        return (
            "StagedOrderAddParcelToDeliveryAction(action=%r, delivery_id=%r, measurements=%r, tracking_data=%r, items=%r)"
            % (
                self.action,
                self.delivery_id,
                self.measurements,
                self.tracking_data,
                self.items,
            )
        )


class StagedOrderAddPaymentAction(StagedOrderUpdateAction):
    #: :class:`commercetools.types.PaymentResourceIdentifier`
    payment: "PaymentResourceIdentifier"

    def __init__(self, *, payment: "PaymentResourceIdentifier") -> None:
        self.payment = payment
        super().__init__(action="addPayment")

    def __repr__(self) -> str:
        return "StagedOrderAddPaymentAction(action=%r, payment=%r)" % (
            self.action,
            self.payment,
        )


class StagedOrderAddReturnInfoAction(StagedOrderUpdateAction):
    #: Optional :class:`str` `(Named` ``returnTrackingId`` `in Commercetools)`
    return_tracking_id: typing.Optional[str]
    #: List of :class:`commercetools.types.ReturnItemDraft`
    items: typing.List["ReturnItemDraft"]
    #: Optional :class:`datetime.datetime` `(Named` ``returnDate`` `in Commercetools)`
    return_date: typing.Optional[datetime.datetime]

    def __init__(
        self,
        *,
        items: typing.List["ReturnItemDraft"],
        return_tracking_id: typing.Optional[str] = None,
        return_date: typing.Optional[datetime.datetime] = None
    ) -> None:
        self.return_tracking_id = return_tracking_id
        self.items = items
        self.return_date = return_date
        super().__init__(action="addReturnInfo")

    def __repr__(self) -> str:
        return (
            "StagedOrderAddReturnInfoAction(action=%r, return_tracking_id=%r, items=%r, return_date=%r)"
            % (self.action, self.return_tracking_id, self.items, self.return_date)
        )


class StagedOrderAddShoppingListAction(StagedOrderUpdateAction):
    #: :class:`commercetools.types.ShoppingListResourceIdentifier` `(Named` ``shoppingList`` `in Commercetools)`
    shopping_list: "ShoppingListResourceIdentifier"
    #: Optional :class:`commercetools.types.ChannelResourceIdentifier` `(Named` ``supplyChannel`` `in Commercetools)`
    supply_channel: typing.Optional["ChannelResourceIdentifier"]
    #: Optional :class:`commercetools.types.ChannelResourceIdentifier` `(Named` ``distributionChannel`` `in Commercetools)`
    distribution_channel: typing.Optional["ChannelResourceIdentifier"]

    def __init__(
        self,
        *,
        shopping_list: "ShoppingListResourceIdentifier",
        supply_channel: typing.Optional["ChannelResourceIdentifier"] = None,
        distribution_channel: typing.Optional["ChannelResourceIdentifier"] = None
    ) -> None:
        self.shopping_list = shopping_list
        self.supply_channel = supply_channel
        self.distribution_channel = distribution_channel
        super().__init__(action="addShoppingList")

    def __repr__(self) -> str:
        return (
            "StagedOrderAddShoppingListAction(action=%r, shopping_list=%r, supply_channel=%r, distribution_channel=%r)"
            % (
                self.action,
                self.shopping_list,
                self.supply_channel,
                self.distribution_channel,
            )
        )


class StagedOrderChangeCustomLineItemMoneyAction(StagedOrderUpdateAction):
    #: :class:`str` `(Named` ``customLineItemId`` `in Commercetools)`
    custom_line_item_id: str
    #: :class:`commercetools.types.Money`
    money: "Money"

    def __init__(self, *, custom_line_item_id: str, money: "Money") -> None:
        self.custom_line_item_id = custom_line_item_id
        self.money = money
        super().__init__(action="changeCustomLineItemMoney")

    def __repr__(self) -> str:
        return (
            "StagedOrderChangeCustomLineItemMoneyAction(action=%r, custom_line_item_id=%r, money=%r)"
            % (self.action, self.custom_line_item_id, self.money)
        )


class StagedOrderChangeCustomLineItemQuantityAction(StagedOrderUpdateAction):
    #: :class:`str` `(Named` ``customLineItemId`` `in Commercetools)`
    custom_line_item_id: str
    #: :class:`int`
    quantity: int

    def __init__(self, *, custom_line_item_id: str, quantity: int) -> None:
        self.custom_line_item_id = custom_line_item_id
        self.quantity = quantity
        super().__init__(action="changeCustomLineItemQuantity")

    def __repr__(self) -> str:
        return (
            "StagedOrderChangeCustomLineItemQuantityAction(action=%r, custom_line_item_id=%r, quantity=%r)"
            % (self.action, self.custom_line_item_id, self.quantity)
        )


class StagedOrderChangeLineItemQuantityAction(StagedOrderUpdateAction):
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: str
    #: :class:`int`
    quantity: int
    #: Optional :class:`commercetools.types.Money` `(Named` ``externalPrice`` `in Commercetools)`
    external_price: typing.Optional["Money"]
    #: Optional :class:`commercetools.types.ExternalLineItemTotalPrice` `(Named` ``externalTotalPrice`` `in Commercetools)`
    external_total_price: typing.Optional["ExternalLineItemTotalPrice"]

    def __init__(
        self,
        *,
        line_item_id: str,
        quantity: int,
        external_price: typing.Optional["Money"] = None,
        external_total_price: typing.Optional["ExternalLineItemTotalPrice"] = None
    ) -> None:
        self.line_item_id = line_item_id
        self.quantity = quantity
        self.external_price = external_price
        self.external_total_price = external_total_price
        super().__init__(action="changeLineItemQuantity")

    def __repr__(self) -> str:
        return (
            "StagedOrderChangeLineItemQuantityAction(action=%r, line_item_id=%r, quantity=%r, external_price=%r, external_total_price=%r)"
            % (
                self.action,
                self.line_item_id,
                self.quantity,
                self.external_price,
                self.external_total_price,
            )
        )


class StagedOrderChangeOrderStateAction(StagedOrderUpdateAction):
    #: :class:`commercetools.types.OrderState` `(Named` ``orderState`` `in Commercetools)`
    order_state: "OrderState"

    def __init__(self, *, order_state: "OrderState") -> None:
        self.order_state = order_state
        super().__init__(action="changeOrderState")

    def __repr__(self) -> str:
        return "StagedOrderChangeOrderStateAction(action=%r, order_state=%r)" % (
            self.action,
            self.order_state,
        )


class StagedOrderChangePaymentStateAction(StagedOrderUpdateAction):
    #: Optional :class:`commercetools.types.PaymentState` `(Named` ``paymentState`` `in Commercetools)`
    payment_state: typing.Optional["PaymentState"]

    def __init__(
        self, *, payment_state: typing.Optional["PaymentState"] = None
    ) -> None:
        self.payment_state = payment_state
        super().__init__(action="changePaymentState")

    def __repr__(self) -> str:
        return "StagedOrderChangePaymentStateAction(action=%r, payment_state=%r)" % (
            self.action,
            self.payment_state,
        )


class StagedOrderChangeShipmentStateAction(StagedOrderUpdateAction):
    #: Optional :class:`commercetools.types.ShipmentState` `(Named` ``shipmentState`` `in Commercetools)`
    shipment_state: typing.Optional["ShipmentState"]

    def __init__(
        self, *, shipment_state: typing.Optional["ShipmentState"] = None
    ) -> None:
        self.shipment_state = shipment_state
        super().__init__(action="changeShipmentState")

    def __repr__(self) -> str:
        return "StagedOrderChangeShipmentStateAction(action=%r, shipment_state=%r)" % (
            self.action,
            self.shipment_state,
        )


class StagedOrderChangeTaxCalculationModeAction(StagedOrderUpdateAction):
    #: :class:`commercetools.types.TaxCalculationMode` `(Named` ``taxCalculationMode`` `in Commercetools)`
    tax_calculation_mode: "TaxCalculationMode"

    def __init__(self, *, tax_calculation_mode: "TaxCalculationMode") -> None:
        self.tax_calculation_mode = tax_calculation_mode
        super().__init__(action="changeTaxCalculationMode")

    def __repr__(self) -> str:
        return (
            "StagedOrderChangeTaxCalculationModeAction(action=%r, tax_calculation_mode=%r)"
            % (self.action, self.tax_calculation_mode)
        )


class StagedOrderChangeTaxModeAction(StagedOrderUpdateAction):
    #: :class:`commercetools.types.TaxMode` `(Named` ``taxMode`` `in Commercetools)`
    tax_mode: "TaxMode"

    def __init__(self, *, tax_mode: "TaxMode") -> None:
        self.tax_mode = tax_mode
        super().__init__(action="changeTaxMode")

    def __repr__(self) -> str:
        return "StagedOrderChangeTaxModeAction(action=%r, tax_mode=%r)" % (
            self.action,
            self.tax_mode,
        )


class StagedOrderChangeTaxRoundingModeAction(StagedOrderUpdateAction):
    #: :class:`commercetools.types.RoundingMode` `(Named` ``taxRoundingMode`` `in Commercetools)`
    tax_rounding_mode: "RoundingMode"

    def __init__(self, *, tax_rounding_mode: "RoundingMode") -> None:
        self.tax_rounding_mode = tax_rounding_mode
        super().__init__(action="changeTaxRoundingMode")

    def __repr__(self) -> str:
        return (
            "StagedOrderChangeTaxRoundingModeAction(action=%r, tax_rounding_mode=%r)"
            % (self.action, self.tax_rounding_mode)
        )


class StagedOrderImportCustomLineItemStateAction(StagedOrderUpdateAction):
    #: :class:`str` `(Named` ``customLineItemId`` `in Commercetools)`
    custom_line_item_id: str
    #: List of :class:`commercetools.types.ItemState`
    state: typing.List["ItemState"]

    def __init__(
        self, *, custom_line_item_id: str, state: typing.List["ItemState"]
    ) -> None:
        self.custom_line_item_id = custom_line_item_id
        self.state = state
        super().__init__(action="importCustomLineItemState")

    def __repr__(self) -> str:
        return (
            "StagedOrderImportCustomLineItemStateAction(action=%r, custom_line_item_id=%r, state=%r)"
            % (self.action, self.custom_line_item_id, self.state)
        )


class StagedOrderImportLineItemStateAction(StagedOrderUpdateAction):
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: str
    #: List of :class:`commercetools.types.ItemState`
    state: typing.List["ItemState"]

    def __init__(self, *, line_item_id: str, state: typing.List["ItemState"]) -> None:
        self.line_item_id = line_item_id
        self.state = state
        super().__init__(action="importLineItemState")

    def __repr__(self) -> str:
        return (
            "StagedOrderImportLineItemStateAction(action=%r, line_item_id=%r, state=%r)"
            % (self.action, self.line_item_id, self.state)
        )


class StagedOrderRemoveCustomLineItemAction(StagedOrderUpdateAction):
    #: :class:`str` `(Named` ``customLineItemId`` `in Commercetools)`
    custom_line_item_id: str

    def __init__(self, *, custom_line_item_id: str) -> None:
        self.custom_line_item_id = custom_line_item_id
        super().__init__(action="removeCustomLineItem")

    def __repr__(self) -> str:
        return (
            "StagedOrderRemoveCustomLineItemAction(action=%r, custom_line_item_id=%r)"
            % (self.action, self.custom_line_item_id)
        )


class StagedOrderRemoveDeliveryAction(StagedOrderUpdateAction):
    #: :class:`str` `(Named` ``deliveryId`` `in Commercetools)`
    delivery_id: str

    def __init__(self, *, delivery_id: str) -> None:
        self.delivery_id = delivery_id
        super().__init__(action="removeDelivery")

    def __repr__(self) -> str:
        return "StagedOrderRemoveDeliveryAction(action=%r, delivery_id=%r)" % (
            self.action,
            self.delivery_id,
        )


class StagedOrderRemoveDiscountCodeAction(StagedOrderUpdateAction):
    #: :class:`commercetools.types.DiscountCodeReference` `(Named` ``discountCode`` `in Commercetools)`
    discount_code: "DiscountCodeReference"

    def __init__(self, *, discount_code: "DiscountCodeReference") -> None:
        self.discount_code = discount_code
        super().__init__(action="removeDiscountCode")

    def __repr__(self) -> str:
        return "StagedOrderRemoveDiscountCodeAction(action=%r, discount_code=%r)" % (
            self.action,
            self.discount_code,
        )


class StagedOrderRemoveItemShippingAddressAction(StagedOrderUpdateAction):
    #: :class:`str` `(Named` ``addressKey`` `in Commercetools)`
    address_key: str

    def __init__(self, *, address_key: str) -> None:
        self.address_key = address_key
        super().__init__(action="removeItemShippingAddress")

    def __repr__(self) -> str:
        return (
            "StagedOrderRemoveItemShippingAddressAction(action=%r, address_key=%r)"
            % (self.action, self.address_key)
        )


class StagedOrderRemoveLineItemAction(StagedOrderUpdateAction):
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: str
    #: Optional :class:`int`
    quantity: typing.Optional[int]
    #: Optional :class:`commercetools.types.Money` `(Named` ``externalPrice`` `in Commercetools)`
    external_price: typing.Optional["Money"]
    #: Optional :class:`commercetools.types.ExternalLineItemTotalPrice` `(Named` ``externalTotalPrice`` `in Commercetools)`
    external_total_price: typing.Optional["ExternalLineItemTotalPrice"]
    #: Optional :class:`commercetools.types.ItemShippingDetailsDraft` `(Named` ``shippingDetailsToRemove`` `in Commercetools)`
    shipping_details_to_remove: typing.Optional["ItemShippingDetailsDraft"]

    def __init__(
        self,
        *,
        line_item_id: str,
        quantity: typing.Optional[int] = None,
        external_price: typing.Optional["Money"] = None,
        external_total_price: typing.Optional["ExternalLineItemTotalPrice"] = None,
        shipping_details_to_remove: typing.Optional["ItemShippingDetailsDraft"] = None
    ) -> None:
        self.line_item_id = line_item_id
        self.quantity = quantity
        self.external_price = external_price
        self.external_total_price = external_total_price
        self.shipping_details_to_remove = shipping_details_to_remove
        super().__init__(action="removeLineItem")

    def __repr__(self) -> str:
        return (
            "StagedOrderRemoveLineItemAction(action=%r, line_item_id=%r, quantity=%r, external_price=%r, external_total_price=%r, shipping_details_to_remove=%r)"
            % (
                self.action,
                self.line_item_id,
                self.quantity,
                self.external_price,
                self.external_total_price,
                self.shipping_details_to_remove,
            )
        )


class StagedOrderRemoveParcelFromDeliveryAction(StagedOrderUpdateAction):
    #: :class:`str` `(Named` ``parcelId`` `in Commercetools)`
    parcel_id: str

    def __init__(self, *, parcel_id: str) -> None:
        self.parcel_id = parcel_id
        super().__init__(action="removeParcelFromDelivery")

    def __repr__(self) -> str:
        return "StagedOrderRemoveParcelFromDeliveryAction(action=%r, parcel_id=%r)" % (
            self.action,
            self.parcel_id,
        )


class StagedOrderRemovePaymentAction(StagedOrderUpdateAction):
    #: :class:`commercetools.types.PaymentResourceIdentifier`
    payment: "PaymentResourceIdentifier"

    def __init__(self, *, payment: "PaymentResourceIdentifier") -> None:
        self.payment = payment
        super().__init__(action="removePayment")

    def __repr__(self) -> str:
        return "StagedOrderRemovePaymentAction(action=%r, payment=%r)" % (
            self.action,
            self.payment,
        )


class StagedOrderSetBillingAddressAction(StagedOrderUpdateAction):
    #: Optional :class:`commercetools.types.Address`
    address: typing.Optional["Address"]

    def __init__(self, *, address: typing.Optional["Address"] = None) -> None:
        self.address = address
        super().__init__(action="setBillingAddress")

    def __repr__(self) -> str:
        return "StagedOrderSetBillingAddressAction(action=%r, address=%r)" % (
            self.action,
            self.address,
        )


class StagedOrderSetCountryAction(StagedOrderUpdateAction):
    #: Optional :class:`str`
    country: typing.Optional[str]

    def __init__(self, *, country: typing.Optional[str] = None) -> None:
        self.country = country
        super().__init__(action="setCountry")

    def __repr__(self) -> str:
        return "StagedOrderSetCountryAction(action=%r, country=%r)" % (
            self.action,
            self.country,
        )


class StagedOrderSetCustomFieldAction(StagedOrderUpdateAction):
    #: :class:`str`
    name: str
    #: Optional :class:`typing.Any`
    value: typing.Optional[typing.Any]

    def __init__(self, *, name: str, value: typing.Optional[typing.Any] = None) -> None:
        self.name = name
        self.value = value
        super().__init__(action="setCustomField")

    def __repr__(self) -> str:
        return "StagedOrderSetCustomFieldAction(action=%r, name=%r, value=%r)" % (
            self.action,
            self.name,
            self.value,
        )


class StagedOrderSetCustomLineItemCustomFieldAction(StagedOrderUpdateAction):
    #: :class:`str` `(Named` ``customLineItemId`` `in Commercetools)`
    custom_line_item_id: str
    #: :class:`str`
    name: str
    #: Optional :class:`typing.Any`
    value: typing.Optional[typing.Any]

    def __init__(
        self,
        *,
        custom_line_item_id: str,
        name: str,
        value: typing.Optional[typing.Any] = None
    ) -> None:
        self.custom_line_item_id = custom_line_item_id
        self.name = name
        self.value = value
        super().__init__(action="setCustomLineItemCustomField")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetCustomLineItemCustomFieldAction(action=%r, custom_line_item_id=%r, name=%r, value=%r)"
            % (self.action, self.custom_line_item_id, self.name, self.value)
        )


class StagedOrderSetCustomLineItemCustomTypeAction(StagedOrderUpdateAction):
    #: :class:`str` `(Named` ``customLineItemId`` `in Commercetools)`
    custom_line_item_id: str
    #: Optional :class:`commercetools.types.TypeResourceIdentifier`
    type: typing.Optional["TypeResourceIdentifier"]
    #: Optional :class:`commercetools.types.FieldContainer`
    fields: typing.Optional["FieldContainer"]

    def __init__(
        self,
        *,
        custom_line_item_id: str,
        type: typing.Optional["TypeResourceIdentifier"] = None,
        fields: typing.Optional["FieldContainer"] = None
    ) -> None:
        self.custom_line_item_id = custom_line_item_id
        self.type = type
        self.fields = fields
        super().__init__(action="setCustomLineItemCustomType")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetCustomLineItemCustomTypeAction(action=%r, custom_line_item_id=%r, type=%r, fields=%r)"
            % (self.action, self.custom_line_item_id, self.type, self.fields)
        )


class StagedOrderSetCustomLineItemShippingDetailsAction(StagedOrderUpdateAction):
    #: :class:`str` `(Named` ``customLineItemId`` `in Commercetools)`
    custom_line_item_id: str
    #: Optional :class:`commercetools.types.ItemShippingDetailsDraft` `(Named` ``shippingDetails`` `in Commercetools)`
    shipping_details: typing.Optional["ItemShippingDetailsDraft"]

    def __init__(
        self,
        *,
        custom_line_item_id: str,
        shipping_details: typing.Optional["ItemShippingDetailsDraft"] = None
    ) -> None:
        self.custom_line_item_id = custom_line_item_id
        self.shipping_details = shipping_details
        super().__init__(action="setCustomLineItemShippingDetails")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetCustomLineItemShippingDetailsAction(action=%r, custom_line_item_id=%r, shipping_details=%r)"
            % (self.action, self.custom_line_item_id, self.shipping_details)
        )


class StagedOrderSetCustomLineItemTaxAmountAction(StagedOrderUpdateAction):
    #: :class:`str` `(Named` ``customLineItemId`` `in Commercetools)`
    custom_line_item_id: str
    #: Optional :class:`commercetools.types.ExternalTaxAmountDraft` `(Named` ``externalTaxAmount`` `in Commercetools)`
    external_tax_amount: typing.Optional["ExternalTaxAmountDraft"]

    def __init__(
        self,
        *,
        custom_line_item_id: str,
        external_tax_amount: typing.Optional["ExternalTaxAmountDraft"] = None
    ) -> None:
        self.custom_line_item_id = custom_line_item_id
        self.external_tax_amount = external_tax_amount
        super().__init__(action="setCustomLineItemTaxAmount")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetCustomLineItemTaxAmountAction(action=%r, custom_line_item_id=%r, external_tax_amount=%r)"
            % (self.action, self.custom_line_item_id, self.external_tax_amount)
        )


class StagedOrderSetCustomLineItemTaxRateAction(StagedOrderUpdateAction):
    #: :class:`str` `(Named` ``customLineItemId`` `in Commercetools)`
    custom_line_item_id: str
    #: Optional :class:`commercetools.types.ExternalTaxRateDraft` `(Named` ``externalTaxRate`` `in Commercetools)`
    external_tax_rate: typing.Optional["ExternalTaxRateDraft"]

    def __init__(
        self,
        *,
        custom_line_item_id: str,
        external_tax_rate: typing.Optional["ExternalTaxRateDraft"] = None
    ) -> None:
        self.custom_line_item_id = custom_line_item_id
        self.external_tax_rate = external_tax_rate
        super().__init__(action="setCustomLineItemTaxRate")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetCustomLineItemTaxRateAction(action=%r, custom_line_item_id=%r, external_tax_rate=%r)"
            % (self.action, self.custom_line_item_id, self.external_tax_rate)
        )


class StagedOrderSetCustomShippingMethodAction(StagedOrderUpdateAction):
    #: :class:`str` `(Named` ``shippingMethodName`` `in Commercetools)`
    shipping_method_name: str
    #: :class:`commercetools.types.ShippingRateDraft` `(Named` ``shippingRate`` `in Commercetools)`
    shipping_rate: "ShippingRateDraft"
    #: Optional :class:`commercetools.types.TaxCategoryResourceIdentifier` `(Named` ``taxCategory`` `in Commercetools)`
    tax_category: typing.Optional["TaxCategoryResourceIdentifier"]
    #: Optional :class:`commercetools.types.ExternalTaxRateDraft` `(Named` ``externalTaxRate`` `in Commercetools)`
    external_tax_rate: typing.Optional["ExternalTaxRateDraft"]

    def __init__(
        self,
        *,
        shipping_method_name: str,
        shipping_rate: "ShippingRateDraft",
        tax_category: typing.Optional["TaxCategoryResourceIdentifier"] = None,
        external_tax_rate: typing.Optional["ExternalTaxRateDraft"] = None
    ) -> None:
        self.shipping_method_name = shipping_method_name
        self.shipping_rate = shipping_rate
        self.tax_category = tax_category
        self.external_tax_rate = external_tax_rate
        super().__init__(action="setCustomShippingMethod")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetCustomShippingMethodAction(action=%r, shipping_method_name=%r, shipping_rate=%r, tax_category=%r, external_tax_rate=%r)"
            % (
                self.action,
                self.shipping_method_name,
                self.shipping_rate,
                self.tax_category,
                self.external_tax_rate,
            )
        )


class StagedOrderSetCustomTypeAction(StagedOrderUpdateAction):
    #: Optional :class:`commercetools.types.TypeResourceIdentifier`
    type: typing.Optional["TypeResourceIdentifier"]
    #: Optional :class:`commercetools.types.FieldContainer`
    fields: typing.Optional["FieldContainer"]

    def __init__(
        self,
        *,
        type: typing.Optional["TypeResourceIdentifier"] = None,
        fields: typing.Optional["FieldContainer"] = None
    ) -> None:
        self.type = type
        self.fields = fields
        super().__init__(action="setCustomType")

    def __repr__(self) -> str:
        return "StagedOrderSetCustomTypeAction(action=%r, type=%r, fields=%r)" % (
            self.action,
            self.type,
            self.fields,
        )


class StagedOrderSetCustomerEmailAction(StagedOrderUpdateAction):
    #: Optional :class:`str`
    email: typing.Optional[str]

    def __init__(self, *, email: typing.Optional[str] = None) -> None:
        self.email = email
        super().__init__(action="setCustomerEmail")

    def __repr__(self) -> str:
        return "StagedOrderSetCustomerEmailAction(action=%r, email=%r)" % (
            self.action,
            self.email,
        )


class StagedOrderSetCustomerGroupAction(StagedOrderUpdateAction):
    #: Optional :class:`commercetools.types.CustomerGroupResourceIdentifier` `(Named` ``customerGroup`` `in Commercetools)`
    customer_group: typing.Optional["CustomerGroupResourceIdentifier"]

    def __init__(
        self,
        *,
        customer_group: typing.Optional["CustomerGroupResourceIdentifier"] = None
    ) -> None:
        self.customer_group = customer_group
        super().__init__(action="setCustomerGroup")

    def __repr__(self) -> str:
        return "StagedOrderSetCustomerGroupAction(action=%r, customer_group=%r)" % (
            self.action,
            self.customer_group,
        )


class StagedOrderSetCustomerIdAction(StagedOrderUpdateAction):
    #: Optional :class:`str` `(Named` ``customerId`` `in Commercetools)`
    customer_id: typing.Optional[str]

    def __init__(self, *, customer_id: typing.Optional[str] = None) -> None:
        self.customer_id = customer_id
        super().__init__(action="setCustomerId")

    def __repr__(self) -> str:
        return "StagedOrderSetCustomerIdAction(action=%r, customer_id=%r)" % (
            self.action,
            self.customer_id,
        )


class StagedOrderSetDeliveryAddressAction(StagedOrderUpdateAction):
    #: :class:`str` `(Named` ``deliveryId`` `in Commercetools)`
    delivery_id: str
    #: Optional :class:`commercetools.types.Address`
    address: typing.Optional["Address"]

    def __init__(
        self, *, delivery_id: str, address: typing.Optional["Address"] = None
    ) -> None:
        self.delivery_id = delivery_id
        self.address = address
        super().__init__(action="setDeliveryAddress")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetDeliveryAddressAction(action=%r, delivery_id=%r, address=%r)"
            % (self.action, self.delivery_id, self.address)
        )


class StagedOrderSetDeliveryItemsAction(StagedOrderUpdateAction):
    #: :class:`str` `(Named` ``deliveryId`` `in Commercetools)`
    delivery_id: str
    #: List of :class:`commercetools.types.DeliveryItem`
    items: typing.List["DeliveryItem"]

    def __init__(self, *, delivery_id: str, items: typing.List["DeliveryItem"]) -> None:
        self.delivery_id = delivery_id
        self.items = items
        super().__init__(action="setDeliveryItems")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetDeliveryItemsAction(action=%r, delivery_id=%r, items=%r)"
            % (self.action, self.delivery_id, self.items)
        )


class StagedOrderSetLineItemCustomFieldAction(StagedOrderUpdateAction):
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: str
    #: :class:`str`
    name: str
    #: Optional :class:`typing.Any`
    value: typing.Optional[typing.Any]

    def __init__(
        self, *, line_item_id: str, name: str, value: typing.Optional[typing.Any] = None
    ) -> None:
        self.line_item_id = line_item_id
        self.name = name
        self.value = value
        super().__init__(action="setLineItemCustomField")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetLineItemCustomFieldAction(action=%r, line_item_id=%r, name=%r, value=%r)"
            % (self.action, self.line_item_id, self.name, self.value)
        )


class StagedOrderSetLineItemCustomTypeAction(StagedOrderUpdateAction):
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: str
    #: Optional :class:`commercetools.types.TypeResourceIdentifier`
    type: typing.Optional["TypeResourceIdentifier"]
    #: Optional :class:`commercetools.types.FieldContainer`
    fields: typing.Optional["FieldContainer"]

    def __init__(
        self,
        *,
        line_item_id: str,
        type: typing.Optional["TypeResourceIdentifier"] = None,
        fields: typing.Optional["FieldContainer"] = None
    ) -> None:
        self.line_item_id = line_item_id
        self.type = type
        self.fields = fields
        super().__init__(action="setLineItemCustomType")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetLineItemCustomTypeAction(action=%r, line_item_id=%r, type=%r, fields=%r)"
            % (self.action, self.line_item_id, self.type, self.fields)
        )


class StagedOrderSetLineItemPriceAction(StagedOrderUpdateAction):
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: str
    #: Optional :class:`commercetools.types.Money` `(Named` ``externalPrice`` `in Commercetools)`
    external_price: typing.Optional["Money"]

    def __init__(
        self, *, line_item_id: str, external_price: typing.Optional["Money"] = None
    ) -> None:
        self.line_item_id = line_item_id
        self.external_price = external_price
        super().__init__(action="setLineItemPrice")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetLineItemPriceAction(action=%r, line_item_id=%r, external_price=%r)"
            % (self.action, self.line_item_id, self.external_price)
        )


class StagedOrderSetLineItemShippingDetailsAction(StagedOrderUpdateAction):
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: str
    #: Optional :class:`commercetools.types.ItemShippingDetailsDraft` `(Named` ``shippingDetails`` `in Commercetools)`
    shipping_details: typing.Optional["ItemShippingDetailsDraft"]

    def __init__(
        self,
        *,
        line_item_id: str,
        shipping_details: typing.Optional["ItemShippingDetailsDraft"] = None
    ) -> None:
        self.line_item_id = line_item_id
        self.shipping_details = shipping_details
        super().__init__(action="setLineItemShippingDetails")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetLineItemShippingDetailsAction(action=%r, line_item_id=%r, shipping_details=%r)"
            % (self.action, self.line_item_id, self.shipping_details)
        )


class StagedOrderSetLineItemTaxAmountAction(StagedOrderUpdateAction):
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: str
    #: Optional :class:`commercetools.types.ExternalTaxAmountDraft` `(Named` ``externalTaxAmount`` `in Commercetools)`
    external_tax_amount: typing.Optional["ExternalTaxAmountDraft"]

    def __init__(
        self,
        *,
        line_item_id: str,
        external_tax_amount: typing.Optional["ExternalTaxAmountDraft"] = None
    ) -> None:
        self.line_item_id = line_item_id
        self.external_tax_amount = external_tax_amount
        super().__init__(action="setLineItemTaxAmount")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetLineItemTaxAmountAction(action=%r, line_item_id=%r, external_tax_amount=%r)"
            % (self.action, self.line_item_id, self.external_tax_amount)
        )


class StagedOrderSetLineItemTaxRateAction(StagedOrderUpdateAction):
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: str
    #: Optional :class:`commercetools.types.ExternalTaxRateDraft` `(Named` ``externalTaxRate`` `in Commercetools)`
    external_tax_rate: typing.Optional["ExternalTaxRateDraft"]

    def __init__(
        self,
        *,
        line_item_id: str,
        external_tax_rate: typing.Optional["ExternalTaxRateDraft"] = None
    ) -> None:
        self.line_item_id = line_item_id
        self.external_tax_rate = external_tax_rate
        super().__init__(action="setLineItemTaxRate")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetLineItemTaxRateAction(action=%r, line_item_id=%r, external_tax_rate=%r)"
            % (self.action, self.line_item_id, self.external_tax_rate)
        )


class StagedOrderSetLineItemTotalPriceAction(StagedOrderUpdateAction):
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: str
    #: Optional :class:`commercetools.types.ExternalLineItemTotalPrice` `(Named` ``externalTotalPrice`` `in Commercetools)`
    external_total_price: typing.Optional["ExternalLineItemTotalPrice"]

    def __init__(
        self,
        *,
        line_item_id: str,
        external_total_price: typing.Optional["ExternalLineItemTotalPrice"] = None
    ) -> None:
        self.line_item_id = line_item_id
        self.external_total_price = external_total_price
        super().__init__(action="setLineItemTotalPrice")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetLineItemTotalPriceAction(action=%r, line_item_id=%r, external_total_price=%r)"
            % (self.action, self.line_item_id, self.external_total_price)
        )


class StagedOrderSetLocaleAction(StagedOrderUpdateAction):
    #: Optional :class:`str`
    locale: typing.Optional[str]

    def __init__(self, *, locale: typing.Optional[str] = None) -> None:
        self.locale = locale
        super().__init__(action="setLocale")

    def __repr__(self) -> str:
        return "StagedOrderSetLocaleAction(action=%r, locale=%r)" % (
            self.action,
            self.locale,
        )


class StagedOrderSetOrderNumberAction(StagedOrderUpdateAction):
    #: Optional :class:`str` `(Named` ``orderNumber`` `in Commercetools)`
    order_number: typing.Optional[str]

    def __init__(self, *, order_number: typing.Optional[str] = None) -> None:
        self.order_number = order_number
        super().__init__(action="setOrderNumber")

    def __repr__(self) -> str:
        return "StagedOrderSetOrderNumberAction(action=%r, order_number=%r)" % (
            self.action,
            self.order_number,
        )


class StagedOrderSetOrderTotalTaxAction(StagedOrderUpdateAction):
    #: :class:`commercetools.types.Money` `(Named` ``externalTotalGross`` `in Commercetools)`
    external_total_gross: "Money"
    #: Optional list of :class:`commercetools.types.TaxPortionDraft` `(Named` ``externalTaxPortions`` `in Commercetools)`
    external_tax_portions: typing.Optional[typing.List["TaxPortionDraft"]]

    def __init__(
        self,
        *,
        external_total_gross: "Money",
        external_tax_portions: typing.Optional[typing.List["TaxPortionDraft"]] = None
    ) -> None:
        self.external_total_gross = external_total_gross
        self.external_tax_portions = external_tax_portions
        super().__init__(action="setOrderTotalTax")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetOrderTotalTaxAction(action=%r, external_total_gross=%r, external_tax_portions=%r)"
            % (self.action, self.external_total_gross, self.external_tax_portions)
        )


class StagedOrderSetParcelItemsAction(StagedOrderUpdateAction):
    #: :class:`str` `(Named` ``parcelId`` `in Commercetools)`
    parcel_id: str
    #: List of :class:`commercetools.types.DeliveryItem`
    items: typing.List["DeliveryItem"]

    def __init__(self, *, parcel_id: str, items: typing.List["DeliveryItem"]) -> None:
        self.parcel_id = parcel_id
        self.items = items
        super().__init__(action="setParcelItems")

    def __repr__(self) -> str:
        return "StagedOrderSetParcelItemsAction(action=%r, parcel_id=%r, items=%r)" % (
            self.action,
            self.parcel_id,
            self.items,
        )


class StagedOrderSetParcelMeasurementsAction(StagedOrderUpdateAction):
    #: :class:`str` `(Named` ``parcelId`` `in Commercetools)`
    parcel_id: str
    #: Optional :class:`commercetools.types.ParcelMeasurements`
    measurements: typing.Optional["ParcelMeasurements"]

    def __init__(
        self,
        *,
        parcel_id: str,
        measurements: typing.Optional["ParcelMeasurements"] = None
    ) -> None:
        self.parcel_id = parcel_id
        self.measurements = measurements
        super().__init__(action="setParcelMeasurements")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetParcelMeasurementsAction(action=%r, parcel_id=%r, measurements=%r)"
            % (self.action, self.parcel_id, self.measurements)
        )


class StagedOrderSetParcelTrackingDataAction(StagedOrderUpdateAction):
    #: :class:`str` `(Named` ``parcelId`` `in Commercetools)`
    parcel_id: str
    #: Optional :class:`commercetools.types.TrackingData` `(Named` ``trackingData`` `in Commercetools)`
    tracking_data: typing.Optional["TrackingData"]

    def __init__(
        self, *, parcel_id: str, tracking_data: typing.Optional["TrackingData"] = None
    ) -> None:
        self.parcel_id = parcel_id
        self.tracking_data = tracking_data
        super().__init__(action="setParcelTrackingData")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetParcelTrackingDataAction(action=%r, parcel_id=%r, tracking_data=%r)"
            % (self.action, self.parcel_id, self.tracking_data)
        )


class StagedOrderSetReturnPaymentStateAction(StagedOrderUpdateAction):
    #: :class:`str` `(Named` ``returnItemId`` `in Commercetools)`
    return_item_id: str
    #: :class:`commercetools.types.ReturnPaymentState` `(Named` ``paymentState`` `in Commercetools)`
    payment_state: "ReturnPaymentState"

    def __init__(
        self, *, return_item_id: str, payment_state: "ReturnPaymentState"
    ) -> None:
        self.return_item_id = return_item_id
        self.payment_state = payment_state
        super().__init__(action="setReturnPaymentState")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetReturnPaymentStateAction(action=%r, return_item_id=%r, payment_state=%r)"
            % (self.action, self.return_item_id, self.payment_state)
        )


class StagedOrderSetReturnShipmentStateAction(StagedOrderUpdateAction):
    #: :class:`str` `(Named` ``returnItemId`` `in Commercetools)`
    return_item_id: str
    #: :class:`commercetools.types.ReturnShipmentState` `(Named` ``shipmentState`` `in Commercetools)`
    shipment_state: "ReturnShipmentState"

    def __init__(
        self, *, return_item_id: str, shipment_state: "ReturnShipmentState"
    ) -> None:
        self.return_item_id = return_item_id
        self.shipment_state = shipment_state
        super().__init__(action="setReturnShipmentState")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetReturnShipmentStateAction(action=%r, return_item_id=%r, shipment_state=%r)"
            % (self.action, self.return_item_id, self.shipment_state)
        )


class StagedOrderSetShippingAddressAction(StagedOrderUpdateAction):
    #: Optional :class:`commercetools.types.Address`
    address: typing.Optional["Address"]

    def __init__(self, *, address: typing.Optional["Address"] = None) -> None:
        self.address = address
        super().__init__(action="setShippingAddress")

    def __repr__(self) -> str:
        return "StagedOrderSetShippingAddressAction(action=%r, address=%r)" % (
            self.action,
            self.address,
        )


class StagedOrderSetShippingAddressAndCustomShippingMethodAction(
    StagedOrderUpdateAction
):
    #: :class:`commercetools.types.Address`
    address: "Address"
    #: :class:`str` `(Named` ``shippingMethodName`` `in Commercetools)`
    shipping_method_name: str
    #: :class:`commercetools.types.ShippingRateDraft` `(Named` ``shippingRate`` `in Commercetools)`
    shipping_rate: "ShippingRateDraft"
    #: Optional :class:`commercetools.types.TaxCategoryResourceIdentifier` `(Named` ``taxCategory`` `in Commercetools)`
    tax_category: typing.Optional["TaxCategoryResourceIdentifier"]
    #: Optional :class:`commercetools.types.ExternalTaxRateDraft` `(Named` ``externalTaxRate`` `in Commercetools)`
    external_tax_rate: typing.Optional["ExternalTaxRateDraft"]

    def __init__(
        self,
        *,
        address: "Address",
        shipping_method_name: str,
        shipping_rate: "ShippingRateDraft",
        tax_category: typing.Optional["TaxCategoryResourceIdentifier"] = None,
        external_tax_rate: typing.Optional["ExternalTaxRateDraft"] = None
    ) -> None:
        self.address = address
        self.shipping_method_name = shipping_method_name
        self.shipping_rate = shipping_rate
        self.tax_category = tax_category
        self.external_tax_rate = external_tax_rate
        super().__init__(action="setShippingAddressAndCustomShippingMethod")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetShippingAddressAndCustomShippingMethodAction(action=%r, address=%r, shipping_method_name=%r, shipping_rate=%r, tax_category=%r, external_tax_rate=%r)"
            % (
                self.action,
                self.address,
                self.shipping_method_name,
                self.shipping_rate,
                self.tax_category,
                self.external_tax_rate,
            )
        )


class StagedOrderSetShippingAddressAndShippingMethodAction(StagedOrderUpdateAction):
    #: :class:`commercetools.types.Address`
    address: "Address"
    #: Optional :class:`commercetools.types.ShippingMethodResourceIdentifier` `(Named` ``shippingMethod`` `in Commercetools)`
    shipping_method: typing.Optional["ShippingMethodResourceIdentifier"]
    #: Optional :class:`commercetools.types.ExternalTaxRateDraft` `(Named` ``externalTaxRate`` `in Commercetools)`
    external_tax_rate: typing.Optional["ExternalTaxRateDraft"]

    def __init__(
        self,
        *,
        address: "Address",
        shipping_method: typing.Optional["ShippingMethodResourceIdentifier"] = None,
        external_tax_rate: typing.Optional["ExternalTaxRateDraft"] = None
    ) -> None:
        self.address = address
        self.shipping_method = shipping_method
        self.external_tax_rate = external_tax_rate
        super().__init__(action="setShippingAddressAndShippingMethod")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetShippingAddressAndShippingMethodAction(action=%r, address=%r, shipping_method=%r, external_tax_rate=%r)"
            % (self.action, self.address, self.shipping_method, self.external_tax_rate)
        )


class StagedOrderSetShippingMethodAction(StagedOrderUpdateAction):
    #: Optional :class:`commercetools.types.ShippingMethodResourceIdentifier` `(Named` ``shippingMethod`` `in Commercetools)`
    shipping_method: typing.Optional["ShippingMethodResourceIdentifier"]
    #: Optional :class:`commercetools.types.ExternalTaxRateDraft` `(Named` ``externalTaxRate`` `in Commercetools)`
    external_tax_rate: typing.Optional["ExternalTaxRateDraft"]

    def __init__(
        self,
        *,
        shipping_method: typing.Optional["ShippingMethodResourceIdentifier"] = None,
        external_tax_rate: typing.Optional["ExternalTaxRateDraft"] = None
    ) -> None:
        self.shipping_method = shipping_method
        self.external_tax_rate = external_tax_rate
        super().__init__(action="setShippingMethod")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetShippingMethodAction(action=%r, shipping_method=%r, external_tax_rate=%r)"
            % (self.action, self.shipping_method, self.external_tax_rate)
        )


class StagedOrderSetShippingMethodTaxAmountAction(StagedOrderUpdateAction):
    #: Optional :class:`commercetools.types.ExternalTaxAmountDraft` `(Named` ``externalTaxAmount`` `in Commercetools)`
    external_tax_amount: typing.Optional["ExternalTaxAmountDraft"]

    def __init__(
        self, *, external_tax_amount: typing.Optional["ExternalTaxAmountDraft"] = None
    ) -> None:
        self.external_tax_amount = external_tax_amount
        super().__init__(action="setShippingMethodTaxAmount")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetShippingMethodTaxAmountAction(action=%r, external_tax_amount=%r)"
            % (self.action, self.external_tax_amount)
        )


class StagedOrderSetShippingMethodTaxRateAction(StagedOrderUpdateAction):
    #: Optional :class:`commercetools.types.ExternalTaxRateDraft` `(Named` ``externalTaxRate`` `in Commercetools)`
    external_tax_rate: typing.Optional["ExternalTaxRateDraft"]

    def __init__(
        self, *, external_tax_rate: typing.Optional["ExternalTaxRateDraft"] = None
    ) -> None:
        self.external_tax_rate = external_tax_rate
        super().__init__(action="setShippingMethodTaxRate")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetShippingMethodTaxRateAction(action=%r, external_tax_rate=%r)"
            % (self.action, self.external_tax_rate)
        )


class StagedOrderSetShippingRateInputAction(StagedOrderUpdateAction):
    #: Optional :class:`commercetools.types.ShippingRateInputDraft` `(Named` ``shippingRateInput`` `in Commercetools)`
    shipping_rate_input: typing.Optional["ShippingRateInputDraft"]

    def __init__(
        self, *, shipping_rate_input: typing.Optional["ShippingRateInputDraft"] = None
    ) -> None:
        self.shipping_rate_input = shipping_rate_input
        super().__init__(action="setShippingRateInput")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetShippingRateInputAction(action=%r, shipping_rate_input=%r)"
            % (self.action, self.shipping_rate_input)
        )


class StagedOrderTransitionCustomLineItemStateAction(StagedOrderUpdateAction):
    #: :class:`str` `(Named` ``customLineItemId`` `in Commercetools)`
    custom_line_item_id: str
    #: :class:`int`
    quantity: int
    #: :class:`commercetools.types.StateResourceIdentifier` `(Named` ``fromState`` `in Commercetools)`
    from_state: "StateResourceIdentifier"
    #: :class:`commercetools.types.StateResourceIdentifier` `(Named` ``toState`` `in Commercetools)`
    to_state: "StateResourceIdentifier"
    #: Optional :class:`datetime.datetime` `(Named` ``actualTransitionDate`` `in Commercetools)`
    actual_transition_date: typing.Optional[datetime.datetime]

    def __init__(
        self,
        *,
        custom_line_item_id: str,
        quantity: int,
        from_state: "StateResourceIdentifier",
        to_state: "StateResourceIdentifier",
        actual_transition_date: typing.Optional[datetime.datetime] = None
    ) -> None:
        self.custom_line_item_id = custom_line_item_id
        self.quantity = quantity
        self.from_state = from_state
        self.to_state = to_state
        self.actual_transition_date = actual_transition_date
        super().__init__(action="transitionCustomLineItemState")

    def __repr__(self) -> str:
        return (
            "StagedOrderTransitionCustomLineItemStateAction(action=%r, custom_line_item_id=%r, quantity=%r, from_state=%r, to_state=%r, actual_transition_date=%r)"
            % (
                self.action,
                self.custom_line_item_id,
                self.quantity,
                self.from_state,
                self.to_state,
                self.actual_transition_date,
            )
        )


class StagedOrderTransitionLineItemStateAction(StagedOrderUpdateAction):
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: str
    #: :class:`int`
    quantity: int
    #: :class:`commercetools.types.StateResourceIdentifier` `(Named` ``fromState`` `in Commercetools)`
    from_state: "StateResourceIdentifier"
    #: :class:`commercetools.types.StateResourceIdentifier` `(Named` ``toState`` `in Commercetools)`
    to_state: "StateResourceIdentifier"
    #: Optional :class:`datetime.datetime` `(Named` ``actualTransitionDate`` `in Commercetools)`
    actual_transition_date: typing.Optional[datetime.datetime]

    def __init__(
        self,
        *,
        line_item_id: str,
        quantity: int,
        from_state: "StateResourceIdentifier",
        to_state: "StateResourceIdentifier",
        actual_transition_date: typing.Optional[datetime.datetime] = None
    ) -> None:
        self.line_item_id = line_item_id
        self.quantity = quantity
        self.from_state = from_state
        self.to_state = to_state
        self.actual_transition_date = actual_transition_date
        super().__init__(action="transitionLineItemState")

    def __repr__(self) -> str:
        return (
            "StagedOrderTransitionLineItemStateAction(action=%r, line_item_id=%r, quantity=%r, from_state=%r, to_state=%r, actual_transition_date=%r)"
            % (
                self.action,
                self.line_item_id,
                self.quantity,
                self.from_state,
                self.to_state,
                self.actual_transition_date,
            )
        )


class StagedOrderTransitionStateAction(StagedOrderUpdateAction):
    #: :class:`commercetools.types.StateResourceIdentifier`
    state: "StateResourceIdentifier"
    #: Optional :class:`bool`
    force: typing.Optional[bool]

    def __init__(
        self, *, state: "StateResourceIdentifier", force: typing.Optional[bool] = None
    ) -> None:
        self.state = state
        self.force = force
        super().__init__(action="transitionState")

    def __repr__(self) -> str:
        return "StagedOrderTransitionStateAction(action=%r, state=%r, force=%r)" % (
            self.action,
            self.state,
            self.force,
        )


class StagedOrderUpdateItemShippingAddressAction(StagedOrderUpdateAction):
    #: :class:`commercetools.types.Address`
    address: "Address"

    def __init__(self, *, address: "Address") -> None:
        self.address = address
        super().__init__(action="updateItemShippingAddress")

    def __repr__(self) -> str:
        return "StagedOrderUpdateItemShippingAddressAction(action=%r, address=%r)" % (
            self.action,
            self.address,
        )


class StagedOrderUpdateSyncInfoAction(StagedOrderUpdateAction):
    #: :class:`commercetools.types.ChannelResourceIdentifier`
    channel: "ChannelResourceIdentifier"
    #: Optional :class:`str` `(Named` ``externalId`` `in Commercetools)`
    external_id: typing.Optional[str]
    #: Optional :class:`datetime.datetime` `(Named` ``syncedAt`` `in Commercetools)`
    synced_at: typing.Optional[datetime.datetime]

    def __init__(
        self,
        *,
        channel: "ChannelResourceIdentifier",
        external_id: typing.Optional[str] = None,
        synced_at: typing.Optional[datetime.datetime] = None
    ) -> None:
        self.channel = channel
        self.external_id = external_id
        self.synced_at = synced_at
        super().__init__(action="updateSyncInfo")

    def __repr__(self) -> str:
        return (
            "StagedOrderUpdateSyncInfoAction(action=%r, channel=%r, external_id=%r, synced_at=%r)"
            % (self.action, self.channel, self.external_id, self.synced_at)
        )


class OrderEditAddStagedActionAction(OrderEditUpdateAction):
    #: :class:`commercetools.types.StagedOrderUpdateAction` `(Named` ``stagedAction`` `in Commercetools)`
    staged_action: "StagedOrderUpdateAction"

    def __init__(self, *, staged_action: "StagedOrderUpdateAction") -> None:
        self.staged_action = staged_action
        super().__init__(action="addStagedAction")

    def __repr__(self) -> str:
        return "OrderEditAddStagedActionAction(action=%r, staged_action=%r)" % (
            self.action,
            self.staged_action,
        )


class OrderEditApplied(OrderEditResult):
    #: :class:`datetime.datetime` `(Named` ``appliedAt`` `in Commercetools)`
    applied_at: datetime.datetime
    #: :class:`commercetools.types.OrderExcerpt` `(Named` ``excerptBeforeEdit`` `in Commercetools)`
    excerpt_before_edit: "OrderExcerpt"
    #: :class:`commercetools.types.OrderExcerpt` `(Named` ``excerptAfterEdit`` `in Commercetools)`
    excerpt_after_edit: "OrderExcerpt"

    def __init__(
        self,
        *,
        applied_at: datetime.datetime,
        excerpt_before_edit: "OrderExcerpt",
        excerpt_after_edit: "OrderExcerpt"
    ) -> None:
        self.applied_at = applied_at
        self.excerpt_before_edit = excerpt_before_edit
        self.excerpt_after_edit = excerpt_after_edit
        super().__init__(type="Applied")

    def __repr__(self) -> str:
        return (
            "OrderEditApplied(type=%r, applied_at=%r, excerpt_before_edit=%r, excerpt_after_edit=%r)"
            % (
                self.type,
                self.applied_at,
                self.excerpt_before_edit,
                self.excerpt_after_edit,
            )
        )


class OrderEditNotProcessed(OrderEditResult):
    def __init__(self) -> None:
        super().__init__(type="NotProcessed")

    def __repr__(self) -> str:
        return "OrderEditNotProcessed(type=%r)" % (self.type,)


class OrderEditPreviewFailure(OrderEditResult):
    #: List of :class:`commercetools.types.ErrorObject`
    errors: typing.List["ErrorObject"]

    def __init__(self, *, errors: typing.List["ErrorObject"]) -> None:
        self.errors = errors
        super().__init__(type="PreviewFailure")

    def __repr__(self) -> str:
        return "OrderEditPreviewFailure(type=%r, errors=%r)" % (self.type, self.errors)


class OrderEditPreviewSuccess(OrderEditResult):
    #: :class:`commercetools.types.StagedOrder`
    preview: "StagedOrder"
    #: List of :class:`commercetools.types.MessagePayload` `(Named` ``messagePayloads`` `in Commercetools)`
    message_payloads: typing.List["MessagePayload"]

    def __init__(
        self, *, preview: "StagedOrder", message_payloads: typing.List["MessagePayload"]
    ) -> None:
        self.preview = preview
        self.message_payloads = message_payloads
        super().__init__(type="PreviewSuccess")

    def __repr__(self) -> str:
        return "OrderEditPreviewSuccess(type=%r, preview=%r, message_payloads=%r)" % (
            self.type,
            self.preview,
            self.message_payloads,
        )


class OrderEditSetCommentAction(OrderEditUpdateAction):
    #: Optional :class:`str`
    comment: typing.Optional[str]

    def __init__(self, *, comment: typing.Optional[str] = None) -> None:
        self.comment = comment
        super().__init__(action="setComment")

    def __repr__(self) -> str:
        return "OrderEditSetCommentAction(action=%r, comment=%r)" % (
            self.action,
            self.comment,
        )


class OrderEditSetCustomFieldAction(OrderEditUpdateAction):
    #: :class:`str`
    name: str
    #: Optional :class:`typing.Any`
    value: typing.Optional[typing.Any]

    def __init__(self, *, name: str, value: typing.Optional[typing.Any] = None) -> None:
        self.name = name
        self.value = value
        super().__init__(action="setCustomField")

    def __repr__(self) -> str:
        return "OrderEditSetCustomFieldAction(action=%r, name=%r, value=%r)" % (
            self.action,
            self.name,
            self.value,
        )


class OrderEditSetCustomTypeAction(OrderEditUpdateAction):
    #: Optional :class:`commercetools.types.TypeResourceIdentifier`
    type: typing.Optional["TypeResourceIdentifier"]
    #: Optional :class:`object`
    fields: typing.Optional[object]

    def __init__(
        self,
        *,
        type: typing.Optional["TypeResourceIdentifier"] = None,
        fields: typing.Optional[object] = None
    ) -> None:
        self.type = type
        self.fields = fields
        super().__init__(action="setCustomType")

    def __repr__(self) -> str:
        return "OrderEditSetCustomTypeAction(action=%r, type=%r, fields=%r)" % (
            self.action,
            self.type,
            self.fields,
        )


class OrderEditSetKeyAction(OrderEditUpdateAction):
    #: Optional :class:`str`
    key: typing.Optional[str]

    def __init__(self, *, key: typing.Optional[str] = None) -> None:
        self.key = key
        super().__init__(action="setKey")

    def __repr__(self) -> str:
        return "OrderEditSetKeyAction(action=%r, key=%r)" % (self.action, self.key)


class OrderEditSetStagedActionsAction(OrderEditUpdateAction):
    #: List of :class:`commercetools.types.StagedOrderUpdateAction` `(Named` ``stagedActions`` `in Commercetools)`
    staged_actions: typing.List["StagedOrderUpdateAction"]

    def __init__(
        self, *, staged_actions: typing.List["StagedOrderUpdateAction"]
    ) -> None:
        self.staged_actions = staged_actions
        super().__init__(action="setStagedActions")

    def __repr__(self) -> str:
        return "OrderEditSetStagedActionsAction(action=%r, staged_actions=%r)" % (
            self.action,
            self.staged_actions,
        )
