# DO NOT EDIT! This file is automatically generated
import typing

from commercetools._schemas._subscription import (
    SubscriptionDraftSchema,
    SubscriptionPagedQueryResponseSchema,
    SubscriptionSchema,
    SubscriptionUpdateSchema,
)
from commercetools.helpers import RemoveEmptyValuesMixin
from commercetools.types._subscription import (
    Subscription,
    SubscriptionDraft,
    SubscriptionPagedQueryResponse,
    SubscriptionUpdate,
    SubscriptionUpdateAction,
)
from commercetools.typing import OptionalListStr

from . import abstract, traits


class _SubscriptionQuerySchema(
    traits.ExpandableSchema,
    traits.SortableSchema,
    traits.PagingSchema,
    traits.QuerySchema,
):
    pass


class _SubscriptionUpdateSchema(traits.ExpandableSchema, traits.VersionedSchema):
    pass


class _SubscriptionDeleteSchema(traits.VersionedSchema, traits.ExpandableSchema):
    pass


class SubscriptionService(abstract.AbstractService):
    """Subscriptions allow you to be notified of new messages or changes via a
    Message Queue of your choice"""

    def get_by_id(self, id: str, *, expand: OptionalListStr = None) -> Subscription:
        """Retrieves the representation of a subscription by its id."""
        params = self._serialize_params({"expand": expand}, traits.ExpandableSchema)
        return self._client._get(
            endpoint=f"subscriptions/{id}", params=params, schema_cls=SubscriptionSchema
        )

    def get_by_key(self, key: str, *, expand: OptionalListStr = None) -> Subscription:
        """Retrieves the representation of a subscription by its key."""
        params = self._serialize_params({"expand": expand}, traits.ExpandableSchema)
        return self._client._get(
            endpoint=f"subscriptions/key={key}",
            params=params,
            schema_cls=SubscriptionSchema,
        )

    def query(
        self,
        *,
        expand: OptionalListStr = None,
        sort: OptionalListStr = None,
        limit: int = None,
        offset: int = None,
        with_total: bool = None,
        where: OptionalListStr = None,
        predicate_var: typing.Dict[str, str] = None,
    ) -> SubscriptionPagedQueryResponse:
        """Subscriptions allow you to be notified of new messages or changes via a
        Message Queue of your choice
        """
        params = self._serialize_params(
            {
                "expand": expand,
                "sort": sort,
                "limit": limit,
                "offset": offset,
                "withTotal": with_total,
                "where": where,
                "predicate_var": predicate_var,
            },
            _SubscriptionQuerySchema,
        )
        return self._client._get(
            endpoint="subscriptions",
            params=params,
            schema_cls=SubscriptionPagedQueryResponseSchema,
        )

    def create(
        self, draft: SubscriptionDraft, *, expand: OptionalListStr = None
    ) -> Subscription:
        """The creation of a Subscription is eventually consistent, it may take up
        to a minute before it becomes fully active.

        In order to test that the destination is correctly configured, a test
        message will be put into the queue. If the message could not be
        delivered, the subscription will not be created. The payload of the test
        message is a notification of type ResourceCreated for the resourceTypeId
        subscription. Currently, a maximum of 25 subscriptions can be created per
        project.   Subscriptions allow you to be notified of new messages or
        changes via a Message Queue of your choice
        """
        params = self._serialize_params({"expand": expand}, traits.ExpandableSchema)
        return self._client._post(
            endpoint="subscriptions",
            params=params,
            data_object=draft,
            request_schema_cls=SubscriptionDraftSchema,
            response_schema_cls=SubscriptionSchema,
        )

    def update_by_id(
        self,
        id: str,
        version: int,
        actions: typing.List[SubscriptionUpdateAction],
        *,
        expand: OptionalListStr = None,
        force_update: bool = False,
    ) -> Subscription:
        params = self._serialize_params({"expand": expand}, _SubscriptionUpdateSchema)
        update_action = SubscriptionUpdate(version=version, actions=actions)
        return self._client._post(
            endpoint=f"subscriptions/{id}",
            params=params,
            data_object=update_action,
            request_schema_cls=SubscriptionUpdateSchema,
            response_schema_cls=SubscriptionSchema,
            force_update=force_update,
        )

    def update_by_key(
        self,
        key: str,
        version: int,
        actions: typing.List[SubscriptionUpdateAction],
        *,
        expand: OptionalListStr = None,
        force_update: bool = False,
    ) -> Subscription:
        params = self._serialize_params({"expand": expand}, _SubscriptionUpdateSchema)
        update_action = SubscriptionUpdate(version=version, actions=actions)
        return self._client._post(
            endpoint=f"subscriptions/key={key}",
            params=params,
            data_object=update_action,
            request_schema_cls=SubscriptionUpdateSchema,
            response_schema_cls=SubscriptionSchema,
            force_update=force_update,
        )

    def delete_by_id(
        self,
        id: str,
        version: int,
        *,
        expand: OptionalListStr = None,
        force_delete: bool = False,
    ) -> Subscription:
        params = self._serialize_params(
            {"version": version, "expand": expand}, _SubscriptionDeleteSchema
        )
        return self._client._delete(
            endpoint=f"subscriptions/{id}",
            params=params,
            response_schema_cls=SubscriptionSchema,
            force_delete=force_delete,
        )

    def delete_by_key(
        self,
        key: str,
        version: int,
        *,
        expand: OptionalListStr = None,
        force_delete: bool = False,
    ) -> Subscription:
        params = self._serialize_params(
            {"version": version, "expand": expand}, _SubscriptionDeleteSchema
        )
        return self._client._delete(
            endpoint=f"subscriptions/key={key}",
            params=params,
            response_schema_cls=SubscriptionSchema,
            force_delete=force_delete,
        )
