# DO NOT EDIT! This file is automatically generated
import marshmallow
import marshmallow_enum

from commercetools import helpers, types
from commercetools._schemas._common import (
    BaseResourceSchema,
    LocalizedStringField,
    ReferenceSchema,
    ResourceIdentifierSchema,
)
from commercetools._schemas._type import FieldContainerField

__all__ = [
    "CustomLineItemReturnItemSchema",
    "DeliveryItemSchema",
    "DeliverySchema",
    "DiscountedLineItemPriceDraftSchema",
    "ItemStateSchema",
    "LineItemImportDraftSchema",
    "LineItemReturnItemSchema",
    "OrderAddDeliveryActionSchema",
    "OrderAddItemShippingAddressActionSchema",
    "OrderAddParcelToDeliveryActionSchema",
    "OrderAddPaymentActionSchema",
    "OrderAddReturnInfoActionSchema",
    "OrderChangeOrderStateActionSchema",
    "OrderChangePaymentStateActionSchema",
    "OrderChangeShipmentStateActionSchema",
    "OrderFromCartDraftSchema",
    "OrderImportCustomLineItemStateActionSchema",
    "OrderImportDraftSchema",
    "OrderImportLineItemStateActionSchema",
    "OrderPagedQueryResponseSchema",
    "OrderReferenceSchema",
    "OrderRemoveDeliveryActionSchema",
    "OrderRemoveItemShippingAddressActionSchema",
    "OrderRemoveParcelFromDeliveryActionSchema",
    "OrderRemovePaymentActionSchema",
    "OrderResourceIdentifierSchema",
    "OrderSchema",
    "OrderSetBillingAddressActionSchema",
    "OrderSetCustomFieldActionSchema",
    "OrderSetCustomLineItemCustomFieldActionSchema",
    "OrderSetCustomLineItemCustomTypeActionSchema",
    "OrderSetCustomLineItemShippingDetailsActionSchema",
    "OrderSetCustomTypeActionSchema",
    "OrderSetCustomerEmailActionSchema",
    "OrderSetCustomerIdActionSchema",
    "OrderSetDeliveryAddressActionSchema",
    "OrderSetDeliveryItemsActionSchema",
    "OrderSetLineItemCustomFieldActionSchema",
    "OrderSetLineItemCustomTypeActionSchema",
    "OrderSetLineItemShippingDetailsActionSchema",
    "OrderSetLocaleActionSchema",
    "OrderSetOrderNumberActionSchema",
    "OrderSetParcelItemsActionSchema",
    "OrderSetParcelMeasurementsActionSchema",
    "OrderSetParcelTrackingDataActionSchema",
    "OrderSetReturnPaymentStateActionSchema",
    "OrderSetReturnShipmentStateActionSchema",
    "OrderSetShippingAddressActionSchema",
    "OrderSetStoreActionSchema",
    "OrderTransitionCustomLineItemStateActionSchema",
    "OrderTransitionLineItemStateActionSchema",
    "OrderTransitionStateActionSchema",
    "OrderUpdateActionSchema",
    "OrderUpdateItemShippingAddressActionSchema",
    "OrderUpdateSchema",
    "OrderUpdateSyncInfoActionSchema",
    "ParcelDraftSchema",
    "ParcelMeasurementsSchema",
    "ParcelSchema",
    "PaymentInfoSchema",
    "ProductVariantImportDraftSchema",
    "ReturnInfoSchema",
    "ReturnItemDraftSchema",
    "ReturnItemSchema",
    "ShippingInfoImportDraftSchema",
    "StagedOrderUpdateActionSchema",
    "SyncInfoSchema",
    "TaxedItemPriceDraftSchema",
    "TrackingDataSchema",
]


class DeliveryItemSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.DeliveryItem`."""

    id = marshmallow.fields.String(allow_none=True)
    quantity = marshmallow.fields.Integer(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.DeliveryItem(**data)


class DeliverySchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.Delivery`."""

    id = marshmallow.fields.String(allow_none=True)
    created_at = marshmallow.fields.DateTime(allow_none=True, data_key="createdAt")
    items = helpers.LazyNestedField(
        nested="commercetools._schemas._order.DeliveryItemSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
    )
    parcels = helpers.LazyNestedField(
        nested="commercetools._schemas._order.ParcelSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
    )
    address = helpers.LazyNestedField(
        nested="commercetools._schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.Delivery(**data)


class DiscountedLineItemPriceDraftSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.DiscountedLineItemPriceDraft`."""

    value = helpers.LazyNestedField(
        nested="commercetools._schemas._common.MoneySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    included_discounts = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.DiscountedLineItemPortionSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        data_key="includedDiscounts",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.DiscountedLineItemPriceDraft(**data)


class ItemStateSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.ItemState`."""

    quantity = marshmallow.fields.Integer(allow_none=True)
    state = helpers.LazyNestedField(
        nested="commercetools._schemas._state.StateReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.ItemState(**data)


class LineItemImportDraftSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.LineItemImportDraft`."""

    product_id = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="productId"
    )
    name = LocalizedStringField(allow_none=True)
    variant = helpers.LazyNestedField(
        nested="commercetools._schemas._order.ProductVariantImportDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    price = helpers.LazyNestedField(
        nested="commercetools._schemas._common.PriceDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    quantity = marshmallow.fields.Integer(allow_none=True)
    state = helpers.LazyNestedField(
        nested="commercetools._schemas._order.ItemStateSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        missing=None,
    )
    supply_channel = helpers.LazyNestedField(
        nested="commercetools._schemas._channel.ChannelResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="supplyChannel",
    )
    distribution_channel = helpers.LazyNestedField(
        nested="commercetools._schemas._channel.ChannelResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="distributionChannel",
    )
    tax_rate = helpers.LazyNestedField(
        nested="commercetools._schemas._tax_category.TaxRateSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="taxRate",
    )
    custom = helpers.LazyNestedField(
        nested="commercetools._schemas._type.CustomFieldsDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    shipping_details = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ItemShippingDetailsDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="shippingDetails",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.LineItemImportDraft(**data)


class OrderFromCartDraftSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.OrderFromCartDraft`."""

    id = marshmallow.fields.String(allow_none=True)
    version = marshmallow.fields.Integer(allow_none=True)
    order_number = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="orderNumber"
    )
    payment_state = marshmallow_enum.EnumField(
        types.PaymentState, by_value=True, missing=None, data_key="paymentState"
    )
    shipment_state = marshmallow_enum.EnumField(
        types.ShipmentState, by_value=True, missing=None, data_key="shipmentState"
    )
    order_state = marshmallow_enum.EnumField(
        types.OrderState, by_value=True, missing=None, data_key="orderState"
    )
    state = helpers.LazyNestedField(
        nested="commercetools._schemas._state.StateResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.OrderFromCartDraft(**data)


class OrderImportDraftSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.OrderImportDraft`."""

    order_number = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="orderNumber"
    )
    customer_id = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="customerId"
    )
    customer_email = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="customerEmail"
    )
    line_items = helpers.LazyNestedField(
        nested="commercetools._schemas._order.LineItemImportDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        missing=None,
        data_key="lineItems",
    )
    custom_line_items = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.CustomLineItemDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        missing=None,
        data_key="customLineItems",
    )
    total_price = helpers.LazyNestedField(
        nested="commercetools._schemas._common.MoneySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="totalPrice",
    )
    taxed_price = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.TaxedPriceDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="taxedPrice",
    )
    shipping_address = helpers.LazyNestedField(
        nested="commercetools._schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="shippingAddress",
    )
    billing_address = helpers.LazyNestedField(
        nested="commercetools._schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="billingAddress",
    )
    customer_group = helpers.LazyNestedField(
        nested="commercetools._schemas._customer_group.CustomerGroupResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="customerGroup",
    )
    country = marshmallow.fields.String(allow_none=True, missing=None)
    order_state = marshmallow_enum.EnumField(
        types.OrderState, by_value=True, missing=None, data_key="orderState"
    )
    shipment_state = marshmallow_enum.EnumField(
        types.ShipmentState, by_value=True, missing=None, data_key="shipmentState"
    )
    payment_state = marshmallow_enum.EnumField(
        types.PaymentState, by_value=True, missing=None, data_key="paymentState"
    )
    shipping_info = helpers.LazyNestedField(
        nested="commercetools._schemas._order.ShippingInfoImportDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="shippingInfo",
    )
    completed_at = marshmallow.fields.DateTime(
        allow_none=True, missing=None, data_key="completedAt"
    )
    custom = helpers.LazyNestedField(
        nested="commercetools._schemas._type.CustomFieldsDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    inventory_mode = marshmallow_enum.EnumField(
        types.InventoryMode, by_value=True, missing=None, data_key="inventoryMode"
    )
    tax_rounding_mode = marshmallow_enum.EnumField(
        types.RoundingMode, by_value=True, missing=None, data_key="taxRoundingMode"
    )
    item_shipping_addresses = helpers.LazyNestedField(
        nested="commercetools._schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        missing=None,
        data_key="itemShippingAddresses",
    )
    store = helpers.LazyNestedField(
        nested="commercetools._schemas._store.StoreResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    origin = marshmallow_enum.EnumField(types.CartOrigin, by_value=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.OrderImportDraft(**data)


class OrderPagedQueryResponseSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.OrderPagedQueryResponse`."""

    limit = marshmallow.fields.Integer(allow_none=True)
    count = marshmallow.fields.Integer(allow_none=True)
    total = marshmallow.fields.Integer(allow_none=True, missing=None)
    offset = marshmallow.fields.Integer(allow_none=True)
    results = helpers.LazyNestedField(
        nested="commercetools._schemas._order.OrderSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.OrderPagedQueryResponse(**data)


class OrderReferenceSchema(ReferenceSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderReference`."""

    obj = helpers.LazyNestedField(
        nested="commercetools._schemas._order.OrderSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type_id"]
        return types.OrderReference(**data)


class OrderResourceIdentifierSchema(ResourceIdentifierSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderResourceIdentifier`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type_id"]
        return types.OrderResourceIdentifier(**data)


class OrderSchema(BaseResourceSchema):
    """Marshmallow schema for :class:`commercetools.types.Order`."""

    id = marshmallow.fields.String(allow_none=True)
    version = marshmallow.fields.Integer(allow_none=True)
    created_at = marshmallow.fields.DateTime(allow_none=True, data_key="createdAt")
    last_modified_at = marshmallow.fields.DateTime(
        allow_none=True, data_key="lastModifiedAt"
    )
    last_modified_by = helpers.LazyNestedField(
        nested="commercetools._schemas._common.LastModifiedBySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="lastModifiedBy",
    )
    created_by = helpers.LazyNestedField(
        nested="commercetools._schemas._common.CreatedBySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="createdBy",
    )
    completed_at = marshmallow.fields.DateTime(
        allow_none=True, missing=None, data_key="completedAt"
    )
    order_number = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="orderNumber"
    )
    customer_id = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="customerId"
    )
    customer_email = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="customerEmail"
    )
    anonymous_id = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="anonymousId"
    )
    store = helpers.LazyNestedField(
        nested="commercetools._schemas._store.StoreKeyReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    line_items = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.LineItemSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        data_key="lineItems",
    )
    custom_line_items = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.CustomLineItemSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        data_key="customLineItems",
    )
    total_price = helpers.Discriminator(
        discriminator_field=("type", "type"),
        discriminator_schemas={
            "centPrecision": "commercetools._schemas._common.CentPrecisionMoneySchema",
            "highPrecision": "commercetools._schemas._common.HighPrecisionMoneySchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="totalPrice",
    )
    taxed_price = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.TaxedPriceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="taxedPrice",
    )
    shipping_address = helpers.LazyNestedField(
        nested="commercetools._schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="shippingAddress",
    )
    billing_address = helpers.LazyNestedField(
        nested="commercetools._schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="billingAddress",
    )
    tax_mode = marshmallow_enum.EnumField(
        types.TaxMode, by_value=True, missing=None, data_key="taxMode"
    )
    tax_rounding_mode = marshmallow_enum.EnumField(
        types.RoundingMode, by_value=True, missing=None, data_key="taxRoundingMode"
    )
    customer_group = helpers.LazyNestedField(
        nested="commercetools._schemas._customer_group.CustomerGroupReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="customerGroup",
    )
    country = marshmallow.fields.String(allow_none=True, missing=None)
    order_state = marshmallow_enum.EnumField(
        types.OrderState, by_value=True, data_key="orderState"
    )
    state = helpers.LazyNestedField(
        nested="commercetools._schemas._state.StateReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    shipment_state = marshmallow_enum.EnumField(
        types.ShipmentState, by_value=True, missing=None, data_key="shipmentState"
    )
    payment_state = marshmallow_enum.EnumField(
        types.PaymentState, by_value=True, missing=None, data_key="paymentState"
    )
    shipping_info = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ShippingInfoSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="shippingInfo",
    )
    sync_info = helpers.LazyNestedField(
        nested="commercetools._schemas._order.SyncInfoSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        data_key="syncInfo",
    )
    return_info = helpers.LazyNestedField(
        nested="commercetools._schemas._order.ReturnInfoSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        missing=None,
        data_key="returnInfo",
    )
    discount_codes = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.DiscountCodeInfoSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        missing=None,
        data_key="discountCodes",
    )
    last_message_sequence_number = marshmallow.fields.Integer(
        allow_none=True, data_key="lastMessageSequenceNumber"
    )
    cart = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.CartReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    custom = helpers.LazyNestedField(
        nested="commercetools._schemas._type.CustomFieldsSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    payment_info = helpers.LazyNestedField(
        nested="commercetools._schemas._order.PaymentInfoSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="paymentInfo",
    )
    locale = marshmallow.fields.String(allow_none=True, missing=None)
    inventory_mode = marshmallow_enum.EnumField(
        types.InventoryMode, by_value=True, missing=None, data_key="inventoryMode"
    )
    origin = marshmallow_enum.EnumField(types.CartOrigin, by_value=True)
    tax_calculation_mode = marshmallow_enum.EnumField(
        types.TaxCalculationMode,
        by_value=True,
        missing=None,
        data_key="taxCalculationMode",
    )
    shipping_rate_input = helpers.Discriminator(
        discriminator_field=("type", "type"),
        discriminator_schemas={
            "Classification": "commercetools._schemas._cart.ClassificationShippingRateInputSchema",
            "Score": "commercetools._schemas._cart.ScoreShippingRateInputSchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="shippingRateInput",
    )
    item_shipping_addresses = helpers.LazyNestedField(
        nested="commercetools._schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        missing=None,
        data_key="itemShippingAddresses",
    )
    refused_gifts = helpers.LazyNestedField(
        nested="commercetools._schemas._cart_discount.CartDiscountReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        data_key="refusedGifts",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.Order(**data)


class OrderUpdateActionSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.OrderUpdateAction`."""

    action = marshmallow.fields.String(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderUpdateAction(**data)


class OrderUpdateSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.OrderUpdate`."""

    version = marshmallow.fields.Integer(allow_none=True)
    actions = marshmallow.fields.List(
        helpers.Discriminator(
            discriminator_field=("action", "action"),
            discriminator_schemas={
                "addDelivery": "commercetools._schemas._order.OrderAddDeliveryActionSchema",
                "addItemShippingAddress": "commercetools._schemas._order.OrderAddItemShippingAddressActionSchema",
                "addParcelToDelivery": "commercetools._schemas._order.OrderAddParcelToDeliveryActionSchema",
                "addPayment": "commercetools._schemas._order.OrderAddPaymentActionSchema",
                "addReturnInfo": "commercetools._schemas._order.OrderAddReturnInfoActionSchema",
                "changeOrderState": "commercetools._schemas._order.OrderChangeOrderStateActionSchema",
                "changePaymentState": "commercetools._schemas._order.OrderChangePaymentStateActionSchema",
                "changeShipmentState": "commercetools._schemas._order.OrderChangeShipmentStateActionSchema",
                "importCustomLineItemState": "commercetools._schemas._order.OrderImportCustomLineItemStateActionSchema",
                "importLineItemState": "commercetools._schemas._order.OrderImportLineItemStateActionSchema",
                "removeDelivery": "commercetools._schemas._order.OrderRemoveDeliveryActionSchema",
                "removeItemShippingAddress": "commercetools._schemas._order.OrderRemoveItemShippingAddressActionSchema",
                "removeParcelFromDelivery": "commercetools._schemas._order.OrderRemoveParcelFromDeliveryActionSchema",
                "removePayment": "commercetools._schemas._order.OrderRemovePaymentActionSchema",
                "setBillingAddress": "commercetools._schemas._order.OrderSetBillingAddressActionSchema",
                "setCustomField": "commercetools._schemas._order.OrderSetCustomFieldActionSchema",
                "setCustomLineItemCustomField": "commercetools._schemas._order.OrderSetCustomLineItemCustomFieldActionSchema",
                "setCustomLineItemCustomType": "commercetools._schemas._order.OrderSetCustomLineItemCustomTypeActionSchema",
                "setCustomLineItemShippingDetails": "commercetools._schemas._order.OrderSetCustomLineItemShippingDetailsActionSchema",
                "setCustomType": "commercetools._schemas._order.OrderSetCustomTypeActionSchema",
                "setCustomerEmail": "commercetools._schemas._order.OrderSetCustomerEmailActionSchema",
                "setCustomerId": "commercetools._schemas._order.OrderSetCustomerIdActionSchema",
                "setDeliveryAddress": "commercetools._schemas._order.OrderSetDeliveryAddressActionSchema",
                "setDeliveryItems": "commercetools._schemas._order.OrderSetDeliveryItemsActionSchema",
                "setLineItemCustomField": "commercetools._schemas._order.OrderSetLineItemCustomFieldActionSchema",
                "setLineItemCustomType": "commercetools._schemas._order.OrderSetLineItemCustomTypeActionSchema",
                "setLineItemShippingDetails": "commercetools._schemas._order.OrderSetLineItemShippingDetailsActionSchema",
                "setLocale": "commercetools._schemas._order.OrderSetLocaleActionSchema",
                "setOrderNumber": "commercetools._schemas._order.OrderSetOrderNumberActionSchema",
                "setParcelItems": "commercetools._schemas._order.OrderSetParcelItemsActionSchema",
                "setParcelMeasurements": "commercetools._schemas._order.OrderSetParcelMeasurementsActionSchema",
                "setParcelTrackingData": "commercetools._schemas._order.OrderSetParcelTrackingDataActionSchema",
                "setReturnPaymentState": "commercetools._schemas._order.OrderSetReturnPaymentStateActionSchema",
                "setReturnShipmentState": "commercetools._schemas._order.OrderSetReturnShipmentStateActionSchema",
                "setShippingAddress": "commercetools._schemas._order.OrderSetShippingAddressActionSchema",
                "setStore": "commercetools._schemas._order.OrderSetStoreActionSchema",
                "transitionCustomLineItemState": "commercetools._schemas._order.OrderTransitionCustomLineItemStateActionSchema",
                "transitionLineItemState": "commercetools._schemas._order.OrderTransitionLineItemStateActionSchema",
                "transitionState": "commercetools._schemas._order.OrderTransitionStateActionSchema",
                "updateItemShippingAddress": "commercetools._schemas._order.OrderUpdateItemShippingAddressActionSchema",
                "updateSyncInfo": "commercetools._schemas._order.OrderUpdateSyncInfoActionSchema",
            },
            unknown=marshmallow.EXCLUDE,
            allow_none=True,
        ),
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.OrderUpdate(**data)


class ParcelDraftSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.ParcelDraft`."""

    measurements = helpers.LazyNestedField(
        nested="commercetools._schemas._order.ParcelMeasurementsSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    tracking_data = helpers.LazyNestedField(
        nested="commercetools._schemas._order.TrackingDataSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="trackingData",
    )
    items = helpers.LazyNestedField(
        nested="commercetools._schemas._order.DeliveryItemSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.ParcelDraft(**data)


class ParcelMeasurementsSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.ParcelMeasurements`."""

    height_in_millimeter = marshmallow.fields.Integer(
        allow_none=True, missing=None, data_key="heightInMillimeter"
    )
    length_in_millimeter = marshmallow.fields.Integer(
        allow_none=True, missing=None, data_key="lengthInMillimeter"
    )
    width_in_millimeter = marshmallow.fields.Integer(
        allow_none=True, missing=None, data_key="widthInMillimeter"
    )
    weight_in_gram = marshmallow.fields.Integer(
        allow_none=True, missing=None, data_key="weightInGram"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.ParcelMeasurements(**data)


class ParcelSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.Parcel`."""

    id = marshmallow.fields.String(allow_none=True)
    created_at = marshmallow.fields.DateTime(allow_none=True, data_key="createdAt")
    measurements = helpers.LazyNestedField(
        nested="commercetools._schemas._order.ParcelMeasurementsSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    tracking_data = helpers.LazyNestedField(
        nested="commercetools._schemas._order.TrackingDataSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="trackingData",
    )
    items = helpers.LazyNestedField(
        nested="commercetools._schemas._order.DeliveryItemSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.Parcel(**data)


class PaymentInfoSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.PaymentInfo`."""

    payments = helpers.LazyNestedField(
        nested="commercetools._schemas._payment.PaymentReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.PaymentInfo(**data)


class ProductVariantImportDraftSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.ProductVariantImportDraft`."""

    id = marshmallow.fields.Integer(allow_none=True, missing=None)
    sku = marshmallow.fields.String(allow_none=True, missing=None)
    prices = helpers.LazyNestedField(
        nested="commercetools._schemas._common.PriceDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        missing=None,
    )
    attributes = helpers.LazyNestedField(
        nested="commercetools._schemas._product.AttributeSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        missing=None,
    )
    images = helpers.LazyNestedField(
        nested="commercetools._schemas._common.ImageSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.ProductVariantImportDraft(**data)


class ReturnInfoSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.ReturnInfo`."""

    items = marshmallow.fields.List(
        helpers.Discriminator(
            discriminator_field=("type", "type"),
            discriminator_schemas={
                "CustomLineItemReturnItem": "commercetools._schemas._order.CustomLineItemReturnItemSchema",
                "LineItemReturnItem": "commercetools._schemas._order.LineItemReturnItemSchema",
            },
            unknown=marshmallow.EXCLUDE,
            allow_none=True,
        )
    )
    return_tracking_id = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="returnTrackingId"
    )
    return_date = marshmallow.fields.DateTime(
        allow_none=True, missing=None, data_key="returnDate"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.ReturnInfo(**data)


class ReturnItemDraftSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.ReturnItemDraft`."""

    quantity = marshmallow.fields.Integer(allow_none=True)
    line_item_id = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="lineItemId"
    )
    custom_line_item_id = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="customLineItemId"
    )
    comment = marshmallow.fields.String(allow_none=True, missing=None)
    shipment_state = marshmallow_enum.EnumField(
        types.ReturnShipmentState, by_value=True, data_key="shipmentState"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.ReturnItemDraft(**data)


class ReturnItemSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.ReturnItem`."""

    id = marshmallow.fields.String(allow_none=True)
    quantity = marshmallow.fields.Integer(allow_none=True)
    type = marshmallow.fields.String(allow_none=True)
    comment = marshmallow.fields.String(allow_none=True, missing=None)
    shipment_state = marshmallow_enum.EnumField(
        types.ReturnShipmentState, by_value=True, data_key="shipmentState"
    )
    payment_state = marshmallow_enum.EnumField(
        types.ReturnPaymentState, by_value=True, data_key="paymentState"
    )
    last_modified_at = marshmallow.fields.DateTime(
        allow_none=True, data_key="lastModifiedAt"
    )
    created_at = marshmallow.fields.DateTime(allow_none=True, data_key="createdAt")

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ReturnItem(**data)


class ShippingInfoImportDraftSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.ShippingInfoImportDraft`."""

    shipping_method_name = marshmallow.fields.String(
        allow_none=True, data_key="shippingMethodName"
    )
    price = helpers.LazyNestedField(
        nested="commercetools._schemas._common.MoneySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    shipping_rate = helpers.LazyNestedField(
        nested="commercetools._schemas._shipping_method.ShippingRateDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="shippingRate",
    )
    tax_rate = helpers.LazyNestedField(
        nested="commercetools._schemas._tax_category.TaxRateSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="taxRate",
    )
    tax_category = helpers.LazyNestedField(
        nested="commercetools._schemas._tax_category.TaxCategoryResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="taxCategory",
    )
    shipping_method = helpers.LazyNestedField(
        nested="commercetools._schemas._shipping_method.ShippingMethodResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="shippingMethod",
    )
    deliveries = helpers.LazyNestedField(
        nested="commercetools._schemas._order.DeliverySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        missing=None,
    )
    discounted_price = helpers.LazyNestedField(
        nested="commercetools._schemas._order.DiscountedLineItemPriceDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="discountedPrice",
    )
    shipping_method_state = marshmallow_enum.EnumField(
        types.ShippingMethodState,
        by_value=True,
        missing=None,
        data_key="shippingMethodState",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.ShippingInfoImportDraft(**data)


class StagedOrderUpdateActionSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderUpdateAction`."""

    action = marshmallow.fields.String(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderUpdateAction(**data)


class SyncInfoSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.SyncInfo`."""

    channel = helpers.LazyNestedField(
        nested="commercetools._schemas._channel.ChannelReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    external_id = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="externalId"
    )
    synced_at = marshmallow.fields.DateTime(allow_none=True, data_key="syncedAt")

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.SyncInfo(**data)


class TaxedItemPriceDraftSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.TaxedItemPriceDraft`."""

    total_net = helpers.LazyNestedField(
        nested="commercetools._schemas._common.MoneySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="totalNet",
    )
    total_gross = helpers.LazyNestedField(
        nested="commercetools._schemas._common.MoneySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="totalGross",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.TaxedItemPriceDraft(**data)


class TrackingDataSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.TrackingData`."""

    tracking_id = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="trackingId"
    )
    carrier = marshmallow.fields.String(allow_none=True, missing=None)
    provider = marshmallow.fields.String(allow_none=True, missing=None)
    provider_transaction = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="providerTransaction"
    )
    is_return = marshmallow.fields.Bool(
        allow_none=True, missing=None, data_key="isReturn"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.TrackingData(**data)


class CustomLineItemReturnItemSchema(ReturnItemSchema):
    """Marshmallow schema for :class:`commercetools.types.CustomLineItemReturnItem`."""

    custom_line_item_id = marshmallow.fields.String(
        allow_none=True, data_key="customLineItemId"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.CustomLineItemReturnItem(**data)


class LineItemReturnItemSchema(ReturnItemSchema):
    """Marshmallow schema for :class:`commercetools.types.LineItemReturnItem`."""

    line_item_id = marshmallow.fields.String(allow_none=True, data_key="lineItemId")

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.LineItemReturnItem(**data)


class OrderAddDeliveryActionSchema(OrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderAddDeliveryAction`."""

    items = helpers.LazyNestedField(
        nested="commercetools._schemas._order.DeliveryItemSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        missing=None,
    )
    address = helpers.LazyNestedField(
        nested="commercetools._schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    parcels = helpers.LazyNestedField(
        nested="commercetools._schemas._order.ParcelDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderAddDeliveryAction(**data)


class OrderAddItemShippingAddressActionSchema(OrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderAddItemShippingAddressAction`."""

    address = helpers.LazyNestedField(
        nested="commercetools._schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderAddItemShippingAddressAction(**data)


class OrderAddParcelToDeliveryActionSchema(OrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderAddParcelToDeliveryAction`."""

    delivery_id = marshmallow.fields.String(allow_none=True, data_key="deliveryId")
    measurements = helpers.LazyNestedField(
        nested="commercetools._schemas._order.ParcelMeasurementsSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    tracking_data = helpers.LazyNestedField(
        nested="commercetools._schemas._order.TrackingDataSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="trackingData",
    )
    items = helpers.LazyNestedField(
        nested="commercetools._schemas._order.DeliveryItemSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderAddParcelToDeliveryAction(**data)


class OrderAddPaymentActionSchema(OrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderAddPaymentAction`."""

    payment = helpers.LazyNestedField(
        nested="commercetools._schemas._payment.PaymentResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderAddPaymentAction(**data)


class OrderAddReturnInfoActionSchema(OrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderAddReturnInfoAction`."""

    return_tracking_id = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="returnTrackingId"
    )
    items = helpers.LazyNestedField(
        nested="commercetools._schemas._order.ReturnItemDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
    )
    return_date = marshmallow.fields.DateTime(
        allow_none=True, missing=None, data_key="returnDate"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderAddReturnInfoAction(**data)


class OrderChangeOrderStateActionSchema(OrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderChangeOrderStateAction`."""

    order_state = marshmallow_enum.EnumField(
        types.OrderState, by_value=True, data_key="orderState"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderChangeOrderStateAction(**data)


class OrderChangePaymentStateActionSchema(OrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderChangePaymentStateAction`."""

    payment_state = marshmallow_enum.EnumField(
        types.PaymentState, by_value=True, missing=None, data_key="paymentState"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderChangePaymentStateAction(**data)


class OrderChangeShipmentStateActionSchema(OrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderChangeShipmentStateAction`."""

    shipment_state = marshmallow_enum.EnumField(
        types.ShipmentState, by_value=True, missing=None, data_key="shipmentState"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderChangeShipmentStateAction(**data)


class OrderImportCustomLineItemStateActionSchema(OrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderImportCustomLineItemStateAction`."""

    custom_line_item_id = marshmallow.fields.String(
        allow_none=True, data_key="customLineItemId"
    )
    state = helpers.LazyNestedField(
        nested="commercetools._schemas._order.ItemStateSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderImportCustomLineItemStateAction(**data)


class OrderImportLineItemStateActionSchema(OrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderImportLineItemStateAction`."""

    line_item_id = marshmallow.fields.String(allow_none=True, data_key="lineItemId")
    state = helpers.LazyNestedField(
        nested="commercetools._schemas._order.ItemStateSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderImportLineItemStateAction(**data)


class OrderRemoveDeliveryActionSchema(OrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderRemoveDeliveryAction`."""

    delivery_id = marshmallow.fields.String(allow_none=True, data_key="deliveryId")

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderRemoveDeliveryAction(**data)


class OrderRemoveItemShippingAddressActionSchema(OrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderRemoveItemShippingAddressAction`."""

    address_key = marshmallow.fields.String(allow_none=True, data_key="addressKey")

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderRemoveItemShippingAddressAction(**data)


class OrderRemoveParcelFromDeliveryActionSchema(OrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderRemoveParcelFromDeliveryAction`."""

    parcel_id = marshmallow.fields.String(allow_none=True, data_key="parcelId")

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderRemoveParcelFromDeliveryAction(**data)


class OrderRemovePaymentActionSchema(OrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderRemovePaymentAction`."""

    payment = helpers.LazyNestedField(
        nested="commercetools._schemas._payment.PaymentResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderRemovePaymentAction(**data)


class OrderSetBillingAddressActionSchema(OrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderSetBillingAddressAction`."""

    address = helpers.LazyNestedField(
        nested="commercetools._schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderSetBillingAddressAction(**data)


class OrderSetCustomFieldActionSchema(OrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderSetCustomFieldAction`."""

    name = marshmallow.fields.String(allow_none=True)
    value = marshmallow.fields.Raw(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderSetCustomFieldAction(**data)


class OrderSetCustomLineItemCustomFieldActionSchema(OrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderSetCustomLineItemCustomFieldAction`."""

    custom_line_item_id = marshmallow.fields.String(
        allow_none=True, data_key="customLineItemId"
    )
    name = marshmallow.fields.String(allow_none=True)
    value = marshmallow.fields.Raw(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderSetCustomLineItemCustomFieldAction(**data)


class OrderSetCustomLineItemCustomTypeActionSchema(OrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderSetCustomLineItemCustomTypeAction`."""

    custom_line_item_id = marshmallow.fields.String(
        allow_none=True, data_key="customLineItemId"
    )
    type = helpers.LazyNestedField(
        nested="commercetools._schemas._type.TypeResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    fields = FieldContainerField(allow_none=True, missing=None)  # type: ignore

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderSetCustomLineItemCustomTypeAction(**data)


class OrderSetCustomLineItemShippingDetailsActionSchema(OrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderSetCustomLineItemShippingDetailsAction`."""

    custom_line_item_id = marshmallow.fields.String(
        allow_none=True, data_key="customLineItemId"
    )
    shipping_details = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ItemShippingDetailsDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="shippingDetails",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderSetCustomLineItemShippingDetailsAction(**data)


class OrderSetCustomTypeActionSchema(OrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderSetCustomTypeAction`."""

    type = helpers.LazyNestedField(
        nested="commercetools._schemas._type.TypeResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    fields = FieldContainerField(allow_none=True, missing=None)  # type: ignore

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderSetCustomTypeAction(**data)


class OrderSetCustomerEmailActionSchema(OrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderSetCustomerEmailAction`."""

    email = marshmallow.fields.String(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderSetCustomerEmailAction(**data)


class OrderSetCustomerIdActionSchema(OrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderSetCustomerIdAction`."""

    customer_id = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="customerId"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderSetCustomerIdAction(**data)


class OrderSetDeliveryAddressActionSchema(OrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderSetDeliveryAddressAction`."""

    delivery_id = marshmallow.fields.String(allow_none=True, data_key="deliveryId")
    address = helpers.LazyNestedField(
        nested="commercetools._schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderSetDeliveryAddressAction(**data)


class OrderSetDeliveryItemsActionSchema(OrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderSetDeliveryItemsAction`."""

    delivery_id = marshmallow.fields.String(allow_none=True, data_key="deliveryId")
    items = helpers.LazyNestedField(
        nested="commercetools._schemas._order.DeliveryItemSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderSetDeliveryItemsAction(**data)


class OrderSetLineItemCustomFieldActionSchema(OrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderSetLineItemCustomFieldAction`."""

    line_item_id = marshmallow.fields.String(allow_none=True, data_key="lineItemId")
    name = marshmallow.fields.String(allow_none=True)
    value = marshmallow.fields.Raw(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderSetLineItemCustomFieldAction(**data)


class OrderSetLineItemCustomTypeActionSchema(OrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderSetLineItemCustomTypeAction`."""

    line_item_id = marshmallow.fields.String(allow_none=True, data_key="lineItemId")
    type = helpers.LazyNestedField(
        nested="commercetools._schemas._type.TypeResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    fields = FieldContainerField(allow_none=True, missing=None)  # type: ignore

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderSetLineItemCustomTypeAction(**data)


class OrderSetLineItemShippingDetailsActionSchema(OrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderSetLineItemShippingDetailsAction`."""

    line_item_id = marshmallow.fields.String(allow_none=True, data_key="lineItemId")
    shipping_details = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ItemShippingDetailsDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="shippingDetails",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderSetLineItemShippingDetailsAction(**data)


class OrderSetLocaleActionSchema(OrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderSetLocaleAction`."""

    locale = marshmallow.fields.String(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderSetLocaleAction(**data)


class OrderSetOrderNumberActionSchema(OrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderSetOrderNumberAction`."""

    order_number = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="orderNumber"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderSetOrderNumberAction(**data)


class OrderSetParcelItemsActionSchema(OrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderSetParcelItemsAction`."""

    parcel_id = marshmallow.fields.String(allow_none=True, data_key="parcelId")
    items = helpers.LazyNestedField(
        nested="commercetools._schemas._order.DeliveryItemSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderSetParcelItemsAction(**data)


class OrderSetParcelMeasurementsActionSchema(OrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderSetParcelMeasurementsAction`."""

    parcel_id = marshmallow.fields.String(allow_none=True, data_key="parcelId")
    measurements = helpers.LazyNestedField(
        nested="commercetools._schemas._order.ParcelMeasurementsSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderSetParcelMeasurementsAction(**data)


class OrderSetParcelTrackingDataActionSchema(OrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderSetParcelTrackingDataAction`."""

    parcel_id = marshmallow.fields.String(allow_none=True, data_key="parcelId")
    tracking_data = helpers.LazyNestedField(
        nested="commercetools._schemas._order.TrackingDataSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="trackingData",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderSetParcelTrackingDataAction(**data)


class OrderSetReturnPaymentStateActionSchema(OrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderSetReturnPaymentStateAction`."""

    return_item_id = marshmallow.fields.String(allow_none=True, data_key="returnItemId")
    payment_state = marshmallow_enum.EnumField(
        types.ReturnPaymentState, by_value=True, data_key="paymentState"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderSetReturnPaymentStateAction(**data)


class OrderSetReturnShipmentStateActionSchema(OrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderSetReturnShipmentStateAction`."""

    return_item_id = marshmallow.fields.String(allow_none=True, data_key="returnItemId")
    shipment_state = marshmallow_enum.EnumField(
        types.ReturnShipmentState, by_value=True, data_key="shipmentState"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderSetReturnShipmentStateAction(**data)


class OrderSetShippingAddressActionSchema(OrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderSetShippingAddressAction`."""

    address = helpers.LazyNestedField(
        nested="commercetools._schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderSetShippingAddressAction(**data)


class OrderSetStoreActionSchema(OrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderSetStoreAction`."""

    store = helpers.LazyNestedField(
        nested="commercetools._schemas._store.StoreResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderSetStoreAction(**data)


class OrderTransitionCustomLineItemStateActionSchema(OrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderTransitionCustomLineItemStateAction`."""

    custom_line_item_id = marshmallow.fields.String(
        allow_none=True, data_key="customLineItemId"
    )
    quantity = marshmallow.fields.Integer(allow_none=True)
    from_state = helpers.LazyNestedField(
        nested="commercetools._schemas._state.StateResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="fromState",
    )
    to_state = helpers.LazyNestedField(
        nested="commercetools._schemas._state.StateResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="toState",
    )
    actual_transition_date = marshmallow.fields.DateTime(
        allow_none=True, missing=None, data_key="actualTransitionDate"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderTransitionCustomLineItemStateAction(**data)


class OrderTransitionLineItemStateActionSchema(OrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderTransitionLineItemStateAction`."""

    line_item_id = marshmallow.fields.String(allow_none=True, data_key="lineItemId")
    quantity = marshmallow.fields.Integer(allow_none=True)
    from_state = helpers.LazyNestedField(
        nested="commercetools._schemas._state.StateResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="fromState",
    )
    to_state = helpers.LazyNestedField(
        nested="commercetools._schemas._state.StateResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="toState",
    )
    actual_transition_date = marshmallow.fields.DateTime(
        allow_none=True, missing=None, data_key="actualTransitionDate"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderTransitionLineItemStateAction(**data)


class OrderTransitionStateActionSchema(OrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderTransitionStateAction`."""

    state = helpers.LazyNestedField(
        nested="commercetools._schemas._state.StateResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    force = marshmallow.fields.Bool(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderTransitionStateAction(**data)


class OrderUpdateItemShippingAddressActionSchema(OrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderUpdateItemShippingAddressAction`."""

    address = helpers.LazyNestedField(
        nested="commercetools._schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderUpdateItemShippingAddressAction(**data)


class OrderUpdateSyncInfoActionSchema(OrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderUpdateSyncInfoAction`."""

    channel = helpers.LazyNestedField(
        nested="commercetools._schemas._channel.ChannelResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    external_id = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="externalId"
    )
    synced_at = marshmallow.fields.DateTime(
        allow_none=True, missing=None, data_key="syncedAt"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderUpdateSyncInfoAction(**data)
