/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.field.DecoratedDateTimeField;
import org.joda.time.field.FieldUtils;

public class OffsetDateTimeField
extends DecoratedDateTimeField {
    private static final long serialVersionUID = 3145790132623583142L;
    private final int iOffset;
    private final int iMin;
    private final int iMax;

    public OffsetDateTimeField(DateTimeField dateTimeField, int n2) {
        this(dateTimeField, dateTimeField == null ? null : dateTimeField.getType(), n2, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public OffsetDateTimeField(DateTimeField dateTimeField, DateTimeFieldType dateTimeFieldType, int n2) {
        this(dateTimeField, dateTimeFieldType, n2, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public OffsetDateTimeField(DateTimeField dateTimeField, DateTimeFieldType dateTimeFieldType, int n2, int n3, int n4) {
        super(dateTimeField, dateTimeFieldType);
        if (n2 == 0) {
            throw new IllegalArgumentException("The offset cannot be zero");
        }
        this.iOffset = n2;
        this.iMin = n3 < dateTimeField.getMinimumValue() + n2 ? dateTimeField.getMinimumValue() + n2 : n3;
        this.iMax = n4 > dateTimeField.getMaximumValue() + n2 ? dateTimeField.getMaximumValue() + n2 : n4;
    }

    public int get(long l2) {
        return super.get(l2) + this.iOffset;
    }

    public long add(long l2, int n2) {
        l2 = super.add(l2, n2);
        FieldUtils.verifyValueBounds(this, this.get(l2), this.iMin, this.iMax);
        return l2;
    }

    public long add(long l2, long l3) {
        l2 = super.add(l2, l3);
        FieldUtils.verifyValueBounds(this, this.get(l2), this.iMin, this.iMax);
        return l2;
    }

    public long addWrapField(long l2, int n2) {
        return this.set(l2, FieldUtils.getWrappedValue(this.get(l2), n2, this.iMin, this.iMax));
    }

    public long set(long l2, int n2) {
        FieldUtils.verifyValueBounds(this, n2, this.iMin, this.iMax);
        return super.set(l2, n2 - this.iOffset);
    }

    public boolean isLeap(long l2) {
        return this.getWrappedField().isLeap(l2);
    }

    public int getLeapAmount(long l2) {
        return this.getWrappedField().getLeapAmount(l2);
    }

    public DurationField getLeapDurationField() {
        return this.getWrappedField().getLeapDurationField();
    }

    public int getMinimumValue() {
        return this.iMin;
    }

    public int getMaximumValue() {
        return this.iMax;
    }

    public long roundFloor(long l2) {
        return this.getWrappedField().roundFloor(l2);
    }

    public long roundCeiling(long l2) {
        return this.getWrappedField().roundCeiling(l2);
    }

    public long roundHalfFloor(long l2) {
        return this.getWrappedField().roundHalfFloor(l2);
    }

    public long roundHalfCeiling(long l2) {
        return this.getWrappedField().roundHalfCeiling(l2);
    }

    public long roundHalfEven(long l2) {
        return this.getWrappedField().roundHalfEven(l2);
    }

    public long remainder(long l2) {
        return this.getWrappedField().remainder(l2);
    }

    public int getOffset() {
        return this.iOffset;
    }
}

