/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.gam;

import hex.genmodel.algos.gam.GamMojoModelBase;
import hex.genmodel.utils.DistributionFamily;

public class GamMojoMultinomialModel
extends GamMojoModelBase {
    private boolean _trueMultinomial;

    GamMojoMultinomialModel(String[] columns, String[][] domains, String responseColumn) {
        super(columns, domains, responseColumn);
    }

    @Override
    void init() {
        super.init();
        this._trueMultinomial = this._family.equals((Object)DistributionFamily.multinomial);
    }

    @Override
    double[] gamScore0(double[] row, double[] preds) {
        this._beta_multinomial = row.length == this.nfeatures() ? this._beta_multinomial_center : this._beta_multinomial_no_center;
        for (int c2 = 0; c2 < this._nclasses; ++c2) {
            preds[c2 + 1] = this.generateEta(this._beta_multinomial[c2], row);
        }
        if (this._trueMultinomial) {
            return this.postPredMultinomial(preds);
        }
        return this.postPredOrdinal(preds);
    }

    double[] postPredMultinomial(double[] preds) {
        int c2;
        double max_row = 0.0;
        double sum_exp = 0.0;
        for (c2 = 1; c2 < preds.length; ++c2) {
            if (!(preds[c2] > max_row)) continue;
            max_row = preds[c2];
        }
        for (c2 = 1; c2 < preds.length; ++c2) {
            preds[c2] = Math.exp(preds[c2] - max_row);
            sum_exp += preds[c2];
        }
        sum_exp = 1.0 / sum_exp;
        double max_p = 0.0;
        for (int c3 = 1; c3 < preds.length; ++c3) {
            int n2 = c3;
            double d2 = preds[n2] = preds[n2] * sum_exp;
            if (!(d2 > max_p)) continue;
            max_p = preds[c3];
            preds[0] = c3 - 1;
        }
        return preds;
    }

    double[] postPredOrdinal(double[] preds) {
        int cInd;
        double previousCDF = 0.0;
        preds[0] = this._lastClass;
        for (cInd = 0; cInd < this._lastClass; ++cInd) {
            double eta = preds[cInd + 1];
            double currCDF = 1.0 / (1.0 + Math.exp(-eta));
            preds[cInd + 1] = currCDF - previousCDF;
            previousCDF = currCDF;
            if (!(eta > 0.0)) continue;
            preds[0] = cInd;
            break;
        }
        for (cInd = (int)preds[0] + 1; cInd < this._lastClass; ++cInd) {
            double currCDF = 1.0 / (1.0 + Math.exp(-preds[cInd + 1]));
            preds[cInd + 1] = currCDF - previousCDF;
            previousCDF = currCDF;
        }
        preds[this._nclasses] = 1.0 - previousCDF;
        return preds;
    }
}

