"use strict";
/**
 *  Copyright 2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const cdk = require("@aws-cdk/core");
const lib_1 = require("../lib");
const api = require("@aws-cdk/aws-apigateway");
const iam = require("@aws-cdk/aws-iam");
// App setup
const app = new cdk.App();
const stack = new cdk.Stack(app, 'test-apigateway-iot-overriden-params');
stack.templateOptions.description = 'Integration Test for aws-apigateway-iot with overriden params';
const apiGatewayProps = {
    restApiName: 'RestApi-Regional',
    description: 'Description for the Regional Rest Api',
    endpointConfiguration: { types: [api.EndpointType.REGIONAL] },
    apiKeySourceType: api.ApiKeySourceType.HEADER,
    defaultMethodOptions: {
        authorizationType: api.AuthorizationType.NONE,
    }
};
const policyJSON = {
    Version: "2012-10-17",
    Statement: [
        {
            Action: [
                "iot:UpdateThingShadow"
            ],
            Resource: `arn:aws:iot:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:thing/*`,
            Effect: "Allow"
        },
        {
            Action: [
                "iot:Publish"
            ],
            Resource: `arn:aws:iot:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:topic/*`,
            Effect: "Allow"
        }
    ]
};
const policyDocument = iam.PolicyDocument.fromJson(policyJSON);
const iamRoleProps = {
    assumedBy: new iam.ServicePrincipal('apigateway.amazonaws.com'),
    path: '/',
    inlinePolicies: { testPolicy: policyDocument }
};
// Create a policy that overrides the default policy that gets created with the construct
const apiGatewayExecutionRole = new iam.Role(stack, 'apigateway-iot-role', iamRoleProps);
// Api gateway setup
const props = {
    iotEndpoint: 'a1234567890123-ats',
    apiGatewayCreateApiKey: true,
    apiGatewayExecutionRole,
    apiGatewayProps
};
// Instantiate construct
new lib_1.ApiGatewayToIot(stack, 'test-apigateway-iot', props);
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,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