# PyCrystallography

Python 3 package being written to illustrate crystallography.\
\
The features of the package include:
- [Atomic Structures](https://github.com/Shellywell123/PyCrystallography/blob/main/docs/atomic_structures.md)\
(Miller Indices, Lattices, primitive unit cells, Triangle Subdivision, Penrose Tiling)
- [3D Crystal Models](https://github.com/Shellywell123/PyCrystallography/blob/main/docs/shapes.md)\
(Cuboids,Pyramids,Bipyramids,Prisms,Biprismid,Tetrakis)
- [Stereographic Projections](https://github.com/Shellywell123/PyCrystallography/blob/main/docs/stereographic_projections.md)\
(Face normal detection of a 3D model, projected normals converted to stereographic projections)
- [Operations](https://github.com/Shellywell123/PyCrystallography/blob/main/docs/operations.md)\
(Inversion, Reflection, Rotation)
- [Stereographic Projections](https://github.com/Shellywell123/PyCrystallography/blob/main/docs/stereographic_projections.md)\
(n-fold roataion detection of stereographic projections)


## Some Examples
### Penrose Tiling

<p float="left">
  <img src="PyCrystallography/Images/penrose_tiling_sun.gif" width="400" />
  <img src="PyCrystallography/Images/penrose_tiling_star.gif" width="400" />
</p>


### Atomic Structures
More info at [Atomic Structures](https://github.com/Shellywell123/PyCrystallography/blob/main/docs/atomic_structures.md)

<p float="left">
  <img src="PyCrystallography/Images/diamond_unit_cell.gif" width="400" />
  <img src="PyCrystallography/Images/diamond_lattice.gif" width="400" />
</p>


### Operations
More info at [Operations](https://github.com/Shellywell123/PyCrystallography/blob/main/docs/operations.md)

<p float="left">
  <img src="PyCrystallography/Images/inversion.gif" width="400" />
  <img src="PyCrystallography/Images/reflection.gif" width="400" />
</p>


### Miller Indices

<p float="left">
  <img src="PyCrystallography/Images/cube_reflection.gif" width="400" />
  <img src="PyCrystallography/Images/cube_reflection_diag.gif" width="400" />
</p>

### Shapes
More info at [Shapes](https://github.com/Shellywell123/PyCrystallography/blob/main/docs/shapes.md)

<p float="left">
  <img src="PyCrystallography/Images/cube.gif" width="400" />
  <img src="PyCrystallography/Images/bipyramid10.gif" width="400" />
</p>

### Face normal detection and Stereographic Projections
More info at [Stereographic Projections](https://github.com/Shellywell123/PyCrystallography/blob/main/docs/stereographic_projections.md)

<p float="left">
  <img src="PyCrystallography/Images/face_normals_tetrakis.gif" width="400" />
  <img src="PyCrystallography/Images/stereographic_projection_tetrakis.png" width="400" />
</p>

### Identifying Symmetries
More info at [symmetries](https://github.com/Shellywell123/PyCrystallography/blob/main/docs/idenitfying_symmetries.md)
