import * as s3 from '@aws-cdk/aws-s3';
import * as cdk from '@aws-cdk/core';
/**
 * @stability stable
 */
export declare enum ReplicationDestinationStorageClass {
    /**
     * @stability stable
     */
    DEEP_ARCHIVE = "DEEP_ARCHIVE",
    /**
     * @stability stable
     */
    GLACIER = "GLACIER",
    /**
     * @stability stable
     */
    INTELLIGENT_TIERING = "INTELLIGENT_TIERING",
    /**
     * @stability stable
     */
    ONEZONE_IA = "ONEZONE_IA",
    /**
     * @stability stable
     */
    OUTPOSTS = "OUTPOSTS",
    /**
     * @stability stable
     */
    REDUCED_REDUNDANCY = "REDUCED_REDUNDANCY",
    /**
     * @stability stable
     */
    STANDARD = "STANDARD",
    /**
     * @stability stable
     */
    STANDARD_IA = "STANDARD_IA"
}
/**
 * @stability stable
 */
export declare enum ReplicationRuleStatus {
    /**
     * @stability stable
     */
    DISABLED = "Disabled",
    /**
     * @stability stable
     */
    ENABLED = "Enabled"
}
/**
 * @stability stable
 */
export interface ReplicationRulePropertyNoDestination {
    /**
     * @stability stable
     */
    readonly status?: ReplicationRuleStatus;
    /**
     * @stability stable
     */
    readonly deleteMarkerReplication?: cdk.IResolvable | s3.CfnBucket.DeleteMarkerReplicationProperty;
    /**
     * @stability stable
     */
    readonly filter?: cdk.IResolvable | s3.CfnBucket.ReplicationRuleFilterProperty;
    /**
     * @stability stable
     */
    readonly id?: string;
    /**
     * @stability stable
     */
    readonly prefix?: string;
    /**
     * @stability stable
     */
    readonly priority?: number;
    /**
     * @stability stable
     */
    readonly sourceSelectionCriteria?: cdk.IResolvable | s3.CfnBucket.SourceSelectionCriteriaProperty;
}
/**
 * @stability stable
 */
export interface ReplicationDestinationPropertyNoBucket {
    /**
     * @stability stable
     */
    readonly accessControlTranslation?: cdk.IResolvable | s3.CfnBucket.AccessControlTranslationProperty;
    /**
     * @stability stable
     */
    readonly account?: string;
    /**
     * @stability stable
     */
    readonly encryptionConfiguration?: cdk.IResolvable | s3.CfnBucket.EncryptionConfigurationProperty;
    /**
     * @stability stable
     */
    readonly metrics?: cdk.IResolvable | s3.CfnBucket.MetricsProperty;
    /**
     * @stability stable
     */
    readonly replicationTime?: cdk.IResolvable | s3.CfnBucket.ReplicationTimeProperty;
    /**
     * @stability stable
     */
    readonly storageClass?: ReplicationDestinationStorageClass;
}
/**
 * @stability stable
 */
export interface BucketReplicationProps {
    /**
     * @stability stable
     */
    readonly sourceBucket: s3.Bucket;
    /**
     * @stability stable
     */
    readonly destinationBucket: s3.Bucket;
    /**
     * @stability stable
     */
    readonly replicationRuleProperties?: ReplicationRulePropertyNoDestination;
    /**
     * @stability stable
     */
    readonly replicationDestinationProperties?: ReplicationDestinationPropertyNoBucket;
}
/**
 * @stability stable
 */
export declare class BucketReplication extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: BucketReplicationProps);
}
