"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.countResources = exports.hasResource = exports.findResources = void 0;
const section_1 = require("./section");
function findResources(template, type, props = {}) {
    const section = template.Resources;
    const result = section_1.matchSection(filterType(section, type), props);
    if (!result.match) {
        return {};
    }
    return result.matches;
}
exports.findResources = findResources;
function hasResource(template, type, props) {
    const section = template.Resources;
    const result = section_1.matchSection(filterType(section, type), props);
    if (result.match) {
        return;
    }
    if (result.closestResult === undefined) {
        return `No resource with type ${type} found`;
    }
    return [
        `Template has ${result.analyzedCount} resources with type ${type}, but none match as expected.`,
        section_1.formatFailure(result.closestResult),
    ].join('\n');
}
exports.hasResource = hasResource;
function countResources(template, type) {
    const section = template.Resources;
    const types = filterType(section, type);
    return Object.entries(types).length;
}
exports.countResources = countResources;
function filterType(section, type) {
    return Object.entries(section !== null && section !== void 0 ? section : {})
        .filter(([_, v]) => v.Type === type)
        .reduce((agg, [k, v]) => { return { ...agg, [k]: v }; }, {});
}
//# sourceMappingURL=data:application/json;base64,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