import { Matcher, MatchResult } from './matcher';
/**
 * (experimental) Capture values while matching templates.
 *
 * Using an instance of this class within a Matcher will capture the matching value.
 * The `as*()` APIs on the instance can be used to get the captured value.
 *
 * @experimental
 */
export declare class Capture extends Matcher {
    /**
     * (experimental) A name for the matcher.
     *
     * This is collected as part of the result and may be presented to the user.
     *
     * @experimental
     */
    readonly name: string;
    private value;
    /**
     * @experimental
     */
    constructor();
    /**
     * (experimental) Test whether a target matches the provided pattern.
     *
     * Every Matcher must implement this method.
     * This method will be invoked by the assertions framework. Do not call this method directly.
     *
     * @experimental
     */
    test(actual: any): MatchResult;
    /**
     * (experimental) Retrieve the captured value as a string.
     *
     * An error is generated if no value is captured or if the value is not a string.
     *
     * @experimental
     */
    asString(): string;
    /**
     * (experimental) Retrieve the captured value as a number.
     *
     * An error is generated if no value is captured or if the value is not a number.
     *
     * @experimental
     */
    asNumber(): number;
    /**
     * (experimental) Retrieve the captured value as a boolean.
     *
     * An error is generated if no value is captured or if the value is not a boolean.
     *
     * @experimental
     */
    asBoolean(): boolean;
    /**
     * (experimental) Retrieve the captured value as an array.
     *
     * An error is generated if no value is captured or if the value is not an array.
     *
     * @experimental
     */
    asArray(): any[];
    /**
     * (experimental) Retrieve the captured value as a JSON object.
     *
     * An error is generated if no value is captured or if the value is not an object.
     *
     * @experimental
     */
    asObject(): {
        [key: string]: any;
    };
    private checkNotNull;
    private reportIncorrectType;
}
