# generated by datamodel-codegen:
#   filename:  schema/entity/policies/accessControl/rule.json
#   timestamp: 2022-01-17T05:47:48+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field

from ....type import tagLabel
from ...teams import team


class Operation(Enum):
    SuggestDescription = 'SuggestDescription'
    SuggestTags = 'SuggestTags'
    UpdateDescription = 'UpdateDescription'
    UpdateOwner = 'UpdateOwner'
    UpdateTags = 'UpdateTags'


class AccessControlRule(BaseModel):
    class Config:
        extra = Extra.forbid

    name: str = Field(..., description='Name for this Rule.')
    entityTypeAttr: Optional[str] = Field(
        None, description='Entity type that the rule should match on'
    )
    entityTagAttr: Optional[tagLabel.TagFQN] = Field(
        None, description='Entity tag that the rule should match on'
    )
    userRoleAttr: Optional[team.TeamName] = Field(
        None, description='Role of the user that the rule should match on'
    )
    operation: Optional[Operation] = Field(None, description='Operation on the entity.')
    allow: Optional[bool] = Field(
        False, description='Allow or Deny operation on the entity.'
    )
    priority: Optional[int] = Field(
        0, description='Priority of this rule among other rules in this policy.'
    )
    enabled: Optional[bool] = Field(True, description='Is the rule enabled.')
