"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTest = exports.IntegTestCaseStack = exports.IntegTestCase = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cloud_assembly_schema_1 = require("aws-cdk-lib/cloud-assembly-schema");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const deploy_assert_1 = require("./assertions/private/deploy-assert");
const manifest_synthesizer_1 = require("./manifest-synthesizer");
const TEST_CASE_STACK_SYMBOL = Symbol.for('@aws-cdk/integ-tests.IntegTestCaseStack');
/**
 * An integration test case. Allows the definition of test properties that
 * apply to all stacks under this case.
 *
 * It is recommended that you use the IntegTest construct since that will create
 * a default IntegTestCase
 */
class IntegTestCase extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_IntegTestCaseProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, IntegTestCase);
            }
            throw error;
        }
        this._assert = new deploy_assert_1.DeployAssert(this);
        this.assertions = this._assert;
    }
    /**
     * The integration test manifest for this test case. Manifests are used
     * by the integration test runner.
     */
    get manifest() {
        return {
            version: cloud_assembly_schema_1.Manifest.version(),
            testCases: { [this.node.path]: this.toTestCase(this.props) },
        };
    }
    toTestCase(props) {
        return {
            ...props,
            assertionStack: this._assert.scope.node.path,
            assertionStackName: this._assert.scope.stackName,
            stacks: props.stacks.map(s => s.node.path),
        };
    }
}
exports.IntegTestCase = IntegTestCase;
_a = JSII_RTTI_SYMBOL_1;
IntegTestCase[_a] = { fqn: "@aws-cdk/integ-tests-alpha.IntegTestCase", version: "2.42.0-alpha.0" };
/**
 * An integration test case stack. Allows the definition of test properties
 * that should apply to this stack.
 *
 * This should be used if there are multiple stacks in the integration test
 * and it is necessary to specify different test case option for each. Otherwise
 * normal stacks should be added to IntegTest
 */
class IntegTestCaseStack extends aws_cdk_lib_1.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_IntegTestCaseStackProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, IntegTestCaseStack);
            }
            throw error;
        }
        Object.defineProperty(this, TEST_CASE_STACK_SYMBOL, { value: true });
        // TODO: should we only have a single DeployAssert per test?
        this.assertions = new deploy_assert_1.DeployAssert(this);
        this._testCase = new IntegTestCase(this, `${id}TestCase`, {
            ...props,
            stacks: [this],
        });
    }
    /**
     * Returns whether the construct is a IntegTestCaseStack
     */
    static isIntegTestCaseStack(x) {
        return x !== null && typeof (x) === 'object' && TEST_CASE_STACK_SYMBOL in x;
    }
}
exports.IntegTestCaseStack = IntegTestCaseStack;
_b = JSII_RTTI_SYMBOL_1;
IntegTestCaseStack[_b] = { fqn: "@aws-cdk/integ-tests-alpha.IntegTestCaseStack", version: "2.42.0-alpha.0" };
/**
 * A collection of test cases. Each test case file should contain exactly one
 * instance of this class.
 */
class IntegTest extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_IntegTestProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, IntegTest);
            }
            throw error;
        }
        const defaultTestCase = new IntegTestCase(this, 'DefaultTest', {
            stacks: props.testCases.filter(stack => !IntegTestCaseStack.isIntegTestCaseStack(stack)),
            hooks: props.hooks,
            regions: props.regions,
            diffAssets: props.diffAssets,
            allowDestroy: props.allowDestroy,
            cdkCommandOptions: props.cdkCommandOptions,
            stackUpdateWorkflow: props.stackUpdateWorkflow,
        });
        this.assertions = defaultTestCase.assertions;
        this.testCases = [
            defaultTestCase,
            ...props.testCases
                .filter(stack => IntegTestCaseStack.isIntegTestCaseStack(stack))
                .map(stack => stack._testCase),
        ];
        this.node.addValidation({
            validate: () => {
                aws_cdk_lib_1.attachCustomSynthesis(this, {
                    onSynthesize: (session) => {
                        const synthesizer = new manifest_synthesizer_1.IntegManifestSynthesizer(this.testCases);
                        synthesizer.synthesize(session);
                    },
                });
                return [];
            },
        });
    }
}
exports.IntegTest = IntegTest;
_c = JSII_RTTI_SYMBOL_1;
IntegTest[_c] = { fqn: "@aws-cdk/integ-tests-alpha.IntegTest", version: "2.42.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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