"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssertionHandler = void 0;
/* eslint-disable no-console */
// eslint-disable-next-line import/no-extraneous-dependencies
const helpers_internal_1 = require("aws-cdk-lib/assertions/lib/helpers-internal");
const base_1 = require("./base");
class AssertionHandler extends base_1.CustomResourceHandler {
    async processEvent(request) {
        let actual = decodeCall(request.actual);
        const expected = decodeCall(request.expected);
        let result;
        const matcher = new MatchCreator(expected).getMatcher();
        console.log(`Testing equality between ${JSON.stringify(request.actual)} and ${JSON.stringify(request.expected)}`);
        const matchResult = matcher.test(actual);
        matchResult.finished();
        if (matchResult.hasFailed()) {
            result = {
                data: JSON.stringify({
                    status: 'fail',
                    message: [
                        ...matchResult.toHumanStrings(),
                        JSON.stringify(matchResult.target, undefined, 2),
                    ].join('\n'),
                }),
            };
            if (request.failDeployment) {
                throw new Error(result.data);
            }
        }
        else {
            result = {
                data: JSON.stringify({
                    status: 'success',
                }),
            };
        }
        return result;
    }
}
exports.AssertionHandler = AssertionHandler;
class MatchCreator {
    constructor(obj) {
        this.parsedObj = {
            matcher: obj,
        };
    }
    /**
     * Return a Matcher that can be tested against the actual results.
     * This will convert the encoded matchers into their corresponding
     * assertions matcher.
     *
     * For example:
     *
     * ExpectedResult.objectLike({
     *   Messages: [{
     *     Body: Match.objectLike({
     *       Elements: Match.arrayWith([{ Asdf: 3 }]),
     *     }),
     *   }],
     * });
     *
     * Will be encoded as:
     * {
     *   $ObjectLike: {
     *     Messages: [{
     *       Body: {
     *         $ObjectLike: {
     *           Elements: {
     *             $ArrayWith: [{ Asdf: 3 }],
     *           },
     *         },
     *       },
     *     }],
     *   },
     * }
     *
     * Which can then be parsed by this function. For each key (recursively)
     * the parser will check if the value has one of the encoded matchers as a key
     * and if so, it will set the value as the Matcher. So,
     *
     * {
     *   Body: {
     *     $ObjectLike: {
     *       Elements: {
     *         $ArrayWith: [{ Asdf: 3 }],
     *       },
     *     },
     *   },
     * }
     *
     * Will be converted to
     * {
     *   Body: Match.objectLike({
     *     Elements: Match.arrayWith([{ Asdf: 3 }]),
     *   }),
     * }
     */
    getMatcher() {
        try {
            const final = JSON.parse(JSON.stringify(this.parsedObj), function (_k, v) {
                const nested = Object.keys(v)[0];
                switch (nested) {
                    case '$ArrayWith':
                        return helpers_internal_1.Match.arrayWith(v[nested]);
                    case '$ObjectLike':
                        return helpers_internal_1.Match.objectLike(v[nested]);
                    case '$StringLike':
                        return helpers_internal_1.Match.stringLikeRegexp(v[nested]);
                    default:
                        return v;
                }
            });
            if (helpers_internal_1.Matcher.isMatcher(final.matcher)) {
                return final.matcher;
            }
            return helpers_internal_1.Match.exact(final.matcher);
        }
        catch {
            return helpers_internal_1.Match.exact(this.parsedObj.matcher);
        }
    }
}
function decodeCall(call) {
    if (!call) {
        return undefined;
    }
    try {
        const parsed = JSON.parse(call);
        return parsed;
    }
    catch (e) {
        return call;
    }
}
//# sourceMappingURL=data:application/json;base64,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