# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel


class AddDataForApiSourceRequest(TeaModel):
    def __init__(self, api_id=None, content=None, iot_instance_id=None):
        self.api_id = api_id  # type: str
        self.content = content  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.api_id, 'api_id')
        self.validate_required(self.content, 'content')
        self.validate_required(self.iot_instance_id, 'iot_instance_id')

    def to_map(self):
        _map = super(AddDataForApiSourceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        if self.content is not None:
            result['Content'] = self.content
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class AddDataForApiSourceResponse(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: long
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.data, 'data')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(AddDataForApiSourceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddShareTaskDeviceRequest(TeaModel):
    def __init__(self, iot_id_list=None, iot_instance_id=None, product_key=None, share_task_id=None):
        self.iot_id_list = iot_id_list  # type: list[str]
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.share_task_id = share_task_id  # type: str

    def validate(self):
        self.validate_required(self.share_task_id, 'share_task_id')

    def to_map(self):
        _map = super(AddShareTaskDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_id_list is not None:
            result['IotIdList'] = self.iot_id_list
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.share_task_id is not None:
            result['ShareTaskId'] = self.share_task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotIdList') is not None:
            self.iot_id_list = m.get('IotIdList')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ShareTaskId') is not None:
            self.share_task_id = m.get('ShareTaskId')
        return self


class AddShareTaskDeviceResponseData(TeaModel):
    def __init__(self, progress=None, progress_id=None):
        self.progress = progress  # type: int
        self.progress_id = progress_id  # type: str

    def validate(self):
        self.validate_required(self.progress, 'progress')
        self.validate_required(self.progress_id, 'progress_id')

    def to_map(self):
        _map = super(AddShareTaskDeviceResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.progress_id is not None:
            result['ProgressId'] = self.progress_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('ProgressId') is not None:
            self.progress_id = m.get('ProgressId')
        return self


class AddShareTaskDeviceResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: AddShareTaskDeviceResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(AddShareTaskDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = AddShareTaskDeviceResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class AttachDestinationRequest(TeaModel):
    def __init__(self, destination_id=None, iot_instance_id=None, is_failover=None, parser_id=None):
        self.destination_id = destination_id  # type: long
        self.iot_instance_id = iot_instance_id  # type: str
        self.is_failover = is_failover  # type: bool
        self.parser_id = parser_id  # type: long

    def validate(self):
        self.validate_required(self.destination_id, 'destination_id')
        self.validate_required(self.is_failover, 'is_failover')
        self.validate_required(self.parser_id, 'parser_id')

    def to_map(self):
        _map = super(AttachDestinationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.destination_id is not None:
            result['DestinationId'] = self.destination_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.is_failover is not None:
            result['IsFailover'] = self.is_failover
        if self.parser_id is not None:
            result['ParserId'] = self.parser_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DestinationId') is not None:
            self.destination_id = m.get('DestinationId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('IsFailover') is not None:
            self.is_failover = m.get('IsFailover')
        if m.get('ParserId') is not None:
            self.parser_id = m.get('ParserId')
        return self


class AttachDestinationResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(AttachDestinationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AttachParserDataSourceRequest(TeaModel):
    def __init__(self, data_source_id=None, iot_instance_id=None, parser_id=None):
        self.data_source_id = data_source_id  # type: long
        self.iot_instance_id = iot_instance_id  # type: str
        self.parser_id = parser_id  # type: long

    def validate(self):
        self.validate_required(self.data_source_id, 'data_source_id')
        self.validate_required(self.parser_id, 'parser_id')

    def to_map(self):
        _map = super(AttachParserDataSourceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.parser_id is not None:
            result['ParserId'] = self.parser_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ParserId') is not None:
            self.parser_id = m.get('ParserId')
        return self


class AttachParserDataSourceResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(AttachParserDataSourceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchAddDataForApiSourceRequest(TeaModel):
    def __init__(self, api_id=None, content_list=None, iot_instance_id=None):
        self.api_id = api_id  # type: str
        self.content_list = content_list  # type: dict[str, any]
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.api_id, 'api_id')
        self.validate_required(self.content_list, 'content_list')
        self.validate_required(self.iot_instance_id, 'iot_instance_id')

    def to_map(self):
        _map = super(BatchAddDataForApiSourceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        if self.content_list is not None:
            result['ContentList'] = self.content_list
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        if m.get('ContentList') is not None:
            self.content_list = m.get('ContentList')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class BatchAddDataForApiSourceShrinkRequest(TeaModel):
    def __init__(self, api_id=None, content_list_shrink=None, iot_instance_id=None):
        self.api_id = api_id  # type: str
        self.content_list_shrink = content_list_shrink  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.api_id, 'api_id')
        self.validate_required(self.content_list_shrink, 'content_list_shrink')
        self.validate_required(self.iot_instance_id, 'iot_instance_id')

    def to_map(self):
        _map = super(BatchAddDataForApiSourceShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        if self.content_list_shrink is not None:
            result['ContentList'] = self.content_list_shrink
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        if m.get('ContentList') is not None:
            self.content_list_shrink = m.get('ContentList')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class BatchAddDataForApiSourceResponse(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: dict[str, any]
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.data, 'data')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(BatchAddDataForApiSourceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchAddDeviceGroupRelationsRequestDevice(TeaModel):
    def __init__(self, device_name=None, product_key=None):
        self.device_name = device_name  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        _map = super(BatchAddDeviceGroupRelationsRequestDevice, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class BatchAddDeviceGroupRelationsRequest(TeaModel):
    def __init__(self, device=None, group_id=None, iot_instance_id=None):
        self.device = device  # type: list[BatchAddDeviceGroupRelationsRequestDevice]
        self.group_id = group_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        if self.device:
            for k in self.device:
                if k:
                    k.validate()
        self.validate_required(self.group_id, 'group_id')

    def to_map(self):
        _map = super(BatchAddDeviceGroupRelationsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Device'] = []
        if self.device is not None:
            for k in self.device:
                result['Device'].append(k.to_map() if k else None)
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.device = []
        if m.get('Device') is not None:
            for k in m.get('Device'):
                temp_model = BatchAddDeviceGroupRelationsRequestDevice()
                self.device.append(temp_model.from_map(k))
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class BatchAddDeviceGroupRelationsResponse(TeaModel):
    def __init__(self, already_related_group_device_count=None, code=None, error_message=None,
                 exceed_ten_group_device_count=None, request_id=None, success=None, success_added_device_count=None, valid_device_count=None):
        self.already_related_group_device_count = already_related_group_device_count  # type: int
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.exceed_ten_group_device_count = exceed_ten_group_device_count  # type: int
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.success_added_device_count = success_added_device_count  # type: int
        self.valid_device_count = valid_device_count  # type: int

    def validate(self):
        self.validate_required(self.already_related_group_device_count, 'already_related_group_device_count')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.exceed_ten_group_device_count, 'exceed_ten_group_device_count')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.success_added_device_count, 'success_added_device_count')
        self.validate_required(self.valid_device_count, 'valid_device_count')

    def to_map(self):
        _map = super(BatchAddDeviceGroupRelationsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.already_related_group_device_count is not None:
            result['AlreadyRelatedGroupDeviceCount'] = self.already_related_group_device_count
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.exceed_ten_group_device_count is not None:
            result['ExceedTenGroupDeviceCount'] = self.exceed_ten_group_device_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.success_added_device_count is not None:
            result['SuccessAddedDeviceCount'] = self.success_added_device_count
        if self.valid_device_count is not None:
            result['ValidDeviceCount'] = self.valid_device_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlreadyRelatedGroupDeviceCount') is not None:
            self.already_related_group_device_count = m.get('AlreadyRelatedGroupDeviceCount')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ExceedTenGroupDeviceCount') is not None:
            self.exceed_ten_group_device_count = m.get('ExceedTenGroupDeviceCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('SuccessAddedDeviceCount') is not None:
            self.success_added_device_count = m.get('SuccessAddedDeviceCount')
        if m.get('ValidDeviceCount') is not None:
            self.valid_device_count = m.get('ValidDeviceCount')
        return self


class BatchAddThingTopoRequestTopoAddItem(TeaModel):
    def __init__(self, client_id=None, device_name=None, product_key=None, sign=None, sign_method=None,
                 timestamp=None):
        self.client_id = client_id  # type: str
        self.device_name = device_name  # type: str
        self.product_key = product_key  # type: str
        self.sign = sign  # type: str
        self.sign_method = sign_method  # type: str
        self.timestamp = timestamp  # type: str

    def validate(self):
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.sign, 'sign')
        self.validate_required(self.sign_method, 'sign_method')

    def to_map(self):
        _map = super(BatchAddThingTopoRequestTopoAddItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.sign is not None:
            result['Sign'] = self.sign
        if self.sign_method is not None:
            result['SignMethod'] = self.sign_method
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Sign') is not None:
            self.sign = m.get('Sign')
        if m.get('SignMethod') is not None:
            self.sign_method = m.get('SignMethod')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        return self


class BatchAddThingTopoRequest(TeaModel):
    def __init__(self, gw_device_name=None, gw_product_key=None, iot_instance_id=None, topo_add_item=None):
        self.gw_device_name = gw_device_name  # type: str
        self.gw_product_key = gw_product_key  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.topo_add_item = topo_add_item  # type: list[BatchAddThingTopoRequestTopoAddItem]

    def validate(self):
        self.validate_required(self.gw_device_name, 'gw_device_name')
        self.validate_required(self.gw_product_key, 'gw_product_key')
        self.validate_required(self.topo_add_item, 'topo_add_item')
        if self.topo_add_item:
            for k in self.topo_add_item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchAddThingTopoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gw_device_name is not None:
            result['GwDeviceName'] = self.gw_device_name
        if self.gw_product_key is not None:
            result['GwProductKey'] = self.gw_product_key
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        result['TopoAddItem'] = []
        if self.topo_add_item is not None:
            for k in self.topo_add_item:
                result['TopoAddItem'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GwDeviceName') is not None:
            self.gw_device_name = m.get('GwDeviceName')
        if m.get('GwProductKey') is not None:
            self.gw_product_key = m.get('GwProductKey')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        self.topo_add_item = []
        if m.get('TopoAddItem') is not None:
            for k in m.get('TopoAddItem'):
                temp_model = BatchAddThingTopoRequestTopoAddItem()
                self.topo_add_item.append(temp_model.from_map(k))
        return self


class BatchAddThingTopoResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(BatchAddThingTopoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchBindDeviceToEdgeInstanceWithDriverRequest(TeaModel):
    def __init__(self, driver_id=None, instance_id=None, iot_ids=None, iot_instance_id=None):
        self.driver_id = driver_id  # type: str
        self.instance_id = instance_id  # type: str
        self.iot_ids = iot_ids  # type: list[str]
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.iot_ids, 'iot_ids')

    def to_map(self):
        _map = super(BatchBindDeviceToEdgeInstanceWithDriverRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class BatchBindDeviceToEdgeInstanceWithDriverResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(BatchBindDeviceToEdgeInstanceWithDriverResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchBindDevicesIntoProjectRequestDevices(TeaModel):
    def __init__(self, device_name=None, product_key=None):
        self.device_name = device_name  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        _map = super(BatchBindDevicesIntoProjectRequestDevices, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class BatchBindDevicesIntoProjectRequest(TeaModel):
    def __init__(self, devices=None, iot_instance_id=None, project_id=None):
        self.devices = devices  # type: list[BatchBindDevicesIntoProjectRequestDevices]
        self.iot_instance_id = iot_instance_id  # type: str
        self.project_id = project_id  # type: str

    def validate(self):
        self.validate_required(self.devices, 'devices')
        if self.devices:
            for k in self.devices:
                if k:
                    k.validate()
        self.validate_required(self.project_id, 'project_id')

    def to_map(self):
        _map = super(BatchBindDevicesIntoProjectRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Devices'] = []
        if self.devices is not None:
            for k in self.devices:
                result['Devices'].append(k.to_map() if k else None)
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.devices = []
        if m.get('Devices') is not None:
            for k in m.get('Devices'):
                temp_model = BatchBindDevicesIntoProjectRequestDevices()
                self.devices.append(temp_model.from_map(k))
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class BatchBindDevicesIntoProjectResponse(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: bool
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.data, 'data')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(BatchBindDevicesIntoProjectResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchBindProductsIntoProjectRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_keys=None, project_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_keys = product_keys  # type: list[str]
        self.project_id = project_id  # type: str

    def validate(self):
        self.validate_required(self.product_keys, 'product_keys')
        self.validate_required(self.project_id, 'project_id')

    def to_map(self):
        _map = super(BatchBindProductsIntoProjectRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_keys is not None:
            result['ProductKeys'] = self.product_keys
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKeys') is not None:
            self.product_keys = m.get('ProductKeys')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class BatchBindProductsIntoProjectResponse(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: bool
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.data, 'data')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(BatchBindProductsIntoProjectResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchCheckDeviceNamesRequestDeviceNameList(TeaModel):
    def __init__(self, device_name=None, device_nickname=None):
        self.device_name = device_name  # type: str
        self.device_nickname = device_nickname  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchCheckDeviceNamesRequestDeviceNameList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_nickname is not None:
            result['DeviceNickname'] = self.device_nickname
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DeviceNickname') is not None:
            self.device_nickname = m.get('DeviceNickname')
        return self


class BatchCheckDeviceNamesRequest(TeaModel):
    def __init__(self, device_name=None, device_name_list=None, iot_instance_id=None, product_key=None):
        self.device_name = device_name  # type: list[str]
        self.device_name_list = device_name_list  # type: list[BatchCheckDeviceNamesRequestDeviceNameList]
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        if self.device_name_list:
            for k in self.device_name_list:
                if k:
                    k.validate()
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        _map = super(BatchCheckDeviceNamesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        result['DeviceNameList'] = []
        if self.device_name_list is not None:
            for k in self.device_name_list:
                result['DeviceNameList'].append(k.to_map() if k else None)
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        self.device_name_list = []
        if m.get('DeviceNameList') is not None:
            for k in m.get('DeviceNameList'):
                temp_model = BatchCheckDeviceNamesRequestDeviceNameList()
                self.device_name_list.append(temp_model.from_map(k))
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class BatchCheckDeviceNamesResponseDataInvalidDeviceNameList(TeaModel):
    def __init__(self, invalid_device_name=None):
        # InvalidDeviceName
        self.invalid_device_name = invalid_device_name  # type: list[str]

    def validate(self):
        self.validate_required(self.invalid_device_name, 'invalid_device_name')

    def to_map(self):
        _map = super(BatchCheckDeviceNamesResponseDataInvalidDeviceNameList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.invalid_device_name is not None:
            result['InvalidDeviceName'] = self.invalid_device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InvalidDeviceName') is not None:
            self.invalid_device_name = m.get('InvalidDeviceName')
        return self


class BatchCheckDeviceNamesResponseDataInvalidDeviceNicknameList(TeaModel):
    def __init__(self, invalid_device_nickname=None):
        # InvalidDeviceNickname
        self.invalid_device_nickname = invalid_device_nickname  # type: list[str]

    def validate(self):
        self.validate_required(self.invalid_device_nickname, 'invalid_device_nickname')

    def to_map(self):
        _map = super(BatchCheckDeviceNamesResponseDataInvalidDeviceNicknameList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.invalid_device_nickname is not None:
            result['InvalidDeviceNickname'] = self.invalid_device_nickname
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InvalidDeviceNickname') is not None:
            self.invalid_device_nickname = m.get('InvalidDeviceNickname')
        return self


class BatchCheckDeviceNamesResponseData(TeaModel):
    def __init__(self, apply_id=None, invalid_device_name_list=None, invalid_device_nickname_list=None):
        self.apply_id = apply_id  # type: long
        self.invalid_device_name_list = invalid_device_name_list  # type: BatchCheckDeviceNamesResponseDataInvalidDeviceNameList
        self.invalid_device_nickname_list = invalid_device_nickname_list  # type: BatchCheckDeviceNamesResponseDataInvalidDeviceNicknameList

    def validate(self):
        self.validate_required(self.apply_id, 'apply_id')
        self.validate_required(self.invalid_device_name_list, 'invalid_device_name_list')
        if self.invalid_device_name_list:
            self.invalid_device_name_list.validate()
        self.validate_required(self.invalid_device_nickname_list, 'invalid_device_nickname_list')
        if self.invalid_device_nickname_list:
            self.invalid_device_nickname_list.validate()

    def to_map(self):
        _map = super(BatchCheckDeviceNamesResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['ApplyId'] = self.apply_id
        if self.invalid_device_name_list is not None:
            result['InvalidDeviceNameList'] = self.invalid_device_name_list.to_map()
        if self.invalid_device_nickname_list is not None:
            result['InvalidDeviceNicknameList'] = self.invalid_device_nickname_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApplyId') is not None:
            self.apply_id = m.get('ApplyId')
        if m.get('InvalidDeviceNameList') is not None:
            temp_model = BatchCheckDeviceNamesResponseDataInvalidDeviceNameList()
            self.invalid_device_name_list = temp_model.from_map(m['InvalidDeviceNameList'])
        if m.get('InvalidDeviceNicknameList') is not None:
            temp_model = BatchCheckDeviceNamesResponseDataInvalidDeviceNicknameList()
            self.invalid_device_nickname_list = temp_model.from_map(m['InvalidDeviceNicknameList'])
        return self


class BatchCheckDeviceNamesResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: BatchCheckDeviceNamesResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(BatchCheckDeviceNamesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = BatchCheckDeviceNamesResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class BatchCheckImportDeviceRequestDeviceList(TeaModel):
    def __init__(self, device_name=None, device_secret=None, sn=None):
        self.device_name = device_name  # type: str
        self.device_secret = device_secret  # type: str
        self.sn = sn  # type: str

    def validate(self):
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.device_secret, 'device_secret')

    def to_map(self):
        _map = super(BatchCheckImportDeviceRequestDeviceList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_secret is not None:
            result['DeviceSecret'] = self.device_secret
        if self.sn is not None:
            result['Sn'] = self.sn
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DeviceSecret') is not None:
            self.device_secret = m.get('DeviceSecret')
        if m.get('Sn') is not None:
            self.sn = m.get('Sn')
        return self


class BatchCheckImportDeviceRequest(TeaModel):
    def __init__(self, device_list=None, iot_instance_id=None, product_key=None):
        self.device_list = device_list  # type: list[BatchCheckImportDeviceRequestDeviceList]
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        self.validate_required(self.device_list, 'device_list')
        if self.device_list:
            for k in self.device_list:
                if k:
                    k.validate()
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        _map = super(BatchCheckImportDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DeviceList'] = []
        if self.device_list is not None:
            for k in self.device_list:
                result['DeviceList'].append(k.to_map() if k else None)
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.device_list = []
        if m.get('DeviceList') is not None:
            for k in m.get('DeviceList'):
                temp_model = BatchCheckImportDeviceRequestDeviceList()
                self.device_list.append(temp_model.from_map(k))
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class BatchCheckImportDeviceResponseData(TeaModel):
    def __init__(self, invalid_device_name_list=None, invalid_device_secret_list=None, invalid_sn_list=None,
                 repeated_device_name_list=None):
        self.invalid_device_name_list = invalid_device_name_list  # type: list[str]
        self.invalid_device_secret_list = invalid_device_secret_list  # type: list[str]
        self.invalid_sn_list = invalid_sn_list  # type: list[str]
        self.repeated_device_name_list = repeated_device_name_list  # type: list[str]

    def validate(self):
        self.validate_required(self.invalid_device_name_list, 'invalid_device_name_list')
        self.validate_required(self.invalid_device_secret_list, 'invalid_device_secret_list')
        self.validate_required(self.invalid_sn_list, 'invalid_sn_list')
        self.validate_required(self.repeated_device_name_list, 'repeated_device_name_list')

    def to_map(self):
        _map = super(BatchCheckImportDeviceResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.invalid_device_name_list is not None:
            result['InvalidDeviceNameList'] = self.invalid_device_name_list
        if self.invalid_device_secret_list is not None:
            result['InvalidDeviceSecretList'] = self.invalid_device_secret_list
        if self.invalid_sn_list is not None:
            result['InvalidSnList'] = self.invalid_sn_list
        if self.repeated_device_name_list is not None:
            result['RepeatedDeviceNameList'] = self.repeated_device_name_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InvalidDeviceNameList') is not None:
            self.invalid_device_name_list = m.get('InvalidDeviceNameList')
        if m.get('InvalidDeviceSecretList') is not None:
            self.invalid_device_secret_list = m.get('InvalidDeviceSecretList')
        if m.get('InvalidSnList') is not None:
            self.invalid_sn_list = m.get('InvalidSnList')
        if m.get('RepeatedDeviceNameList') is not None:
            self.repeated_device_name_list = m.get('RepeatedDeviceNameList')
        return self


class BatchCheckImportDeviceResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: BatchCheckImportDeviceResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(BatchCheckImportDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = BatchCheckImportDeviceResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class BatchCheckVehicleDeviceRequestDeviceList(TeaModel):
    def __init__(self, device_id=None, device_model=None, manufacturer=None):
        self.device_id = device_id  # type: str
        self.device_model = device_model  # type: str
        self.manufacturer = manufacturer  # type: str

    def validate(self):
        self.validate_required(self.device_model, 'device_model')
        self.validate_required(self.manufacturer, 'manufacturer')

    def to_map(self):
        _map = super(BatchCheckVehicleDeviceRequestDeviceList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_model is not None:
            result['DeviceModel'] = self.device_model
        if self.manufacturer is not None:
            result['Manufacturer'] = self.manufacturer
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceModel') is not None:
            self.device_model = m.get('DeviceModel')
        if m.get('Manufacturer') is not None:
            self.manufacturer = m.get('Manufacturer')
        return self


class BatchCheckVehicleDeviceRequest(TeaModel):
    def __init__(self, device_list=None, iot_instance_id=None, product_key=None):
        self.device_list = device_list  # type: list[BatchCheckVehicleDeviceRequestDeviceList]
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        self.validate_required(self.device_list, 'device_list')
        if self.device_list:
            for k in self.device_list:
                if k:
                    k.validate()
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        _map = super(BatchCheckVehicleDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DeviceList'] = []
        if self.device_list is not None:
            for k in self.device_list:
                result['DeviceList'].append(k.to_map() if k else None)
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.device_list = []
        if m.get('DeviceList') is not None:
            for k in m.get('DeviceList'):
                temp_model = BatchCheckVehicleDeviceRequestDeviceList()
                self.device_list.append(temp_model.from_map(k))
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class BatchCheckVehicleDeviceResponseData(TeaModel):
    def __init__(self, invalid_device_id_list=None, invalid_device_model_list=None,
                 invalid_manufacturer_list=None, repeated_device_id_list=None):
        self.invalid_device_id_list = invalid_device_id_list  # type: list[str]
        self.invalid_device_model_list = invalid_device_model_list  # type: list[str]
        self.invalid_manufacturer_list = invalid_manufacturer_list  # type: list[str]
        self.repeated_device_id_list = repeated_device_id_list  # type: list[str]

    def validate(self):
        self.validate_required(self.invalid_device_id_list, 'invalid_device_id_list')
        self.validate_required(self.invalid_device_model_list, 'invalid_device_model_list')
        self.validate_required(self.invalid_manufacturer_list, 'invalid_manufacturer_list')
        self.validate_required(self.repeated_device_id_list, 'repeated_device_id_list')

    def to_map(self):
        _map = super(BatchCheckVehicleDeviceResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.invalid_device_id_list is not None:
            result['InvalidDeviceIdList'] = self.invalid_device_id_list
        if self.invalid_device_model_list is not None:
            result['InvalidDeviceModelList'] = self.invalid_device_model_list
        if self.invalid_manufacturer_list is not None:
            result['InvalidManufacturerList'] = self.invalid_manufacturer_list
        if self.repeated_device_id_list is not None:
            result['RepeatedDeviceIdList'] = self.repeated_device_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InvalidDeviceIdList') is not None:
            self.invalid_device_id_list = m.get('InvalidDeviceIdList')
        if m.get('InvalidDeviceModelList') is not None:
            self.invalid_device_model_list = m.get('InvalidDeviceModelList')
        if m.get('InvalidManufacturerList') is not None:
            self.invalid_manufacturer_list = m.get('InvalidManufacturerList')
        if m.get('RepeatedDeviceIdList') is not None:
            self.repeated_device_id_list = m.get('RepeatedDeviceIdList')
        return self


class BatchCheckVehicleDeviceResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: BatchCheckVehicleDeviceResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(BatchCheckVehicleDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = BatchCheckVehicleDeviceResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class BatchClearEdgeInstanceDeviceConfigRequest(TeaModel):
    def __init__(self, instance_id=None, iot_ids=None, iot_instance_id=None):
        self.instance_id = instance_id  # type: str
        self.iot_ids = iot_ids  # type: list[str]
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.iot_ids, 'iot_ids')

    def to_map(self):
        _map = super(BatchClearEdgeInstanceDeviceConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class BatchClearEdgeInstanceDeviceConfigResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(BatchClearEdgeInstanceDeviceConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchCreateSoundCodeLabelRequest(TeaModel):
    def __init__(self, description=None, iot_instance_id=None, schedule_code=None, total=None):
        self.description = description  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.schedule_code = schedule_code  # type: str
        self.total = total  # type: int

    def validate(self):
        self.validate_required(self.schedule_code, 'schedule_code')
        self.validate_required(self.total, 'total')

    def to_map(self):
        _map = super(BatchCreateSoundCodeLabelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.schedule_code is not None:
            result['ScheduleCode'] = self.schedule_code
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ScheduleCode') is not None:
            self.schedule_code = m.get('ScheduleCode')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class BatchCreateSoundCodeLabelResponse(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.data, 'data')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(BatchCreateSoundCodeLabelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchCreateSoundCodeLabelWithLabelsRequest(TeaModel):
    def __init__(self, description=None, iot_instance_id=None, labels=None, schedule_code=None):
        self.description = description  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.labels = labels  # type: list[str]
        self.schedule_code = schedule_code  # type: str

    def validate(self):
        self.validate_required(self.labels, 'labels')
        self.validate_required(self.schedule_code, 'schedule_code')

    def to_map(self):
        _map = super(BatchCreateSoundCodeLabelWithLabelsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.labels is not None:
            result['Labels'] = self.labels
        if self.schedule_code is not None:
            result['ScheduleCode'] = self.schedule_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Labels') is not None:
            self.labels = m.get('Labels')
        if m.get('ScheduleCode') is not None:
            self.schedule_code = m.get('ScheduleCode')
        return self


class BatchCreateSoundCodeLabelWithLabelsResponse(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.data, 'data')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(BatchCreateSoundCodeLabelWithLabelsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchDeleteDeviceGroupRelationsRequestDevice(TeaModel):
    def __init__(self, device_name=None, product_key=None):
        self.device_name = device_name  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        _map = super(BatchDeleteDeviceGroupRelationsRequestDevice, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class BatchDeleteDeviceGroupRelationsRequest(TeaModel):
    def __init__(self, device=None, group_id=None, iot_instance_id=None):
        self.device = device  # type: list[BatchDeleteDeviceGroupRelationsRequestDevice]
        self.group_id = group_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        if self.device:
            for k in self.device:
                if k:
                    k.validate()
        self.validate_required(self.group_id, 'group_id')

    def to_map(self):
        _map = super(BatchDeleteDeviceGroupRelationsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Device'] = []
        if self.device is not None:
            for k in self.device:
                result['Device'].append(k.to_map() if k else None)
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.device = []
        if m.get('Device') is not None:
            for k in m.get('Device'):
                temp_model = BatchDeleteDeviceGroupRelationsRequestDevice()
                self.device.append(temp_model.from_map(k))
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class BatchDeleteDeviceGroupRelationsResponse(TeaModel):
    def __init__(self, already_related_group_device_count=None, code=None, error_message=None, request_id=None,
                 success=None, success_device_count=None, valid_device_count=None):
        self.already_related_group_device_count = already_related_group_device_count  # type: int
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.success_device_count = success_device_count  # type: int
        self.valid_device_count = valid_device_count  # type: int

    def validate(self):
        self.validate_required(self.already_related_group_device_count, 'already_related_group_device_count')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.success_device_count, 'success_device_count')
        self.validate_required(self.valid_device_count, 'valid_device_count')

    def to_map(self):
        _map = super(BatchDeleteDeviceGroupRelationsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.already_related_group_device_count is not None:
            result['AlreadyRelatedGroupDeviceCount'] = self.already_related_group_device_count
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.success_device_count is not None:
            result['SuccessDeviceCount'] = self.success_device_count
        if self.valid_device_count is not None:
            result['ValidDeviceCount'] = self.valid_device_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlreadyRelatedGroupDeviceCount') is not None:
            self.already_related_group_device_count = m.get('AlreadyRelatedGroupDeviceCount')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('SuccessDeviceCount') is not None:
            self.success_device_count = m.get('SuccessDeviceCount')
        if m.get('ValidDeviceCount') is not None:
            self.valid_device_count = m.get('ValidDeviceCount')
        return self


class BatchDeleteEdgeInstanceChannelRequest(TeaModel):
    def __init__(self, channel_ids=None, driver_id=None, instance_id=None, iot_instance_id=None):
        self.channel_ids = channel_ids  # type: list[str]
        self.driver_id = driver_id  # type: str
        self.instance_id = instance_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.channel_ids, 'channel_ids')
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        _map = super(BatchDeleteEdgeInstanceChannelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_ids is not None:
            result['ChannelIds'] = self.channel_ids
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChannelIds') is not None:
            self.channel_ids = m.get('ChannelIds')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class BatchDeleteEdgeInstanceChannelResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(BatchDeleteEdgeInstanceChannelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchGetDeviceBindStatusRequest(TeaModel):
    def __init__(self, iot_ids=None, iot_instance_id=None):
        self.iot_ids = iot_ids  # type: list[str]
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.iot_ids, 'iot_ids')

    def to_map(self):
        _map = super(BatchGetDeviceBindStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class BatchGetDeviceBindStatusResponseData(TeaModel):
    def __init__(self, bind_status=None, instance_id=None, iot_id=None):
        self.bind_status = bind_status  # type: int
        self.instance_id = instance_id  # type: str
        self.iot_id = iot_id  # type: str

    def validate(self):
        self.validate_required(self.bind_status, 'bind_status')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.iot_id, 'iot_id')

    def to_map(self):
        _map = super(BatchGetDeviceBindStatusResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bind_status is not None:
            result['BindStatus'] = self.bind_status
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BindStatus') is not None:
            self.bind_status = m.get('BindStatus')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchGetDeviceBindStatusResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: list[BatchGetDeviceBindStatusResponseData]

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchGetDeviceBindStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = BatchGetDeviceBindStatusResponseData()
                self.data.append(temp_model.from_map(k))
        return self


class BatchGetDeviceStateRequest(TeaModel):
    def __init__(self, device_name=None, iot_id=None, iot_instance_id=None, product_key=None):
        self.device_name = device_name  # type: list[str]
        self.iot_id = iot_id  # type: list[str]
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchGetDeviceStateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class BatchGetDeviceStateResponseDeviceStatusListDeviceStatus(TeaModel):
    def __init__(self, as_address=None, device_id=None, device_name=None, iot_id=None, last_online_time=None,
                 status=None):
        self.as_address = as_address  # type: str
        self.device_id = device_id  # type: str
        self.device_name = device_name  # type: str
        self.iot_id = iot_id  # type: str
        self.last_online_time = last_online_time  # type: str
        self.status = status  # type: str

    def validate(self):
        self.validate_required(self.as_address, 'as_address')
        self.validate_required(self.device_id, 'device_id')
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.iot_id, 'iot_id')
        self.validate_required(self.last_online_time, 'last_online_time')
        self.validate_required(self.status, 'status')

    def to_map(self):
        _map = super(BatchGetDeviceStateResponseDeviceStatusListDeviceStatus, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.as_address is not None:
            result['AsAddress'] = self.as_address
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.last_online_time is not None:
            result['LastOnlineTime'] = self.last_online_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AsAddress') is not None:
            self.as_address = m.get('AsAddress')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('LastOnlineTime') is not None:
            self.last_online_time = m.get('LastOnlineTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class BatchGetDeviceStateResponseDeviceStatusList(TeaModel):
    def __init__(self, device_status=None):
        self.device_status = device_status  # type: list[BatchGetDeviceStateResponseDeviceStatusListDeviceStatus]

    def validate(self):
        self.validate_required(self.device_status, 'device_status')
        if self.device_status:
            for k in self.device_status:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchGetDeviceStateResponseDeviceStatusList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DeviceStatus'] = []
        if self.device_status is not None:
            for k in self.device_status:
                result['DeviceStatus'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.device_status = []
        if m.get('DeviceStatus') is not None:
            for k in m.get('DeviceStatus'):
                temp_model = BatchGetDeviceStateResponseDeviceStatusListDeviceStatus()
                self.device_status.append(temp_model.from_map(k))
        return self


class BatchGetDeviceStateResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, device_status_list=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.device_status_list = device_status_list  # type: BatchGetDeviceStateResponseDeviceStatusList

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.device_status_list, 'device_status_list')
        if self.device_status_list:
            self.device_status_list.validate()

    def to_map(self):
        _map = super(BatchGetDeviceStateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.device_status_list is not None:
            result['DeviceStatusList'] = self.device_status_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('DeviceStatusList') is not None:
            temp_model = BatchGetDeviceStateResponseDeviceStatusList()
            self.device_status_list = temp_model.from_map(m['DeviceStatusList'])
        return self


class BatchGetEdgeDriverRequest(TeaModel):
    def __init__(self, driver_ids=None, iot_instance_id=None):
        self.driver_ids = driver_ids  # type: list[str]
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.driver_ids, 'driver_ids')

    def to_map(self):
        _map = super(BatchGetEdgeDriverRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.driver_ids is not None:
            result['DriverIds'] = self.driver_ids
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DriverIds') is not None:
            self.driver_ids = m.get('DriverIds')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class BatchGetEdgeDriverResponseDriverList(TeaModel):
    def __init__(self, cpu_arch=None, driver_id=None, driver_name=None, driver_protocol=None,
                 gmt_create_timestamp=None, gmt_modified_timestamp=None, is_built_in=None, runtime=None, type=None):
        self.cpu_arch = cpu_arch  # type: str
        self.driver_id = driver_id  # type: str
        self.driver_name = driver_name  # type: str
        self.driver_protocol = driver_protocol  # type: str
        self.gmt_create_timestamp = gmt_create_timestamp  # type: long
        self.gmt_modified_timestamp = gmt_modified_timestamp  # type: long
        self.is_built_in = is_built_in  # type: bool
        self.runtime = runtime  # type: str
        self.type = type  # type: int

    def validate(self):
        self.validate_required(self.cpu_arch, 'cpu_arch')
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.driver_name, 'driver_name')
        self.validate_required(self.driver_protocol, 'driver_protocol')
        self.validate_required(self.gmt_create_timestamp, 'gmt_create_timestamp')
        self.validate_required(self.gmt_modified_timestamp, 'gmt_modified_timestamp')
        self.validate_required(self.is_built_in, 'is_built_in')
        self.validate_required(self.runtime, 'runtime')
        self.validate_required(self.type, 'type')

    def to_map(self):
        _map = super(BatchGetEdgeDriverResponseDriverList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cpu_arch is not None:
            result['CpuArch'] = self.cpu_arch
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_name is not None:
            result['DriverName'] = self.driver_name
        if self.driver_protocol is not None:
            result['DriverProtocol'] = self.driver_protocol
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.is_built_in is not None:
            result['IsBuiltIn'] = self.is_built_in
        if self.runtime is not None:
            result['Runtime'] = self.runtime
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CpuArch') is not None:
            self.cpu_arch = m.get('CpuArch')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverName') is not None:
            self.driver_name = m.get('DriverName')
        if m.get('DriverProtocol') is not None:
            self.driver_protocol = m.get('DriverProtocol')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('IsBuiltIn') is not None:
            self.is_built_in = m.get('IsBuiltIn')
        if m.get('Runtime') is not None:
            self.runtime = m.get('Runtime')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class BatchGetEdgeDriverResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, driver_list=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.driver_list = driver_list  # type: list[BatchGetEdgeDriverResponseDriverList]

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.driver_list, 'driver_list')
        if self.driver_list:
            for k in self.driver_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchGetEdgeDriverResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        result['DriverList'] = []
        if self.driver_list is not None:
            for k in self.driver_list:
                result['DriverList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        self.driver_list = []
        if m.get('DriverList') is not None:
            for k in m.get('DriverList'):
                temp_model = BatchGetEdgeDriverResponseDriverList()
                self.driver_list.append(temp_model.from_map(k))
        return self


class BatchGetEdgeInstanceChannelRequest(TeaModel):
    def __init__(self, channel_ids=None, driver_id=None, instance_id=None, iot_instance_id=None):
        self.channel_ids = channel_ids  # type: list[str]
        self.driver_id = driver_id  # type: str
        self.instance_id = instance_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.channel_ids, 'channel_ids')
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        _map = super(BatchGetEdgeInstanceChannelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_ids is not None:
            result['ChannelIds'] = self.channel_ids
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChannelIds') is not None:
            self.channel_ids = m.get('ChannelIds')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class BatchGetEdgeInstanceChannelResponseDataChannelConfigListConfig(TeaModel):
    def __init__(self, config_id=None, content=None, format=None, key=None):
        self.config_id = config_id  # type: str
        self.content = content  # type: str
        self.format = format  # type: str
        self.key = key  # type: str

    def validate(self):
        self.validate_required(self.config_id, 'config_id')
        self.validate_required(self.content, 'content')
        self.validate_required(self.format, 'format')
        self.validate_required(self.key, 'key')

    def to_map(self):
        _map = super(BatchGetEdgeInstanceChannelResponseDataChannelConfigListConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        if self.content is not None:
            result['Content'] = self.content
        if self.format is not None:
            result['Format'] = self.format
        if self.key is not None:
            result['Key'] = self.key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        return self


class BatchGetEdgeInstanceChannelResponseDataChannelConfigList(TeaModel):
    def __init__(self, config=None):
        self.config = config  # type: list[BatchGetEdgeInstanceChannelResponseDataChannelConfigListConfig]

    def validate(self):
        self.validate_required(self.config, 'config')
        if self.config:
            for k in self.config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchGetEdgeInstanceChannelResponseDataChannelConfigList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Config'] = []
        if self.config is not None:
            for k in self.config:
                result['Config'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.config = []
        if m.get('Config') is not None:
            for k in m.get('Config'):
                temp_model = BatchGetEdgeInstanceChannelResponseDataChannelConfigListConfig()
                self.config.append(temp_model.from_map(k))
        return self


class BatchGetEdgeInstanceChannelResponseDataChannel(TeaModel):
    def __init__(self, channel_id=None, channel_name=None, config_list=None):
        self.channel_id = channel_id  # type: str
        self.channel_name = channel_name  # type: str
        self.config_list = config_list  # type: BatchGetEdgeInstanceChannelResponseDataChannelConfigList

    def validate(self):
        self.validate_required(self.channel_id, 'channel_id')
        self.validate_required(self.channel_name, 'channel_name')
        self.validate_required(self.config_list, 'config_list')
        if self.config_list:
            self.config_list.validate()

    def to_map(self):
        _map = super(BatchGetEdgeInstanceChannelResponseDataChannel, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        if self.config_list is not None:
            result['ConfigList'] = self.config_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        if m.get('ConfigList') is not None:
            temp_model = BatchGetEdgeInstanceChannelResponseDataChannelConfigList()
            self.config_list = temp_model.from_map(m['ConfigList'])
        return self


class BatchGetEdgeInstanceChannelResponseData(TeaModel):
    def __init__(self, channel=None):
        self.channel = channel  # type: list[BatchGetEdgeInstanceChannelResponseDataChannel]

    def validate(self):
        self.validate_required(self.channel, 'channel')
        if self.channel:
            for k in self.channel:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchGetEdgeInstanceChannelResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Channel'] = []
        if self.channel is not None:
            for k in self.channel:
                result['Channel'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.channel = []
        if m.get('Channel') is not None:
            for k in m.get('Channel'):
                temp_model = BatchGetEdgeInstanceChannelResponseDataChannel()
                self.channel.append(temp_model.from_map(k))
        return self


class BatchGetEdgeInstanceChannelResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: BatchGetEdgeInstanceChannelResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(BatchGetEdgeInstanceChannelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = BatchGetEdgeInstanceChannelResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class BatchGetEdgeInstanceDeviceChannelRequest(TeaModel):
    def __init__(self, driver_id=None, instance_id=None, iot_ids=None, iot_instance_id=None):
        self.driver_id = driver_id  # type: str
        self.instance_id = instance_id  # type: str
        self.iot_ids = iot_ids  # type: list[str]
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.iot_ids, 'iot_ids')

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDeviceChannelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class BatchGetEdgeInstanceDeviceChannelResponseDeviceChannelList(TeaModel):
    def __init__(self, channel_id=None, channel_name=None, iot_id=None):
        self.channel_id = channel_id  # type: str
        self.channel_name = channel_name  # type: str
        self.iot_id = iot_id  # type: str

    def validate(self):
        self.validate_required(self.channel_id, 'channel_id')
        self.validate_required(self.channel_name, 'channel_name')
        self.validate_required(self.iot_id, 'iot_id')

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDeviceChannelResponseDeviceChannelList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchGetEdgeInstanceDeviceChannelResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, device_channel_list=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.device_channel_list = device_channel_list  # type: list[BatchGetEdgeInstanceDeviceChannelResponseDeviceChannelList]

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.device_channel_list, 'device_channel_list')
        if self.device_channel_list:
            for k in self.device_channel_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDeviceChannelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        result['DeviceChannelList'] = []
        if self.device_channel_list is not None:
            for k in self.device_channel_list:
                result['DeviceChannelList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        self.device_channel_list = []
        if m.get('DeviceChannelList') is not None:
            for k in m.get('DeviceChannelList'):
                temp_model = BatchGetEdgeInstanceDeviceChannelResponseDeviceChannelList()
                self.device_channel_list.append(temp_model.from_map(k))
        return self


class BatchGetEdgeInstanceDeviceConfigRequest(TeaModel):
    def __init__(self, instance_id=None, iot_ids=None, iot_instance_id=None):
        self.instance_id = instance_id  # type: str
        self.iot_ids = iot_ids  # type: list[str]
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.iot_ids, 'iot_ids')

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDeviceConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class BatchGetEdgeInstanceDeviceConfigResponseDeviceConfigListConfig(TeaModel):
    def __init__(self, content=None, format=None):
        self.content = content  # type: str
        self.format = format  # type: str

    def validate(self):
        self.validate_required(self.content, 'content')
        self.validate_required(self.format, 'format')

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDeviceConfigResponseDeviceConfigListConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.format is not None:
            result['Format'] = self.format
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        return self


class BatchGetEdgeInstanceDeviceConfigResponseDeviceConfigList(TeaModel):
    def __init__(self, iot_id=None, config=None):
        self.iot_id = iot_id  # type: str
        self.config = config  # type: BatchGetEdgeInstanceDeviceConfigResponseDeviceConfigListConfig

    def validate(self):
        self.validate_required(self.iot_id, 'iot_id')
        self.validate_required(self.config, 'config')
        if self.config:
            self.config.validate()

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDeviceConfigResponseDeviceConfigList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.config is not None:
            result['Config'] = self.config.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('Config') is not None:
            temp_model = BatchGetEdgeInstanceDeviceConfigResponseDeviceConfigListConfig()
            self.config = temp_model.from_map(m['Config'])
        return self


class BatchGetEdgeInstanceDeviceConfigResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, device_config_list=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.device_config_list = device_config_list  # type: list[BatchGetEdgeInstanceDeviceConfigResponseDeviceConfigList]

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.device_config_list, 'device_config_list')
        if self.device_config_list:
            for k in self.device_config_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDeviceConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        result['DeviceConfigList'] = []
        if self.device_config_list is not None:
            for k in self.device_config_list:
                result['DeviceConfigList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        self.device_config_list = []
        if m.get('DeviceConfigList') is not None:
            for k in m.get('DeviceConfigList'):
                temp_model = BatchGetEdgeInstanceDeviceConfigResponseDeviceConfigList()
                self.device_config_list.append(temp_model.from_map(k))
        return self


class BatchGetEdgeInstanceDeviceDriverRequest(TeaModel):
    def __init__(self, instance_id=None, iot_ids=None, iot_instance_id=None):
        self.instance_id = instance_id  # type: str
        self.iot_ids = iot_ids  # type: list[str]
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.iot_ids, 'iot_ids')

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDeviceDriverRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class BatchGetEdgeInstanceDeviceDriverResponseDeviceDriverList(TeaModel):
    def __init__(self, driver_id=None, iot_id=None):
        self.driver_id = driver_id  # type: str
        self.iot_id = iot_id  # type: str

    def validate(self):
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.iot_id, 'iot_id')

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDeviceDriverResponseDeviceDriverList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchGetEdgeInstanceDeviceDriverResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, device_driver_list=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.device_driver_list = device_driver_list  # type: list[BatchGetEdgeInstanceDeviceDriverResponseDeviceDriverList]

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.device_driver_list, 'device_driver_list')
        if self.device_driver_list:
            for k in self.device_driver_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDeviceDriverResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        result['DeviceDriverList'] = []
        if self.device_driver_list is not None:
            for k in self.device_driver_list:
                result['DeviceDriverList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        self.device_driver_list = []
        if m.get('DeviceDriverList') is not None:
            for k in m.get('DeviceDriverList'):
                temp_model = BatchGetEdgeInstanceDeviceDriverResponseDeviceDriverList()
                self.device_driver_list.append(temp_model.from_map(k))
        return self


class BatchGetEdgeInstanceDriverConfigsRequest(TeaModel):
    def __init__(self, driver_ids=None, instance_id=None, iot_instance_id=None):
        self.driver_ids = driver_ids  # type: list[str]
        self.instance_id = instance_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.driver_ids, 'driver_ids')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDriverConfigsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.driver_ids is not None:
            result['DriverIds'] = self.driver_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DriverIds') is not None:
            self.driver_ids = m.get('DriverIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class BatchGetEdgeInstanceDriverConfigsResponseDriverConfigListConfigList(TeaModel):
    def __init__(self, config_id=None, content=None, format=None, key=None):
        self.config_id = config_id  # type: str
        self.content = content  # type: str
        self.format = format  # type: str
        self.key = key  # type: str

    def validate(self):
        self.validate_required(self.config_id, 'config_id')
        self.validate_required(self.content, 'content')
        self.validate_required(self.format, 'format')
        self.validate_required(self.key, 'key')

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDriverConfigsResponseDriverConfigListConfigList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        if self.content is not None:
            result['Content'] = self.content
        if self.format is not None:
            result['Format'] = self.format
        if self.key is not None:
            result['Key'] = self.key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        return self


class BatchGetEdgeInstanceDriverConfigsResponseDriverConfigList(TeaModel):
    def __init__(self, driver_id=None, config_list=None):
        self.driver_id = driver_id  # type: str
        self.config_list = config_list  # type: list[BatchGetEdgeInstanceDriverConfigsResponseDriverConfigListConfigList]

    def validate(self):
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.config_list, 'config_list')
        if self.config_list:
            for k in self.config_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDriverConfigsResponseDriverConfigList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        result['ConfigList'] = []
        if self.config_list is not None:
            for k in self.config_list:
                result['ConfigList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        self.config_list = []
        if m.get('ConfigList') is not None:
            for k in m.get('ConfigList'):
                temp_model = BatchGetEdgeInstanceDriverConfigsResponseDriverConfigListConfigList()
                self.config_list.append(temp_model.from_map(k))
        return self


class BatchGetEdgeInstanceDriverConfigsResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, driver_config_list=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.driver_config_list = driver_config_list  # type: list[BatchGetEdgeInstanceDriverConfigsResponseDriverConfigList]

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.driver_config_list, 'driver_config_list')
        if self.driver_config_list:
            for k in self.driver_config_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDriverConfigsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        result['DriverConfigList'] = []
        if self.driver_config_list is not None:
            for k in self.driver_config_list:
                result['DriverConfigList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        self.driver_config_list = []
        if m.get('DriverConfigList') is not None:
            for k in m.get('DriverConfigList'):
                temp_model = BatchGetEdgeInstanceDriverConfigsResponseDriverConfigList()
                self.driver_config_list.append(temp_model.from_map(k))
        return self


class BatchImportDeviceRequestDeviceList(TeaModel):
    def __init__(self, device_name=None, device_secret=None, sn=None):
        self.device_name = device_name  # type: str
        self.device_secret = device_secret  # type: str
        self.sn = sn  # type: str

    def validate(self):
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.device_secret, 'device_secret')

    def to_map(self):
        _map = super(BatchImportDeviceRequestDeviceList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_secret is not None:
            result['DeviceSecret'] = self.device_secret
        if self.sn is not None:
            result['Sn'] = self.sn
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DeviceSecret') is not None:
            self.device_secret = m.get('DeviceSecret')
        if m.get('Sn') is not None:
            self.sn = m.get('Sn')
        return self


class BatchImportDeviceRequest(TeaModel):
    def __init__(self, device_list=None, iot_instance_id=None, product_key=None):
        self.device_list = device_list  # type: list[BatchImportDeviceRequestDeviceList]
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        self.validate_required(self.device_list, 'device_list')
        if self.device_list:
            for k in self.device_list:
                if k:
                    k.validate()
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        _map = super(BatchImportDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DeviceList'] = []
        if self.device_list is not None:
            for k in self.device_list:
                result['DeviceList'].append(k.to_map() if k else None)
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.device_list = []
        if m.get('DeviceList') is not None:
            for k in m.get('DeviceList'):
                temp_model = BatchImportDeviceRequestDeviceList()
                self.device_list.append(temp_model.from_map(k))
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class BatchImportDeviceResponseDataInvalidDeviceNameList(TeaModel):
    def __init__(self, invalid_device_name=None):
        # invalidDeviceName
        self.invalid_device_name = invalid_device_name  # type: list[str]

    def validate(self):
        self.validate_required(self.invalid_device_name, 'invalid_device_name')

    def to_map(self):
        _map = super(BatchImportDeviceResponseDataInvalidDeviceNameList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.invalid_device_name is not None:
            result['invalidDeviceName'] = self.invalid_device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('invalidDeviceName') is not None:
            self.invalid_device_name = m.get('invalidDeviceName')
        return self


class BatchImportDeviceResponseDataInvalidDeviceSecretList(TeaModel):
    def __init__(self, invalid_device_secret=None):
        # invalidDeviceSecret
        self.invalid_device_secret = invalid_device_secret  # type: list[str]

    def validate(self):
        self.validate_required(self.invalid_device_secret, 'invalid_device_secret')

    def to_map(self):
        _map = super(BatchImportDeviceResponseDataInvalidDeviceSecretList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.invalid_device_secret is not None:
            result['invalidDeviceSecret'] = self.invalid_device_secret
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('invalidDeviceSecret') is not None:
            self.invalid_device_secret = m.get('invalidDeviceSecret')
        return self


class BatchImportDeviceResponseDataInvalidSnList(TeaModel):
    def __init__(self, invalid_sn=None):
        # invalidSn
        self.invalid_sn = invalid_sn  # type: list[str]

    def validate(self):
        self.validate_required(self.invalid_sn, 'invalid_sn')

    def to_map(self):
        _map = super(BatchImportDeviceResponseDataInvalidSnList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.invalid_sn is not None:
            result['invalidSn'] = self.invalid_sn
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('invalidSn') is not None:
            self.invalid_sn = m.get('invalidSn')
        return self


class BatchImportDeviceResponseDataRepeatedDeviceNameList(TeaModel):
    def __init__(self, repeated_device_name=None):
        # repeatedDeviceName
        self.repeated_device_name = repeated_device_name  # type: list[str]

    def validate(self):
        self.validate_required(self.repeated_device_name, 'repeated_device_name')

    def to_map(self):
        _map = super(BatchImportDeviceResponseDataRepeatedDeviceNameList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.repeated_device_name is not None:
            result['repeatedDeviceName'] = self.repeated_device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('repeatedDeviceName') is not None:
            self.repeated_device_name = m.get('repeatedDeviceName')
        return self


class BatchImportDeviceResponseData(TeaModel):
    def __init__(self, apply_id=None, invalid_device_name_list=None, invalid_device_secret_list=None,
                 invalid_sn_list=None, repeated_device_name_list=None):
        self.apply_id = apply_id  # type: long
        self.invalid_device_name_list = invalid_device_name_list  # type: BatchImportDeviceResponseDataInvalidDeviceNameList
        self.invalid_device_secret_list = invalid_device_secret_list  # type: BatchImportDeviceResponseDataInvalidDeviceSecretList
        self.invalid_sn_list = invalid_sn_list  # type: BatchImportDeviceResponseDataInvalidSnList
        self.repeated_device_name_list = repeated_device_name_list  # type: BatchImportDeviceResponseDataRepeatedDeviceNameList

    def validate(self):
        self.validate_required(self.apply_id, 'apply_id')
        self.validate_required(self.invalid_device_name_list, 'invalid_device_name_list')
        if self.invalid_device_name_list:
            self.invalid_device_name_list.validate()
        self.validate_required(self.invalid_device_secret_list, 'invalid_device_secret_list')
        if self.invalid_device_secret_list:
            self.invalid_device_secret_list.validate()
        self.validate_required(self.invalid_sn_list, 'invalid_sn_list')
        if self.invalid_sn_list:
            self.invalid_sn_list.validate()
        self.validate_required(self.repeated_device_name_list, 'repeated_device_name_list')
        if self.repeated_device_name_list:
            self.repeated_device_name_list.validate()

    def to_map(self):
        _map = super(BatchImportDeviceResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['ApplyId'] = self.apply_id
        if self.invalid_device_name_list is not None:
            result['InvalidDeviceNameList'] = self.invalid_device_name_list.to_map()
        if self.invalid_device_secret_list is not None:
            result['InvalidDeviceSecretList'] = self.invalid_device_secret_list.to_map()
        if self.invalid_sn_list is not None:
            result['InvalidSnList'] = self.invalid_sn_list.to_map()
        if self.repeated_device_name_list is not None:
            result['RepeatedDeviceNameList'] = self.repeated_device_name_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApplyId') is not None:
            self.apply_id = m.get('ApplyId')
        if m.get('InvalidDeviceNameList') is not None:
            temp_model = BatchImportDeviceResponseDataInvalidDeviceNameList()
            self.invalid_device_name_list = temp_model.from_map(m['InvalidDeviceNameList'])
        if m.get('InvalidDeviceSecretList') is not None:
            temp_model = BatchImportDeviceResponseDataInvalidDeviceSecretList()
            self.invalid_device_secret_list = temp_model.from_map(m['InvalidDeviceSecretList'])
        if m.get('InvalidSnList') is not None:
            temp_model = BatchImportDeviceResponseDataInvalidSnList()
            self.invalid_sn_list = temp_model.from_map(m['InvalidSnList'])
        if m.get('RepeatedDeviceNameList') is not None:
            temp_model = BatchImportDeviceResponseDataRepeatedDeviceNameList()
            self.repeated_device_name_list = temp_model.from_map(m['RepeatedDeviceNameList'])
        return self


class BatchImportDeviceResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: BatchImportDeviceResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(BatchImportDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = BatchImportDeviceResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class BatchImportVehicleDeviceRequestDeviceList(TeaModel):
    def __init__(self, device_id=None, device_model=None, manufacturer=None):
        self.device_id = device_id  # type: str
        self.device_model = device_model  # type: str
        self.manufacturer = manufacturer  # type: str

    def validate(self):
        self.validate_required(self.device_model, 'device_model')
        self.validate_required(self.manufacturer, 'manufacturer')

    def to_map(self):
        _map = super(BatchImportVehicleDeviceRequestDeviceList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_model is not None:
            result['DeviceModel'] = self.device_model
        if self.manufacturer is not None:
            result['Manufacturer'] = self.manufacturer
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceModel') is not None:
            self.device_model = m.get('DeviceModel')
        if m.get('Manufacturer') is not None:
            self.manufacturer = m.get('Manufacturer')
        return self


class BatchImportVehicleDeviceRequest(TeaModel):
    def __init__(self, device_list=None, iot_instance_id=None, product_key=None):
        self.device_list = device_list  # type: list[BatchImportVehicleDeviceRequestDeviceList]
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        self.validate_required(self.device_list, 'device_list')
        if self.device_list:
            for k in self.device_list:
                if k:
                    k.validate()
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        _map = super(BatchImportVehicleDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DeviceList'] = []
        if self.device_list is not None:
            for k in self.device_list:
                result['DeviceList'].append(k.to_map() if k else None)
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.device_list = []
        if m.get('DeviceList') is not None:
            for k in m.get('DeviceList'):
                temp_model = BatchImportVehicleDeviceRequestDeviceList()
                self.device_list.append(temp_model.from_map(k))
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class BatchImportVehicleDeviceResponseData(TeaModel):
    def __init__(self, apply_id=None):
        self.apply_id = apply_id  # type: long

    def validate(self):
        self.validate_required(self.apply_id, 'apply_id')

    def to_map(self):
        _map = super(BatchImportVehicleDeviceResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['ApplyId'] = self.apply_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApplyId') is not None:
            self.apply_id = m.get('ApplyId')
        return self


class BatchImportVehicleDeviceResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: BatchImportVehicleDeviceResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(BatchImportVehicleDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = BatchImportVehicleDeviceResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class BatchPubRequest(TeaModel):
    def __init__(self, device_name=None, iot_instance_id=None, message_content=None, product_key=None, qos=None,
                 topic_short_name=None):
        self.device_name = device_name  # type: list[str]
        self.iot_instance_id = iot_instance_id  # type: str
        self.message_content = message_content  # type: str
        self.product_key = product_key  # type: str
        self.qos = qos  # type: int
        self.topic_short_name = topic_short_name  # type: str

    def validate(self):
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.message_content, 'message_content')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.topic_short_name, 'topic_short_name')

    def to_map(self):
        _map = super(BatchPubRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.message_content is not None:
            result['MessageContent'] = self.message_content
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.qos is not None:
            result['Qos'] = self.qos
        if self.topic_short_name is not None:
            result['TopicShortName'] = self.topic_short_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('MessageContent') is not None:
            self.message_content = m.get('MessageContent')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Qos') is not None:
            self.qos = m.get('Qos')
        if m.get('TopicShortName') is not None:
            self.topic_short_name = m.get('TopicShortName')
        return self


class BatchPubResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(BatchPubResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchQueryDeviceDetailRequest(TeaModel):
    def __init__(self, device_name=None, iot_instance_id=None, product_key=None):
        self.device_name = device_name  # type: list[str]
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        _map = super(BatchQueryDeviceDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class BatchQueryDeviceDetailResponseDataData(TeaModel):
    def __init__(self, device_name=None, device_secret=None, firmware_version=None, gmt_active=None,
                 gmt_create=None, iot_id=None, nickname=None, node_type=None, product_key=None, product_name=None, region=None,
                 status=None, utc_active=None, utc_create=None):
        self.device_name = device_name  # type: str
        self.device_secret = device_secret  # type: str
        self.firmware_version = firmware_version  # type: str
        self.gmt_active = gmt_active  # type: str
        self.gmt_create = gmt_create  # type: str
        self.iot_id = iot_id  # type: str
        self.nickname = nickname  # type: str
        self.node_type = node_type  # type: int
        self.product_key = product_key  # type: str
        self.product_name = product_name  # type: str
        self.region = region  # type: str
        self.status = status  # type: str
        self.utc_active = utc_active  # type: str
        self.utc_create = utc_create  # type: str

    def validate(self):
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.device_secret, 'device_secret')
        self.validate_required(self.firmware_version, 'firmware_version')
        self.validate_required(self.gmt_active, 'gmt_active')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.iot_id, 'iot_id')
        self.validate_required(self.nickname, 'nickname')
        self.validate_required(self.node_type, 'node_type')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.product_name, 'product_name')
        self.validate_required(self.region, 'region')
        self.validate_required(self.status, 'status')
        self.validate_required(self.utc_active, 'utc_active')
        self.validate_required(self.utc_create, 'utc_create')

    def to_map(self):
        _map = super(BatchQueryDeviceDetailResponseDataData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_secret is not None:
            result['DeviceSecret'] = self.device_secret
        if self.firmware_version is not None:
            result['FirmwareVersion'] = self.firmware_version
        if self.gmt_active is not None:
            result['GmtActive'] = self.gmt_active
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.nickname is not None:
            result['Nickname'] = self.nickname
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.region is not None:
            result['Region'] = self.region
        if self.status is not None:
            result['Status'] = self.status
        if self.utc_active is not None:
            result['UtcActive'] = self.utc_active
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DeviceSecret') is not None:
            self.device_secret = m.get('DeviceSecret')
        if m.get('FirmwareVersion') is not None:
            self.firmware_version = m.get('FirmwareVersion')
        if m.get('GmtActive') is not None:
            self.gmt_active = m.get('GmtActive')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('Nickname') is not None:
            self.nickname = m.get('Nickname')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UtcActive') is not None:
            self.utc_active = m.get('UtcActive')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class BatchQueryDeviceDetailResponseData(TeaModel):
    def __init__(self, data=None):
        self.data = data  # type: list[BatchQueryDeviceDetailResponseDataData]

    def validate(self):
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchQueryDeviceDetailResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = BatchQueryDeviceDetailResponseDataData()
                self.data.append(temp_model.from_map(k))
        return self


class BatchQueryDeviceDetailResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: BatchQueryDeviceDetailResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(BatchQueryDeviceDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = BatchQueryDeviceDetailResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class BatchRegisterDeviceRequest(TeaModel):
    def __init__(self, count=None, iot_instance_id=None, product_key=None):
        self.count = count  # type: int
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        self.validate_required(self.count, 'count')
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        _map = super(BatchRegisterDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class BatchRegisterDeviceResponseData(TeaModel):
    def __init__(self, apply_id=None):
        self.apply_id = apply_id  # type: long

    def validate(self):
        self.validate_required(self.apply_id, 'apply_id')

    def to_map(self):
        _map = super(BatchRegisterDeviceResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['ApplyId'] = self.apply_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApplyId') is not None:
            self.apply_id = m.get('ApplyId')
        return self


class BatchRegisterDeviceResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: BatchRegisterDeviceResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(BatchRegisterDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = BatchRegisterDeviceResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class BatchRegisterDeviceWithApplyIdRequest(TeaModel):
    def __init__(self, apply_id=None, iot_instance_id=None, product_key=None):
        self.apply_id = apply_id  # type: long
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        self.validate_required(self.apply_id, 'apply_id')
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        _map = super(BatchRegisterDeviceWithApplyIdRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['ApplyId'] = self.apply_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApplyId') is not None:
            self.apply_id = m.get('ApplyId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class BatchRegisterDeviceWithApplyIdResponseData(TeaModel):
    def __init__(self, apply_id=None):
        self.apply_id = apply_id  # type: long

    def validate(self):
        self.validate_required(self.apply_id, 'apply_id')

    def to_map(self):
        _map = super(BatchRegisterDeviceWithApplyIdResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['ApplyId'] = self.apply_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApplyId') is not None:
            self.apply_id = m.get('ApplyId')
        return self


class BatchRegisterDeviceWithApplyIdResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: BatchRegisterDeviceWithApplyIdResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(BatchRegisterDeviceWithApplyIdResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = BatchRegisterDeviceWithApplyIdResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class BatchSetEdgeInstanceDeviceChannelRequest(TeaModel):
    def __init__(self, channel_id=None, driver_id=None, instance_id=None, iot_ids=None, iot_instance_id=None):
        self.channel_id = channel_id  # type: str
        self.driver_id = driver_id  # type: str
        self.instance_id = instance_id  # type: str
        self.iot_ids = iot_ids  # type: list[str]
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.channel_id, 'channel_id')
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.iot_ids, 'iot_ids')

    def to_map(self):
        _map = super(BatchSetEdgeInstanceDeviceChannelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class BatchSetEdgeInstanceDeviceChannelResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(BatchSetEdgeInstanceDeviceChannelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchSetEdgeInstanceDeviceConfigRequestDeviceConfigs(TeaModel):
    def __init__(self, content=None, iot_id=None):
        self.content = content  # type: str
        self.iot_id = iot_id  # type: str

    def validate(self):
        self.validate_required(self.content, 'content')
        self.validate_required(self.iot_id, 'iot_id')

    def to_map(self):
        _map = super(BatchSetEdgeInstanceDeviceConfigRequestDeviceConfigs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchSetEdgeInstanceDeviceConfigRequest(TeaModel):
    def __init__(self, device_configs=None, instance_id=None, iot_instance_id=None):
        self.device_configs = device_configs  # type: list[BatchSetEdgeInstanceDeviceConfigRequestDeviceConfigs]
        self.instance_id = instance_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.device_configs, 'device_configs')
        if self.device_configs:
            for k in self.device_configs:
                if k:
                    k.validate()
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        _map = super(BatchSetEdgeInstanceDeviceConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DeviceConfigs'] = []
        if self.device_configs is not None:
            for k in self.device_configs:
                result['DeviceConfigs'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.device_configs = []
        if m.get('DeviceConfigs') is not None:
            for k in m.get('DeviceConfigs'):
                temp_model = BatchSetEdgeInstanceDeviceConfigRequestDeviceConfigs()
                self.device_configs.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class BatchSetEdgeInstanceDeviceConfigResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(BatchSetEdgeInstanceDeviceConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchUnbindDeviceFromEdgeInstanceRequest(TeaModel):
    def __init__(self, instance_id=None, iot_ids=None, iot_instance_id=None):
        self.instance_id = instance_id  # type: str
        self.iot_ids = iot_ids  # type: list[str]
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.iot_ids, 'iot_ids')

    def to_map(self):
        _map = super(BatchUnbindDeviceFromEdgeInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class BatchUnbindDeviceFromEdgeInstanceResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(BatchUnbindDeviceFromEdgeInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchUnbindProjectDevicesRequestDevices(TeaModel):
    def __init__(self, device_name=None, product_key=None):
        self.device_name = device_name  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        _map = super(BatchUnbindProjectDevicesRequestDevices, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class BatchUnbindProjectDevicesRequest(TeaModel):
    def __init__(self, devices=None, iot_instance_id=None, project_id=None):
        self.devices = devices  # type: list[BatchUnbindProjectDevicesRequestDevices]
        self.iot_instance_id = iot_instance_id  # type: str
        self.project_id = project_id  # type: str

    def validate(self):
        self.validate_required(self.devices, 'devices')
        if self.devices:
            for k in self.devices:
                if k:
                    k.validate()
        self.validate_required(self.project_id, 'project_id')

    def to_map(self):
        _map = super(BatchUnbindProjectDevicesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Devices'] = []
        if self.devices is not None:
            for k in self.devices:
                result['Devices'].append(k.to_map() if k else None)
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.devices = []
        if m.get('Devices') is not None:
            for k in m.get('Devices'):
                temp_model = BatchUnbindProjectDevicesRequestDevices()
                self.devices.append(temp_model.from_map(k))
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class BatchUnbindProjectDevicesResponse(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: bool
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.data, 'data')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(BatchUnbindProjectDevicesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchUnbindProjectProductsRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_keys=None, project_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_keys = product_keys  # type: list[str]
        self.project_id = project_id  # type: str

    def validate(self):
        self.validate_required(self.product_keys, 'product_keys')
        self.validate_required(self.project_id, 'project_id')

    def to_map(self):
        _map = super(BatchUnbindProjectProductsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_keys is not None:
            result['ProductKeys'] = self.product_keys
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKeys') is not None:
            self.product_keys = m.get('ProductKeys')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class BatchUnbindProjectProductsResponse(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: bool
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.data, 'data')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(BatchUnbindProjectProductsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchUpdateDeviceNicknameRequestDeviceNicknameInfo(TeaModel):
    def __init__(self, device_name=None, iot_id=None, nickname=None, product_key=None):
        self.device_name = device_name  # type: str
        self.iot_id = iot_id  # type: str
        self.nickname = nickname  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchUpdateDeviceNicknameRequestDeviceNicknameInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.nickname is not None:
            result['Nickname'] = self.nickname
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('Nickname') is not None:
            self.nickname = m.get('Nickname')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class BatchUpdateDeviceNicknameRequest(TeaModel):
    def __init__(self, device_nickname_info=None, iot_instance_id=None):
        self.device_nickname_info = device_nickname_info  # type: list[BatchUpdateDeviceNicknameRequestDeviceNicknameInfo]
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.device_nickname_info, 'device_nickname_info')
        if self.device_nickname_info:
            for k in self.device_nickname_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchUpdateDeviceNicknameRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DeviceNicknameInfo'] = []
        if self.device_nickname_info is not None:
            for k in self.device_nickname_info:
                result['DeviceNicknameInfo'].append(k.to_map() if k else None)
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.device_nickname_info = []
        if m.get('DeviceNicknameInfo') is not None:
            for k in m.get('DeviceNicknameInfo'):
                temp_model = BatchUpdateDeviceNicknameRequestDeviceNicknameInfo()
                self.device_nickname_info.append(temp_model.from_map(k))
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class BatchUpdateDeviceNicknameResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(BatchUpdateDeviceNicknameResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BindApplicationToEdgeInstanceRequest(TeaModel):
    def __init__(self, application_id=None, application_version=None, instance_id=None, iot_instance_id=None):
        self.application_id = application_id  # type: str
        self.application_version = application_version  # type: str
        self.instance_id = instance_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.application_id, 'application_id')
        self.validate_required(self.application_version, 'application_version')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        _map = super(BindApplicationToEdgeInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.application_version is not None:
            result['ApplicationVersion'] = self.application_version
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('ApplicationVersion') is not None:
            self.application_version = m.get('ApplicationVersion')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class BindApplicationToEdgeInstanceResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(BindApplicationToEdgeInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BindDriverToEdgeInstanceRequest(TeaModel):
    def __init__(self, driver_id=None, driver_version=None, instance_id=None, iot_instance_id=None, order_id=None):
        self.driver_id = driver_id  # type: str
        self.driver_version = driver_version  # type: str
        self.instance_id = instance_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.order_id = order_id  # type: str

    def validate(self):
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        _map = super(BindDriverToEdgeInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        return self


class BindDriverToEdgeInstanceResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(BindDriverToEdgeInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BindGatewayToEdgeInstanceRequest(TeaModel):
    def __init__(self, device_name=None, instance_id=None, iot_id=None, iot_instance_id=None, product_key=None):
        self.device_name = device_name  # type: str
        self.instance_id = instance_id  # type: str
        self.iot_id = iot_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        _map = super(BindGatewayToEdgeInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class BindGatewayToEdgeInstanceResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(BindGatewayToEdgeInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BindLicenseDeviceRequest(TeaModel):
    def __init__(self, device_name_list=None, iot_id_list=None, iot_instance_id=None, license_code=None,
                 product_key=None):
        self.device_name_list = device_name_list  # type: list[str]
        self.iot_id_list = iot_id_list  # type: list[str]
        self.iot_instance_id = iot_instance_id  # type: str
        self.license_code = license_code  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        self.validate_required(self.license_code, 'license_code')
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        _map = super(BindLicenseDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name_list is not None:
            result['DeviceNameList'] = self.device_name_list
        if self.iot_id_list is not None:
            result['IotIdList'] = self.iot_id_list
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.license_code is not None:
            result['LicenseCode'] = self.license_code
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceNameList') is not None:
            self.device_name_list = m.get('DeviceNameList')
        if m.get('IotIdList') is not None:
            self.iot_id_list = m.get('IotIdList')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('LicenseCode') is not None:
            self.license_code = m.get('LicenseCode')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class BindLicenseDeviceResponseData(TeaModel):
    def __init__(self, check_progress_id=None, fail_sum=None, progress=None, result_csv_file=None, success_sum=None):
        self.check_progress_id = check_progress_id  # type: str
        self.fail_sum = fail_sum  # type: long
        self.progress = progress  # type: int
        self.result_csv_file = result_csv_file  # type: str
        self.success_sum = success_sum  # type: long

    def validate(self):
        self.validate_required(self.check_progress_id, 'check_progress_id')
        self.validate_required(self.fail_sum, 'fail_sum')
        self.validate_required(self.progress, 'progress')
        self.validate_required(self.result_csv_file, 'result_csv_file')
        self.validate_required(self.success_sum, 'success_sum')

    def to_map(self):
        _map = super(BindLicenseDeviceResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_progress_id is not None:
            result['CheckProgressId'] = self.check_progress_id
        if self.fail_sum is not None:
            result['FailSum'] = self.fail_sum
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.result_csv_file is not None:
            result['ResultCsvFile'] = self.result_csv_file
        if self.success_sum is not None:
            result['SuccessSum'] = self.success_sum
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CheckProgressId') is not None:
            self.check_progress_id = m.get('CheckProgressId')
        if m.get('FailSum') is not None:
            self.fail_sum = m.get('FailSum')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('ResultCsvFile') is not None:
            self.result_csv_file = m.get('ResultCsvFile')
        if m.get('SuccessSum') is not None:
            self.success_sum = m.get('SuccessSum')
        return self


class BindLicenseDeviceResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: BindLicenseDeviceResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(BindLicenseDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = BindLicenseDeviceResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class BindLicenseProductRequest(TeaModel):
    def __init__(self, iot_instance_id=None, license_code=None, product_key=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.license_code = license_code  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        self.validate_required(self.license_code, 'license_code')
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        _map = super(BindLicenseProductRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.license_code is not None:
            result['LicenseCode'] = self.license_code
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('LicenseCode') is not None:
            self.license_code = m.get('LicenseCode')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class BindLicenseProductResponse(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: bool
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.data, 'data')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(BindLicenseProductResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BindRoleToEdgeInstanceRequest(TeaModel):
    def __init__(self, instance_id=None, iot_instance_id=None, role_arn=None, role_name=None):
        self.instance_id = instance_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.role_arn = role_arn  # type: str
        self.role_name = role_name  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.role_arn, 'role_arn')
        self.validate_required(self.role_name, 'role_name')

    def to_map(self):
        _map = super(BindRoleToEdgeInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        if self.role_name is not None:
            result['RoleName'] = self.role_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        if m.get('RoleName') is not None:
            self.role_name = m.get('RoleName')
        return self


class BindRoleToEdgeInstanceResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(BindRoleToEdgeInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BindSceneRuleToEdgeInstanceRequest(TeaModel):
    def __init__(self, instance_id=None, iot_instance_id=None, rule_id=None):
        self.instance_id = instance_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.rule_id = rule_id  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.rule_id, 'rule_id')

    def to_map(self):
        _map = super(BindSceneRuleToEdgeInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class BindSceneRuleToEdgeInstanceResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(BindSceneRuleToEdgeInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CancelJobRequest(TeaModel):
    def __init__(self, iot_instance_id=None, job_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        self.validate_required(self.job_id, 'job_id')

    def to_map(self):
        _map = super(CancelJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class CancelJobResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(CancelJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CancelOTAStrategyByJobRequest(TeaModel):
    def __init__(self, iot_instance_id=None, job_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        self.validate_required(self.job_id, 'job_id')

    def to_map(self):
        _map = super(CancelOTAStrategyByJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class CancelOTAStrategyByJobResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(CancelOTAStrategyByJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CancelOTATaskByDeviceRequest(TeaModel):
    def __init__(self, device_name=None, firmware_id=None, iot_instance_id=None, job_id=None, product_key=None):
        self.device_name = device_name  # type: list[str]
        self.firmware_id = firmware_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.job_id = job_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.firmware_id, 'firmware_id')
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        _map = super(CancelOTATaskByDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class CancelOTATaskByDeviceResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(CancelOTATaskByDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CancelOTATaskByJobRequest(TeaModel):
    def __init__(self, cancel_in_progress_task=None, cancel_notified_task=None, cancel_queued_task=None,
                 cancel_scheduled_task=None, cancel_unconfirmed_task=None, iot_instance_id=None, job_id=None):
        self.cancel_in_progress_task = cancel_in_progress_task  # type: bool
        self.cancel_notified_task = cancel_notified_task  # type: bool
        self.cancel_queued_task = cancel_queued_task  # type: bool
        self.cancel_scheduled_task = cancel_scheduled_task  # type: bool
        self.cancel_unconfirmed_task = cancel_unconfirmed_task  # type: bool
        self.iot_instance_id = iot_instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        self.validate_required(self.job_id, 'job_id')

    def to_map(self):
        _map = super(CancelOTATaskByJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cancel_in_progress_task is not None:
            result['CancelInProgressTask'] = self.cancel_in_progress_task
        if self.cancel_notified_task is not None:
            result['CancelNotifiedTask'] = self.cancel_notified_task
        if self.cancel_queued_task is not None:
            result['CancelQueuedTask'] = self.cancel_queued_task
        if self.cancel_scheduled_task is not None:
            result['CancelScheduledTask'] = self.cancel_scheduled_task
        if self.cancel_unconfirmed_task is not None:
            result['CancelUnconfirmedTask'] = self.cancel_unconfirmed_task
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CancelInProgressTask') is not None:
            self.cancel_in_progress_task = m.get('CancelInProgressTask')
        if m.get('CancelNotifiedTask') is not None:
            self.cancel_notified_task = m.get('CancelNotifiedTask')
        if m.get('CancelQueuedTask') is not None:
            self.cancel_queued_task = m.get('CancelQueuedTask')
        if m.get('CancelScheduledTask') is not None:
            self.cancel_scheduled_task = m.get('CancelScheduledTask')
        if m.get('CancelUnconfirmedTask') is not None:
            self.cancel_unconfirmed_task = m.get('CancelUnconfirmedTask')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class CancelOTATaskByJobResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(CancelOTATaskByJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CancelReleaseProductRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        _map = super(CancelReleaseProductRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class CancelReleaseProductResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(CancelReleaseProductResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CheckBindLicenseDeviceProgressRequest(TeaModel):
    def __init__(self, check_progress_id=None, iot_instance_id=None, license_code=None, product_key=None):
        self.check_progress_id = check_progress_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.license_code = license_code  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        self.validate_required(self.check_progress_id, 'check_progress_id')
        self.validate_required(self.license_code, 'license_code')
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        _map = super(CheckBindLicenseDeviceProgressRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_progress_id is not None:
            result['CheckProgressId'] = self.check_progress_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.license_code is not None:
            result['LicenseCode'] = self.license_code
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CheckProgressId') is not None:
            self.check_progress_id = m.get('CheckProgressId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('LicenseCode') is not None:
            self.license_code = m.get('LicenseCode')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class CheckBindLicenseDeviceProgressResponseData(TeaModel):
    def __init__(self, fail_sum=None, progress=None, result_csv_file=None, success_sum=None):
        self.fail_sum = fail_sum  # type: long
        self.progress = progress  # type: int
        self.result_csv_file = result_csv_file  # type: str
        self.success_sum = success_sum  # type: long

    def validate(self):
        self.validate_required(self.fail_sum, 'fail_sum')
        self.validate_required(self.progress, 'progress')
        self.validate_required(self.result_csv_file, 'result_csv_file')
        self.validate_required(self.success_sum, 'success_sum')

    def to_map(self):
        _map = super(CheckBindLicenseDeviceProgressResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fail_sum is not None:
            result['FailSum'] = self.fail_sum
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.result_csv_file is not None:
            result['ResultCsvFile'] = self.result_csv_file
        if self.success_sum is not None:
            result['SuccessSum'] = self.success_sum
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FailSum') is not None:
            self.fail_sum = m.get('FailSum')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('ResultCsvFile') is not None:
            self.result_csv_file = m.get('ResultCsvFile')
        if m.get('SuccessSum') is not None:
            self.success_sum = m.get('SuccessSum')
        return self


class CheckBindLicenseDeviceProgressResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: CheckBindLicenseDeviceProgressResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CheckBindLicenseDeviceProgressResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = CheckBindLicenseDeviceProgressResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ClearDeviceDesiredPropertyRequest(TeaModel):
    def __init__(self, device_name=None, identifies=None, iot_id=None, iot_instance_id=None, product_key=None):
        self.device_name = device_name  # type: str
        self.identifies = identifies  # type: list[str]
        self.iot_id = iot_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ClearDeviceDesiredPropertyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.identifies is not None:
            result['Identifies'] = self.identifies
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Identifies') is not None:
            self.identifies = m.get('Identifies')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class ClearDeviceDesiredPropertyResponseData(TeaModel):
    def __init__(self, versions=None):
        self.versions = versions  # type: str

    def validate(self):
        self.validate_required(self.versions, 'versions')

    def to_map(self):
        _map = super(ClearDeviceDesiredPropertyResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.versions is not None:
            result['Versions'] = self.versions
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Versions') is not None:
            self.versions = m.get('Versions')
        return self


class ClearDeviceDesiredPropertyResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: ClearDeviceDesiredPropertyResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ClearDeviceDesiredPropertyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = ClearDeviceDesiredPropertyResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ClearEdgeInstanceDriverConfigsRequest(TeaModel):
    def __init__(self, driver_id=None, instance_id=None, iot_instance_id=None):
        self.driver_id = driver_id  # type: str
        self.instance_id = instance_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        _map = super(ClearEdgeInstanceDriverConfigsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class ClearEdgeInstanceDriverConfigsResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(ClearEdgeInstanceDriverConfigsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CloseDeviceTunnelRequest(TeaModel):
    def __init__(self, tunnel_id=None, iot_instance_id=None):
        self.tunnel_id = tunnel_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.tunnel_id, 'tunnel_id')

    def to_map(self):
        _map = super(CloseDeviceTunnelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tunnel_id is not None:
            result['TunnelId'] = self.tunnel_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TunnelId') is not None:
            self.tunnel_id = m.get('TunnelId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class CloseDeviceTunnelResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(CloseDeviceTunnelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CloseEdgeInstanceDeploymentRequest(TeaModel):
    def __init__(self, instance_id=None, iot_instance_id=None):
        self.instance_id = instance_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        _map = super(CloseEdgeInstanceDeploymentRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class CloseEdgeInstanceDeploymentResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(CloseEdgeInstanceDeploymentResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ConfirmOTATaskRequest(TeaModel):
    def __init__(self, iot_instance_id=None, task_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.task_id = task_id  # type: list[str]

    def validate(self):
        self.validate_required(self.task_id, 'task_id')

    def to_map(self):
        _map = super(ConfirmOTATaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class ConfirmOTATaskResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(ConfirmOTATaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CopyThingModelRequest(TeaModel):
    def __init__(self, iot_instance_id=None, resource_group_id=None, source_model_version=None,
                 source_product_key=None, target_product_key=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.source_model_version = source_model_version  # type: str
        self.source_product_key = source_product_key  # type: str
        self.target_product_key = target_product_key  # type: str

    def validate(self):
        self.validate_required(self.source_product_key, 'source_product_key')
        self.validate_required(self.target_product_key, 'target_product_key')

    def to_map(self):
        _map = super(CopyThingModelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.source_model_version is not None:
            result['SourceModelVersion'] = self.source_model_version
        if self.source_product_key is not None:
            result['SourceProductKey'] = self.source_product_key
        if self.target_product_key is not None:
            result['TargetProductKey'] = self.target_product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SourceModelVersion') is not None:
            self.source_model_version = m.get('SourceModelVersion')
        if m.get('SourceProductKey') is not None:
            self.source_product_key = m.get('SourceProductKey')
        if m.get('TargetProductKey') is not None:
            self.target_product_key = m.get('TargetProductKey')
        return self


class CopyThingModelResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(CopyThingModelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CountSpeechBroadcastHourRequest(TeaModel):
    def __init__(self, iot_instance_id=None, query_date_time_hour=None, share_task_code=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.query_date_time_hour = query_date_time_hour  # type: str
        self.share_task_code = share_task_code  # type: str

    def validate(self):
        self.validate_required(self.query_date_time_hour, 'query_date_time_hour')
        self.validate_required(self.share_task_code, 'share_task_code')

    def to_map(self):
        _map = super(CountSpeechBroadcastHourRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.query_date_time_hour is not None:
            result['QueryDateTimeHour'] = self.query_date_time_hour
        if self.share_task_code is not None:
            result['ShareTaskCode'] = self.share_task_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('QueryDateTimeHour') is not None:
            self.query_date_time_hour = m.get('QueryDateTimeHour')
        if m.get('ShareTaskCode') is not None:
            self.share_task_code = m.get('ShareTaskCode')
        return self


class CountSpeechBroadcastHourResponse(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: int
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.data, 'data')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(CountSpeechBroadcastHourResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateConsumerGroupRequest(TeaModel):
    def __init__(self, group_name=None, iot_instance_id=None):
        self.group_name = group_name  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.group_name, 'group_name')

    def to_map(self):
        _map = super(CreateConsumerGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class CreateConsumerGroupResponse(TeaModel):
    def __init__(self, code=None, error_message=None, group_id=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.group_id = group_id  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(CreateConsumerGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateConsumerGroupSubscribeRelationRequest(TeaModel):
    def __init__(self, consumer_group_id=None, iot_instance_id=None, product_key=None):
        self.consumer_group_id = consumer_group_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        self.validate_required(self.consumer_group_id, 'consumer_group_id')
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        _map = super(CreateConsumerGroupSubscribeRelationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.consumer_group_id is not None:
            result['ConsumerGroupId'] = self.consumer_group_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConsumerGroupId') is not None:
            self.consumer_group_id = m.get('ConsumerGroupId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class CreateConsumerGroupSubscribeRelationResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(CreateConsumerGroupSubscribeRelationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDataAPIServiceRequestRequestParam(TeaModel):
    def __init__(self, name=None, type=None, desc=None, example=None, required=None):
        self.name = name  # type: str
        self.type = type  # type: str
        self.desc = desc  # type: str
        self.example = example  # type: str
        self.required = required  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDataAPIServiceRequestRequestParam, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.example is not None:
            result['Example'] = self.example
        if self.required is not None:
            result['Required'] = self.required
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('Example') is not None:
            self.example = m.get('Example')
        if m.get('Required') is not None:
            self.required = m.get('Required')
        return self


class CreateDataAPIServiceRequestResponseParam(TeaModel):
    def __init__(self, name=None, type=None, desc=None, example=None, required=None):
        self.name = name  # type: str
        self.type = type  # type: str
        self.desc = desc  # type: str
        self.example = example  # type: str
        self.required = required  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDataAPIServiceRequestResponseParam, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.example is not None:
            result['Example'] = self.example
        if self.required is not None:
            result['Required'] = self.required
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('Example') is not None:
            self.example = m.get('Example')
        if m.get('Required') is not None:
            self.required = m.get('Required')
        return self


class CreateDataAPIServiceRequest(TeaModel):
    def __init__(self, display_name=None, origin_sql=None, request_param=None, desc=None, response_param=None,
                 template_sql=None, api_path=None, iot_instance_id=None):
        self.display_name = display_name  # type: str
        self.origin_sql = origin_sql  # type: str
        self.request_param = request_param  # type: list[CreateDataAPIServiceRequestRequestParam]
        self.desc = desc  # type: str
        self.response_param = response_param  # type: list[CreateDataAPIServiceRequestResponseParam]
        self.template_sql = template_sql  # type: str
        self.api_path = api_path  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.display_name, 'display_name')
        self.validate_required(self.origin_sql, 'origin_sql')
        if self.request_param:
            for k in self.request_param:
                if k:
                    k.validate()
        if self.response_param:
            for k in self.response_param:
                if k:
                    k.validate()
        self.validate_required(self.template_sql, 'template_sql')
        self.validate_required(self.api_path, 'api_path')

    def to_map(self):
        _map = super(CreateDataAPIServiceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.origin_sql is not None:
            result['OriginSql'] = self.origin_sql
        result['RequestParam'] = []
        if self.request_param is not None:
            for k in self.request_param:
                result['RequestParam'].append(k.to_map() if k else None)
        if self.desc is not None:
            result['Desc'] = self.desc
        result['ResponseParam'] = []
        if self.response_param is not None:
            for k in self.response_param:
                result['ResponseParam'].append(k.to_map() if k else None)
        if self.template_sql is not None:
            result['TemplateSql'] = self.template_sql
        if self.api_path is not None:
            result['ApiPath'] = self.api_path
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('OriginSql') is not None:
            self.origin_sql = m.get('OriginSql')
        self.request_param = []
        if m.get('RequestParam') is not None:
            for k in m.get('RequestParam'):
                temp_model = CreateDataAPIServiceRequestRequestParam()
                self.request_param.append(temp_model.from_map(k))
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        self.response_param = []
        if m.get('ResponseParam') is not None:
            for k in m.get('ResponseParam'):
                temp_model = CreateDataAPIServiceRequestResponseParam()
                self.response_param.append(temp_model.from_map(k))
        if m.get('TemplateSql') is not None:
            self.template_sql = m.get('TemplateSql')
        if m.get('ApiPath') is not None:
            self.api_path = m.get('ApiPath')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class CreateDataAPIServiceResponseData(TeaModel):
    def __init__(self, api_srn=None, create_time=None, last_update_time=None):
        self.api_srn = api_srn  # type: str
        self.create_time = create_time  # type: long
        self.last_update_time = last_update_time  # type: long

    def validate(self):
        self.validate_required(self.api_srn, 'api_srn')
        self.validate_required(self.create_time, 'create_time')
        self.validate_required(self.last_update_time, 'last_update_time')

    def to_map(self):
        _map = super(CreateDataAPIServiceResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_srn is not None:
            result['ApiSrn'] = self.api_srn
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.last_update_time is not None:
            result['LastUpdateTime'] = self.last_update_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiSrn') is not None:
            self.api_srn = m.get('ApiSrn')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('LastUpdateTime') is not None:
            self.last_update_time = m.get('LastUpdateTime')
        return self


class CreateDataAPIServiceResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: CreateDataAPIServiceResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateDataAPIServiceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = CreateDataAPIServiceResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateDataSourceItemRequest(TeaModel):
    def __init__(self, data_source_id=None, device_name=None, iot_instance_id=None, product_key=None,
                 scope_type=None, topic=None):
        self.data_source_id = data_source_id  # type: long
        self.device_name = device_name  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.scope_type = scope_type  # type: str
        self.topic = topic  # type: str

    def validate(self):
        self.validate_required(self.data_source_id, 'data_source_id')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        _map = super(CreateDataSourceItemRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.scope_type is not None:
            result['ScopeType'] = self.scope_type
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ScopeType') is not None:
            self.scope_type = m.get('ScopeType')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class CreateDataSourceItemResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(CreateDataSourceItemResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDestinationRequest(TeaModel):
    def __init__(self, configuration=None, description=None, iot_instance_id=None, name=None, type=None):
        self.configuration = configuration  # type: str
        self.description = description  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.name = name  # type: str
        self.type = type  # type: str

    def validate(self):
        self.validate_required(self.configuration, 'configuration')
        self.validate_required(self.name, 'name')
        self.validate_required(self.type, 'type')

    def to_map(self):
        _map = super(CreateDestinationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.configuration is not None:
            result['Configuration'] = self.configuration
        if self.description is not None:
            result['Description'] = self.description
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Configuration') is not None:
            self.configuration = m.get('Configuration')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateDestinationResponseDestination(TeaModel):
    def __init__(self, configuration=None, destination_id=None, is_failover=None, name=None, type=None,
                 utc_created=None):
        self.configuration = configuration  # type: str
        self.destination_id = destination_id  # type: long
        self.is_failover = is_failover  # type: bool
        self.name = name  # type: str
        self.type = type  # type: str
        self.utc_created = utc_created  # type: str

    def validate(self):
        self.validate_required(self.configuration, 'configuration')
        self.validate_required(self.destination_id, 'destination_id')
        self.validate_required(self.is_failover, 'is_failover')
        self.validate_required(self.name, 'name')
        self.validate_required(self.type, 'type')
        self.validate_required(self.utc_created, 'utc_created')

    def to_map(self):
        _map = super(CreateDestinationResponseDestination, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.configuration is not None:
            result['Configuration'] = self.configuration
        if self.destination_id is not None:
            result['DestinationId'] = self.destination_id
        if self.is_failover is not None:
            result['IsFailover'] = self.is_failover
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.utc_created is not None:
            result['UtcCreated'] = self.utc_created
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Configuration') is not None:
            self.configuration = m.get('Configuration')
        if m.get('DestinationId') is not None:
            self.destination_id = m.get('DestinationId')
        if m.get('IsFailover') is not None:
            self.is_failover = m.get('IsFailover')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UtcCreated') is not None:
            self.utc_created = m.get('UtcCreated')
        return self


class CreateDestinationResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, destination=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.destination = destination  # type: CreateDestinationResponseDestination

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.destination, 'destination')
        if self.destination:
            self.destination.validate()

    def to_map(self):
        _map = super(CreateDestinationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.destination is not None:
            result['Destination'] = self.destination.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Destination') is not None:
            temp_model = CreateDestinationResponseDestination()
            self.destination = temp_model.from_map(m['Destination'])
        return self


class CreateDeviceDistributeJobRequestTargetInstanceConfig(TeaModel):
    def __init__(self, target_instance_id=None):
        self.target_instance_id = target_instance_id  # type: str

    def validate(self):
        self.validate_required(self.target_instance_id, 'target_instance_id')

    def to_map(self):
        _map = super(CreateDeviceDistributeJobRequestTargetInstanceConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.target_instance_id is not None:
            result['TargetInstanceId'] = self.target_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TargetInstanceId') is not None:
            self.target_instance_id = m.get('TargetInstanceId')
        return self


class CreateDeviceDistributeJobRequest(TeaModel):
    def __init__(self, device_name=None, source_instance_id=None, product_key=None, target_uid=None,
                 target_aliyun_id=None, target_instance_config=None, strategy=None):
        self.device_name = device_name  # type: list[str]
        self.source_instance_id = source_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.target_uid = target_uid  # type: str
        self.target_aliyun_id = target_aliyun_id  # type: str
        self.target_instance_config = target_instance_config  # type: list[CreateDeviceDistributeJobRequestTargetInstanceConfig]
        self.strategy = strategy  # type: int

    def validate(self):
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.source_instance_id, 'source_instance_id')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.target_instance_config, 'target_instance_config')
        if self.target_instance_config:
            for k in self.target_instance_config:
                if k:
                    k.validate()
        self.validate_required(self.strategy, 'strategy')

    def to_map(self):
        _map = super(CreateDeviceDistributeJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        if self.target_aliyun_id is not None:
            result['TargetAliyunId'] = self.target_aliyun_id
        result['TargetInstanceConfig'] = []
        if self.target_instance_config is not None:
            for k in self.target_instance_config:
                result['TargetInstanceConfig'].append(k.to_map() if k else None)
        if self.strategy is not None:
            result['Strategy'] = self.strategy
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        if m.get('TargetAliyunId') is not None:
            self.target_aliyun_id = m.get('TargetAliyunId')
        self.target_instance_config = []
        if m.get('TargetInstanceConfig') is not None:
            for k in m.get('TargetInstanceConfig'):
                temp_model = CreateDeviceDistributeJobRequestTargetInstanceConfig()
                self.target_instance_config.append(temp_model.from_map(k))
        if m.get('Strategy') is not None:
            self.strategy = m.get('Strategy')
        return self


class CreateDeviceDistributeJobResponse(TeaModel):
    def __init__(self, code=None, error_message=None, job_id=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.job_id = job_id  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.job_id, 'job_id')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(CreateDeviceDistributeJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDeviceDynamicGroupRequest(TeaModel):
    def __init__(self, dynamic_group_expression=None, group_desc=None, group_name=None, iot_instance_id=None):
        self.dynamic_group_expression = dynamic_group_expression  # type: str
        self.group_desc = group_desc  # type: str
        self.group_name = group_name  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.dynamic_group_expression, 'dynamic_group_expression')
        self.validate_required(self.group_name, 'group_name')
        self.validate_required(self.iot_instance_id, 'iot_instance_id')

    def to_map(self):
        _map = super(CreateDeviceDynamicGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dynamic_group_expression is not None:
            result['DynamicGroupExpression'] = self.dynamic_group_expression
        if self.group_desc is not None:
            result['GroupDesc'] = self.group_desc
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DynamicGroupExpression') is not None:
            self.dynamic_group_expression = m.get('DynamicGroupExpression')
        if m.get('GroupDesc') is not None:
            self.group_desc = m.get('GroupDesc')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class CreateDeviceDynamicGroupResponseData(TeaModel):
    def __init__(self, dynamic_group_expression=None, group_desc=None, group_id=None, group_name=None,
                 utc_create=None):
        self.dynamic_group_expression = dynamic_group_expression  # type: str
        self.group_desc = group_desc  # type: str
        self.group_id = group_id  # type: str
        self.group_name = group_name  # type: str
        self.utc_create = utc_create  # type: str

    def validate(self):
        self.validate_required(self.dynamic_group_expression, 'dynamic_group_expression')
        self.validate_required(self.group_desc, 'group_desc')
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.group_name, 'group_name')
        self.validate_required(self.utc_create, 'utc_create')

    def to_map(self):
        _map = super(CreateDeviceDynamicGroupResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dynamic_group_expression is not None:
            result['DynamicGroupExpression'] = self.dynamic_group_expression
        if self.group_desc is not None:
            result['GroupDesc'] = self.group_desc
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DynamicGroupExpression') is not None:
            self.dynamic_group_expression = m.get('DynamicGroupExpression')
        if m.get('GroupDesc') is not None:
            self.group_desc = m.get('GroupDesc')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class CreateDeviceDynamicGroupResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: CreateDeviceDynamicGroupResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateDeviceDynamicGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = CreateDeviceDynamicGroupResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateDeviceGroupRequest(TeaModel):
    def __init__(self, group_desc=None, group_name=None, iot_instance_id=None, super_group_id=None):
        self.group_desc = group_desc  # type: str
        self.group_name = group_name  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.super_group_id = super_group_id  # type: str

    def validate(self):
        self.validate_required(self.group_name, 'group_name')

    def to_map(self):
        _map = super(CreateDeviceGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_desc is not None:
            result['GroupDesc'] = self.group_desc
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.super_group_id is not None:
            result['SuperGroupId'] = self.super_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupDesc') is not None:
            self.group_desc = m.get('GroupDesc')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('SuperGroupId') is not None:
            self.super_group_id = m.get('SuperGroupId')
        return self


class CreateDeviceGroupResponseData(TeaModel):
    def __init__(self, group_desc=None, group_id=None, group_name=None, utc_create=None):
        self.group_desc = group_desc  # type: str
        self.group_id = group_id  # type: str
        self.group_name = group_name  # type: str
        self.utc_create = utc_create  # type: str

    def validate(self):
        self.validate_required(self.group_desc, 'group_desc')
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.group_name, 'group_name')
        self.validate_required(self.utc_create, 'utc_create')

    def to_map(self):
        _map = super(CreateDeviceGroupResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_desc is not None:
            result['GroupDesc'] = self.group_desc
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupDesc') is not None:
            self.group_desc = m.get('GroupDesc')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class CreateDeviceGroupResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: CreateDeviceGroupResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateDeviceGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = CreateDeviceGroupResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateDeviceTunnelRequest(TeaModel):
    def __init__(self, iot_id=None, description=None, udi=None, product_key=None, device_name=None,
                 iot_instance_id=None):
        self.iot_id = iot_id  # type: str
        self.description = description  # type: str
        self.udi = udi  # type: str
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDeviceTunnelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.description is not None:
            result['Description'] = self.description
        if self.udi is not None:
            result['Udi'] = self.udi
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Udi') is not None:
            self.udi = m.get('Udi')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class CreateDeviceTunnelResponseData(TeaModel):
    def __init__(self, source_access_token=None, source_uri=None, tunnel_id=None):
        self.source_access_token = source_access_token  # type: str
        self.source_uri = source_uri  # type: str
        self.tunnel_id = tunnel_id  # type: str

    def validate(self):
        self.validate_required(self.source_access_token, 'source_access_token')
        self.validate_required(self.source_uri, 'source_uri')
        self.validate_required(self.tunnel_id, 'tunnel_id')

    def to_map(self):
        _map = super(CreateDeviceTunnelResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_access_token is not None:
            result['SourceAccessToken'] = self.source_access_token
        if self.source_uri is not None:
            result['SourceURI'] = self.source_uri
        if self.tunnel_id is not None:
            result['TunnelId'] = self.tunnel_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SourceAccessToken') is not None:
            self.source_access_token = m.get('SourceAccessToken')
        if m.get('SourceURI') is not None:
            self.source_uri = m.get('SourceURI')
        if m.get('TunnelId') is not None:
            self.tunnel_id = m.get('TunnelId')
        return self


class CreateDeviceTunnelResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: CreateDeviceTunnelResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateDeviceTunnelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = CreateDeviceTunnelResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateDownloadDataJobRequest(TeaModel):
    def __init__(self, context=None, download_data_type=None, end_time=None, file_config=None, iot_instance_id=None,
                 start_time=None, table_name=None):
        self.context = context  # type: dict[str, any]
        self.download_data_type = download_data_type  # type: str
        self.end_time = end_time  # type: long
        self.file_config = file_config  # type: dict[str, any]
        self.iot_instance_id = iot_instance_id  # type: str
        self.start_time = start_time  # type: long
        self.table_name = table_name  # type: str

    def validate(self):
        self.validate_required(self.download_data_type, 'download_data_type')
        self.validate_required(self.table_name, 'table_name')

    def to_map(self):
        _map = super(CreateDownloadDataJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.context is not None:
            result['Context'] = self.context
        if self.download_data_type is not None:
            result['DownloadDataType'] = self.download_data_type
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.file_config is not None:
            result['FileConfig'] = self.file_config
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Context') is not None:
            self.context = m.get('Context')
        if m.get('DownloadDataType') is not None:
            self.download_data_type = m.get('DownloadDataType')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('FileConfig') is not None:
            self.file_config = m.get('FileConfig')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class CreateDownloadDataJobShrinkRequest(TeaModel):
    def __init__(self, context_shrink=None, download_data_type=None, end_time=None, file_config_shrink=None,
                 iot_instance_id=None, start_time=None, table_name=None):
        self.context_shrink = context_shrink  # type: str
        self.download_data_type = download_data_type  # type: str
        self.end_time = end_time  # type: long
        self.file_config_shrink = file_config_shrink  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.start_time = start_time  # type: long
        self.table_name = table_name  # type: str

    def validate(self):
        self.validate_required(self.download_data_type, 'download_data_type')
        self.validate_required(self.table_name, 'table_name')

    def to_map(self):
        _map = super(CreateDownloadDataJobShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.context_shrink is not None:
            result['Context'] = self.context_shrink
        if self.download_data_type is not None:
            result['DownloadDataType'] = self.download_data_type
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.file_config_shrink is not None:
            result['FileConfig'] = self.file_config_shrink
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Context') is not None:
            self.context_shrink = m.get('Context')
        if m.get('DownloadDataType') is not None:
            self.download_data_type = m.get('DownloadDataType')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('FileConfig') is not None:
            self.file_config_shrink = m.get('FileConfig')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class CreateDownloadDataJobResponseDataHeader(TeaModel):
    def __init__(self, alias=None, data_precision=None, dim_date_class=None, field_name=None, field_type=None,
                 geo_class=None, time_class=None, type_class=None):
        self.alias = alias  # type: str
        self.data_precision = data_precision  # type: str
        self.dim_date_class = dim_date_class  # type: str
        self.field_name = field_name  # type: str
        self.field_type = field_type  # type: str
        self.geo_class = geo_class  # type: str
        self.time_class = time_class  # type: str
        self.type_class = type_class  # type: str

    def validate(self):
        self.validate_required(self.alias, 'alias')
        self.validate_required(self.data_precision, 'data_precision')
        self.validate_required(self.dim_date_class, 'dim_date_class')
        self.validate_required(self.field_name, 'field_name')
        self.validate_required(self.field_type, 'field_type')
        self.validate_required(self.geo_class, 'geo_class')
        self.validate_required(self.time_class, 'time_class')
        self.validate_required(self.type_class, 'type_class')

    def to_map(self):
        _map = super(CreateDownloadDataJobResponseDataHeader, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias is not None:
            result['Alias'] = self.alias
        if self.data_precision is not None:
            result['DataPrecision'] = self.data_precision
        if self.dim_date_class is not None:
            result['DimDateClass'] = self.dim_date_class
        if self.field_name is not None:
            result['FieldName'] = self.field_name
        if self.field_type is not None:
            result['FieldType'] = self.field_type
        if self.geo_class is not None:
            result['GeoClass'] = self.geo_class
        if self.time_class is not None:
            result['TimeClass'] = self.time_class
        if self.type_class is not None:
            result['TypeClass'] = self.type_class
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        if m.get('DataPrecision') is not None:
            self.data_precision = m.get('DataPrecision')
        if m.get('DimDateClass') is not None:
            self.dim_date_class = m.get('DimDateClass')
        if m.get('FieldName') is not None:
            self.field_name = m.get('FieldName')
        if m.get('FieldType') is not None:
            self.field_type = m.get('FieldType')
        if m.get('GeoClass') is not None:
            self.geo_class = m.get('GeoClass')
        if m.get('TimeClass') is not None:
            self.time_class = m.get('TimeClass')
        if m.get('TypeClass') is not None:
            self.type_class = m.get('TypeClass')
        return self


class CreateDownloadDataJobResponseDataQuerySettingAstExpr(TeaModel):
    def __init__(self, expr=None, expr_type=None):
        self.expr = expr  # type: str
        self.expr_type = expr_type  # type: str

    def validate(self):
        self.validate_required(self.expr, 'expr')
        self.validate_required(self.expr_type, 'expr_type')

    def to_map(self):
        _map = super(CreateDownloadDataJobResponseDataQuerySettingAstExpr, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expr is not None:
            result['Expr'] = self.expr
        if self.expr_type is not None:
            result['ExprType'] = self.expr_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Expr') is not None:
            self.expr = m.get('Expr')
        if m.get('ExprType') is not None:
            self.expr_type = m.get('ExprType')
        return self


class CreateDownloadDataJobResponseDataQuerySettingSelectedHeaders(TeaModel):
    def __init__(self, alias=None, dim_date_class=None, field_name=None, field_type=None, geo_class=None,
                 time_class=None):
        self.alias = alias  # type: str
        self.dim_date_class = dim_date_class  # type: str
        self.field_name = field_name  # type: str
        self.field_type = field_type  # type: str
        self.geo_class = geo_class  # type: str
        self.time_class = time_class  # type: str

    def validate(self):
        self.validate_required(self.alias, 'alias')
        self.validate_required(self.dim_date_class, 'dim_date_class')
        self.validate_required(self.field_name, 'field_name')
        self.validate_required(self.field_type, 'field_type')
        self.validate_required(self.geo_class, 'geo_class')
        self.validate_required(self.time_class, 'time_class')

    def to_map(self):
        _map = super(CreateDownloadDataJobResponseDataQuerySettingSelectedHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias is not None:
            result['Alias'] = self.alias
        if self.dim_date_class is not None:
            result['DimDateClass'] = self.dim_date_class
        if self.field_name is not None:
            result['FieldName'] = self.field_name
        if self.field_type is not None:
            result['FieldType'] = self.field_type
        if self.geo_class is not None:
            result['GeoClass'] = self.geo_class
        if self.time_class is not None:
            result['TimeClass'] = self.time_class
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        if m.get('DimDateClass') is not None:
            self.dim_date_class = m.get('DimDateClass')
        if m.get('FieldName') is not None:
            self.field_name = m.get('FieldName')
        if m.get('FieldType') is not None:
            self.field_type = m.get('FieldType')
        if m.get('GeoClass') is not None:
            self.geo_class = m.get('GeoClass')
        if m.get('TimeClass') is not None:
            self.time_class = m.get('TimeClass')
        return self


class CreateDownloadDataJobResponseDataQuerySetting(TeaModel):
    def __init__(self, ast_expr=None, selected_headers=None):
        self.ast_expr = ast_expr  # type: list[CreateDownloadDataJobResponseDataQuerySettingAstExpr]
        self.selected_headers = selected_headers  # type: list[CreateDownloadDataJobResponseDataQuerySettingSelectedHeaders]

    def validate(self):
        self.validate_required(self.ast_expr, 'ast_expr')
        if self.ast_expr:
            for k in self.ast_expr:
                if k:
                    k.validate()
        self.validate_required(self.selected_headers, 'selected_headers')
        if self.selected_headers:
            for k in self.selected_headers:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateDownloadDataJobResponseDataQuerySetting, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AstExpr'] = []
        if self.ast_expr is not None:
            for k in self.ast_expr:
                result['AstExpr'].append(k.to_map() if k else None)
        result['SelectedHeaders'] = []
        if self.selected_headers is not None:
            for k in self.selected_headers:
                result['SelectedHeaders'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.ast_expr = []
        if m.get('AstExpr') is not None:
            for k in m.get('AstExpr'):
                temp_model = CreateDownloadDataJobResponseDataQuerySettingAstExpr()
                self.ast_expr.append(temp_model.from_map(k))
        self.selected_headers = []
        if m.get('SelectedHeaders') is not None:
            for k in m.get('SelectedHeaders'):
                temp_model = CreateDownloadDataJobResponseDataQuerySettingSelectedHeaders()
                self.selected_headers.append(temp_model.from_map(k))
        return self


class CreateDownloadDataJobResponseData(TeaModel):
    def __init__(self, async_execute=None, begin_time=None, csv_file_name=None, csv_url=None, dataset_id=None,
                 end_time=None, long_job_id=None, page_no=None, page_size=None, preview_size=None,
                 result_data_in_string=None, status=None, total_count=None, header=None, query_setting=None):
        self.async_execute = async_execute  # type: bool
        self.begin_time = begin_time  # type: long
        self.csv_file_name = csv_file_name  # type: str
        self.csv_url = csv_url  # type: str
        self.dataset_id = dataset_id  # type: str
        self.end_time = end_time  # type: long
        self.long_job_id = long_job_id  # type: str
        self.page_no = page_no  # type: int
        self.page_size = page_size  # type: int
        self.preview_size = preview_size  # type: int
        self.result_data_in_string = result_data_in_string  # type: str
        self.status = status  # type: int
        self.total_count = total_count  # type: long
        self.header = header  # type: list[CreateDownloadDataJobResponseDataHeader]
        self.query_setting = query_setting  # type: CreateDownloadDataJobResponseDataQuerySetting

    def validate(self):
        self.validate_required(self.async_execute, 'async_execute')
        self.validate_required(self.begin_time, 'begin_time')
        self.validate_required(self.csv_file_name, 'csv_file_name')
        self.validate_required(self.csv_url, 'csv_url')
        self.validate_required(self.dataset_id, 'dataset_id')
        self.validate_required(self.end_time, 'end_time')
        self.validate_required(self.long_job_id, 'long_job_id')
        self.validate_required(self.page_no, 'page_no')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.preview_size, 'preview_size')
        self.validate_required(self.result_data_in_string, 'result_data_in_string')
        self.validate_required(self.status, 'status')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.header, 'header')
        if self.header:
            for k in self.header:
                if k:
                    k.validate()
        self.validate_required(self.query_setting, 'query_setting')
        if self.query_setting:
            self.query_setting.validate()

    def to_map(self):
        _map = super(CreateDownloadDataJobResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.async_execute is not None:
            result['AsyncExecute'] = self.async_execute
        if self.begin_time is not None:
            result['BeginTime'] = self.begin_time
        if self.csv_file_name is not None:
            result['CsvFileName'] = self.csv_file_name
        if self.csv_url is not None:
            result['CsvUrl'] = self.csv_url
        if self.dataset_id is not None:
            result['DatasetId'] = self.dataset_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.long_job_id is not None:
            result['LongJobId'] = self.long_job_id
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.preview_size is not None:
            result['PreviewSize'] = self.preview_size
        if self.result_data_in_string is not None:
            result['ResultDataInString'] = self.result_data_in_string
        if self.status is not None:
            result['Status'] = self.status
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['Header'] = []
        if self.header is not None:
            for k in self.header:
                result['Header'].append(k.to_map() if k else None)
        if self.query_setting is not None:
            result['QuerySetting'] = self.query_setting.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AsyncExecute') is not None:
            self.async_execute = m.get('AsyncExecute')
        if m.get('BeginTime') is not None:
            self.begin_time = m.get('BeginTime')
        if m.get('CsvFileName') is not None:
            self.csv_file_name = m.get('CsvFileName')
        if m.get('CsvUrl') is not None:
            self.csv_url = m.get('CsvUrl')
        if m.get('DatasetId') is not None:
            self.dataset_id = m.get('DatasetId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('LongJobId') is not None:
            self.long_job_id = m.get('LongJobId')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PreviewSize') is not None:
            self.preview_size = m.get('PreviewSize')
        if m.get('ResultDataInString') is not None:
            self.result_data_in_string = m.get('ResultDataInString')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.header = []
        if m.get('Header') is not None:
            for k in m.get('Header'):
                temp_model = CreateDownloadDataJobResponseDataHeader()
                self.header.append(temp_model.from_map(k))
        if m.get('QuerySetting') is not None:
            temp_model = CreateDownloadDataJobResponseDataQuerySetting()
            self.query_setting = temp_model.from_map(m['QuerySetting'])
        return self


class CreateDownloadDataJobResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: CreateDownloadDataJobResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateDownloadDataJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = CreateDownloadDataJobResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateEdgeDriverRequest(TeaModel):
    def __init__(self, cpu_arch=None, driver_name=None, driver_protocol=None, iot_instance_id=None,
                 is_built_in=None, runtime=None):
        self.cpu_arch = cpu_arch  # type: str
        self.driver_name = driver_name  # type: str
        self.driver_protocol = driver_protocol  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.is_built_in = is_built_in  # type: bool
        self.runtime = runtime  # type: str

    def validate(self):
        self.validate_required(self.driver_name, 'driver_name')
        self.validate_required(self.driver_protocol, 'driver_protocol')
        self.validate_required(self.runtime, 'runtime')

    def to_map(self):
        _map = super(CreateEdgeDriverRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cpu_arch is not None:
            result['CpuArch'] = self.cpu_arch
        if self.driver_name is not None:
            result['DriverName'] = self.driver_name
        if self.driver_protocol is not None:
            result['DriverProtocol'] = self.driver_protocol
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.is_built_in is not None:
            result['IsBuiltIn'] = self.is_built_in
        if self.runtime is not None:
            result['Runtime'] = self.runtime
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CpuArch') is not None:
            self.cpu_arch = m.get('CpuArch')
        if m.get('DriverName') is not None:
            self.driver_name = m.get('DriverName')
        if m.get('DriverProtocol') is not None:
            self.driver_protocol = m.get('DriverProtocol')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('IsBuiltIn') is not None:
            self.is_built_in = m.get('IsBuiltIn')
        if m.get('Runtime') is not None:
            self.runtime = m.get('Runtime')
        return self


class CreateEdgeDriverResponse(TeaModel):
    def __init__(self, code=None, driver_id=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.driver_id = driver_id  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(CreateEdgeDriverResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateEdgeDriverVersionRequest(TeaModel):
    def __init__(self, argument=None, config_check_rule=None, container_config=None, description=None,
                 driver_config=None, driver_id=None, driver_version=None, edge_version=None, iot_instance_id=None,
                 source_config=None):
        self.argument = argument  # type: str
        self.config_check_rule = config_check_rule  # type: str
        self.container_config = container_config  # type: str
        self.description = description  # type: str
        self.driver_config = driver_config  # type: str
        self.driver_id = driver_id  # type: str
        self.driver_version = driver_version  # type: str
        self.edge_version = edge_version  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.source_config = source_config  # type: str

    def validate(self):
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.driver_version, 'driver_version')
        self.validate_required(self.edge_version, 'edge_version')

    def to_map(self):
        _map = super(CreateEdgeDriverVersionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.argument is not None:
            result['Argument'] = self.argument
        if self.config_check_rule is not None:
            result['ConfigCheckRule'] = self.config_check_rule
        if self.container_config is not None:
            result['ContainerConfig'] = self.container_config
        if self.description is not None:
            result['Description'] = self.description
        if self.driver_config is not None:
            result['DriverConfig'] = self.driver_config
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        if self.edge_version is not None:
            result['EdgeVersion'] = self.edge_version
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.source_config is not None:
            result['SourceConfig'] = self.source_config
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Argument') is not None:
            self.argument = m.get('Argument')
        if m.get('ConfigCheckRule') is not None:
            self.config_check_rule = m.get('ConfigCheckRule')
        if m.get('ContainerConfig') is not None:
            self.container_config = m.get('ContainerConfig')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DriverConfig') is not None:
            self.driver_config = m.get('DriverConfig')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        if m.get('EdgeVersion') is not None:
            self.edge_version = m.get('EdgeVersion')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('SourceConfig') is not None:
            self.source_config = m.get('SourceConfig')
        return self


class CreateEdgeDriverVersionResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(CreateEdgeDriverVersionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateEdgeInstanceRequest(TeaModel):
    def __init__(self, iot_instance_id=None, name=None, spec=None, tags=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.name = name  # type: str
        self.spec = spec  # type: int
        self.tags = tags  # type: str

    def validate(self):
        self.validate_required(self.name, 'name')

    def to_map(self):
        _map = super(CreateEdgeInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.spec is not None:
            result['Spec'] = self.spec
        if self.tags is not None:
            result['Tags'] = self.tags
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        return self


class CreateEdgeInstanceResponse(TeaModel):
    def __init__(self, code=None, error_message=None, instance_id=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.instance_id = instance_id  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(CreateEdgeInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateEdgeInstanceChannelRequestConfigs(TeaModel):
    def __init__(self, content=None, format=None, key=None):
        self.content = content  # type: str
        self.format = format  # type: str
        self.key = key  # type: str

    def validate(self):
        self.validate_required(self.content, 'content')
        self.validate_required(self.format, 'format')

    def to_map(self):
        _map = super(CreateEdgeInstanceChannelRequestConfigs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.format is not None:
            result['Format'] = self.format
        if self.key is not None:
            result['Key'] = self.key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        return self


class CreateEdgeInstanceChannelRequest(TeaModel):
    def __init__(self, channel_name=None, configs=None, driver_id=None, instance_id=None, iot_instance_id=None):
        self.channel_name = channel_name  # type: str
        self.configs = configs  # type: list[CreateEdgeInstanceChannelRequestConfigs]
        self.driver_id = driver_id  # type: str
        self.instance_id = instance_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.channel_name, 'channel_name')
        self.validate_required(self.configs, 'configs')
        if self.configs:
            for k in self.configs:
                if k:
                    k.validate()
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        _map = super(CreateEdgeInstanceChannelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        result['Configs'] = []
        if self.configs is not None:
            for k in self.configs:
                result['Configs'].append(k.to_map() if k else None)
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        self.configs = []
        if m.get('Configs') is not None:
            for k in m.get('Configs'):
                temp_model = CreateEdgeInstanceChannelRequestConfigs()
                self.configs.append(temp_model.from_map(k))
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class CreateEdgeInstanceChannelResponse(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.data, 'data')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(CreateEdgeInstanceChannelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateEdgeInstanceDeploymentRequest(TeaModel):
    def __init__(self, instance_id=None, iot_instance_id=None, type=None):
        self.instance_id = instance_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.type = type  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.type, 'type')

    def to_map(self):
        _map = super(CreateEdgeInstanceDeploymentRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateEdgeInstanceDeploymentResponse(TeaModel):
    def __init__(self, code=None, deployment_id=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.deployment_id = deployment_id  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.deployment_id, 'deployment_id')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(CreateEdgeInstanceDeploymentResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.deployment_id is not None:
            result['DeploymentId'] = self.deployment_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('DeploymentId') is not None:
            self.deployment_id = m.get('DeploymentId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateEdgeInstanceMessageRoutingRequest(TeaModel):
    def __init__(self, instance_id=None, iot_instance_id=None, name=None, source_data=None, source_type=None,
                 target_data=None, target_iot_hub_qos=None, target_type=None, topic_filter=None):
        self.instance_id = instance_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.name = name  # type: str
        self.source_data = source_data  # type: str
        self.source_type = source_type  # type: str
        self.target_data = target_data  # type: str
        self.target_iot_hub_qos = target_iot_hub_qos  # type: int
        self.target_type = target_type  # type: str
        self.topic_filter = topic_filter  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.source_type, 'source_type')
        self.validate_required(self.target_type, 'target_type')

    def to_map(self):
        _map = super(CreateEdgeInstanceMessageRoutingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.source_data is not None:
            result['SourceData'] = self.source_data
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.target_data is not None:
            result['TargetData'] = self.target_data
        if self.target_iot_hub_qos is not None:
            result['TargetIotHubQos'] = self.target_iot_hub_qos
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        if self.topic_filter is not None:
            result['TopicFilter'] = self.topic_filter
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SourceData') is not None:
            self.source_data = m.get('SourceData')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('TargetData') is not None:
            self.target_data = m.get('TargetData')
        if m.get('TargetIotHubQos') is not None:
            self.target_iot_hub_qos = m.get('TargetIotHubQos')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        if m.get('TopicFilter') is not None:
            self.topic_filter = m.get('TopicFilter')
        return self


class CreateEdgeInstanceMessageRoutingResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, route_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.route_id = route_id  # type: long
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.route_id, 'route_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(CreateEdgeInstanceMessageRoutingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.route_id is not None:
            result['RouteId'] = self.route_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RouteId') is not None:
            self.route_id = m.get('RouteId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateEdgeOssPreSignedAddressRequest(TeaModel):
    def __init__(self, file_name=None, instance_id=None, iot_instance_id=None, resource_id=None,
                 resource_version=None, type=None):
        self.file_name = file_name  # type: str
        self.instance_id = instance_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.resource_id = resource_id  # type: str
        self.resource_version = resource_version  # type: str
        self.type = type  # type: str

    def validate(self):
        self.validate_required(self.file_name, 'file_name')
        self.validate_required(self.resource_id, 'resource_id')
        self.validate_required(self.resource_version, 'resource_version')
        self.validate_required(self.type, 'type')

    def to_map(self):
        _map = super(CreateEdgeOssPreSignedAddressRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_version is not None:
            result['ResourceVersion'] = self.resource_version
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceVersion') is not None:
            self.resource_version = m.get('ResourceVersion')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateEdgeOssPreSignedAddressResponseData(TeaModel):
    def __init__(self, oss_address=None, oss_pre_signed_address=None):
        self.oss_address = oss_address  # type: str
        self.oss_pre_signed_address = oss_pre_signed_address  # type: str

    def validate(self):
        self.validate_required(self.oss_address, 'oss_address')
        self.validate_required(self.oss_pre_signed_address, 'oss_pre_signed_address')

    def to_map(self):
        _map = super(CreateEdgeOssPreSignedAddressResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.oss_address is not None:
            result['OssAddress'] = self.oss_address
        if self.oss_pre_signed_address is not None:
            result['OssPreSignedAddress'] = self.oss_pre_signed_address
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OssAddress') is not None:
            self.oss_address = m.get('OssAddress')
        if m.get('OssPreSignedAddress') is not None:
            self.oss_pre_signed_address = m.get('OssPreSignedAddress')
        return self


class CreateEdgeOssPreSignedAddressResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: CreateEdgeOssPreSignedAddressResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateEdgeOssPreSignedAddressResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = CreateEdgeOssPreSignedAddressResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateJobRequest(TeaModel):
    def __init__(self, description=None, iot_instance_id=None, job_document=None, job_file=None, job_name=None,
                 rollout_config=None, scheduled_time=None, target_config=None, timeout_config=None, type=None):
        self.description = description  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.job_document = job_document  # type: str
        self.job_file = job_file  # type: dict[str, any]
        self.job_name = job_name  # type: str
        self.rollout_config = rollout_config  # type: dict[str, any]
        self.scheduled_time = scheduled_time  # type: long
        self.target_config = target_config  # type: dict[str, any]
        self.timeout_config = timeout_config  # type: dict[str, any]
        self.type = type  # type: str

    def validate(self):
        self.validate_required(self.job_document, 'job_document')
        self.validate_required(self.job_name, 'job_name')
        self.validate_required(self.target_config, 'target_config')
        self.validate_required(self.type, 'type')

    def to_map(self):
        _map = super(CreateJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_document is not None:
            result['JobDocument'] = self.job_document
        if self.job_file is not None:
            result['JobFile'] = self.job_file
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.rollout_config is not None:
            result['RolloutConfig'] = self.rollout_config
        if self.scheduled_time is not None:
            result['ScheduledTime'] = self.scheduled_time
        if self.target_config is not None:
            result['TargetConfig'] = self.target_config
        if self.timeout_config is not None:
            result['TimeoutConfig'] = self.timeout_config
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobDocument') is not None:
            self.job_document = m.get('JobDocument')
        if m.get('JobFile') is not None:
            self.job_file = m.get('JobFile')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('RolloutConfig') is not None:
            self.rollout_config = m.get('RolloutConfig')
        if m.get('ScheduledTime') is not None:
            self.scheduled_time = m.get('ScheduledTime')
        if m.get('TargetConfig') is not None:
            self.target_config = m.get('TargetConfig')
        if m.get('TimeoutConfig') is not None:
            self.timeout_config = m.get('TimeoutConfig')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateJobShrinkRequest(TeaModel):
    def __init__(self, description=None, iot_instance_id=None, job_document=None, job_file_shrink=None,
                 job_name=None, rollout_config_shrink=None, scheduled_time=None, target_config_shrink=None,
                 timeout_config_shrink=None, type=None):
        self.description = description  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.job_document = job_document  # type: str
        self.job_file_shrink = job_file_shrink  # type: str
        self.job_name = job_name  # type: str
        self.rollout_config_shrink = rollout_config_shrink  # type: str
        self.scheduled_time = scheduled_time  # type: long
        self.target_config_shrink = target_config_shrink  # type: str
        self.timeout_config_shrink = timeout_config_shrink  # type: str
        self.type = type  # type: str

    def validate(self):
        self.validate_required(self.job_document, 'job_document')
        self.validate_required(self.job_name, 'job_name')
        self.validate_required(self.target_config_shrink, 'target_config_shrink')
        self.validate_required(self.type, 'type')

    def to_map(self):
        _map = super(CreateJobShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_document is not None:
            result['JobDocument'] = self.job_document
        if self.job_file_shrink is not None:
            result['JobFile'] = self.job_file_shrink
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.rollout_config_shrink is not None:
            result['RolloutConfig'] = self.rollout_config_shrink
        if self.scheduled_time is not None:
            result['ScheduledTime'] = self.scheduled_time
        if self.target_config_shrink is not None:
            result['TargetConfig'] = self.target_config_shrink
        if self.timeout_config_shrink is not None:
            result['TimeoutConfig'] = self.timeout_config_shrink
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobDocument') is not None:
            self.job_document = m.get('JobDocument')
        if m.get('JobFile') is not None:
            self.job_file_shrink = m.get('JobFile')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('RolloutConfig') is not None:
            self.rollout_config_shrink = m.get('RolloutConfig')
        if m.get('ScheduledTime') is not None:
            self.scheduled_time = m.get('ScheduledTime')
        if m.get('TargetConfig') is not None:
            self.target_config_shrink = m.get('TargetConfig')
        if m.get('TimeoutConfig') is not None:
            self.timeout_config_shrink = m.get('TimeoutConfig')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateJobResponse(TeaModel):
    def __init__(self, code=None, error_message=None, job_id=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.job_id = job_id  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.job_id, 'job_id')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(CreateJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateLoRaNodesTaskRequestDeviceInfo(TeaModel):
    def __init__(self, dev_eui=None, pin_code=None):
        self.dev_eui = dev_eui  # type: str
        self.pin_code = pin_code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateLoRaNodesTaskRequestDeviceInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dev_eui is not None:
            result['DevEui'] = self.dev_eui
        if self.pin_code is not None:
            result['PinCode'] = self.pin_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DevEui') is not None:
            self.dev_eui = m.get('DevEui')
        if m.get('PinCode') is not None:
            self.pin_code = m.get('PinCode')
        return self


class CreateLoRaNodesTaskRequest(TeaModel):
    def __init__(self, device_info=None, iot_instance_id=None, product_key=None):
        self.device_info = device_info  # type: list[CreateLoRaNodesTaskRequestDeviceInfo]
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        self.validate_required(self.device_info, 'device_info')
        if self.device_info:
            for k in self.device_info:
                if k:
                    k.validate()
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        _map = super(CreateLoRaNodesTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DeviceInfo'] = []
        if self.device_info is not None:
            for k in self.device_info:
                result['DeviceInfo'].append(k.to_map() if k else None)
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.device_info = []
        if m.get('DeviceInfo') is not None:
            for k in m.get('DeviceInfo'):
                temp_model = CreateLoRaNodesTaskRequestDeviceInfo()
                self.device_info.append(temp_model.from_map(k))
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class CreateLoRaNodesTaskResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, task_id=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.task_id = task_id  # type: str

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.task_id, 'task_id')

    def to_map(self):
        _map = super(CreateLoRaNodesTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CreateOTADynamicUpgradeJobRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        _map = super(CreateOTADynamicUpgradeJobRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateOTADynamicUpgradeJobRequest(TeaModel):
    def __init__(self, download_protocol=None, dynamic_mode=None, firmware_id=None, group_id=None, group_type=None,
                 iot_instance_id=None, maximum_per_minute=None, multi_module_mode=None, need_confirm=None, need_push=None,
                 overwrite_mode=None, product_key=None, retry_count=None, retry_interval=None, src_version=None, tag=None,
                 timeout_in_minutes=None):
        self.download_protocol = download_protocol  # type: str
        self.dynamic_mode = dynamic_mode  # type: int
        self.firmware_id = firmware_id  # type: str
        self.group_id = group_id  # type: str
        self.group_type = group_type  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.maximum_per_minute = maximum_per_minute  # type: int
        self.multi_module_mode = multi_module_mode  # type: bool
        self.need_confirm = need_confirm  # type: bool
        self.need_push = need_push  # type: bool
        self.overwrite_mode = overwrite_mode  # type: int
        self.product_key = product_key  # type: str
        self.retry_count = retry_count  # type: int
        self.retry_interval = retry_interval  # type: int
        self.src_version = src_version  # type: list[str]
        self.tag = tag  # type: list[CreateOTADynamicUpgradeJobRequestTag]
        self.timeout_in_minutes = timeout_in_minutes  # type: int

    def validate(self):
        self.validate_required(self.firmware_id, 'firmware_id')
        self.validate_required(self.product_key, 'product_key')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateOTADynamicUpgradeJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.download_protocol is not None:
            result['DownloadProtocol'] = self.download_protocol
        if self.dynamic_mode is not None:
            result['DynamicMode'] = self.dynamic_mode
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_type is not None:
            result['GroupType'] = self.group_type
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.maximum_per_minute is not None:
            result['MaximumPerMinute'] = self.maximum_per_minute
        if self.multi_module_mode is not None:
            result['MultiModuleMode'] = self.multi_module_mode
        if self.need_confirm is not None:
            result['NeedConfirm'] = self.need_confirm
        if self.need_push is not None:
            result['NeedPush'] = self.need_push
        if self.overwrite_mode is not None:
            result['OverwriteMode'] = self.overwrite_mode
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.retry_count is not None:
            result['RetryCount'] = self.retry_count
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.src_version is not None:
            result['SrcVersion'] = self.src_version
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.timeout_in_minutes is not None:
            result['TimeoutInMinutes'] = self.timeout_in_minutes
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DownloadProtocol') is not None:
            self.download_protocol = m.get('DownloadProtocol')
        if m.get('DynamicMode') is not None:
            self.dynamic_mode = m.get('DynamicMode')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupType') is not None:
            self.group_type = m.get('GroupType')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('MaximumPerMinute') is not None:
            self.maximum_per_minute = m.get('MaximumPerMinute')
        if m.get('MultiModuleMode') is not None:
            self.multi_module_mode = m.get('MultiModuleMode')
        if m.get('NeedConfirm') is not None:
            self.need_confirm = m.get('NeedConfirm')
        if m.get('NeedPush') is not None:
            self.need_push = m.get('NeedPush')
        if m.get('OverwriteMode') is not None:
            self.overwrite_mode = m.get('OverwriteMode')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('RetryCount') is not None:
            self.retry_count = m.get('RetryCount')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('SrcVersion') is not None:
            self.src_version = m.get('SrcVersion')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateOTADynamicUpgradeJobRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('TimeoutInMinutes') is not None:
            self.timeout_in_minutes = m.get('TimeoutInMinutes')
        return self


class CreateOTADynamicUpgradeJobResponseData(TeaModel):
    def __init__(self, job_id=None, utc_create=None):
        self.job_id = job_id  # type: str
        self.utc_create = utc_create  # type: str

    def validate(self):
        self.validate_required(self.job_id, 'job_id')
        self.validate_required(self.utc_create, 'utc_create')

    def to_map(self):
        _map = super(CreateOTADynamicUpgradeJobResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class CreateOTADynamicUpgradeJobResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: CreateOTADynamicUpgradeJobResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateOTADynamicUpgradeJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = CreateOTADynamicUpgradeJobResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateOTAFirmwareRequestMultiFiles(TeaModel):
    def __init__(self, file_md_5=None, name=None, sign_value=None, size=None, url=None):
        self.file_md_5 = file_md_5  # type: str
        self.name = name  # type: str
        self.sign_value = sign_value  # type: str
        self.size = size  # type: int
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOTAFirmwareRequestMultiFiles, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_md_5 is not None:
            result['FileMd5'] = self.file_md_5
        if self.name is not None:
            result['Name'] = self.name
        if self.sign_value is not None:
            result['SignValue'] = self.sign_value
        if self.size is not None:
            result['Size'] = self.size
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileMd5') is not None:
            self.file_md_5 = m.get('FileMd5')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SignValue') is not None:
            self.sign_value = m.get('SignValue')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class CreateOTAFirmwareRequest(TeaModel):
    def __init__(self, dest_version=None, firmware_desc=None, firmware_name=None, firmware_sign=None,
                 firmware_size=None, firmware_url=None, iot_instance_id=None, module_name=None, multi_files=None,
                 need_to_verify=None, product_key=None, sign_method=None, src_version=None, type=None, udi=None):
        self.dest_version = dest_version  # type: str
        self.firmware_desc = firmware_desc  # type: str
        self.firmware_name = firmware_name  # type: str
        self.firmware_sign = firmware_sign  # type: str
        self.firmware_size = firmware_size  # type: int
        self.firmware_url = firmware_url  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.module_name = module_name  # type: str
        self.multi_files = multi_files  # type: list[CreateOTAFirmwareRequestMultiFiles]
        self.need_to_verify = need_to_verify  # type: bool
        self.product_key = product_key  # type: str
        self.sign_method = sign_method  # type: str
        self.src_version = src_version  # type: str
        self.type = type  # type: int
        self.udi = udi  # type: str

    def validate(self):
        self.validate_required(self.dest_version, 'dest_version')
        self.validate_required(self.firmware_name, 'firmware_name')
        if self.multi_files:
            for k in self.multi_files:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateOTAFirmwareRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dest_version is not None:
            result['DestVersion'] = self.dest_version
        if self.firmware_desc is not None:
            result['FirmwareDesc'] = self.firmware_desc
        if self.firmware_name is not None:
            result['FirmwareName'] = self.firmware_name
        if self.firmware_sign is not None:
            result['FirmwareSign'] = self.firmware_sign
        if self.firmware_size is not None:
            result['FirmwareSize'] = self.firmware_size
        if self.firmware_url is not None:
            result['FirmwareUrl'] = self.firmware_url
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        result['MultiFiles'] = []
        if self.multi_files is not None:
            for k in self.multi_files:
                result['MultiFiles'].append(k.to_map() if k else None)
        if self.need_to_verify is not None:
            result['NeedToVerify'] = self.need_to_verify
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.sign_method is not None:
            result['SignMethod'] = self.sign_method
        if self.src_version is not None:
            result['SrcVersion'] = self.src_version
        if self.type is not None:
            result['Type'] = self.type
        if self.udi is not None:
            result['Udi'] = self.udi
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DestVersion') is not None:
            self.dest_version = m.get('DestVersion')
        if m.get('FirmwareDesc') is not None:
            self.firmware_desc = m.get('FirmwareDesc')
        if m.get('FirmwareName') is not None:
            self.firmware_name = m.get('FirmwareName')
        if m.get('FirmwareSign') is not None:
            self.firmware_sign = m.get('FirmwareSign')
        if m.get('FirmwareSize') is not None:
            self.firmware_size = m.get('FirmwareSize')
        if m.get('FirmwareUrl') is not None:
            self.firmware_url = m.get('FirmwareUrl')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        self.multi_files = []
        if m.get('MultiFiles') is not None:
            for k in m.get('MultiFiles'):
                temp_model = CreateOTAFirmwareRequestMultiFiles()
                self.multi_files.append(temp_model.from_map(k))
        if m.get('NeedToVerify') is not None:
            self.need_to_verify = m.get('NeedToVerify')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('SignMethod') is not None:
            self.sign_method = m.get('SignMethod')
        if m.get('SrcVersion') is not None:
            self.src_version = m.get('SrcVersion')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Udi') is not None:
            self.udi = m.get('Udi')
        return self


class CreateOTAFirmwareResponseData(TeaModel):
    def __init__(self, firmware_id=None, utc_create=None):
        self.firmware_id = firmware_id  # type: str
        self.utc_create = utc_create  # type: str

    def validate(self):
        self.validate_required(self.firmware_id, 'firmware_id')
        self.validate_required(self.utc_create, 'utc_create')

    def to_map(self):
        _map = super(CreateOTAFirmwareResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class CreateOTAFirmwareResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: CreateOTAFirmwareResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateOTAFirmwareResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = CreateOTAFirmwareResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateOTAModuleRequest(TeaModel):
    def __init__(self, alias_name=None, desc=None, iot_instance_id=None, module_name=None, product_key=None):
        self.alias_name = alias_name  # type: str
        self.desc = desc  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.module_name = module_name  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        self.validate_required(self.module_name, 'module_name')
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        _map = super(CreateOTAModuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class CreateOTAModuleResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(CreateOTAModuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateOTAStaticUpgradeJobRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        _map = super(CreateOTAStaticUpgradeJobRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateOTAStaticUpgradeJobRequest(TeaModel):
    def __init__(self, dn_list_file_url=None, download_protocol=None, firmware_id=None, gray_percent=None,
                 group_id=None, group_type=None, iot_instance_id=None, maximum_per_minute=None, multi_module_mode=None,
                 need_confirm=None, need_push=None, overwrite_mode=None, product_key=None, retry_count=None, retry_interval=None,
                 schedule_finish_time=None, schedule_time=None, src_version=None, tag=None, target_device_name=None,
                 target_selection=None, timeout_in_minutes=None):
        self.dn_list_file_url = dn_list_file_url  # type: str
        self.download_protocol = download_protocol  # type: str
        self.firmware_id = firmware_id  # type: str
        self.gray_percent = gray_percent  # type: str
        self.group_id = group_id  # type: str
        self.group_type = group_type  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.maximum_per_minute = maximum_per_minute  # type: int
        self.multi_module_mode = multi_module_mode  # type: bool
        self.need_confirm = need_confirm  # type: bool
        self.need_push = need_push  # type: bool
        self.overwrite_mode = overwrite_mode  # type: int
        self.product_key = product_key  # type: str
        self.retry_count = retry_count  # type: int
        self.retry_interval = retry_interval  # type: int
        self.schedule_finish_time = schedule_finish_time  # type: long
        self.schedule_time = schedule_time  # type: long
        self.src_version = src_version  # type: list[str]
        self.tag = tag  # type: list[CreateOTAStaticUpgradeJobRequestTag]
        self.target_device_name = target_device_name  # type: list[str]
        self.target_selection = target_selection  # type: str
        self.timeout_in_minutes = timeout_in_minutes  # type: int

    def validate(self):
        self.validate_required(self.firmware_id, 'firmware_id')
        self.validate_required(self.product_key, 'product_key')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()
        self.validate_required(self.target_selection, 'target_selection')

    def to_map(self):
        _map = super(CreateOTAStaticUpgradeJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dn_list_file_url is not None:
            result['DnListFileUrl'] = self.dn_list_file_url
        if self.download_protocol is not None:
            result['DownloadProtocol'] = self.download_protocol
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.gray_percent is not None:
            result['GrayPercent'] = self.gray_percent
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_type is not None:
            result['GroupType'] = self.group_type
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.maximum_per_minute is not None:
            result['MaximumPerMinute'] = self.maximum_per_minute
        if self.multi_module_mode is not None:
            result['MultiModuleMode'] = self.multi_module_mode
        if self.need_confirm is not None:
            result['NeedConfirm'] = self.need_confirm
        if self.need_push is not None:
            result['NeedPush'] = self.need_push
        if self.overwrite_mode is not None:
            result['OverwriteMode'] = self.overwrite_mode
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.retry_count is not None:
            result['RetryCount'] = self.retry_count
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.schedule_finish_time is not None:
            result['ScheduleFinishTime'] = self.schedule_finish_time
        if self.schedule_time is not None:
            result['ScheduleTime'] = self.schedule_time
        if self.src_version is not None:
            result['SrcVersion'] = self.src_version
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.target_device_name is not None:
            result['TargetDeviceName'] = self.target_device_name
        if self.target_selection is not None:
            result['TargetSelection'] = self.target_selection
        if self.timeout_in_minutes is not None:
            result['TimeoutInMinutes'] = self.timeout_in_minutes
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DnListFileUrl') is not None:
            self.dn_list_file_url = m.get('DnListFileUrl')
        if m.get('DownloadProtocol') is not None:
            self.download_protocol = m.get('DownloadProtocol')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('GrayPercent') is not None:
            self.gray_percent = m.get('GrayPercent')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupType') is not None:
            self.group_type = m.get('GroupType')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('MaximumPerMinute') is not None:
            self.maximum_per_minute = m.get('MaximumPerMinute')
        if m.get('MultiModuleMode') is not None:
            self.multi_module_mode = m.get('MultiModuleMode')
        if m.get('NeedConfirm') is not None:
            self.need_confirm = m.get('NeedConfirm')
        if m.get('NeedPush') is not None:
            self.need_push = m.get('NeedPush')
        if m.get('OverwriteMode') is not None:
            self.overwrite_mode = m.get('OverwriteMode')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('RetryCount') is not None:
            self.retry_count = m.get('RetryCount')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('ScheduleFinishTime') is not None:
            self.schedule_finish_time = m.get('ScheduleFinishTime')
        if m.get('ScheduleTime') is not None:
            self.schedule_time = m.get('ScheduleTime')
        if m.get('SrcVersion') is not None:
            self.src_version = m.get('SrcVersion')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateOTAStaticUpgradeJobRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('TargetDeviceName') is not None:
            self.target_device_name = m.get('TargetDeviceName')
        if m.get('TargetSelection') is not None:
            self.target_selection = m.get('TargetSelection')
        if m.get('TimeoutInMinutes') is not None:
            self.timeout_in_minutes = m.get('TimeoutInMinutes')
        return self


class CreateOTAStaticUpgradeJobResponseData(TeaModel):
    def __init__(self, job_id=None, utc_create=None):
        self.job_id = job_id  # type: str
        self.utc_create = utc_create  # type: str

    def validate(self):
        self.validate_required(self.job_id, 'job_id')
        self.validate_required(self.utc_create, 'utc_create')

    def to_map(self):
        _map = super(CreateOTAStaticUpgradeJobResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class CreateOTAStaticUpgradeJobResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: CreateOTAStaticUpgradeJobResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateOTAStaticUpgradeJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = CreateOTAStaticUpgradeJobResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateOTAVerifyJobRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        _map = super(CreateOTAVerifyJobRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateOTAVerifyJobRequest(TeaModel):
    def __init__(self, download_protocol=None, firmware_id=None, iot_instance_id=None, need_confirm=None,
                 need_push=None, product_key=None, tag=None, target_device_name=None, timeout_in_minutes=None):
        self.download_protocol = download_protocol  # type: str
        self.firmware_id = firmware_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.need_confirm = need_confirm  # type: bool
        self.need_push = need_push  # type: bool
        self.product_key = product_key  # type: str
        self.tag = tag  # type: list[CreateOTAVerifyJobRequestTag]
        self.target_device_name = target_device_name  # type: list[str]
        self.timeout_in_minutes = timeout_in_minutes  # type: int

    def validate(self):
        self.validate_required(self.firmware_id, 'firmware_id')
        self.validate_required(self.product_key, 'product_key')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()
        self.validate_required(self.target_device_name, 'target_device_name')

    def to_map(self):
        _map = super(CreateOTAVerifyJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.download_protocol is not None:
            result['DownloadProtocol'] = self.download_protocol
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.need_confirm is not None:
            result['NeedConfirm'] = self.need_confirm
        if self.need_push is not None:
            result['NeedPush'] = self.need_push
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.target_device_name is not None:
            result['TargetDeviceName'] = self.target_device_name
        if self.timeout_in_minutes is not None:
            result['TimeoutInMinutes'] = self.timeout_in_minutes
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DownloadProtocol') is not None:
            self.download_protocol = m.get('DownloadProtocol')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('NeedConfirm') is not None:
            self.need_confirm = m.get('NeedConfirm')
        if m.get('NeedPush') is not None:
            self.need_push = m.get('NeedPush')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateOTAVerifyJobRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('TargetDeviceName') is not None:
            self.target_device_name = m.get('TargetDeviceName')
        if m.get('TimeoutInMinutes') is not None:
            self.timeout_in_minutes = m.get('TimeoutInMinutes')
        return self


class CreateOTAVerifyJobResponseData(TeaModel):
    def __init__(self, job_id=None, utc_create=None):
        self.job_id = job_id  # type: str
        self.utc_create = utc_create  # type: str

    def validate(self):
        self.validate_required(self.job_id, 'job_id')
        self.validate_required(self.utc_create, 'utc_create')

    def to_map(self):
        _map = super(CreateOTAVerifyJobResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class CreateOTAVerifyJobResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: CreateOTAVerifyJobResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateOTAVerifyJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = CreateOTAVerifyJobResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateParserRequest(TeaModel):
    def __init__(self, description=None, iot_instance_id=None, name=None):
        self.description = description  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.name = name  # type: str

    def validate(self):
        self.validate_required(self.name, 'name')

    def to_map(self):
        _map = super(CreateParserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateParserResponse(TeaModel):
    def __init__(self, code=None, error_message=None, parser_id=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.parser_id = parser_id  # type: long
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.parser_id, 'parser_id')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(CreateParserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.parser_id is not None:
            result['ParserId'] = self.parser_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ParserId') is not None:
            self.parser_id = m.get('ParserId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateParserDataSourceRequest(TeaModel):
    def __init__(self, description=None, iot_instance_id=None, name=None):
        self.description = description  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.name = name  # type: str

    def validate(self):
        self.validate_required(self.name, 'name')

    def to_map(self):
        _map = super(CreateParserDataSourceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateParserDataSourceResponseDataSource(TeaModel):
    def __init__(self, data_source_id=None, description=None, name=None, utc_created=None):
        self.data_source_id = data_source_id  # type: long
        self.description = description  # type: str
        self.name = name  # type: str
        self.utc_created = utc_created  # type: str

    def validate(self):
        self.validate_required(self.data_source_id, 'data_source_id')
        self.validate_required(self.description, 'description')
        self.validate_required(self.name, 'name')
        self.validate_required(self.utc_created, 'utc_created')

    def to_map(self):
        _map = super(CreateParserDataSourceResponseDataSource, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.utc_created is not None:
            result['UtcCreated'] = self.utc_created
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('UtcCreated') is not None:
            self.utc_created = m.get('UtcCreated')
        return self


class CreateParserDataSourceResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data_source=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data_source = data_source  # type: CreateParserDataSourceResponseDataSource

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data_source, 'data_source')
        if self.data_source:
            self.data_source.validate()

    def to_map(self):
        _map = super(CreateParserDataSourceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data_source is not None:
            result['DataSource'] = self.data_source.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('DataSource') is not None:
            temp_model = CreateParserDataSourceResponseDataSource()
            self.data_source = temp_model.from_map(m['DataSource'])
        return self


class CreateProductRequest(TeaModel):
    def __init__(self, aliyun_commodity_code=None, auth_type=None, category_key=None, data_format=None,
                 description=None, id_2=None, iot_instance_id=None, join_permission_id=None, net_type=None, node_type=None,
                 product_name=None, protocol_type=None, publish_auto=None, resource_group_id=None, validate_type=None):
        self.aliyun_commodity_code = aliyun_commodity_code  # type: str
        self.auth_type = auth_type  # type: str
        self.category_key = category_key  # type: str
        self.data_format = data_format  # type: int
        self.description = description  # type: str
        self.id_2 = id_2  # type: bool
        self.iot_instance_id = iot_instance_id  # type: str
        self.join_permission_id = join_permission_id  # type: str
        self.net_type = net_type  # type: str
        self.node_type = node_type  # type: int
        self.product_name = product_name  # type: str
        self.protocol_type = protocol_type  # type: str
        self.publish_auto = publish_auto  # type: bool
        self.resource_group_id = resource_group_id  # type: str
        self.validate_type = validate_type  # type: int

    def validate(self):
        self.validate_required(self.node_type, 'node_type')
        self.validate_required(self.product_name, 'product_name')

    def to_map(self):
        _map = super(CreateProductRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aliyun_commodity_code is not None:
            result['AliyunCommodityCode'] = self.aliyun_commodity_code
        if self.auth_type is not None:
            result['AuthType'] = self.auth_type
        if self.category_key is not None:
            result['CategoryKey'] = self.category_key
        if self.data_format is not None:
            result['DataFormat'] = self.data_format
        if self.description is not None:
            result['Description'] = self.description
        if self.id_2 is not None:
            result['Id2'] = self.id_2
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.join_permission_id is not None:
            result['JoinPermissionId'] = self.join_permission_id
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.publish_auto is not None:
            result['PublishAuto'] = self.publish_auto
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.validate_type is not None:
            result['ValidateType'] = self.validate_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AliyunCommodityCode') is not None:
            self.aliyun_commodity_code = m.get('AliyunCommodityCode')
        if m.get('AuthType') is not None:
            self.auth_type = m.get('AuthType')
        if m.get('CategoryKey') is not None:
            self.category_key = m.get('CategoryKey')
        if m.get('DataFormat') is not None:
            self.data_format = m.get('DataFormat')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Id2') is not None:
            self.id_2 = m.get('Id2')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JoinPermissionId') is not None:
            self.join_permission_id = m.get('JoinPermissionId')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('PublishAuto') is not None:
            self.publish_auto = m.get('PublishAuto')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ValidateType') is not None:
            self.validate_type = m.get('ValidateType')
        return self


class CreateProductResponseData(TeaModel):
    def __init__(self, aliyun_commodity_code=None, auth_type=None, data_format=None, description=None, id_2=None,
                 node_type=None, product_key=None, product_name=None, product_secret=None, protocol_type=None):
        self.aliyun_commodity_code = aliyun_commodity_code  # type: str
        self.auth_type = auth_type  # type: str
        self.data_format = data_format  # type: int
        self.description = description  # type: str
        self.id_2 = id_2  # type: bool
        self.node_type = node_type  # type: int
        self.product_key = product_key  # type: str
        self.product_name = product_name  # type: str
        self.product_secret = product_secret  # type: str
        self.protocol_type = protocol_type  # type: str

    def validate(self):
        self.validate_required(self.aliyun_commodity_code, 'aliyun_commodity_code')
        self.validate_required(self.auth_type, 'auth_type')
        self.validate_required(self.data_format, 'data_format')
        self.validate_required(self.description, 'description')
        self.validate_required(self.id_2, 'id_2')
        self.validate_required(self.node_type, 'node_type')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.product_name, 'product_name')
        self.validate_required(self.product_secret, 'product_secret')
        self.validate_required(self.protocol_type, 'protocol_type')

    def to_map(self):
        _map = super(CreateProductResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aliyun_commodity_code is not None:
            result['AliyunCommodityCode'] = self.aliyun_commodity_code
        if self.auth_type is not None:
            result['AuthType'] = self.auth_type
        if self.data_format is not None:
            result['DataFormat'] = self.data_format
        if self.description is not None:
            result['Description'] = self.description
        if self.id_2 is not None:
            result['Id2'] = self.id_2
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.product_secret is not None:
            result['ProductSecret'] = self.product_secret
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AliyunCommodityCode') is not None:
            self.aliyun_commodity_code = m.get('AliyunCommodityCode')
        if m.get('AuthType') is not None:
            self.auth_type = m.get('AuthType')
        if m.get('DataFormat') is not None:
            self.data_format = m.get('DataFormat')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Id2') is not None:
            self.id_2 = m.get('Id2')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('ProductSecret') is not None:
            self.product_secret = m.get('ProductSecret')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        return self


class CreateProductResponse(TeaModel):
    def __init__(self, code=None, error_message=None, product_key=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.product_key = product_key  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: CreateProductResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateProductResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = CreateProductResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateProductDistributeJobRequest(TeaModel):
    def __init__(self, product_key=None, source_instance_id=None, target_aliyun_id=None, target_instance_id=None,
                 target_uid=None):
        self.product_key = product_key  # type: str
        self.source_instance_id = source_instance_id  # type: str
        self.target_aliyun_id = target_aliyun_id  # type: str
        self.target_instance_id = target_instance_id  # type: str
        self.target_uid = target_uid  # type: str

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.source_instance_id, 'source_instance_id')
        self.validate_required(self.target_instance_id, 'target_instance_id')

    def to_map(self):
        _map = super(CreateProductDistributeJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        if self.target_aliyun_id is not None:
            result['TargetAliyunId'] = self.target_aliyun_id
        if self.target_instance_id is not None:
            result['TargetInstanceId'] = self.target_instance_id
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        if m.get('TargetAliyunId') is not None:
            self.target_aliyun_id = m.get('TargetAliyunId')
        if m.get('TargetInstanceId') is not None:
            self.target_instance_id = m.get('TargetInstanceId')
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        return self


class CreateProductDistributeJobResponse(TeaModel):
    def __init__(self, code=None, error_message=None, job_id=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.job_id = job_id  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.job_id, 'job_id')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(CreateProductDistributeJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateProductTagsRequestProductTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key  # type: str
        self.tag_value = tag_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateProductTagsRequestProductTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class CreateProductTagsRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, product_tag=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.product_tag = product_tag  # type: list[CreateProductTagsRequestProductTag]

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.product_tag, 'product_tag')
        if self.product_tag:
            for k in self.product_tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateProductTagsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        result['ProductTag'] = []
        if self.product_tag is not None:
            for k in self.product_tag:
                result['ProductTag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        self.product_tag = []
        if m.get('ProductTag') is not None:
            for k in m.get('ProductTag'):
                temp_model = CreateProductTagsRequestProductTag()
                self.product_tag.append(temp_model.from_map(k))
        return self


class CreateProductTagsResponseInvalidProductTagsProductTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key  # type: str
        self.tag_value = tag_value  # type: str

    def validate(self):
        self.validate_required(self.tag_key, 'tag_key')
        self.validate_required(self.tag_value, 'tag_value')

    def to_map(self):
        _map = super(CreateProductTagsResponseInvalidProductTagsProductTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class CreateProductTagsResponseInvalidProductTags(TeaModel):
    def __init__(self, product_tag=None):
        self.product_tag = product_tag  # type: list[CreateProductTagsResponseInvalidProductTagsProductTag]

    def validate(self):
        self.validate_required(self.product_tag, 'product_tag')
        if self.product_tag:
            for k in self.product_tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateProductTagsResponseInvalidProductTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ProductTag'] = []
        if self.product_tag is not None:
            for k in self.product_tag:
                result['ProductTag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.product_tag = []
        if m.get('ProductTag') is not None:
            for k in m.get('ProductTag'):
                temp_model = CreateProductTagsResponseInvalidProductTagsProductTag()
                self.product_tag.append(temp_model.from_map(k))
        return self


class CreateProductTagsResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, invalid_product_tags=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.invalid_product_tags = invalid_product_tags  # type: CreateProductTagsResponseInvalidProductTags

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.invalid_product_tags, 'invalid_product_tags')
        if self.invalid_product_tags:
            self.invalid_product_tags.validate()

    def to_map(self):
        _map = super(CreateProductTagsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.invalid_product_tags is not None:
            result['InvalidProductTags'] = self.invalid_product_tags.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('InvalidProductTags') is not None:
            temp_model = CreateProductTagsResponseInvalidProductTags()
            self.invalid_product_tags = temp_model.from_map(m['InvalidProductTags'])
        return self


class CreateProductTopicRequest(TeaModel):
    def __init__(self, desc=None, iot_instance_id=None, operation=None, product_key=None, topic_short_name=None):
        self.desc = desc  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.operation = operation  # type: str
        self.product_key = product_key  # type: str
        self.topic_short_name = topic_short_name  # type: str

    def validate(self):
        self.validate_required(self.operation, 'operation')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.topic_short_name, 'topic_short_name')

    def to_map(self):
        _map = super(CreateProductTopicRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.operation is not None:
            result['Operation'] = self.operation
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.topic_short_name is not None:
            result['TopicShortName'] = self.topic_short_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Operation') is not None:
            self.operation = m.get('Operation')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TopicShortName') is not None:
            self.topic_short_name = m.get('TopicShortName')
        return self


class CreateProductTopicResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, topic_id=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.topic_id = topic_id  # type: long

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.topic_id, 'topic_id')

    def to_map(self):
        _map = super(CreateProductTopicResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        return self


class CreateRuleRequest(TeaModel):
    def __init__(self, data_type=None, iot_instance_id=None, name=None, product_key=None, resource_group_id=None,
                 rule_desc=None, select=None, short_topic=None, topic=None, topic_type=None, where=None):
        self.data_type = data_type  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.name = name  # type: str
        self.product_key = product_key  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.rule_desc = rule_desc  # type: str
        self.select = select  # type: str
        self.short_topic = short_topic  # type: str
        self.topic = topic  # type: str
        self.topic_type = topic_type  # type: int
        self.where = where  # type: str

    def validate(self):
        self.validate_required(self.name, 'name')

    def to_map(self):
        _map = super(CreateRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_type is not None:
            result['DataType'] = self.data_type
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.rule_desc is not None:
            result['RuleDesc'] = self.rule_desc
        if self.select is not None:
            result['Select'] = self.select
        if self.short_topic is not None:
            result['ShortTopic'] = self.short_topic
        if self.topic is not None:
            result['Topic'] = self.topic
        if self.topic_type is not None:
            result['TopicType'] = self.topic_type
        if self.where is not None:
            result['Where'] = self.where
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataType') is not None:
            self.data_type = m.get('DataType')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('RuleDesc') is not None:
            self.rule_desc = m.get('RuleDesc')
        if m.get('Select') is not None:
            self.select = m.get('Select')
        if m.get('ShortTopic') is not None:
            self.short_topic = m.get('ShortTopic')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        if m.get('TopicType') is not None:
            self.topic_type = m.get('TopicType')
        if m.get('Where') is not None:
            self.where = m.get('Where')
        return self


class CreateRuleResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, rule_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.rule_id = rule_id  # type: long
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.rule_id, 'rule_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(CreateRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateRuleActionRequest(TeaModel):
    def __init__(self, configuration=None, error_action_flag=None, iot_instance_id=None, rule_id=None, type=None):
        self.configuration = configuration  # type: str
        self.error_action_flag = error_action_flag  # type: bool
        self.iot_instance_id = iot_instance_id  # type: str
        self.rule_id = rule_id  # type: long
        self.type = type  # type: str

    def validate(self):
        self.validate_required(self.configuration, 'configuration')
        self.validate_required(self.rule_id, 'rule_id')
        self.validate_required(self.type, 'type')

    def to_map(self):
        _map = super(CreateRuleActionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.configuration is not None:
            result['Configuration'] = self.configuration
        if self.error_action_flag is not None:
            result['ErrorActionFlag'] = self.error_action_flag
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Configuration') is not None:
            self.configuration = m.get('Configuration')
        if m.get('ErrorActionFlag') is not None:
            self.error_action_flag = m.get('ErrorActionFlag')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateRuleActionResponse(TeaModel):
    def __init__(self, action_id=None, code=None, error_message=None, request_id=None, success=None):
        self.action_id = action_id  # type: long
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.action_id, 'action_id')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(CreateRuleActionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action_id is not None:
            result['ActionId'] = self.action_id
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActionId') is not None:
            self.action_id = m.get('ActionId')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateSceneRuleRequest(TeaModel):
    def __init__(self, iot_instance_id=None, rule_content=None, rule_description=None, rule_name=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.rule_content = rule_content  # type: str
        self.rule_description = rule_description  # type: str
        self.rule_name = rule_name  # type: str

    def validate(self):
        self.validate_required(self.rule_name, 'rule_name')

    def to_map(self):
        _map = super(CreateSceneRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_content is not None:
            result['RuleContent'] = self.rule_content
        if self.rule_description is not None:
            result['RuleDescription'] = self.rule_description
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleContent') is not None:
            self.rule_content = m.get('RuleContent')
        if m.get('RuleDescription') is not None:
            self.rule_description = m.get('RuleDescription')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        return self


class CreateSceneRuleResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, rule_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.rule_id = rule_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.rule_id, 'rule_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(CreateSceneRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateSchedulePeriodRequest(TeaModel):
    def __init__(self, description=None, end_time=None, iot_instance_id=None, schedule_code=None,
                 sound_code_content=None, start_time=None):
        self.description = description  # type: str
        self.end_time = end_time  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.schedule_code = schedule_code  # type: str
        self.sound_code_content = sound_code_content  # type: str
        self.start_time = start_time  # type: str

    def validate(self):
        self.validate_required(self.description, 'description')
        self.validate_required(self.end_time, 'end_time')
        self.validate_required(self.schedule_code, 'schedule_code')
        self.validate_required(self.sound_code_content, 'sound_code_content')
        self.validate_required(self.start_time, 'start_time')

    def to_map(self):
        _map = super(CreateSchedulePeriodRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.schedule_code is not None:
            result['ScheduleCode'] = self.schedule_code
        if self.sound_code_content is not None:
            result['SoundCodeContent'] = self.sound_code_content
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ScheduleCode') is not None:
            self.schedule_code = m.get('ScheduleCode')
        if m.get('SoundCodeContent') is not None:
            self.sound_code_content = m.get('SoundCodeContent')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class CreateSchedulePeriodResponse(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.data, 'data')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(CreateSchedulePeriodResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateSoundCodeRequest(TeaModel):
    def __init__(self, duration=None, iot_instance_id=None, name=None, open_type=None, sound_code_content=None):
        self.duration = duration  # type: int
        self.iot_instance_id = iot_instance_id  # type: str
        self.name = name  # type: str
        self.open_type = open_type  # type: str
        self.sound_code_content = sound_code_content  # type: str

    def validate(self):
        self.validate_required(self.duration, 'duration')
        self.validate_required(self.sound_code_content, 'sound_code_content')

    def to_map(self):
        _map = super(CreateSoundCodeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.open_type is not None:
            result['OpenType'] = self.open_type
        if self.sound_code_content is not None:
            result['SoundCodeContent'] = self.sound_code_content
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OpenType') is not None:
            self.open_type = m.get('OpenType')
        if m.get('SoundCodeContent') is not None:
            self.sound_code_content = m.get('SoundCodeContent')
        return self


class CreateSoundCodeResponse(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.data, 'data')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(CreateSoundCodeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateSoundCodeLabelRequest(TeaModel):
    def __init__(self, iot_instance_id=None, label=None, schedule_code=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.label = label  # type: str
        self.schedule_code = schedule_code  # type: str

    def validate(self):
        self.validate_required(self.label, 'label')
        self.validate_required(self.schedule_code, 'schedule_code')

    def to_map(self):
        _map = super(CreateSoundCodeLabelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.label is not None:
            result['Label'] = self.label
        if self.schedule_code is not None:
            result['ScheduleCode'] = self.schedule_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('ScheduleCode') is not None:
            self.schedule_code = m.get('ScheduleCode')
        return self


class CreateSoundCodeLabelResponse(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.data, 'data')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(CreateSoundCodeLabelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateSoundCodeScheduleRequest(TeaModel):
    def __init__(self, description=None, end_date=None, iot_instance_id=None, name=None, open_type=None,
                 start_date=None):
        self.description = description  # type: str
        self.end_date = end_date  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.name = name  # type: str
        self.open_type = open_type  # type: str
        self.start_date = start_date  # type: str

    def validate(self):
        self.validate_required(self.end_date, 'end_date')
        self.validate_required(self.name, 'name')
        self.validate_required(self.start_date, 'start_date')

    def to_map(self):
        _map = super(CreateSoundCodeScheduleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.open_type is not None:
            result['OpenType'] = self.open_type
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OpenType') is not None:
            self.open_type = m.get('OpenType')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class CreateSoundCodeScheduleResponse(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.data, 'data')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(CreateSoundCodeScheduleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateSpeechRequest(TeaModel):
    def __init__(self, audio_format=None, biz_code=None, enable_sound_code=None, iot_instance_id=None,
                 project_code=None, sound_code_config=None, speech_rate=None, speech_type=None, text=None, voice=None,
                 volume=None):
        self.audio_format = audio_format  # type: str
        self.biz_code = biz_code  # type: str
        self.enable_sound_code = enable_sound_code  # type: bool
        self.iot_instance_id = iot_instance_id  # type: str
        self.project_code = project_code  # type: str
        self.sound_code_config = sound_code_config  # type: dict[str, any]
        self.speech_rate = speech_rate  # type: int
        self.speech_type = speech_type  # type: str
        self.text = text  # type: str
        self.voice = voice  # type: str
        self.volume = volume  # type: int

    def validate(self):
        self.validate_required(self.project_code, 'project_code')
        self.validate_required(self.voice, 'voice')

    def to_map(self):
        _map = super(CreateSpeechRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_format is not None:
            result['AudioFormat'] = self.audio_format
        if self.biz_code is not None:
            result['BizCode'] = self.biz_code
        if self.enable_sound_code is not None:
            result['EnableSoundCode'] = self.enable_sound_code
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.project_code is not None:
            result['ProjectCode'] = self.project_code
        if self.sound_code_config is not None:
            result['SoundCodeConfig'] = self.sound_code_config
        if self.speech_rate is not None:
            result['SpeechRate'] = self.speech_rate
        if self.speech_type is not None:
            result['SpeechType'] = self.speech_type
        if self.text is not None:
            result['Text'] = self.text
        if self.voice is not None:
            result['Voice'] = self.voice
        if self.volume is not None:
            result['Volume'] = self.volume
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AudioFormat') is not None:
            self.audio_format = m.get('AudioFormat')
        if m.get('BizCode') is not None:
            self.biz_code = m.get('BizCode')
        if m.get('EnableSoundCode') is not None:
            self.enable_sound_code = m.get('EnableSoundCode')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProjectCode') is not None:
            self.project_code = m.get('ProjectCode')
        if m.get('SoundCodeConfig') is not None:
            self.sound_code_config = m.get('SoundCodeConfig')
        if m.get('SpeechRate') is not None:
            self.speech_rate = m.get('SpeechRate')
        if m.get('SpeechType') is not None:
            self.speech_type = m.get('SpeechType')
        if m.get('Text') is not None:
            self.text = m.get('Text')
        if m.get('Voice') is not None:
            self.voice = m.get('Voice')
        if m.get('Volume') is not None:
            self.volume = m.get('Volume')
        return self


class CreateSpeechShrinkRequest(TeaModel):
    def __init__(self, audio_format=None, biz_code=None, enable_sound_code=None, iot_instance_id=None,
                 project_code=None, sound_code_config_shrink=None, speech_rate=None, speech_type=None, text=None, voice=None,
                 volume=None):
        self.audio_format = audio_format  # type: str
        self.biz_code = biz_code  # type: str
        self.enable_sound_code = enable_sound_code  # type: bool
        self.iot_instance_id = iot_instance_id  # type: str
        self.project_code = project_code  # type: str
        self.sound_code_config_shrink = sound_code_config_shrink  # type: str
        self.speech_rate = speech_rate  # type: int
        self.speech_type = speech_type  # type: str
        self.text = text  # type: str
        self.voice = voice  # type: str
        self.volume = volume  # type: int

    def validate(self):
        self.validate_required(self.project_code, 'project_code')
        self.validate_required(self.voice, 'voice')

    def to_map(self):
        _map = super(CreateSpeechShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_format is not None:
            result['AudioFormat'] = self.audio_format
        if self.biz_code is not None:
            result['BizCode'] = self.biz_code
        if self.enable_sound_code is not None:
            result['EnableSoundCode'] = self.enable_sound_code
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.project_code is not None:
            result['ProjectCode'] = self.project_code
        if self.sound_code_config_shrink is not None:
            result['SoundCodeConfig'] = self.sound_code_config_shrink
        if self.speech_rate is not None:
            result['SpeechRate'] = self.speech_rate
        if self.speech_type is not None:
            result['SpeechType'] = self.speech_type
        if self.text is not None:
            result['Text'] = self.text
        if self.voice is not None:
            result['Voice'] = self.voice
        if self.volume is not None:
            result['Volume'] = self.volume
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AudioFormat') is not None:
            self.audio_format = m.get('AudioFormat')
        if m.get('BizCode') is not None:
            self.biz_code = m.get('BizCode')
        if m.get('EnableSoundCode') is not None:
            self.enable_sound_code = m.get('EnableSoundCode')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProjectCode') is not None:
            self.project_code = m.get('ProjectCode')
        if m.get('SoundCodeConfig') is not None:
            self.sound_code_config_shrink = m.get('SoundCodeConfig')
        if m.get('SpeechRate') is not None:
            self.speech_rate = m.get('SpeechRate')
        if m.get('SpeechType') is not None:
            self.speech_type = m.get('SpeechType')
        if m.get('Text') is not None:
            self.text = m.get('Text')
        if m.get('Voice') is not None:
            self.voice = m.get('Voice')
        if m.get('Volume') is not None:
            self.volume = m.get('Volume')
        return self


class CreateSpeechResponse(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.data, 'data')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(CreateSpeechResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateStudioAppDomainOpenRequest(TeaModel):
    def __init__(self, app_id=None, host=None, iot_instance_id=None, project_id=None, protocol=None):
        self.app_id = app_id  # type: str
        self.host = host  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.project_id = project_id  # type: str
        self.protocol = protocol  # type: str

    def validate(self):
        self.validate_required(self.app_id, 'app_id')
        self.validate_required(self.host, 'host')
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.protocol, 'protocol')

    def to_map(self):
        _map = super(CreateStudioAppDomainOpenRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.host is not None:
            result['Host'] = self.host
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        return self


class CreateStudioAppDomainOpenResponseData(TeaModel):
    def __init__(self, app_id=None, host=None, id=None, is_beian=None, project_id=None, protocol=None, tenant_id=None):
        self.app_id = app_id  # type: str
        self.host = host  # type: str
        self.id = id  # type: int
        self.is_beian = is_beian  # type: str
        self.project_id = project_id  # type: str
        self.protocol = protocol  # type: str
        self.tenant_id = tenant_id  # type: str

    def validate(self):
        self.validate_required(self.app_id, 'app_id')
        self.validate_required(self.host, 'host')
        self.validate_required(self.id, 'id')
        self.validate_required(self.is_beian, 'is_beian')
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.protocol, 'protocol')
        self.validate_required(self.tenant_id, 'tenant_id')

    def to_map(self):
        _map = super(CreateStudioAppDomainOpenResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.host is not None:
            result['Host'] = self.host
        if self.id is not None:
            result['Id'] = self.id
        if self.is_beian is not None:
            result['IsBeian'] = self.is_beian
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('IsBeian') is not None:
            self.is_beian = m.get('IsBeian')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class CreateStudioAppDomainOpenResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: CreateStudioAppDomainOpenResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateStudioAppDomainOpenResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = CreateStudioAppDomainOpenResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateSubscribeRelationRequest(TeaModel):
    def __init__(self, consumer_group_ids=None, device_data_flag=None, device_life_cycle_flag=None,
                 device_status_change_flag=None, device_tag_flag=None, device_topo_life_cycle_flag=None, found_device_list_flag=None,
                 iot_instance_id=None, mns_configuration=None, ota_event_flag=None, ota_job_flag=None, ota_version_flag=None,
                 product_key=None, subscribe_flags=None, thing_history_flag=None, type=None):
        self.consumer_group_ids = consumer_group_ids  # type: list[str]
        self.device_data_flag = device_data_flag  # type: bool
        self.device_life_cycle_flag = device_life_cycle_flag  # type: bool
        self.device_status_change_flag = device_status_change_flag  # type: bool
        self.device_tag_flag = device_tag_flag  # type: bool
        self.device_topo_life_cycle_flag = device_topo_life_cycle_flag  # type: bool
        self.found_device_list_flag = found_device_list_flag  # type: bool
        self.iot_instance_id = iot_instance_id  # type: str
        self.mns_configuration = mns_configuration  # type: str
        self.ota_event_flag = ota_event_flag  # type: bool
        self.ota_job_flag = ota_job_flag  # type: bool
        self.ota_version_flag = ota_version_flag  # type: bool
        self.product_key = product_key  # type: str
        self.subscribe_flags = subscribe_flags  # type: str
        self.thing_history_flag = thing_history_flag  # type: bool
        self.type = type  # type: str

    def validate(self):
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        _map = super(CreateSubscribeRelationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.consumer_group_ids is not None:
            result['ConsumerGroupIds'] = self.consumer_group_ids
        if self.device_data_flag is not None:
            result['DeviceDataFlag'] = self.device_data_flag
        if self.device_life_cycle_flag is not None:
            result['DeviceLifeCycleFlag'] = self.device_life_cycle_flag
        if self.device_status_change_flag is not None:
            result['DeviceStatusChangeFlag'] = self.device_status_change_flag
        if self.device_tag_flag is not None:
            result['DeviceTagFlag'] = self.device_tag_flag
        if self.device_topo_life_cycle_flag is not None:
            result['DeviceTopoLifeCycleFlag'] = self.device_topo_life_cycle_flag
        if self.found_device_list_flag is not None:
            result['FoundDeviceListFlag'] = self.found_device_list_flag
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.mns_configuration is not None:
            result['MnsConfiguration'] = self.mns_configuration
        if self.ota_event_flag is not None:
            result['OtaEventFlag'] = self.ota_event_flag
        if self.ota_job_flag is not None:
            result['OtaJobFlag'] = self.ota_job_flag
        if self.ota_version_flag is not None:
            result['OtaVersionFlag'] = self.ota_version_flag
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.subscribe_flags is not None:
            result['SubscribeFlags'] = self.subscribe_flags
        if self.thing_history_flag is not None:
            result['ThingHistoryFlag'] = self.thing_history_flag
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConsumerGroupIds') is not None:
            self.consumer_group_ids = m.get('ConsumerGroupIds')
        if m.get('DeviceDataFlag') is not None:
            self.device_data_flag = m.get('DeviceDataFlag')
        if m.get('DeviceLifeCycleFlag') is not None:
            self.device_life_cycle_flag = m.get('DeviceLifeCycleFlag')
        if m.get('DeviceStatusChangeFlag') is not None:
            self.device_status_change_flag = m.get('DeviceStatusChangeFlag')
        if m.get('DeviceTagFlag') is not None:
            self.device_tag_flag = m.get('DeviceTagFlag')
        if m.get('DeviceTopoLifeCycleFlag') is not None:
            self.device_topo_life_cycle_flag = m.get('DeviceTopoLifeCycleFlag')
        if m.get('FoundDeviceListFlag') is not None:
            self.found_device_list_flag = m.get('FoundDeviceListFlag')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('MnsConfiguration') is not None:
            self.mns_configuration = m.get('MnsConfiguration')
        if m.get('OtaEventFlag') is not None:
            self.ota_event_flag = m.get('OtaEventFlag')
        if m.get('OtaJobFlag') is not None:
            self.ota_job_flag = m.get('OtaJobFlag')
        if m.get('OtaVersionFlag') is not None:
            self.ota_version_flag = m.get('OtaVersionFlag')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('SubscribeFlags') is not None:
            self.subscribe_flags = m.get('SubscribeFlags')
        if m.get('ThingHistoryFlag') is not None:
            self.thing_history_flag = m.get('ThingHistoryFlag')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateSubscribeRelationResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(CreateSubscribeRelationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateThingModelRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, thing_model_json=None, function_block_id=None,
                 function_block_name=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.thing_model_json = thing_model_json  # type: str
        self.function_block_id = function_block_id  # type: str
        self.function_block_name = function_block_name  # type: str

    def validate(self):
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        _map = super(CreateThingModelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.thing_model_json is not None:
            result['ThingModelJson'] = self.thing_model_json
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        if self.function_block_name is not None:
            result['FunctionBlockName'] = self.function_block_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ThingModelJson') is not None:
            self.thing_model_json = m.get('ThingModelJson')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        if m.get('FunctionBlockName') is not None:
            self.function_block_name = m.get('FunctionBlockName')
        return self


class CreateThingModelResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(CreateThingModelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateThingScriptRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, script_content=None, script_type=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.script_content = script_content  # type: str
        self.script_type = script_type  # type: str

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.script_content, 'script_content')
        self.validate_required(self.script_type, 'script_type')

    def to_map(self):
        _map = super(CreateThingScriptRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.script_content is not None:
            result['ScriptContent'] = self.script_content
        if self.script_type is not None:
            result['ScriptType'] = self.script_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ScriptContent') is not None:
            self.script_content = m.get('ScriptContent')
        if m.get('ScriptType') is not None:
            self.script_type = m.get('ScriptType')
        return self


class CreateThingScriptResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(CreateThingScriptResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateTopicRouteTableRequest(TeaModel):
    def __init__(self, dst_topic=None, iot_instance_id=None, src_topic=None):
        self.dst_topic = dst_topic  # type: list[str]
        self.iot_instance_id = iot_instance_id  # type: str
        self.src_topic = src_topic  # type: str

    def validate(self):
        self.validate_required(self.dst_topic, 'dst_topic')
        self.validate_required(self.src_topic, 'src_topic')

    def to_map(self):
        _map = super(CreateTopicRouteTableRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dst_topic is not None:
            result['DstTopic'] = self.dst_topic
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.src_topic is not None:
            result['SrcTopic'] = self.src_topic
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DstTopic') is not None:
            self.dst_topic = m.get('DstTopic')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('SrcTopic') is not None:
            self.src_topic = m.get('SrcTopic')
        return self


class CreateTopicRouteTableResponseFailureTopics(TeaModel):
    def __init__(self, topic=None):
        self.topic = topic  # type: list[dict[str, any]]

    def validate(self):
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        _map = super(CreateTopicRouteTableResponseFailureTopics, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class CreateTopicRouteTableResponse(TeaModel):
    def __init__(self, code=None, error_message=None, is_all_succeed=None, request_id=None, success=None,
                 failure_topics=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.is_all_succeed = is_all_succeed  # type: bool
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.failure_topics = failure_topics  # type: CreateTopicRouteTableResponseFailureTopics

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.is_all_succeed, 'is_all_succeed')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.failure_topics, 'failure_topics')
        if self.failure_topics:
            self.failure_topics.validate()

    def to_map(self):
        _map = super(CreateTopicRouteTableResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.is_all_succeed is not None:
            result['IsAllSucceed'] = self.is_all_succeed
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.failure_topics is not None:
            result['FailureTopics'] = self.failure_topics.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('IsAllSucceed') is not None:
            self.is_all_succeed = m.get('IsAllSucceed')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('FailureTopics') is not None:
            temp_model = CreateTopicRouteTableResponseFailureTopics()
            self.failure_topics = temp_model.from_map(m['FailureTopics'])
        return self


class DeleteClientIdsRequest(TeaModel):
    def __init__(self, iot_id=None, iot_instance_id=None):
        self.iot_id = iot_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.iot_id, 'iot_id')

    def to_map(self):
        _map = super(DeleteClientIdsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class DeleteClientIdsResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(DeleteClientIdsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteConsumerGroupRequest(TeaModel):
    def __init__(self, group_id=None, iot_instance_id=None):
        self.group_id = group_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.group_id, 'group_id')

    def to_map(self):
        _map = super(DeleteConsumerGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class DeleteConsumerGroupResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(DeleteConsumerGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteConsumerGroupSubscribeRelationRequest(TeaModel):
    def __init__(self, consumer_group_id=None, iot_instance_id=None, product_key=None):
        self.consumer_group_id = consumer_group_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        self.validate_required(self.consumer_group_id, 'consumer_group_id')
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        _map = super(DeleteConsumerGroupSubscribeRelationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.consumer_group_id is not None:
            result['ConsumerGroupId'] = self.consumer_group_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConsumerGroupId') is not None:
            self.consumer_group_id = m.get('ConsumerGroupId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class DeleteConsumerGroupSubscribeRelationResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(DeleteConsumerGroupSubscribeRelationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDataSourceItemRequest(TeaModel):
    def __init__(self, data_source_id=None, data_source_item_id=None, iot_instance_id=None):
        self.data_source_id = data_source_id  # type: long
        self.data_source_item_id = data_source_item_id  # type: long
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.data_source_id, 'data_source_id')
        self.validate_required(self.data_source_item_id, 'data_source_item_id')

    def to_map(self):
        _map = super(DeleteDataSourceItemRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.data_source_item_id is not None:
            result['DataSourceItemId'] = self.data_source_item_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('DataSourceItemId') is not None:
            self.data_source_item_id = m.get('DataSourceItemId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class DeleteDataSourceItemResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(DeleteDataSourceItemResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDestinationRequest(TeaModel):
    def __init__(self, destination_id=None, iot_instance_id=None):
        self.destination_id = destination_id  # type: long
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.destination_id, 'destination_id')

    def to_map(self):
        _map = super(DeleteDestinationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.destination_id is not None:
            result['DestinationId'] = self.destination_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DestinationId') is not None:
            self.destination_id = m.get('DestinationId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class DeleteDestinationResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(DeleteDestinationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDeviceRequest(TeaModel):
    def __init__(self, device_name=None, iot_id=None, iot_instance_id=None, product_key=None):
        self.device_name = device_name  # type: str
        self.iot_id = iot_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class DeleteDeviceResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(DeleteDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDeviceDistributeJobRequest(TeaModel):
    def __init__(self, job_id=None):
        self.job_id = job_id  # type: str

    def validate(self):
        self.validate_required(self.job_id, 'job_id')

    def to_map(self):
        _map = super(DeleteDeviceDistributeJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class DeleteDeviceDistributeJobResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(DeleteDeviceDistributeJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDeviceDynamicGroupRequest(TeaModel):
    def __init__(self, group_id=None, iot_instance_id=None):
        self.group_id = group_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.iot_instance_id, 'iot_instance_id')

    def to_map(self):
        _map = super(DeleteDeviceDynamicGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class DeleteDeviceDynamicGroupResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(DeleteDeviceDynamicGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDeviceFileRequest(TeaModel):
    def __init__(self, device_name=None, file_id=None, iot_id=None, iot_instance_id=None, product_key=None):
        self.device_name = device_name  # type: str
        self.file_id = file_id  # type: str
        self.iot_id = iot_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        self.validate_required(self.file_id, 'file_id')

    def to_map(self):
        _map = super(DeleteDeviceFileRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class DeleteDeviceFileResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(DeleteDeviceFileResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDeviceGroupRequest(TeaModel):
    def __init__(self, group_id=None, iot_instance_id=None):
        self.group_id = group_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.group_id, 'group_id')

    def to_map(self):
        _map = super(DeleteDeviceGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class DeleteDeviceGroupResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(DeleteDeviceGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDevicePropRequest(TeaModel):
    def __init__(self, device_name=None, iot_id=None, iot_instance_id=None, product_key=None, prop_key=None):
        self.device_name = device_name  # type: str
        self.iot_id = iot_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.prop_key = prop_key  # type: str

    def validate(self):
        self.validate_required(self.prop_key, 'prop_key')

    def to_map(self):
        _map = super(DeleteDevicePropRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.prop_key is not None:
            result['PropKey'] = self.prop_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('PropKey') is not None:
            self.prop_key = m.get('PropKey')
        return self


class DeleteDevicePropResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(DeleteDevicePropResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDeviceSpeechRequestDeviceSpeechList(TeaModel):
    def __init__(self, audio_format=None, biz_code=None):
        self.audio_format = audio_format  # type: str
        self.biz_code = biz_code  # type: str

    def validate(self):
        self.validate_required(self.audio_format, 'audio_format')
        self.validate_required(self.biz_code, 'biz_code')

    def to_map(self):
        _map = super(DeleteDeviceSpeechRequestDeviceSpeechList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_format is not None:
            result['AudioFormat'] = self.audio_format
        if self.biz_code is not None:
            result['BizCode'] = self.biz_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AudioFormat') is not None:
            self.audio_format = m.get('AudioFormat')
        if m.get('BizCode') is not None:
            self.biz_code = m.get('BizCode')
        return self


class DeleteDeviceSpeechRequest(TeaModel):
    def __init__(self, device_speech_list=None, iot_id=None, iot_instance_id=None):
        self.device_speech_list = device_speech_list  # type: list[DeleteDeviceSpeechRequestDeviceSpeechList]
        self.iot_id = iot_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.device_speech_list, 'device_speech_list')
        if self.device_speech_list:
            for k in self.device_speech_list:
                if k:
                    k.validate()
        self.validate_required(self.iot_id, 'iot_id')

    def to_map(self):
        _map = super(DeleteDeviceSpeechRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DeviceSpeechList'] = []
        if self.device_speech_list is not None:
            for k in self.device_speech_list:
                result['DeviceSpeechList'].append(k.to_map() if k else None)
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.device_speech_list = []
        if m.get('DeviceSpeechList') is not None:
            for k in m.get('DeviceSpeechList'):
                temp_model = DeleteDeviceSpeechRequestDeviceSpeechList()
                self.device_speech_list.append(temp_model.from_map(k))
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class DeleteDeviceSpeechResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(DeleteDeviceSpeechResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDeviceTunnelRequest(TeaModel):
    def __init__(self, tunnel_id=None, iot_instance_id=None):
        self.tunnel_id = tunnel_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.tunnel_id, 'tunnel_id')

    def to_map(self):
        _map = super(DeleteDeviceTunnelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tunnel_id is not None:
            result['TunnelId'] = self.tunnel_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TunnelId') is not None:
            self.tunnel_id = m.get('TunnelId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class DeleteDeviceTunnelResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(DeleteDeviceTunnelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteEdgeDriverRequest(TeaModel):
    def __init__(self, driver_id=None, iot_instance_id=None):
        self.driver_id = driver_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.driver_id, 'driver_id')

    def to_map(self):
        _map = super(DeleteEdgeDriverRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class DeleteEdgeDriverResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(DeleteEdgeDriverResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteEdgeDriverVersionRequest(TeaModel):
    def __init__(self, driver_id=None, driver_version=None, iot_instance_id=None):
        self.driver_id = driver_id  # type: str
        self.driver_version = driver_version  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.driver_version, 'driver_version')

    def to_map(self):
        _map = super(DeleteEdgeDriverVersionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class DeleteEdgeDriverVersionResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(DeleteEdgeDriverVersionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteEdgeInstanceRequest(TeaModel):
    def __init__(self, instance_id=None, iot_instance_id=None):
        self.instance_id = instance_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        _map = super(DeleteEdgeInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class DeleteEdgeInstanceResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(DeleteEdgeInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteEdgeInstanceMessageRoutingRequest(TeaModel):
    def __init__(self, instance_id=None, iot_instance_id=None, route_id=None):
        self.instance_id = instance_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.route_id = route_id  # type: long

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.route_id, 'route_id')

    def to_map(self):
        _map = super(DeleteEdgeInstanceMessageRoutingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.route_id is not None:
            result['RouteId'] = self.route_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RouteId') is not None:
            self.route_id = m.get('RouteId')
        return self


class DeleteEdgeInstanceMessageRoutingResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(DeleteEdgeInstanceMessageRoutingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteJobRequest(TeaModel):
    def __init__(self, iot_instance_id=None, job_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        self.validate_required(self.job_id, 'job_id')

    def to_map(self):
        _map = super(DeleteJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class DeleteJobResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(DeleteJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteOTAFirmwareRequest(TeaModel):
    def __init__(self, firmware_id=None, iot_instance_id=None):
        self.firmware_id = firmware_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.firmware_id, 'firmware_id')

    def to_map(self):
        _map = super(DeleteOTAFirmwareRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class DeleteOTAFirmwareResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(DeleteOTAFirmwareResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteOTAModuleRequest(TeaModel):
    def __init__(self, iot_instance_id=None, module_name=None, product_key=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.module_name = module_name  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        self.validate_required(self.module_name, 'module_name')
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        _map = super(DeleteOTAModuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class DeleteOTAModuleResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(DeleteOTAModuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteParserRequest(TeaModel):
    def __init__(self, iot_instance_id=None, parser_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.parser_id = parser_id  # type: long

    def validate(self):
        self.validate_required(self.parser_id, 'parser_id')

    def to_map(self):
        _map = super(DeleteParserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.parser_id is not None:
            result['ParserId'] = self.parser_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ParserId') is not None:
            self.parser_id = m.get('ParserId')
        return self


class DeleteParserResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(DeleteParserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteParserDataSourceRequest(TeaModel):
    def __init__(self, data_source_id=None, iot_instance_id=None):
        self.data_source_id = data_source_id  # type: long
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.data_source_id, 'data_source_id')

    def to_map(self):
        _map = super(DeleteParserDataSourceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class DeleteParserDataSourceResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(DeleteParserDataSourceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteProductRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        _map = super(DeleteProductRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class DeleteProductResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(DeleteProductResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteProductTagsRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, product_tag_key=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.product_tag_key = product_tag_key  # type: list[str]

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.product_tag_key, 'product_tag_key')

    def to_map(self):
        _map = super(DeleteProductTagsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.product_tag_key is not None:
            result['ProductTagKey'] = self.product_tag_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ProductTagKey') is not None:
            self.product_tag_key = m.get('ProductTagKey')
        return self


class DeleteProductTagsResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(DeleteProductTagsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteProductTopicRequest(TeaModel):
    def __init__(self, iot_instance_id=None, topic_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.topic_id = topic_id  # type: str

    def validate(self):
        self.validate_required(self.topic_id, 'topic_id')

    def to_map(self):
        _map = super(DeleteProductTopicRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        return self


class DeleteProductTopicResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(DeleteProductTopicResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteRuleRequest(TeaModel):
    def __init__(self, iot_instance_id=None, rule_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.rule_id = rule_id  # type: long

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')

    def to_map(self):
        _map = super(DeleteRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DeleteRuleResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(DeleteRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteRuleActionRequest(TeaModel):
    def __init__(self, action_id=None, iot_instance_id=None):
        self.action_id = action_id  # type: long
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.action_id, 'action_id')

    def to_map(self):
        _map = super(DeleteRuleActionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action_id is not None:
            result['ActionId'] = self.action_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActionId') is not None:
            self.action_id = m.get('ActionId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class DeleteRuleActionResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(DeleteRuleActionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteSceneRuleRequest(TeaModel):
    def __init__(self, iot_instance_id=None, rule_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.rule_id = rule_id  # type: str

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')

    def to_map(self):
        _map = super(DeleteSceneRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DeleteSceneRuleResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(DeleteSceneRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteSchedulePeriodRequest(TeaModel):
    def __init__(self, iot_instance_id=None, period_code=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.period_code = period_code  # type: str

    def validate(self):
        self.validate_required(self.period_code, 'period_code')

    def to_map(self):
        _map = super(DeleteSchedulePeriodRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.period_code is not None:
            result['PeriodCode'] = self.period_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PeriodCode') is not None:
            self.period_code = m.get('PeriodCode')
        return self


class DeleteSchedulePeriodResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(DeleteSchedulePeriodResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteShareTaskDeviceRequest(TeaModel):
    def __init__(self, iot_id_list=None, iot_instance_id=None, share_task_id=None):
        self.iot_id_list = iot_id_list  # type: list[str]
        self.iot_instance_id = iot_instance_id  # type: str
        self.share_task_id = share_task_id  # type: str

    def validate(self):
        self.validate_required(self.share_task_id, 'share_task_id')

    def to_map(self):
        _map = super(DeleteShareTaskDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_id_list is not None:
            result['IotIdList'] = self.iot_id_list
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.share_task_id is not None:
            result['ShareTaskId'] = self.share_task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotIdList') is not None:
            self.iot_id_list = m.get('IotIdList')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ShareTaskId') is not None:
            self.share_task_id = m.get('ShareTaskId')
        return self


class DeleteShareTaskDeviceResponseData(TeaModel):
    def __init__(self, progress=None, progress_id=None):
        self.progress = progress  # type: int
        self.progress_id = progress_id  # type: str

    def validate(self):
        self.validate_required(self.progress, 'progress')
        self.validate_required(self.progress_id, 'progress_id')

    def to_map(self):
        _map = super(DeleteShareTaskDeviceResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.progress_id is not None:
            result['ProgressId'] = self.progress_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('ProgressId') is not None:
            self.progress_id = m.get('ProgressId')
        return self


class DeleteShareTaskDeviceResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: DeleteShareTaskDeviceResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DeleteShareTaskDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = DeleteShareTaskDeviceResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class DeleteSoundCodeRequest(TeaModel):
    def __init__(self, iot_instance_id=None, sound_code=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.sound_code = sound_code  # type: str

    def validate(self):
        self.validate_required(self.sound_code, 'sound_code')

    def to_map(self):
        _map = super(DeleteSoundCodeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.sound_code is not None:
            result['SoundCode'] = self.sound_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('SoundCode') is not None:
            self.sound_code = m.get('SoundCode')
        return self


class DeleteSoundCodeResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(DeleteSoundCodeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteSoundCodeLabelRequest(TeaModel):
    def __init__(self, iot_instance_id=None, sound_code=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.sound_code = sound_code  # type: str

    def validate(self):
        self.validate_required(self.sound_code, 'sound_code')

    def to_map(self):
        _map = super(DeleteSoundCodeLabelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.sound_code is not None:
            result['SoundCode'] = self.sound_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('SoundCode') is not None:
            self.sound_code = m.get('SoundCode')
        return self


class DeleteSoundCodeLabelResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(DeleteSoundCodeLabelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteSoundCodeScheduleRequest(TeaModel):
    def __init__(self, iot_instance_id=None, schedule_code=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.schedule_code = schedule_code  # type: str

    def validate(self):
        self.validate_required(self.schedule_code, 'schedule_code')

    def to_map(self):
        _map = super(DeleteSoundCodeScheduleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.schedule_code is not None:
            result['ScheduleCode'] = self.schedule_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ScheduleCode') is not None:
            self.schedule_code = m.get('ScheduleCode')
        return self


class DeleteSoundCodeScheduleResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(DeleteSoundCodeScheduleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteSpeechRequest(TeaModel):
    def __init__(self, iot_instance_id=None, speech_code_list=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.speech_code_list = speech_code_list  # type: list[str]

    def validate(self):
        self.validate_required(self.speech_code_list, 'speech_code_list')

    def to_map(self):
        _map = super(DeleteSpeechRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.speech_code_list is not None:
            result['SpeechCodeList'] = self.speech_code_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('SpeechCodeList') is not None:
            self.speech_code_list = m.get('SpeechCodeList')
        return self


class DeleteSpeechResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(DeleteSpeechResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteStudioAppDomainOpenRequest(TeaModel):
    def __init__(self, app_id=None, domain_id=None, iot_instance_id=None, project_id=None):
        self.app_id = app_id  # type: str
        self.domain_id = domain_id  # type: int
        self.iot_instance_id = iot_instance_id  # type: str
        self.project_id = project_id  # type: str

    def validate(self):
        self.validate_required(self.app_id, 'app_id')
        self.validate_required(self.domain_id, 'domain_id')
        self.validate_required(self.project_id, 'project_id')

    def to_map(self):
        _map = super(DeleteStudioAppDomainOpenRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.domain_id is not None:
            result['DomainId'] = self.domain_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('DomainId') is not None:
            self.domain_id = m.get('DomainId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class DeleteStudioAppDomainOpenResponse(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: bool
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.data, 'data')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(DeleteStudioAppDomainOpenResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteSubscribeRelationRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, type=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.type = type  # type: str

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.type, 'type')

    def to_map(self):
        _map = super(DeleteSubscribeRelationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DeleteSubscribeRelationResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(DeleteSubscribeRelationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteThingModelRequest(TeaModel):
    def __init__(self, event_identifier=None, function_block_id=None, iot_instance_id=None, product_key=None,
                 property_identifier=None, resource_group_id=None, service_identifier=None):
        self.event_identifier = event_identifier  # type: list[str]
        self.function_block_id = function_block_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.property_identifier = property_identifier  # type: list[str]
        self.resource_group_id = resource_group_id  # type: str
        self.service_identifier = service_identifier  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteThingModelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_identifier is not None:
            result['EventIdentifier'] = self.event_identifier
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.property_identifier is not None:
            result['PropertyIdentifier'] = self.property_identifier
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.service_identifier is not None:
            result['ServiceIdentifier'] = self.service_identifier
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EventIdentifier') is not None:
            self.event_identifier = m.get('EventIdentifier')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('PropertyIdentifier') is not None:
            self.property_identifier = m.get('PropertyIdentifier')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ServiceIdentifier') is not None:
            self.service_identifier = m.get('ServiceIdentifier')
        return self


class DeleteThingModelResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(DeleteThingModelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteTopicRouteTableRequest(TeaModel):
    def __init__(self, dst_topic=None, iot_instance_id=None, src_topic=None):
        self.dst_topic = dst_topic  # type: list[str]
        self.iot_instance_id = iot_instance_id  # type: str
        self.src_topic = src_topic  # type: str

    def validate(self):
        self.validate_required(self.dst_topic, 'dst_topic')
        self.validate_required(self.src_topic, 'src_topic')

    def to_map(self):
        _map = super(DeleteTopicRouteTableRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dst_topic is not None:
            result['DstTopic'] = self.dst_topic
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.src_topic is not None:
            result['SrcTopic'] = self.src_topic
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DstTopic') is not None:
            self.dst_topic = m.get('DstTopic')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('SrcTopic') is not None:
            self.src_topic = m.get('SrcTopic')
        return self


class DeleteTopicRouteTableResponseFailureTopics(TeaModel):
    def __init__(self, topic=None):
        self.topic = topic  # type: list[dict[str, any]]

    def validate(self):
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        _map = super(DeleteTopicRouteTableResponseFailureTopics, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class DeleteTopicRouteTableResponse(TeaModel):
    def __init__(self, code=None, error_message=None, is_all_succeed=None, request_id=None, success=None,
                 failure_topics=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.is_all_succeed = is_all_succeed  # type: bool
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.failure_topics = failure_topics  # type: DeleteTopicRouteTableResponseFailureTopics

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.is_all_succeed, 'is_all_succeed')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.failure_topics, 'failure_topics')
        if self.failure_topics:
            self.failure_topics.validate()

    def to_map(self):
        _map = super(DeleteTopicRouteTableResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.is_all_succeed is not None:
            result['IsAllSucceed'] = self.is_all_succeed
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.failure_topics is not None:
            result['FailureTopics'] = self.failure_topics.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('IsAllSucceed') is not None:
            self.is_all_succeed = m.get('IsAllSucceed')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('FailureTopics') is not None:
            temp_model = DeleteTopicRouteTableResponseFailureTopics()
            self.failure_topics = temp_model.from_map(m['FailureTopics'])
        return self


class DetachDestinationRequest(TeaModel):
    def __init__(self, destination_id=None, iot_instance_id=None, parser_id=None):
        self.destination_id = destination_id  # type: long
        self.iot_instance_id = iot_instance_id  # type: str
        self.parser_id = parser_id  # type: long

    def validate(self):
        self.validate_required(self.destination_id, 'destination_id')
        self.validate_required(self.parser_id, 'parser_id')

    def to_map(self):
        _map = super(DetachDestinationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.destination_id is not None:
            result['DestinationId'] = self.destination_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.parser_id is not None:
            result['ParserId'] = self.parser_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DestinationId') is not None:
            self.destination_id = m.get('DestinationId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ParserId') is not None:
            self.parser_id = m.get('ParserId')
        return self


class DetachDestinationResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(DetachDestinationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DetachParserDataSourceRequest(TeaModel):
    def __init__(self, data_source_id=None, iot_instance_id=None, parser_id=None):
        self.data_source_id = data_source_id  # type: long
        self.iot_instance_id = iot_instance_id  # type: str
        self.parser_id = parser_id  # type: long

    def validate(self):
        self.validate_required(self.data_source_id, 'data_source_id')
        self.validate_required(self.parser_id, 'parser_id')

    def to_map(self):
        _map = super(DetachParserDataSourceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.parser_id is not None:
            result['ParserId'] = self.parser_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ParserId') is not None:
            self.parser_id = m.get('ParserId')
        return self


class DetachParserDataSourceResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(DetachParserDataSourceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DisableDeviceTunnelRequest(TeaModel):
    def __init__(self, device_name=None, iot_instance_id=None, product_key=None):
        self.device_name = device_name  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        _map = super(DisableDeviceTunnelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class DisableDeviceTunnelResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(DisableDeviceTunnelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DisableDeviceTunnelShareRequest(TeaModel):
    def __init__(self, device_name=None, iot_instance_id=None, product_key=None):
        self.device_name = device_name  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        _map = super(DisableDeviceTunnelShareRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class DisableDeviceTunnelShareResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(DisableDeviceTunnelShareResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DisableSceneRuleRequest(TeaModel):
    def __init__(self, iot_instance_id=None, rule_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.rule_id = rule_id  # type: str

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')

    def to_map(self):
        _map = super(DisableSceneRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DisableSceneRuleResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(DisableSceneRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DisableThingRequest(TeaModel):
    def __init__(self, device_name=None, iot_id=None, iot_instance_id=None, product_key=None):
        self.device_name = device_name  # type: str
        self.iot_id = iot_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DisableThingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class DisableThingResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(DisableThingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class EnableDeviceTunnelRequest(TeaModel):
    def __init__(self, device_name=None, iot_instance_id=None, product_key=None):
        self.device_name = device_name  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        _map = super(EnableDeviceTunnelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class EnableDeviceTunnelResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(EnableDeviceTunnelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class EnableDeviceTunnelShareRequest(TeaModel):
    def __init__(self, device_name=None, iot_instance_id=None, product_key=None):
        self.device_name = device_name  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        _map = super(EnableDeviceTunnelShareRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class EnableDeviceTunnelShareResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(EnableDeviceTunnelShareResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class EnableSceneRuleRequest(TeaModel):
    def __init__(self, iot_instance_id=None, rule_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.rule_id = rule_id  # type: str

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')

    def to_map(self):
        _map = super(EnableSceneRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class EnableSceneRuleResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(EnableSceneRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class EnableThingRequest(TeaModel):
    def __init__(self, device_name=None, iot_id=None, iot_instance_id=None, product_key=None):
        self.device_name = device_name  # type: str
        self.iot_id = iot_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(EnableThingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class EnableThingResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(EnableThingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GenerateDeviceNameListURLRequest(TeaModel):
    def __init__(self, iot_instance_id=None):
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GenerateDeviceNameListURLRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class GenerateDeviceNameListURLResponseData(TeaModel):
    def __init__(self, access_key_id=None, file_url=None, host=None, key=None, object_storage=None, policy=None,
                 signature=None, utc_create=None):
        self.access_key_id = access_key_id  # type: str
        self.file_url = file_url  # type: str
        self.host = host  # type: str
        self.key = key  # type: str
        self.object_storage = object_storage  # type: str
        self.policy = policy  # type: str
        self.signature = signature  # type: str
        self.utc_create = utc_create  # type: str

    def validate(self):
        self.validate_required(self.access_key_id, 'access_key_id')
        self.validate_required(self.file_url, 'file_url')
        self.validate_required(self.host, 'host')
        self.validate_required(self.key, 'key')
        self.validate_required(self.object_storage, 'object_storage')
        self.validate_required(self.policy, 'policy')
        self.validate_required(self.signature, 'signature')
        self.validate_required(self.utc_create, 'utc_create')

    def to_map(self):
        _map = super(GenerateDeviceNameListURLResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_key_id is not None:
            result['AccessKeyId'] = self.access_key_id
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.host is not None:
            result['Host'] = self.host
        if self.key is not None:
            result['Key'] = self.key
        if self.object_storage is not None:
            result['ObjectStorage'] = self.object_storage
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.signature is not None:
            result['Signature'] = self.signature
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccessKeyId') is not None:
            self.access_key_id = m.get('AccessKeyId')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('ObjectStorage') is not None:
            self.object_storage = m.get('ObjectStorage')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('Signature') is not None:
            self.signature = m.get('Signature')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class GenerateDeviceNameListURLResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: GenerateDeviceNameListURLResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GenerateDeviceNameListURLResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GenerateDeviceNameListURLResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GenerateFileUploadURLRequest(TeaModel):
    def __init__(self, biz_code=None, file_name=None, file_suffix=None, iot_instance_id=None):
        self.biz_code = biz_code  # type: str
        self.file_name = file_name  # type: str
        self.file_suffix = file_suffix  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.biz_code, 'biz_code')
        self.validate_required(self.file_suffix, 'file_suffix')

    def to_map(self):
        _map = super(GenerateFileUploadURLRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_code is not None:
            result['BizCode'] = self.biz_code
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_suffix is not None:
            result['FileSuffix'] = self.file_suffix
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BizCode') is not None:
            self.biz_code = m.get('BizCode')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileSuffix') is not None:
            self.file_suffix = m.get('FileSuffix')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class GenerateFileUploadURLResponseData(TeaModel):
    def __init__(self, host=None, key=None, object_storage=None, oss_access_key_id=None, policy=None, signature=None):
        self.host = host  # type: str
        self.key = key  # type: str
        self.object_storage = object_storage  # type: str
        self.oss_access_key_id = oss_access_key_id  # type: str
        self.policy = policy  # type: str
        self.signature = signature  # type: str

    def validate(self):
        self.validate_required(self.host, 'host')
        self.validate_required(self.key, 'key')
        self.validate_required(self.object_storage, 'object_storage')
        self.validate_required(self.oss_access_key_id, 'oss_access_key_id')
        self.validate_required(self.policy, 'policy')
        self.validate_required(self.signature, 'signature')

    def to_map(self):
        _map = super(GenerateFileUploadURLResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.host is not None:
            result['Host'] = self.host
        if self.key is not None:
            result['Key'] = self.key
        if self.object_storage is not None:
            result['ObjectStorage'] = self.object_storage
        if self.oss_access_key_id is not None:
            result['OssAccessKeyId'] = self.oss_access_key_id
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.signature is not None:
            result['Signature'] = self.signature
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('ObjectStorage') is not None:
            self.object_storage = m.get('ObjectStorage')
        if m.get('OssAccessKeyId') is not None:
            self.oss_access_key_id = m.get('OssAccessKeyId')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('Signature') is not None:
            self.signature = m.get('Signature')
        return self


class GenerateFileUploadURLResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: GenerateFileUploadURLResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GenerateFileUploadURLResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GenerateFileUploadURLResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GenerateOTAUploadURLRequest(TeaModel):
    def __init__(self, file_suffix=None, iot_instance_id=None):
        self.file_suffix = file_suffix  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GenerateOTAUploadURLRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_suffix is not None:
            result['FileSuffix'] = self.file_suffix
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileSuffix') is not None:
            self.file_suffix = m.get('FileSuffix')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class GenerateOTAUploadURLResponseData(TeaModel):
    def __init__(self, firmware_url=None, host=None, key=None, ossaccess_key_id=None, object_storage=None,
                 policy=None, signature=None, utc_create=None):
        self.firmware_url = firmware_url  # type: str
        self.host = host  # type: str
        self.key = key  # type: str
        self.ossaccess_key_id = ossaccess_key_id  # type: str
        self.object_storage = object_storage  # type: str
        self.policy = policy  # type: str
        self.signature = signature  # type: str
        self.utc_create = utc_create  # type: str

    def validate(self):
        self.validate_required(self.firmware_url, 'firmware_url')
        self.validate_required(self.host, 'host')
        self.validate_required(self.key, 'key')
        self.validate_required(self.ossaccess_key_id, 'ossaccess_key_id')
        self.validate_required(self.object_storage, 'object_storage')
        self.validate_required(self.policy, 'policy')
        self.validate_required(self.signature, 'signature')
        self.validate_required(self.utc_create, 'utc_create')

    def to_map(self):
        _map = super(GenerateOTAUploadURLResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.firmware_url is not None:
            result['FirmwareUrl'] = self.firmware_url
        if self.host is not None:
            result['Host'] = self.host
        if self.key is not None:
            result['Key'] = self.key
        if self.ossaccess_key_id is not None:
            result['OSSAccessKeyId'] = self.ossaccess_key_id
        if self.object_storage is not None:
            result['ObjectStorage'] = self.object_storage
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.signature is not None:
            result['Signature'] = self.signature
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FirmwareUrl') is not None:
            self.firmware_url = m.get('FirmwareUrl')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('OSSAccessKeyId') is not None:
            self.ossaccess_key_id = m.get('OSSAccessKeyId')
        if m.get('ObjectStorage') is not None:
            self.object_storage = m.get('ObjectStorage')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('Signature') is not None:
            self.signature = m.get('Signature')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class GenerateOTAUploadURLResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: GenerateOTAUploadURLResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GenerateOTAUploadURLResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GenerateOTAUploadURLResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetDataAPIServiceDetailRequest(TeaModel):
    def __init__(self, api_srn=None, iot_instance_id=None):
        self.api_srn = api_srn  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.api_srn, 'api_srn')

    def to_map(self):
        _map = super(GetDataAPIServiceDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_srn is not None:
            result['ApiSrn'] = self.api_srn
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiSrn') is not None:
            self.api_srn = m.get('ApiSrn')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class GetDataAPIServiceDetailResponseDataSqlTemplateDTORequestParamsRequestParams(TeaModel):
    def __init__(self, desc=None, example=None, name=None, required=None, type=None):
        self.desc = desc  # type: str
        self.example = example  # type: str
        self.name = name  # type: str
        self.required = required  # type: bool
        self.type = type  # type: str

    def validate(self):
        self.validate_required(self.desc, 'desc')
        self.validate_required(self.example, 'example')
        self.validate_required(self.name, 'name')
        self.validate_required(self.required, 'required')
        self.validate_required(self.type, 'type')

    def to_map(self):
        _map = super(GetDataAPIServiceDetailResponseDataSqlTemplateDTORequestParamsRequestParams, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.example is not None:
            result['Example'] = self.example
        if self.name is not None:
            result['Name'] = self.name
        if self.required is not None:
            result['Required'] = self.required
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('Example') is not None:
            self.example = m.get('Example')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Required') is not None:
            self.required = m.get('Required')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetDataAPIServiceDetailResponseDataSqlTemplateDTORequestParams(TeaModel):
    def __init__(self, request_params=None):
        self.request_params = request_params  # type: list[GetDataAPIServiceDetailResponseDataSqlTemplateDTORequestParamsRequestParams]

    def validate(self):
        self.validate_required(self.request_params, 'request_params')
        if self.request_params:
            for k in self.request_params:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetDataAPIServiceDetailResponseDataSqlTemplateDTORequestParams, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RequestParams'] = []
        if self.request_params is not None:
            for k in self.request_params:
                result['RequestParams'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.request_params = []
        if m.get('RequestParams') is not None:
            for k in m.get('RequestParams'):
                temp_model = GetDataAPIServiceDetailResponseDataSqlTemplateDTORequestParamsRequestParams()
                self.request_params.append(temp_model.from_map(k))
        return self


class GetDataAPIServiceDetailResponseDataSqlTemplateDTOResponseParamsResponseParams(TeaModel):
    def __init__(self, desc=None, example=None, name=None, required=None, type=None):
        self.desc = desc  # type: str
        self.example = example  # type: str
        self.name = name  # type: str
        self.required = required  # type: bool
        self.type = type  # type: str

    def validate(self):
        self.validate_required(self.desc, 'desc')
        self.validate_required(self.example, 'example')
        self.validate_required(self.name, 'name')
        self.validate_required(self.required, 'required')
        self.validate_required(self.type, 'type')

    def to_map(self):
        _map = super(GetDataAPIServiceDetailResponseDataSqlTemplateDTOResponseParamsResponseParams, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.example is not None:
            result['Example'] = self.example
        if self.name is not None:
            result['Name'] = self.name
        if self.required is not None:
            result['Required'] = self.required
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('Example') is not None:
            self.example = m.get('Example')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Required') is not None:
            self.required = m.get('Required')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetDataAPIServiceDetailResponseDataSqlTemplateDTOResponseParams(TeaModel):
    def __init__(self, response_params=None):
        self.response_params = response_params  # type: list[GetDataAPIServiceDetailResponseDataSqlTemplateDTOResponseParamsResponseParams]

    def validate(self):
        self.validate_required(self.response_params, 'response_params')
        if self.response_params:
            for k in self.response_params:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetDataAPIServiceDetailResponseDataSqlTemplateDTOResponseParams, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ResponseParams'] = []
        if self.response_params is not None:
            for k in self.response_params:
                result['ResponseParams'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.response_params = []
        if m.get('ResponseParams') is not None:
            for k in m.get('ResponseParams'):
                temp_model = GetDataAPIServiceDetailResponseDataSqlTemplateDTOResponseParamsResponseParams()
                self.response_params.append(temp_model.from_map(k))
        return self


class GetDataAPIServiceDetailResponseDataSqlTemplateDTO(TeaModel):
    def __init__(self, origin_sql=None, template_sql=None, request_params=None, response_params=None):
        self.origin_sql = origin_sql  # type: str
        self.template_sql = template_sql  # type: str
        self.request_params = request_params  # type: GetDataAPIServiceDetailResponseDataSqlTemplateDTORequestParams
        self.response_params = response_params  # type: GetDataAPIServiceDetailResponseDataSqlTemplateDTOResponseParams

    def validate(self):
        self.validate_required(self.origin_sql, 'origin_sql')
        self.validate_required(self.template_sql, 'template_sql')
        self.validate_required(self.request_params, 'request_params')
        if self.request_params:
            self.request_params.validate()
        self.validate_required(self.response_params, 'response_params')
        if self.response_params:
            self.response_params.validate()

    def to_map(self):
        _map = super(GetDataAPIServiceDetailResponseDataSqlTemplateDTO, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.origin_sql is not None:
            result['OriginSql'] = self.origin_sql
        if self.template_sql is not None:
            result['TemplateSql'] = self.template_sql
        if self.request_params is not None:
            result['RequestParams'] = self.request_params.to_map()
        if self.response_params is not None:
            result['ResponseParams'] = self.response_params.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OriginSql') is not None:
            self.origin_sql = m.get('OriginSql')
        if m.get('TemplateSql') is not None:
            self.template_sql = m.get('TemplateSql')
        if m.get('RequestParams') is not None:
            temp_model = GetDataAPIServiceDetailResponseDataSqlTemplateDTORequestParams()
            self.request_params = temp_model.from_map(m['RequestParams'])
        if m.get('ResponseParams') is not None:
            temp_model = GetDataAPIServiceDetailResponseDataSqlTemplateDTOResponseParams()
            self.response_params = temp_model.from_map(m['ResponseParams'])
        return self


class GetDataAPIServiceDetailResponseData(TeaModel):
    def __init__(self, api_path=None, api_srn=None, create_time=None, date_format=None, description=None,
                 display_name=None, last_update_time=None, request_method=None, request_protocol=None, status=None,
                 sql_template_dto=None):
        self.api_path = api_path  # type: str
        self.api_srn = api_srn  # type: str
        self.create_time = create_time  # type: long
        self.date_format = date_format  # type: str
        self.description = description  # type: str
        self.display_name = display_name  # type: str
        self.last_update_time = last_update_time  # type: long
        self.request_method = request_method  # type: str
        self.request_protocol = request_protocol  # type: str
        self.status = status  # type: int
        self.sql_template_dto = sql_template_dto  # type: GetDataAPIServiceDetailResponseDataSqlTemplateDTO

    def validate(self):
        self.validate_required(self.api_path, 'api_path')
        self.validate_required(self.api_srn, 'api_srn')
        self.validate_required(self.create_time, 'create_time')
        self.validate_required(self.date_format, 'date_format')
        self.validate_required(self.description, 'description')
        self.validate_required(self.display_name, 'display_name')
        self.validate_required(self.last_update_time, 'last_update_time')
        self.validate_required(self.request_method, 'request_method')
        self.validate_required(self.request_protocol, 'request_protocol')
        self.validate_required(self.status, 'status')
        self.validate_required(self.sql_template_dto, 'sql_template_dto')
        if self.sql_template_dto:
            self.sql_template_dto.validate()

    def to_map(self):
        _map = super(GetDataAPIServiceDetailResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_path is not None:
            result['ApiPath'] = self.api_path
        if self.api_srn is not None:
            result['ApiSrn'] = self.api_srn
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.date_format is not None:
            result['DateFormat'] = self.date_format
        if self.description is not None:
            result['Description'] = self.description
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.last_update_time is not None:
            result['LastUpdateTime'] = self.last_update_time
        if self.request_method is not None:
            result['RequestMethod'] = self.request_method
        if self.request_protocol is not None:
            result['RequestProtocol'] = self.request_protocol
        if self.status is not None:
            result['Status'] = self.status
        if self.sql_template_dto is not None:
            result['SqlTemplateDTO'] = self.sql_template_dto.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiPath') is not None:
            self.api_path = m.get('ApiPath')
        if m.get('ApiSrn') is not None:
            self.api_srn = m.get('ApiSrn')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DateFormat') is not None:
            self.date_format = m.get('DateFormat')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('LastUpdateTime') is not None:
            self.last_update_time = m.get('LastUpdateTime')
        if m.get('RequestMethod') is not None:
            self.request_method = m.get('RequestMethod')
        if m.get('RequestProtocol') is not None:
            self.request_protocol = m.get('RequestProtocol')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SqlTemplateDTO') is not None:
            temp_model = GetDataAPIServiceDetailResponseDataSqlTemplateDTO()
            self.sql_template_dto = temp_model.from_map(m['SqlTemplateDTO'])
        return self


class GetDataAPIServiceDetailResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: GetDataAPIServiceDetailResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetDataAPIServiceDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetDataAPIServiceDetailResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetDestinationRequest(TeaModel):
    def __init__(self, destination_id=None, iot_instance_id=None):
        self.destination_id = destination_id  # type: long
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.destination_id, 'destination_id')

    def to_map(self):
        _map = super(GetDestinationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.destination_id is not None:
            result['DestinationId'] = self.destination_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DestinationId') is not None:
            self.destination_id = m.get('DestinationId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class GetDestinationResponseDestination(TeaModel):
    def __init__(self, configuration=None, destination_id=None, is_failover=None, name=None, status=None, type=None,
                 utc_created=None):
        self.configuration = configuration  # type: str
        self.destination_id = destination_id  # type: str
        self.is_failover = is_failover  # type: bool
        self.name = name  # type: str
        self.status = status  # type: str
        self.type = type  # type: str
        self.utc_created = utc_created  # type: str

    def validate(self):
        self.validate_required(self.configuration, 'configuration')
        self.validate_required(self.destination_id, 'destination_id')
        self.validate_required(self.is_failover, 'is_failover')
        self.validate_required(self.name, 'name')
        self.validate_required(self.status, 'status')
        self.validate_required(self.type, 'type')
        self.validate_required(self.utc_created, 'utc_created')

    def to_map(self):
        _map = super(GetDestinationResponseDestination, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.configuration is not None:
            result['Configuration'] = self.configuration
        if self.destination_id is not None:
            result['DestinationId'] = self.destination_id
        if self.is_failover is not None:
            result['IsFailover'] = self.is_failover
        if self.name is not None:
            result['Name'] = self.name
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.utc_created is not None:
            result['UtcCreated'] = self.utc_created
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Configuration') is not None:
            self.configuration = m.get('Configuration')
        if m.get('DestinationId') is not None:
            self.destination_id = m.get('DestinationId')
        if m.get('IsFailover') is not None:
            self.is_failover = m.get('IsFailover')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UtcCreated') is not None:
            self.utc_created = m.get('UtcCreated')
        return self


class GetDestinationResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, destination=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.destination = destination  # type: GetDestinationResponseDestination

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.destination, 'destination')
        if self.destination:
            self.destination.validate()

    def to_map(self):
        _map = super(GetDestinationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.destination is not None:
            result['Destination'] = self.destination.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Destination') is not None:
            temp_model = GetDestinationResponseDestination()
            self.destination = temp_model.from_map(m['Destination'])
        return self


class GetDeviceShadowRequest(TeaModel):
    def __init__(self, device_name=None, iot_instance_id=None, product_key=None):
        self.device_name = device_name  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        _map = super(GetDeviceShadowRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class GetDeviceShadowResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, shadow_message=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.shadow_message = shadow_message  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.shadow_message, 'shadow_message')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(GetDeviceShadowResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.shadow_message is not None:
            result['ShadowMessage'] = self.shadow_message
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ShadowMessage') is not None:
            self.shadow_message = m.get('ShadowMessage')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDeviceStatusRequest(TeaModel):
    def __init__(self, device_name=None, iot_id=None, iot_instance_id=None, product_key=None):
        self.device_name = device_name  # type: str
        self.iot_id = iot_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDeviceStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class GetDeviceStatusResponseData(TeaModel):
    def __init__(self, status=None, timestamp=None):
        self.status = status  # type: str
        self.timestamp = timestamp  # type: long

    def validate(self):
        self.validate_required(self.status, 'status')
        self.validate_required(self.timestamp, 'timestamp')

    def to_map(self):
        _map = super(GetDeviceStatusResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        return self


class GetDeviceStatusResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: GetDeviceStatusResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetDeviceStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetDeviceStatusResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetDeviceTunnelShareStatusRequest(TeaModel):
    def __init__(self, device_name=None, iot_instance_id=None, product_key=None):
        self.device_name = device_name  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        _map = super(GetDeviceTunnelShareStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class GetDeviceTunnelShareStatusResponseData(TeaModel):
    def __init__(self, gmt_opened=None, is_open=None, password=None, share_id=None):
        self.gmt_opened = gmt_opened  # type: long
        self.is_open = is_open  # type: bool
        self.password = password  # type: str
        self.share_id = share_id  # type: str

    def validate(self):
        self.validate_required(self.gmt_opened, 'gmt_opened')
        self.validate_required(self.is_open, 'is_open')
        self.validate_required(self.password, 'password')
        self.validate_required(self.share_id, 'share_id')

    def to_map(self):
        _map = super(GetDeviceTunnelShareStatusResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_opened is not None:
            result['GmtOpened'] = self.gmt_opened
        if self.is_open is not None:
            result['IsOpen'] = self.is_open
        if self.password is not None:
            result['Password'] = self.password
        if self.share_id is not None:
            result['ShareId'] = self.share_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GmtOpened') is not None:
            self.gmt_opened = m.get('GmtOpened')
        if m.get('IsOpen') is not None:
            self.is_open = m.get('IsOpen')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('ShareId') is not None:
            self.share_id = m.get('ShareId')
        return self


class GetDeviceTunnelShareStatusResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: GetDeviceTunnelShareStatusResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetDeviceTunnelShareStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetDeviceTunnelShareStatusResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetDeviceTunnelStatusRequest(TeaModel):
    def __init__(self, device_name=None, iot_instance_id=None, product_key=None):
        self.device_name = device_name  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        _map = super(GetDeviceTunnelStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class GetDeviceTunnelStatusResponse(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.data, 'data')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(GetDeviceTunnelStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDownloadFileRequest(TeaModel):
    def __init__(self, context=None, iot_instance_id=None, long_job_id=None):
        self.context = context  # type: dict[str, any]
        self.iot_instance_id = iot_instance_id  # type: str
        self.long_job_id = long_job_id  # type: str

    def validate(self):
        self.validate_required(self.long_job_id, 'long_job_id')

    def to_map(self):
        _map = super(GetDownloadFileRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.context is not None:
            result['Context'] = self.context
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.long_job_id is not None:
            result['LongJobId'] = self.long_job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Context') is not None:
            self.context = m.get('Context')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('LongJobId') is not None:
            self.long_job_id = m.get('LongJobId')
        return self


class GetDownloadFileShrinkRequest(TeaModel):
    def __init__(self, context_shrink=None, iot_instance_id=None, long_job_id=None):
        self.context_shrink = context_shrink  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.long_job_id = long_job_id  # type: str

    def validate(self):
        self.validate_required(self.long_job_id, 'long_job_id')

    def to_map(self):
        _map = super(GetDownloadFileShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.context_shrink is not None:
            result['Context'] = self.context_shrink
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.long_job_id is not None:
            result['LongJobId'] = self.long_job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Context') is not None:
            self.context_shrink = m.get('Context')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('LongJobId') is not None:
            self.long_job_id = m.get('LongJobId')
        return self


class GetDownloadFileResponseDataHeader(TeaModel):
    def __init__(self, alias=None, dim_date_class=None, field_name=None, field_type=None, geo_class=None,
                 time_class=None, type_class=None):
        self.alias = alias  # type: str
        self.dim_date_class = dim_date_class  # type: str
        self.field_name = field_name  # type: str
        self.field_type = field_type  # type: str
        self.geo_class = geo_class  # type: str
        self.time_class = time_class  # type: str
        self.type_class = type_class  # type: str

    def validate(self):
        self.validate_required(self.alias, 'alias')
        self.validate_required(self.dim_date_class, 'dim_date_class')
        self.validate_required(self.field_name, 'field_name')
        self.validate_required(self.field_type, 'field_type')
        self.validate_required(self.geo_class, 'geo_class')
        self.validate_required(self.time_class, 'time_class')
        self.validate_required(self.type_class, 'type_class')

    def to_map(self):
        _map = super(GetDownloadFileResponseDataHeader, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias is not None:
            result['Alias'] = self.alias
        if self.dim_date_class is not None:
            result['DimDateClass'] = self.dim_date_class
        if self.field_name is not None:
            result['FieldName'] = self.field_name
        if self.field_type is not None:
            result['FieldType'] = self.field_type
        if self.geo_class is not None:
            result['GeoClass'] = self.geo_class
        if self.time_class is not None:
            result['TimeClass'] = self.time_class
        if self.type_class is not None:
            result['TypeClass'] = self.type_class
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        if m.get('DimDateClass') is not None:
            self.dim_date_class = m.get('DimDateClass')
        if m.get('FieldName') is not None:
            self.field_name = m.get('FieldName')
        if m.get('FieldType') is not None:
            self.field_type = m.get('FieldType')
        if m.get('GeoClass') is not None:
            self.geo_class = m.get('GeoClass')
        if m.get('TimeClass') is not None:
            self.time_class = m.get('TimeClass')
        if m.get('TypeClass') is not None:
            self.type_class = m.get('TypeClass')
        return self


class GetDownloadFileResponseDataQuerySettingAstExpr(TeaModel):
    def __init__(self, expr=None, expr_type=None):
        self.expr = expr  # type: str
        self.expr_type = expr_type  # type: str

    def validate(self):
        self.validate_required(self.expr, 'expr')
        self.validate_required(self.expr_type, 'expr_type')

    def to_map(self):
        _map = super(GetDownloadFileResponseDataQuerySettingAstExpr, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expr is not None:
            result['Expr'] = self.expr
        if self.expr_type is not None:
            result['ExprType'] = self.expr_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Expr') is not None:
            self.expr = m.get('Expr')
        if m.get('ExprType') is not None:
            self.expr_type = m.get('ExprType')
        return self


class GetDownloadFileResponseDataQuerySettingSelectedHeaders(TeaModel):
    def __init__(self, alias=None, dim_date_class=None, field_name=None, field_type=None, geo_class=None,
                 time_class=None):
        self.alias = alias  # type: str
        self.dim_date_class = dim_date_class  # type: str
        self.field_name = field_name  # type: str
        self.field_type = field_type  # type: str
        self.geo_class = geo_class  # type: str
        self.time_class = time_class  # type: str

    def validate(self):
        self.validate_required(self.alias, 'alias')
        self.validate_required(self.dim_date_class, 'dim_date_class')
        self.validate_required(self.field_name, 'field_name')
        self.validate_required(self.field_type, 'field_type')
        self.validate_required(self.geo_class, 'geo_class')
        self.validate_required(self.time_class, 'time_class')

    def to_map(self):
        _map = super(GetDownloadFileResponseDataQuerySettingSelectedHeaders, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias is not None:
            result['Alias'] = self.alias
        if self.dim_date_class is not None:
            result['DimDateClass'] = self.dim_date_class
        if self.field_name is not None:
            result['FieldName'] = self.field_name
        if self.field_type is not None:
            result['FieldType'] = self.field_type
        if self.geo_class is not None:
            result['GeoClass'] = self.geo_class
        if self.time_class is not None:
            result['TimeClass'] = self.time_class
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        if m.get('DimDateClass') is not None:
            self.dim_date_class = m.get('DimDateClass')
        if m.get('FieldName') is not None:
            self.field_name = m.get('FieldName')
        if m.get('FieldType') is not None:
            self.field_type = m.get('FieldType')
        if m.get('GeoClass') is not None:
            self.geo_class = m.get('GeoClass')
        if m.get('TimeClass') is not None:
            self.time_class = m.get('TimeClass')
        return self


class GetDownloadFileResponseDataQuerySetting(TeaModel):
    def __init__(self, ast_expr=None, selected_headers=None):
        self.ast_expr = ast_expr  # type: list[GetDownloadFileResponseDataQuerySettingAstExpr]
        self.selected_headers = selected_headers  # type: list[GetDownloadFileResponseDataQuerySettingSelectedHeaders]

    def validate(self):
        self.validate_required(self.ast_expr, 'ast_expr')
        if self.ast_expr:
            for k in self.ast_expr:
                if k:
                    k.validate()
        self.validate_required(self.selected_headers, 'selected_headers')
        if self.selected_headers:
            for k in self.selected_headers:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetDownloadFileResponseDataQuerySetting, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AstExpr'] = []
        if self.ast_expr is not None:
            for k in self.ast_expr:
                result['AstExpr'].append(k.to_map() if k else None)
        result['SelectedHeaders'] = []
        if self.selected_headers is not None:
            for k in self.selected_headers:
                result['SelectedHeaders'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.ast_expr = []
        if m.get('AstExpr') is not None:
            for k in m.get('AstExpr'):
                temp_model = GetDownloadFileResponseDataQuerySettingAstExpr()
                self.ast_expr.append(temp_model.from_map(k))
        self.selected_headers = []
        if m.get('SelectedHeaders') is not None:
            for k in m.get('SelectedHeaders'):
                temp_model = GetDownloadFileResponseDataQuerySettingSelectedHeaders()
                self.selected_headers.append(temp_model.from_map(k))
        return self


class GetDownloadFileResponseData(TeaModel):
    def __init__(self, async_execute=None, begin_time=None, csv_file_name=None, csv_url=None, dataset_id=None,
                 end_time=None, long_job_id=None, page_no=None, page_size=None, preview_size=None,
                 result_data_in_string=None, status=None, total_count=None, header=None, query_setting=None, result=None):
        self.async_execute = async_execute  # type: bool
        self.begin_time = begin_time  # type: long
        self.csv_file_name = csv_file_name  # type: str
        self.csv_url = csv_url  # type: str
        self.dataset_id = dataset_id  # type: str
        self.end_time = end_time  # type: long
        self.long_job_id = long_job_id  # type: str
        self.page_no = page_no  # type: int
        self.page_size = page_size  # type: int
        self.preview_size = preview_size  # type: int
        self.result_data_in_string = result_data_in_string  # type: str
        self.status = status  # type: int
        self.total_count = total_count  # type: long
        self.header = header  # type: list[GetDownloadFileResponseDataHeader]
        self.query_setting = query_setting  # type: GetDownloadFileResponseDataQuerySetting
        self.result = result  # type: list[dict[str, any]]

    def validate(self):
        self.validate_required(self.async_execute, 'async_execute')
        self.validate_required(self.begin_time, 'begin_time')
        self.validate_required(self.csv_file_name, 'csv_file_name')
        self.validate_required(self.csv_url, 'csv_url')
        self.validate_required(self.dataset_id, 'dataset_id')
        self.validate_required(self.end_time, 'end_time')
        self.validate_required(self.long_job_id, 'long_job_id')
        self.validate_required(self.page_no, 'page_no')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.preview_size, 'preview_size')
        self.validate_required(self.result_data_in_string, 'result_data_in_string')
        self.validate_required(self.status, 'status')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.header, 'header')
        if self.header:
            for k in self.header:
                if k:
                    k.validate()
        self.validate_required(self.query_setting, 'query_setting')
        if self.query_setting:
            self.query_setting.validate()
        self.validate_required(self.result, 'result')

    def to_map(self):
        _map = super(GetDownloadFileResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.async_execute is not None:
            result['AsyncExecute'] = self.async_execute
        if self.begin_time is not None:
            result['BeginTime'] = self.begin_time
        if self.csv_file_name is not None:
            result['CsvFileName'] = self.csv_file_name
        if self.csv_url is not None:
            result['CsvUrl'] = self.csv_url
        if self.dataset_id is not None:
            result['DatasetId'] = self.dataset_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.long_job_id is not None:
            result['LongJobId'] = self.long_job_id
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.preview_size is not None:
            result['PreviewSize'] = self.preview_size
        if self.result_data_in_string is not None:
            result['ResultDataInString'] = self.result_data_in_string
        if self.status is not None:
            result['Status'] = self.status
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['Header'] = []
        if self.header is not None:
            for k in self.header:
                result['Header'].append(k.to_map() if k else None)
        if self.query_setting is not None:
            result['QuerySetting'] = self.query_setting.to_map()
        if self.result is not None:
            result['Result'] = self.result
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AsyncExecute') is not None:
            self.async_execute = m.get('AsyncExecute')
        if m.get('BeginTime') is not None:
            self.begin_time = m.get('BeginTime')
        if m.get('CsvFileName') is not None:
            self.csv_file_name = m.get('CsvFileName')
        if m.get('CsvUrl') is not None:
            self.csv_url = m.get('CsvUrl')
        if m.get('DatasetId') is not None:
            self.dataset_id = m.get('DatasetId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('LongJobId') is not None:
            self.long_job_id = m.get('LongJobId')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PreviewSize') is not None:
            self.preview_size = m.get('PreviewSize')
        if m.get('ResultDataInString') is not None:
            self.result_data_in_string = m.get('ResultDataInString')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.header = []
        if m.get('Header') is not None:
            for k in m.get('Header'):
                temp_model = GetDownloadFileResponseDataHeader()
                self.header.append(temp_model.from_map(k))
        if m.get('QuerySetting') is not None:
            temp_model = GetDownloadFileResponseDataQuerySetting()
            self.query_setting = temp_model.from_map(m['QuerySetting'])
        if m.get('Result') is not None:
            self.result = m.get('Result')
        return self


class GetDownloadFileResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: GetDownloadFileResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetDownloadFileResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetDownloadFileResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetEdgeDriverVersionRequest(TeaModel):
    def __init__(self, driver_id=None, driver_version=None, iot_instance_id=None):
        self.driver_id = driver_id  # type: str
        self.driver_version = driver_version  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.driver_version, 'driver_version')

    def to_map(self):
        _map = super(GetEdgeDriverVersionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class GetEdgeDriverVersionResponseData(TeaModel):
    def __init__(self, argument=None, config_check_rule=None, container_config=None, description=None,
                 driver_config=None, driver_id=None, driver_version=None, edge_version=None, gmt_create_timestamp=None,
                 gmt_modified_timestamp=None, source_config=None, version_state=None):
        self.argument = argument  # type: str
        self.config_check_rule = config_check_rule  # type: str
        self.container_config = container_config  # type: str
        self.description = description  # type: str
        self.driver_config = driver_config  # type: str
        self.driver_id = driver_id  # type: str
        self.driver_version = driver_version  # type: str
        self.edge_version = edge_version  # type: str
        self.gmt_create_timestamp = gmt_create_timestamp  # type: long
        self.gmt_modified_timestamp = gmt_modified_timestamp  # type: long
        self.source_config = source_config  # type: str
        self.version_state = version_state  # type: str

    def validate(self):
        self.validate_required(self.argument, 'argument')
        self.validate_required(self.config_check_rule, 'config_check_rule')
        self.validate_required(self.container_config, 'container_config')
        self.validate_required(self.description, 'description')
        self.validate_required(self.driver_config, 'driver_config')
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.driver_version, 'driver_version')
        self.validate_required(self.edge_version, 'edge_version')
        self.validate_required(self.gmt_create_timestamp, 'gmt_create_timestamp')
        self.validate_required(self.gmt_modified_timestamp, 'gmt_modified_timestamp')
        self.validate_required(self.source_config, 'source_config')
        self.validate_required(self.version_state, 'version_state')

    def to_map(self):
        _map = super(GetEdgeDriverVersionResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.argument is not None:
            result['Argument'] = self.argument
        if self.config_check_rule is not None:
            result['ConfigCheckRule'] = self.config_check_rule
        if self.container_config is not None:
            result['ContainerConfig'] = self.container_config
        if self.description is not None:
            result['Description'] = self.description
        if self.driver_config is not None:
            result['DriverConfig'] = self.driver_config
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        if self.edge_version is not None:
            result['EdgeVersion'] = self.edge_version
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.source_config is not None:
            result['SourceConfig'] = self.source_config
        if self.version_state is not None:
            result['VersionState'] = self.version_state
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Argument') is not None:
            self.argument = m.get('Argument')
        if m.get('ConfigCheckRule') is not None:
            self.config_check_rule = m.get('ConfigCheckRule')
        if m.get('ContainerConfig') is not None:
            self.container_config = m.get('ContainerConfig')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DriverConfig') is not None:
            self.driver_config = m.get('DriverConfig')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        if m.get('EdgeVersion') is not None:
            self.edge_version = m.get('EdgeVersion')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('SourceConfig') is not None:
            self.source_config = m.get('SourceConfig')
        if m.get('VersionState') is not None:
            self.version_state = m.get('VersionState')
        return self


class GetEdgeDriverVersionResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: GetEdgeDriverVersionResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetEdgeDriverVersionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetEdgeDriverVersionResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetEdgeInstanceRequest(TeaModel):
    def __init__(self, instance_id=None, iot_instance_id=None):
        self.instance_id = instance_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        _map = super(GetEdgeInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class GetEdgeInstanceResponseData(TeaModel):
    def __init__(self, biz_enable=None, gmt_create=None, gmt_create_timestamp=None, gmt_modified=None,
                 gmt_modified_timestamp=None, instance_id=None, latest_deployment_status=None, latest_deployment_type=None, name=None,
                 role_arn=None, role_attach_time=None, role_attach_timestamp=None, role_name=None, spec=None, tags=None,
                 type=None):
        self.biz_enable = biz_enable  # type: bool
        self.gmt_create = gmt_create  # type: str
        self.gmt_create_timestamp = gmt_create_timestamp  # type: long
        self.gmt_modified = gmt_modified  # type: str
        self.gmt_modified_timestamp = gmt_modified_timestamp  # type: long
        self.instance_id = instance_id  # type: str
        self.latest_deployment_status = latest_deployment_status  # type: int
        self.latest_deployment_type = latest_deployment_type  # type: str
        self.name = name  # type: str
        self.role_arn = role_arn  # type: str
        self.role_attach_time = role_attach_time  # type: str
        self.role_attach_timestamp = role_attach_timestamp  # type: long
        self.role_name = role_name  # type: str
        self.spec = spec  # type: int
        self.tags = tags  # type: str
        self.type = type  # type: str

    def validate(self):
        self.validate_required(self.biz_enable, 'biz_enable')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_create_timestamp, 'gmt_create_timestamp')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.gmt_modified_timestamp, 'gmt_modified_timestamp')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.latest_deployment_status, 'latest_deployment_status')
        self.validate_required(self.latest_deployment_type, 'latest_deployment_type')
        self.validate_required(self.name, 'name')
        self.validate_required(self.role_arn, 'role_arn')
        self.validate_required(self.role_attach_time, 'role_attach_time')
        self.validate_required(self.role_attach_timestamp, 'role_attach_timestamp')
        self.validate_required(self.role_name, 'role_name')
        self.validate_required(self.spec, 'spec')
        self.validate_required(self.tags, 'tags')
        self.validate_required(self.type, 'type')

    def to_map(self):
        _map = super(GetEdgeInstanceResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_enable is not None:
            result['BizEnable'] = self.biz_enable
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.latest_deployment_status is not None:
            result['LatestDeploymentStatus'] = self.latest_deployment_status
        if self.latest_deployment_type is not None:
            result['LatestDeploymentType'] = self.latest_deployment_type
        if self.name is not None:
            result['Name'] = self.name
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        if self.role_attach_time is not None:
            result['RoleAttachTime'] = self.role_attach_time
        if self.role_attach_timestamp is not None:
            result['RoleAttachTimestamp'] = self.role_attach_timestamp
        if self.role_name is not None:
            result['RoleName'] = self.role_name
        if self.spec is not None:
            result['Spec'] = self.spec
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BizEnable') is not None:
            self.biz_enable = m.get('BizEnable')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LatestDeploymentStatus') is not None:
            self.latest_deployment_status = m.get('LatestDeploymentStatus')
        if m.get('LatestDeploymentType') is not None:
            self.latest_deployment_type = m.get('LatestDeploymentType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        if m.get('RoleAttachTime') is not None:
            self.role_attach_time = m.get('RoleAttachTime')
        if m.get('RoleAttachTimestamp') is not None:
            self.role_attach_timestamp = m.get('RoleAttachTimestamp')
        if m.get('RoleName') is not None:
            self.role_name = m.get('RoleName')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetEdgeInstanceResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: GetEdgeInstanceResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetEdgeInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetEdgeInstanceResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetEdgeInstanceDeploymentRequest(TeaModel):
    def __init__(self, deployment_id=None, instance_id=None, iot_instance_id=None):
        self.deployment_id = deployment_id  # type: str
        self.instance_id = instance_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.deployment_id, 'deployment_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        _map = super(GetEdgeInstanceDeploymentRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deployment_id is not None:
            result['DeploymentId'] = self.deployment_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeploymentId') is not None:
            self.deployment_id = m.get('DeploymentId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class GetEdgeInstanceDeploymentResponseDataTaskListResourceSnapshotList(TeaModel):
    def __init__(self, gmt_completed=None, gmt_completed_timestamp=None, gmt_create=None,
                 gmt_create_timestamp=None, gmt_modified=None, gmt_modified_timestamp=None, log=None, operate_type=None,
                 resource_id=None, resource_name=None, resource_type=None, snapshot_id=None, stage=None, status=None):
        self.gmt_completed = gmt_completed  # type: str
        self.gmt_completed_timestamp = gmt_completed_timestamp  # type: long
        self.gmt_create = gmt_create  # type: str
        self.gmt_create_timestamp = gmt_create_timestamp  # type: long
        self.gmt_modified = gmt_modified  # type: str
        self.gmt_modified_timestamp = gmt_modified_timestamp  # type: long
        self.log = log  # type: str
        self.operate_type = operate_type  # type: int
        self.resource_id = resource_id  # type: str
        self.resource_name = resource_name  # type: str
        self.resource_type = resource_type  # type: str
        self.snapshot_id = snapshot_id  # type: str
        self.stage = stage  # type: int
        self.status = status  # type: int

    def validate(self):
        self.validate_required(self.gmt_completed, 'gmt_completed')
        self.validate_required(self.gmt_completed_timestamp, 'gmt_completed_timestamp')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_create_timestamp, 'gmt_create_timestamp')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.gmt_modified_timestamp, 'gmt_modified_timestamp')
        self.validate_required(self.log, 'log')
        self.validate_required(self.operate_type, 'operate_type')
        self.validate_required(self.resource_id, 'resource_id')
        self.validate_required(self.resource_name, 'resource_name')
        self.validate_required(self.resource_type, 'resource_type')
        self.validate_required(self.snapshot_id, 'snapshot_id')
        self.validate_required(self.stage, 'stage')
        self.validate_required(self.status, 'status')

    def to_map(self):
        _map = super(GetEdgeInstanceDeploymentResponseDataTaskListResourceSnapshotList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_completed is not None:
            result['GmtCompleted'] = self.gmt_completed
        if self.gmt_completed_timestamp is not None:
            result['GmtCompletedTimestamp'] = self.gmt_completed_timestamp
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.log is not None:
            result['Log'] = self.log
        if self.operate_type is not None:
            result['OperateType'] = self.operate_type
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_name is not None:
            result['ResourceName'] = self.resource_name
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.stage is not None:
            result['Stage'] = self.stage
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GmtCompleted') is not None:
            self.gmt_completed = m.get('GmtCompleted')
        if m.get('GmtCompletedTimestamp') is not None:
            self.gmt_completed_timestamp = m.get('GmtCompletedTimestamp')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('Log') is not None:
            self.log = m.get('Log')
        if m.get('OperateType') is not None:
            self.operate_type = m.get('OperateType')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceName') is not None:
            self.resource_name = m.get('ResourceName')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        if m.get('Stage') is not None:
            self.stage = m.get('Stage')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetEdgeInstanceDeploymentResponseDataTaskList(TeaModel):
    def __init__(self, gateway_id=None, gmt_completed=None, gmt_completed_timestamp=None, gmt_create=None,
                 gmt_create_timestamp=None, gmt_modified=None, gmt_modified_timestamp=None, stage=None, status=None, task_id=None,
                 resource_snapshot_list=None):
        self.gateway_id = gateway_id  # type: str
        self.gmt_completed = gmt_completed  # type: str
        self.gmt_completed_timestamp = gmt_completed_timestamp  # type: long
        self.gmt_create = gmt_create  # type: str
        self.gmt_create_timestamp = gmt_create_timestamp  # type: long
        self.gmt_modified = gmt_modified  # type: str
        self.gmt_modified_timestamp = gmt_modified_timestamp  # type: long
        self.stage = stage  # type: int
        self.status = status  # type: int
        self.task_id = task_id  # type: str
        self.resource_snapshot_list = resource_snapshot_list  # type: list[GetEdgeInstanceDeploymentResponseDataTaskListResourceSnapshotList]

    def validate(self):
        self.validate_required(self.gateway_id, 'gateway_id')
        self.validate_required(self.gmt_completed, 'gmt_completed')
        self.validate_required(self.gmt_completed_timestamp, 'gmt_completed_timestamp')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_create_timestamp, 'gmt_create_timestamp')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.gmt_modified_timestamp, 'gmt_modified_timestamp')
        self.validate_required(self.stage, 'stage')
        self.validate_required(self.status, 'status')
        self.validate_required(self.task_id, 'task_id')
        self.validate_required(self.resource_snapshot_list, 'resource_snapshot_list')
        if self.resource_snapshot_list:
            for k in self.resource_snapshot_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetEdgeInstanceDeploymentResponseDataTaskList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gateway_id is not None:
            result['GatewayId'] = self.gateway_id
        if self.gmt_completed is not None:
            result['GmtCompleted'] = self.gmt_completed
        if self.gmt_completed_timestamp is not None:
            result['GmtCompletedTimestamp'] = self.gmt_completed_timestamp
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.stage is not None:
            result['Stage'] = self.stage
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        result['ResourceSnapshotList'] = []
        if self.resource_snapshot_list is not None:
            for k in self.resource_snapshot_list:
                result['ResourceSnapshotList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GatewayId') is not None:
            self.gateway_id = m.get('GatewayId')
        if m.get('GmtCompleted') is not None:
            self.gmt_completed = m.get('GmtCompleted')
        if m.get('GmtCompletedTimestamp') is not None:
            self.gmt_completed_timestamp = m.get('GmtCompletedTimestamp')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('Stage') is not None:
            self.stage = m.get('Stage')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        self.resource_snapshot_list = []
        if m.get('ResourceSnapshotList') is not None:
            for k in m.get('ResourceSnapshotList'):
                temp_model = GetEdgeInstanceDeploymentResponseDataTaskListResourceSnapshotList()
                self.resource_snapshot_list.append(temp_model.from_map(k))
        return self


class GetEdgeInstanceDeploymentResponseData(TeaModel):
    def __init__(self, deployment_id=None, description=None, gmt_completed=None, gmt_completed_timestamp=None,
                 gmt_create=None, gmt_create_timestamp=None, gmt_modified=None, gmt_modified_timestamp=None, status=None,
                 type=None, task_list=None):
        self.deployment_id = deployment_id  # type: str
        self.description = description  # type: str
        self.gmt_completed = gmt_completed  # type: str
        self.gmt_completed_timestamp = gmt_completed_timestamp  # type: long
        self.gmt_create = gmt_create  # type: str
        self.gmt_create_timestamp = gmt_create_timestamp  # type: long
        self.gmt_modified = gmt_modified  # type: str
        self.gmt_modified_timestamp = gmt_modified_timestamp  # type: long
        self.status = status  # type: int
        self.type = type  # type: str
        self.task_list = task_list  # type: list[GetEdgeInstanceDeploymentResponseDataTaskList]

    def validate(self):
        self.validate_required(self.deployment_id, 'deployment_id')
        self.validate_required(self.description, 'description')
        self.validate_required(self.gmt_completed, 'gmt_completed')
        self.validate_required(self.gmt_completed_timestamp, 'gmt_completed_timestamp')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_create_timestamp, 'gmt_create_timestamp')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.gmt_modified_timestamp, 'gmt_modified_timestamp')
        self.validate_required(self.status, 'status')
        self.validate_required(self.type, 'type')
        self.validate_required(self.task_list, 'task_list')
        if self.task_list:
            for k in self.task_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetEdgeInstanceDeploymentResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deployment_id is not None:
            result['DeploymentId'] = self.deployment_id
        if self.description is not None:
            result['Description'] = self.description
        if self.gmt_completed is not None:
            result['GmtCompleted'] = self.gmt_completed
        if self.gmt_completed_timestamp is not None:
            result['GmtCompletedTimestamp'] = self.gmt_completed_timestamp
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        result['TaskList'] = []
        if self.task_list is not None:
            for k in self.task_list:
                result['TaskList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeploymentId') is not None:
            self.deployment_id = m.get('DeploymentId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GmtCompleted') is not None:
            self.gmt_completed = m.get('GmtCompleted')
        if m.get('GmtCompletedTimestamp') is not None:
            self.gmt_completed_timestamp = m.get('GmtCompletedTimestamp')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        self.task_list = []
        if m.get('TaskList') is not None:
            for k in m.get('TaskList'):
                temp_model = GetEdgeInstanceDeploymentResponseDataTaskList()
                self.task_list.append(temp_model.from_map(k))
        return self


class GetEdgeInstanceDeploymentResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: GetEdgeInstanceDeploymentResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetEdgeInstanceDeploymentResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetEdgeInstanceDeploymentResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetEdgeInstanceMessageRoutingRequest(TeaModel):
    def __init__(self, instance_id=None, iot_instance_id=None, route_id=None):
        self.instance_id = instance_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.route_id = route_id  # type: long

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.route_id, 'route_id')

    def to_map(self):
        _map = super(GetEdgeInstanceMessageRoutingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.route_id is not None:
            result['RouteId'] = self.route_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RouteId') is not None:
            self.route_id = m.get('RouteId')
        return self


class GetEdgeInstanceMessageRoutingResponseDataRouteContext(TeaModel):
    def __init__(self, qos=None, source_application_name=None, source_fc_function_name=None,
                 source_fc_service_name=None, target_application_name=None, target_fc_function_name=None, target_fc_service_name=None):
        self.qos = qos  # type: str
        self.source_application_name = source_application_name  # type: str
        self.source_fc_function_name = source_fc_function_name  # type: str
        self.source_fc_service_name = source_fc_service_name  # type: str
        self.target_application_name = target_application_name  # type: str
        self.target_fc_function_name = target_fc_function_name  # type: str
        self.target_fc_service_name = target_fc_service_name  # type: str

    def validate(self):
        self.validate_required(self.qos, 'qos')
        self.validate_required(self.source_application_name, 'source_application_name')
        self.validate_required(self.source_fc_function_name, 'source_fc_function_name')
        self.validate_required(self.source_fc_service_name, 'source_fc_service_name')
        self.validate_required(self.target_application_name, 'target_application_name')
        self.validate_required(self.target_fc_function_name, 'target_fc_function_name')
        self.validate_required(self.target_fc_service_name, 'target_fc_service_name')

    def to_map(self):
        _map = super(GetEdgeInstanceMessageRoutingResponseDataRouteContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.qos is not None:
            result['Qos'] = self.qos
        if self.source_application_name is not None:
            result['SourceApplicationName'] = self.source_application_name
        if self.source_fc_function_name is not None:
            result['SourceFcFunctionName'] = self.source_fc_function_name
        if self.source_fc_service_name is not None:
            result['SourceFcServiceName'] = self.source_fc_service_name
        if self.target_application_name is not None:
            result['TargetApplicationName'] = self.target_application_name
        if self.target_fc_function_name is not None:
            result['TargetFcFunctionName'] = self.target_fc_function_name
        if self.target_fc_service_name is not None:
            result['TargetFcServiceName'] = self.target_fc_service_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Qos') is not None:
            self.qos = m.get('Qos')
        if m.get('SourceApplicationName') is not None:
            self.source_application_name = m.get('SourceApplicationName')
        if m.get('SourceFcFunctionName') is not None:
            self.source_fc_function_name = m.get('SourceFcFunctionName')
        if m.get('SourceFcServiceName') is not None:
            self.source_fc_service_name = m.get('SourceFcServiceName')
        if m.get('TargetApplicationName') is not None:
            self.target_application_name = m.get('TargetApplicationName')
        if m.get('TargetFcFunctionName') is not None:
            self.target_fc_function_name = m.get('TargetFcFunctionName')
        if m.get('TargetFcServiceName') is not None:
            self.target_fc_service_name = m.get('TargetFcServiceName')
        return self


class GetEdgeInstanceMessageRoutingResponseData(TeaModel):
    def __init__(self, gmt_create=None, gmt_create_timestamp=None, gmt_modified=None, gmt_modified_timestamp=None,
                 name=None, source_data=None, source_type=None, target_data=None, target_type=None, topic_filter=None,
                 route_context=None):
        self.gmt_create = gmt_create  # type: str
        self.gmt_create_timestamp = gmt_create_timestamp  # type: long
        self.gmt_modified = gmt_modified  # type: str
        self.gmt_modified_timestamp = gmt_modified_timestamp  # type: long
        self.name = name  # type: str
        self.source_data = source_data  # type: str
        self.source_type = source_type  # type: str
        self.target_data = target_data  # type: str
        self.target_type = target_type  # type: str
        self.topic_filter = topic_filter  # type: str
        self.route_context = route_context  # type: GetEdgeInstanceMessageRoutingResponseDataRouteContext

    def validate(self):
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_create_timestamp, 'gmt_create_timestamp')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.gmt_modified_timestamp, 'gmt_modified_timestamp')
        self.validate_required(self.name, 'name')
        self.validate_required(self.source_data, 'source_data')
        self.validate_required(self.source_type, 'source_type')
        self.validate_required(self.target_data, 'target_data')
        self.validate_required(self.target_type, 'target_type')
        self.validate_required(self.topic_filter, 'topic_filter')
        self.validate_required(self.route_context, 'route_context')
        if self.route_context:
            self.route_context.validate()

    def to_map(self):
        _map = super(GetEdgeInstanceMessageRoutingResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.name is not None:
            result['Name'] = self.name
        if self.source_data is not None:
            result['SourceData'] = self.source_data
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.target_data is not None:
            result['TargetData'] = self.target_data
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        if self.topic_filter is not None:
            result['TopicFilter'] = self.topic_filter
        if self.route_context is not None:
            result['RouteContext'] = self.route_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SourceData') is not None:
            self.source_data = m.get('SourceData')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('TargetData') is not None:
            self.target_data = m.get('TargetData')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        if m.get('TopicFilter') is not None:
            self.topic_filter = m.get('TopicFilter')
        if m.get('RouteContext') is not None:
            temp_model = GetEdgeInstanceMessageRoutingResponseDataRouteContext()
            self.route_context = temp_model.from_map(m['RouteContext'])
        return self


class GetEdgeInstanceMessageRoutingResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: GetEdgeInstanceMessageRoutingResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetEdgeInstanceMessageRoutingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetEdgeInstanceMessageRoutingResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetGatewayBySubDeviceRequest(TeaModel):
    def __init__(self, device_name=None, iot_id=None, iot_instance_id=None, product_key=None):
        self.device_name = device_name  # type: str
        self.iot_id = iot_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetGatewayBySubDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class GetGatewayBySubDeviceResponseData(TeaModel):
    def __init__(self, device_name=None, device_secret=None, firmware_version=None, gmt_active=None,
                 gmt_create=None, gmt_online=None, ip_address=None, node_type=None, product_key=None, product_name=None,
                 status=None, utc_active=None, utc_create=None, utc_online=None, iot_id=None, region=None):
        self.device_name = device_name  # type: str
        self.device_secret = device_secret  # type: str
        self.firmware_version = firmware_version  # type: str
        self.gmt_active = gmt_active  # type: str
        self.gmt_create = gmt_create  # type: str
        self.gmt_online = gmt_online  # type: str
        self.ip_address = ip_address  # type: str
        self.node_type = node_type  # type: str
        self.product_key = product_key  # type: str
        self.product_name = product_name  # type: str
        self.status = status  # type: str
        self.utc_active = utc_active  # type: str
        self.utc_create = utc_create  # type: str
        self.utc_online = utc_online  # type: str
        self.iot_id = iot_id  # type: str
        self.region = region  # type: str

    def validate(self):
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.device_secret, 'device_secret')
        self.validate_required(self.firmware_version, 'firmware_version')
        self.validate_required(self.gmt_active, 'gmt_active')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_online, 'gmt_online')
        self.validate_required(self.ip_address, 'ip_address')
        self.validate_required(self.node_type, 'node_type')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.product_name, 'product_name')
        self.validate_required(self.status, 'status')
        self.validate_required(self.utc_active, 'utc_active')
        self.validate_required(self.utc_create, 'utc_create')
        self.validate_required(self.utc_online, 'utc_online')
        self.validate_required(self.iot_id, 'iot_id')
        self.validate_required(self.region, 'region')

    def to_map(self):
        _map = super(GetGatewayBySubDeviceResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_secret is not None:
            result['DeviceSecret'] = self.device_secret
        if self.firmware_version is not None:
            result['FirmwareVersion'] = self.firmware_version
        if self.gmt_active is not None:
            result['GmtActive'] = self.gmt_active
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_online is not None:
            result['GmtOnline'] = self.gmt_online
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.status is not None:
            result['Status'] = self.status
        if self.utc_active is not None:
            result['UtcActive'] = self.utc_active
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_online is not None:
            result['UtcOnline'] = self.utc_online
        if self.iot_id is not None:
            result['iotId'] = self.iot_id
        if self.region is not None:
            result['region'] = self.region
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DeviceSecret') is not None:
            self.device_secret = m.get('DeviceSecret')
        if m.get('FirmwareVersion') is not None:
            self.firmware_version = m.get('FirmwareVersion')
        if m.get('GmtActive') is not None:
            self.gmt_active = m.get('GmtActive')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtOnline') is not None:
            self.gmt_online = m.get('GmtOnline')
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UtcActive') is not None:
            self.utc_active = m.get('UtcActive')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcOnline') is not None:
            self.utc_online = m.get('UtcOnline')
        if m.get('iotId') is not None:
            self.iot_id = m.get('iotId')
        if m.get('region') is not None:
            self.region = m.get('region')
        return self


class GetGatewayBySubDeviceResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: GetGatewayBySubDeviceResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetGatewayBySubDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetGatewayBySubDeviceResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetLoraNodesTaskRequest(TeaModel):
    def __init__(self, iot_instance_id=None, task_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.task_id = task_id  # type: str

    def validate(self):
        self.validate_required(self.task_id, 'task_id')

    def to_map(self):
        _map = super(GetLoraNodesTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetLoraNodesTaskResponseSuccessDevEuis(TeaModel):
    def __init__(self, success_dev_eui=None):
        self.success_dev_eui = success_dev_eui  # type: list[str]

    def validate(self):
        self.validate_required(self.success_dev_eui, 'success_dev_eui')

    def to_map(self):
        _map = super(GetLoraNodesTaskResponseSuccessDevEuis, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success_dev_eui is not None:
            result['SuccessDevEui'] = self.success_dev_eui
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SuccessDevEui') is not None:
            self.success_dev_eui = m.get('SuccessDevEui')
        return self


class GetLoraNodesTaskResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, success_count=None,
                 task_id=None, task_state=None, total_count=None, success_dev_euis=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.success_count = success_count  # type: long
        self.task_id = task_id  # type: str
        self.task_state = task_state  # type: str
        self.total_count = total_count  # type: long
        self.success_dev_euis = success_dev_euis  # type: GetLoraNodesTaskResponseSuccessDevEuis

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.success_count, 'success_count')
        self.validate_required(self.task_id, 'task_id')
        self.validate_required(self.task_state, 'task_state')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.success_dev_euis, 'success_dev_euis')
        if self.success_dev_euis:
            self.success_dev_euis.validate()

    def to_map(self):
        _map = super(GetLoraNodesTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.success_count is not None:
            result['SuccessCount'] = self.success_count
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_state is not None:
            result['TaskState'] = self.task_state
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.success_dev_euis is not None:
            result['SuccessDevEuis'] = self.success_dev_euis.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('SuccessCount') is not None:
            self.success_count = m.get('SuccessCount')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskState') is not None:
            self.task_state = m.get('TaskState')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('SuccessDevEuis') is not None:
            temp_model = GetLoraNodesTaskResponseSuccessDevEuis()
            self.success_dev_euis = temp_model.from_map(m['SuccessDevEuis'])
        return self


class GetParserRequest(TeaModel):
    def __init__(self, iot_instance_id=None, parser_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.parser_id = parser_id  # type: long

    def validate(self):
        self.validate_required(self.parser_id, 'parser_id')

    def to_map(self):
        _map = super(GetParserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.parser_id is not None:
            result['ParserId'] = self.parser_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ParserId') is not None:
            self.parser_id = m.get('ParserId')
        return self


class GetParserResponseData(TeaModel):
    def __init__(self, data_source_id=None, description=None, name=None, parser_id=None, script=None,
                 script_draft=None, status=None, utc_created=None, utc_modified=None):
        self.data_source_id = data_source_id  # type: long
        self.description = description  # type: str
        self.name = name  # type: str
        self.parser_id = parser_id  # type: long
        self.script = script  # type: str
        self.script_draft = script_draft  # type: str
        self.status = status  # type: str
        self.utc_created = utc_created  # type: str
        self.utc_modified = utc_modified  # type: str

    def validate(self):
        self.validate_required(self.data_source_id, 'data_source_id')
        self.validate_required(self.description, 'description')
        self.validate_required(self.name, 'name')
        self.validate_required(self.parser_id, 'parser_id')
        self.validate_required(self.script, 'script')
        self.validate_required(self.script_draft, 'script_draft')
        self.validate_required(self.status, 'status')
        self.validate_required(self.utc_created, 'utc_created')
        self.validate_required(self.utc_modified, 'utc_modified')

    def to_map(self):
        _map = super(GetParserResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.parser_id is not None:
            result['ParserId'] = self.parser_id
        if self.script is not None:
            result['Script'] = self.script
        if self.script_draft is not None:
            result['ScriptDraft'] = self.script_draft
        if self.status is not None:
            result['Status'] = self.status
        if self.utc_created is not None:
            result['UtcCreated'] = self.utc_created
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ParserId') is not None:
            self.parser_id = m.get('ParserId')
        if m.get('Script') is not None:
            self.script = m.get('Script')
        if m.get('ScriptDraft') is not None:
            self.script_draft = m.get('ScriptDraft')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UtcCreated') is not None:
            self.utc_created = m.get('UtcCreated')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        return self


class GetParserResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: GetParserResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetParserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetParserResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetParserDataSourceRequest(TeaModel):
    def __init__(self, data_source_id=None, iot_instance_id=None):
        self.data_source_id = data_source_id  # type: long
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.data_source_id, 'data_source_id')

    def to_map(self):
        _map = super(GetParserDataSourceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class GetParserDataSourceResponseDataSource(TeaModel):
    def __init__(self, create_user_id=None, data_source_id=None, description=None, name=None, utc_created=None):
        self.create_user_id = create_user_id  # type: long
        self.data_source_id = data_source_id  # type: long
        self.description = description  # type: str
        self.name = name  # type: str
        self.utc_created = utc_created  # type: str

    def validate(self):
        self.validate_required(self.create_user_id, 'create_user_id')
        self.validate_required(self.data_source_id, 'data_source_id')
        self.validate_required(self.description, 'description')
        self.validate_required(self.name, 'name')
        self.validate_required(self.utc_created, 'utc_created')

    def to_map(self):
        _map = super(GetParserDataSourceResponseDataSource, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_user_id is not None:
            result['CreateUserId'] = self.create_user_id
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.utc_created is not None:
            result['UtcCreated'] = self.utc_created
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateUserId') is not None:
            self.create_user_id = m.get('CreateUserId')
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('UtcCreated') is not None:
            self.utc_created = m.get('UtcCreated')
        return self


class GetParserDataSourceResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data_source=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data_source = data_source  # type: GetParserDataSourceResponseDataSource

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data_source, 'data_source')
        if self.data_source:
            self.data_source.validate()

    def to_map(self):
        _map = super(GetParserDataSourceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data_source is not None:
            result['DataSource'] = self.data_source.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('DataSource') is not None:
            temp_model = GetParserDataSourceResponseDataSource()
            self.data_source = temp_model.from_map(m['DataSource'])
        return self


class GetRuleRequest(TeaModel):
    def __init__(self, iot_instance_id=None, rule_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.rule_id = rule_id  # type: long

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')

    def to_map(self):
        _map = super(GetRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class GetRuleResponseRuleInfo(TeaModel):
    def __init__(self, create_user_id=None, created=None, data_type=None, id=None, modified=None, name=None,
                 product_key=None, rule_desc=None, select=None, short_topic=None, status=None, topic=None, topic_type=None,
                 utc_created=None, utc_modified=None, where=None):
        self.create_user_id = create_user_id  # type: long
        self.created = created  # type: str
        self.data_type = data_type  # type: str
        self.id = id  # type: long
        self.modified = modified  # type: str
        self.name = name  # type: str
        self.product_key = product_key  # type: str
        self.rule_desc = rule_desc  # type: str
        self.select = select  # type: str
        self.short_topic = short_topic  # type: str
        self.status = status  # type: str
        self.topic = topic  # type: str
        self.topic_type = topic_type  # type: int
        self.utc_created = utc_created  # type: str
        self.utc_modified = utc_modified  # type: str
        self.where = where  # type: str

    def validate(self):
        self.validate_required(self.create_user_id, 'create_user_id')
        self.validate_required(self.created, 'created')
        self.validate_required(self.data_type, 'data_type')
        self.validate_required(self.id, 'id')
        self.validate_required(self.modified, 'modified')
        self.validate_required(self.name, 'name')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.rule_desc, 'rule_desc')
        self.validate_required(self.select, 'select')
        self.validate_required(self.short_topic, 'short_topic')
        self.validate_required(self.status, 'status')
        self.validate_required(self.topic, 'topic')
        self.validate_required(self.topic_type, 'topic_type')
        self.validate_required(self.utc_created, 'utc_created')
        self.validate_required(self.utc_modified, 'utc_modified')
        self.validate_required(self.where, 'where')

    def to_map(self):
        _map = super(GetRuleResponseRuleInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_user_id is not None:
            result['CreateUserId'] = self.create_user_id
        if self.created is not None:
            result['Created'] = self.created
        if self.data_type is not None:
            result['DataType'] = self.data_type
        if self.id is not None:
            result['Id'] = self.id
        if self.modified is not None:
            result['Modified'] = self.modified
        if self.name is not None:
            result['Name'] = self.name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.rule_desc is not None:
            result['RuleDesc'] = self.rule_desc
        if self.select is not None:
            result['Select'] = self.select
        if self.short_topic is not None:
            result['ShortTopic'] = self.short_topic
        if self.status is not None:
            result['Status'] = self.status
        if self.topic is not None:
            result['Topic'] = self.topic
        if self.topic_type is not None:
            result['TopicType'] = self.topic_type
        if self.utc_created is not None:
            result['UtcCreated'] = self.utc_created
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.where is not None:
            result['Where'] = self.where
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateUserId') is not None:
            self.create_user_id = m.get('CreateUserId')
        if m.get('Created') is not None:
            self.created = m.get('Created')
        if m.get('DataType') is not None:
            self.data_type = m.get('DataType')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Modified') is not None:
            self.modified = m.get('Modified')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('RuleDesc') is not None:
            self.rule_desc = m.get('RuleDesc')
        if m.get('Select') is not None:
            self.select = m.get('Select')
        if m.get('ShortTopic') is not None:
            self.short_topic = m.get('ShortTopic')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        if m.get('TopicType') is not None:
            self.topic_type = m.get('TopicType')
        if m.get('UtcCreated') is not None:
            self.utc_created = m.get('UtcCreated')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('Where') is not None:
            self.where = m.get('Where')
        return self


class GetRuleResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, rule_info=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.rule_info = rule_info  # type: GetRuleResponseRuleInfo

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.rule_info, 'rule_info')
        if self.rule_info:
            self.rule_info.validate()

    def to_map(self):
        _map = super(GetRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.rule_info is not None:
            result['RuleInfo'] = self.rule_info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RuleInfo') is not None:
            temp_model = GetRuleResponseRuleInfo()
            self.rule_info = temp_model.from_map(m['RuleInfo'])
        return self


class GetRuleActionRequest(TeaModel):
    def __init__(self, action_id=None, iot_instance_id=None):
        self.action_id = action_id  # type: long
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.action_id, 'action_id')

    def to_map(self):
        _map = super(GetRuleActionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action_id is not None:
            result['ActionId'] = self.action_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActionId') is not None:
            self.action_id = m.get('ActionId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class GetRuleActionResponseRuleActionInfo(TeaModel):
    def __init__(self, configuration=None, error_action_flag=None, id=None, rule_id=None, type=None):
        self.configuration = configuration  # type: str
        self.error_action_flag = error_action_flag  # type: bool
        self.id = id  # type: long
        self.rule_id = rule_id  # type: long
        self.type = type  # type: str

    def validate(self):
        self.validate_required(self.configuration, 'configuration')
        self.validate_required(self.error_action_flag, 'error_action_flag')
        self.validate_required(self.id, 'id')
        self.validate_required(self.rule_id, 'rule_id')
        self.validate_required(self.type, 'type')

    def to_map(self):
        _map = super(GetRuleActionResponseRuleActionInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.configuration is not None:
            result['Configuration'] = self.configuration
        if self.error_action_flag is not None:
            result['ErrorActionFlag'] = self.error_action_flag
        if self.id is not None:
            result['Id'] = self.id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Configuration') is not None:
            self.configuration = m.get('Configuration')
        if m.get('ErrorActionFlag') is not None:
            self.error_action_flag = m.get('ErrorActionFlag')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetRuleActionResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, rule_action_info=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.rule_action_info = rule_action_info  # type: GetRuleActionResponseRuleActionInfo

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.rule_action_info, 'rule_action_info')
        if self.rule_action_info:
            self.rule_action_info.validate()

    def to_map(self):
        _map = super(GetRuleActionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.rule_action_info is not None:
            result['RuleActionInfo'] = self.rule_action_info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RuleActionInfo') is not None:
            temp_model = GetRuleActionResponseRuleActionInfo()
            self.rule_action_info = temp_model.from_map(m['RuleActionInfo'])
        return self


class GetSceneRuleRequest(TeaModel):
    def __init__(self, iot_instance_id=None, rule_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.rule_id = rule_id  # type: str

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')

    def to_map(self):
        _map = super(GetSceneRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class GetSceneRuleResponseData(TeaModel):
    def __init__(self, gmt_create=None, gmt_modified=None, rule_content=None, rule_description=None, rule_name=None,
                 rule_status=None):
        self.gmt_create = gmt_create  # type: long
        self.gmt_modified = gmt_modified  # type: long
        self.rule_content = rule_content  # type: str
        self.rule_description = rule_description  # type: str
        self.rule_name = rule_name  # type: str
        self.rule_status = rule_status  # type: int

    def validate(self):
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.rule_content, 'rule_content')
        self.validate_required(self.rule_description, 'rule_description')
        self.validate_required(self.rule_name, 'rule_name')
        self.validate_required(self.rule_status, 'rule_status')

    def to_map(self):
        _map = super(GetSceneRuleResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.rule_content is not None:
            result['RuleContent'] = self.rule_content
        if self.rule_description is not None:
            result['RuleDescription'] = self.rule_description
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.rule_status is not None:
            result['RuleStatus'] = self.rule_status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('RuleContent') is not None:
            self.rule_content = m.get('RuleContent')
        if m.get('RuleDescription') is not None:
            self.rule_description = m.get('RuleDescription')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('RuleStatus') is not None:
            self.rule_status = m.get('RuleStatus')
        return self


class GetSceneRuleResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: GetSceneRuleResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetSceneRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetSceneRuleResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetShareTaskByDeviceOpenRequest(TeaModel):
    def __init__(self, device_name=None, iot_id=None, iot_instance_id=None, product_key=None):
        self.device_name = device_name  # type: str
        self.iot_id = iot_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetShareTaskByDeviceOpenRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class GetShareTaskByDeviceOpenResponse(TeaModel):
    def __init__(self, code=None, data=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.data, 'data')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(GetShareTaskByDeviceOpenResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetSoundCodeAudioRequest(TeaModel):
    def __init__(self, iot_instance_id=None, sound_code_list=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.sound_code_list = sound_code_list  # type: list[str]

    def validate(self):
        self.validate_required(self.sound_code_list, 'sound_code_list')

    def to_map(self):
        _map = super(GetSoundCodeAudioRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.sound_code_list is not None:
            result['SoundCodeList'] = self.sound_code_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('SoundCodeList') is not None:
            self.sound_code_list = m.get('SoundCodeList')
        return self


class GetSoundCodeAudioResponseData(TeaModel):
    def __init__(self, items=None):
        self.items = items  # type: list[str]

    def validate(self):
        self.validate_required(self.items, 'items')

    def to_map(self):
        _map = super(GetSoundCodeAudioResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.items is not None:
            result['Items'] = self.items
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Items') is not None:
            self.items = m.get('Items')
        return self


class GetSoundCodeAudioResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: GetSoundCodeAudioResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetSoundCodeAudioResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetSoundCodeAudioResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetSoundCodeScheduleRequest(TeaModel):
    def __init__(self, iot_instance_id=None, schedule_code=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.schedule_code = schedule_code  # type: str

    def validate(self):
        self.validate_required(self.schedule_code, 'schedule_code')

    def to_map(self):
        _map = super(GetSoundCodeScheduleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.schedule_code is not None:
            result['ScheduleCode'] = self.schedule_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ScheduleCode') is not None:
            self.schedule_code = m.get('ScheduleCode')
        return self


class GetSoundCodeScheduleResponseData(TeaModel):
    def __init__(self, description=None, end_date=None, end_time=None, gmt_create=None, name=None, open_type=None,
                 schedule_code=None, start_date=None, start_time=None, status=None):
        self.description = description  # type: str
        self.end_date = end_date  # type: str
        self.end_time = end_time  # type: str
        self.gmt_create = gmt_create  # type: long
        self.name = name  # type: str
        self.open_type = open_type  # type: str
        self.schedule_code = schedule_code  # type: str
        self.start_date = start_date  # type: str
        self.start_time = start_time  # type: str
        self.status = status  # type: str

    def validate(self):
        self.validate_required(self.description, 'description')
        self.validate_required(self.end_date, 'end_date')
        self.validate_required(self.end_time, 'end_time')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.name, 'name')
        self.validate_required(self.open_type, 'open_type')
        self.validate_required(self.schedule_code, 'schedule_code')
        self.validate_required(self.start_date, 'start_date')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.status, 'status')

    def to_map(self):
        _map = super(GetSoundCodeScheduleResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.name is not None:
            result['Name'] = self.name
        if self.open_type is not None:
            result['OpenType'] = self.open_type
        if self.schedule_code is not None:
            result['ScheduleCode'] = self.schedule_code
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OpenType') is not None:
            self.open_type = m.get('OpenType')
        if m.get('ScheduleCode') is not None:
            self.schedule_code = m.get('ScheduleCode')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetSoundCodeScheduleResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: GetSoundCodeScheduleResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetSoundCodeScheduleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetSoundCodeScheduleResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetSpeechDeviceDetailRequest(TeaModel):
    def __init__(self, iot_id=None, iot_instance_id=None):
        self.iot_id = iot_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.iot_id, 'iot_id')

    def to_map(self):
        _map = super(GetSpeechDeviceDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class GetSpeechDeviceDetailResponseData(TeaModel):
    def __init__(self, available_space=None, device_name=None, iot_id=None, product_key=None,
                 speech_list_update_time=None, status=None, total_space=None):
        self.available_space = available_space  # type: float
        self.device_name = device_name  # type: str
        self.iot_id = iot_id  # type: str
        self.product_key = product_key  # type: str
        self.speech_list_update_time = speech_list_update_time  # type: long
        self.status = status  # type: str
        self.total_space = total_space  # type: float

    def validate(self):
        self.validate_required(self.available_space, 'available_space')
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.iot_id, 'iot_id')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.speech_list_update_time, 'speech_list_update_time')
        self.validate_required(self.status, 'status')
        self.validate_required(self.total_space, 'total_space')

    def to_map(self):
        _map = super(GetSpeechDeviceDetailResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.available_space is not None:
            result['AvailableSpace'] = self.available_space
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.speech_list_update_time is not None:
            result['SpeechListUpdateTime'] = self.speech_list_update_time
        if self.status is not None:
            result['Status'] = self.status
        if self.total_space is not None:
            result['TotalSpace'] = self.total_space
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AvailableSpace') is not None:
            self.available_space = m.get('AvailableSpace')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('SpeechListUpdateTime') is not None:
            self.speech_list_update_time = m.get('SpeechListUpdateTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TotalSpace') is not None:
            self.total_space = m.get('TotalSpace')
        return self


class GetSpeechDeviceDetailResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: GetSpeechDeviceDetailResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetSpeechDeviceDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetSpeechDeviceDetailResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetSpeechLicenseDeviceStatisticsRequest(TeaModel):
    def __init__(self, iot_instance_id=None):
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSpeechLicenseDeviceStatisticsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class GetSpeechLicenseDeviceStatisticsResponseData(TeaModel):
    def __init__(self, available_quota=None, expired_quota=None, expiring_quota=None):
        self.available_quota = available_quota  # type: int
        self.expired_quota = expired_quota  # type: int
        self.expiring_quota = expiring_quota  # type: int

    def validate(self):
        self.validate_required(self.available_quota, 'available_quota')
        self.validate_required(self.expired_quota, 'expired_quota')
        self.validate_required(self.expiring_quota, 'expiring_quota')

    def to_map(self):
        _map = super(GetSpeechLicenseDeviceStatisticsResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.available_quota is not None:
            result['AvailableQuota'] = self.available_quota
        if self.expired_quota is not None:
            result['ExpiredQuota'] = self.expired_quota
        if self.expiring_quota is not None:
            result['ExpiringQuota'] = self.expiring_quota
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AvailableQuota') is not None:
            self.available_quota = m.get('AvailableQuota')
        if m.get('ExpiredQuota') is not None:
            self.expired_quota = m.get('ExpiredQuota')
        if m.get('ExpiringQuota') is not None:
            self.expiring_quota = m.get('ExpiringQuota')
        return self


class GetSpeechLicenseDeviceStatisticsResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: GetSpeechLicenseDeviceStatisticsResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetSpeechLicenseDeviceStatisticsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetSpeechLicenseDeviceStatisticsResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetSpeechVoiceRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSpeechVoiceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m=None):
        m = m or dict()
        return self


class GetSpeechVoiceResponseDataItemsVoiceListItems(TeaModel):
    def __init__(self, label=None, value=None):
        self.label = label  # type: str
        self.value = value  # type: str

    def validate(self):
        self.validate_required(self.label, 'label')
        self.validate_required(self.value, 'value')

    def to_map(self):
        _map = super(GetSpeechVoiceResponseDataItemsVoiceListItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetSpeechVoiceResponseDataItemsVoiceList(TeaModel):
    def __init__(self, items=None):
        self.items = items  # type: list[GetSpeechVoiceResponseDataItemsVoiceListItems]

    def validate(self):
        self.validate_required(self.items, 'items')
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetSpeechVoiceResponseDataItemsVoiceList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = GetSpeechVoiceResponseDataItemsVoiceListItems()
                self.items.append(temp_model.from_map(k))
        return self


class GetSpeechVoiceResponseDataItems(TeaModel):
    def __init__(self, label=None, value=None, voice_list=None):
        self.label = label  # type: str
        self.value = value  # type: str
        self.voice_list = voice_list  # type: GetSpeechVoiceResponseDataItemsVoiceList

    def validate(self):
        self.validate_required(self.label, 'label')
        self.validate_required(self.value, 'value')
        self.validate_required(self.voice_list, 'voice_list')
        if self.voice_list:
            self.voice_list.validate()

    def to_map(self):
        _map = super(GetSpeechVoiceResponseDataItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.value is not None:
            result['Value'] = self.value
        if self.voice_list is not None:
            result['VoiceList'] = self.voice_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('VoiceList') is not None:
            temp_model = GetSpeechVoiceResponseDataItemsVoiceList()
            self.voice_list = temp_model.from_map(m['VoiceList'])
        return self


class GetSpeechVoiceResponseData(TeaModel):
    def __init__(self, items=None):
        self.items = items  # type: list[GetSpeechVoiceResponseDataItems]

    def validate(self):
        self.validate_required(self.items, 'items')
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetSpeechVoiceResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = GetSpeechVoiceResponseDataItems()
                self.items.append(temp_model.from_map(k))
        return self


class GetSpeechVoiceResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: GetSpeechVoiceResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetSpeechVoiceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetSpeechVoiceResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetStudioAppTokenOpenRequest(TeaModel):
    def __init__(self, app_id=None, iot_instance_id=None, project_id=None):
        self.app_id = app_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.project_id = project_id  # type: str

    def validate(self):
        self.validate_required(self.app_id, 'app_id')
        self.validate_required(self.project_id, 'project_id')

    def to_map(self):
        _map = super(GetStudioAppTokenOpenRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetStudioAppTokenOpenResponseData(TeaModel):
    def __init__(self, biz_id=None, biz_type=None, is_enable=None, token=None, type=None):
        self.biz_id = biz_id  # type: str
        self.biz_type = biz_type  # type: str
        self.is_enable = is_enable  # type: str
        self.token = token  # type: str
        self.type = type  # type: str

    def validate(self):
        self.validate_required(self.biz_id, 'biz_id')
        self.validate_required(self.biz_type, 'biz_type')
        self.validate_required(self.is_enable, 'is_enable')
        self.validate_required(self.token, 'token')
        self.validate_required(self.type, 'type')

    def to_map(self):
        _map = super(GetStudioAppTokenOpenResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_id is not None:
            result['BizId'] = self.biz_id
        if self.biz_type is not None:
            result['BizType'] = self.biz_type
        if self.is_enable is not None:
            result['IsEnable'] = self.is_enable
        if self.token is not None:
            result['Token'] = self.token
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BizId') is not None:
            self.biz_id = m.get('BizId')
        if m.get('BizType') is not None:
            self.biz_type = m.get('BizType')
        if m.get('IsEnable') is not None:
            self.is_enable = m.get('IsEnable')
        if m.get('Token') is not None:
            self.token = m.get('Token')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetStudioAppTokenOpenResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: GetStudioAppTokenOpenResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetStudioAppTokenOpenResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetStudioAppTokenOpenResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetThingModelTslRequest(TeaModel):
    def __init__(self, function_block_id=None, iot_instance_id=None, model_version=None, product_key=None,
                 simple=None):
        self.function_block_id = function_block_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.model_version = model_version  # type: str
        self.product_key = product_key  # type: str
        self.simple = simple  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetThingModelTslRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.model_version is not None:
            result['ModelVersion'] = self.model_version
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.simple is not None:
            result['Simple'] = self.simple
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ModelVersion') is not None:
            self.model_version = m.get('ModelVersion')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Simple') is not None:
            self.simple = m.get('Simple')
        return self


class GetThingModelTslResponseData(TeaModel):
    def __init__(self, tsl_str=None, tsl_uri=None):
        self.tsl_str = tsl_str  # type: str
        self.tsl_uri = tsl_uri  # type: str

    def validate(self):
        self.validate_required(self.tsl_str, 'tsl_str')
        self.validate_required(self.tsl_uri, 'tsl_uri')

    def to_map(self):
        _map = super(GetThingModelTslResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tsl_str is not None:
            result['TslStr'] = self.tsl_str
        if self.tsl_uri is not None:
            result['TslUri'] = self.tsl_uri
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TslStr') is not None:
            self.tsl_str = m.get('TslStr')
        if m.get('TslUri') is not None:
            self.tsl_uri = m.get('TslUri')
        return self


class GetThingModelTslResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: GetThingModelTslResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetThingModelTslResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetThingModelTslResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetThingModelTslPublishedRequest(TeaModel):
    def __init__(self, function_block_id=None, iot_instance_id=None, model_version=None, product_key=None,
                 resource_group_id=None, simple=None):
        self.function_block_id = function_block_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.model_version = model_version  # type: str
        self.product_key = product_key  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.simple = simple  # type: bool

    def validate(self):
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        _map = super(GetThingModelTslPublishedRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.model_version is not None:
            result['ModelVersion'] = self.model_version
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.simple is not None:
            result['Simple'] = self.simple
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ModelVersion') is not None:
            self.model_version = m.get('ModelVersion')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Simple') is not None:
            self.simple = m.get('Simple')
        return self


class GetThingModelTslPublishedResponseData(TeaModel):
    def __init__(self, tsl_str=None, tsl_uri=None):
        self.tsl_str = tsl_str  # type: str
        self.tsl_uri = tsl_uri  # type: str

    def validate(self):
        self.validate_required(self.tsl_str, 'tsl_str')
        self.validate_required(self.tsl_uri, 'tsl_uri')

    def to_map(self):
        _map = super(GetThingModelTslPublishedResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tsl_str is not None:
            result['TslStr'] = self.tsl_str
        if self.tsl_uri is not None:
            result['TslUri'] = self.tsl_uri
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TslStr') is not None:
            self.tsl_str = m.get('TslStr')
        if m.get('TslUri') is not None:
            self.tsl_uri = m.get('TslUri')
        return self


class GetThingModelTslPublishedResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: GetThingModelTslPublishedResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetThingModelTslPublishedResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetThingModelTslPublishedResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetThingScriptRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        _map = super(GetThingScriptRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class GetThingScriptResponseData(TeaModel):
    def __init__(self, script_type=None, script_url=None):
        self.script_type = script_type  # type: str
        self.script_url = script_url  # type: str

    def validate(self):
        self.validate_required(self.script_type, 'script_type')
        self.validate_required(self.script_url, 'script_url')

    def to_map(self):
        _map = super(GetThingScriptResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.script_type is not None:
            result['ScriptType'] = self.script_type
        if self.script_url is not None:
            result['ScriptUrl'] = self.script_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ScriptType') is not None:
            self.script_type = m.get('ScriptType')
        if m.get('ScriptUrl') is not None:
            self.script_url = m.get('ScriptUrl')
        return self


class GetThingScriptResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: GetThingScriptResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetThingScriptResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetThingScriptResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetThingTemplateRequest(TeaModel):
    def __init__(self, category_key=None, iot_instance_id=None, resource_group_id=None):
        self.category_key = category_key  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.resource_group_id = resource_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetThingTemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_key is not None:
            result['CategoryKey'] = self.category_key
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CategoryKey') is not None:
            self.category_key = m.get('CategoryKey')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class GetThingTemplateResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, thing_model_json=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.thing_model_json = thing_model_json  # type: str

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.thing_model_json, 'thing_model_json')

    def to_map(self):
        _map = super(GetThingTemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.thing_model_json is not None:
            result['ThingModelJSON'] = self.thing_model_json
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ThingModelJSON') is not None:
            self.thing_model_json = m.get('ThingModelJSON')
        return self


class GetThingTopoRequest(TeaModel):
    def __init__(self, device_name=None, iot_id=None, iot_instance_id=None, page_no=None, page_size=None,
                 product_key=None):
        self.device_name = device_name  # type: str
        self.iot_id = iot_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.page_no = page_no  # type: int
        self.page_size = page_size  # type: int
        self.product_key = product_key  # type: str

    def validate(self):
        self.validate_required(self.page_no, 'page_no')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        _map = super(GetThingTopoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class GetThingTopoResponseDataListDeviceInfo(TeaModel):
    def __init__(self, device_name=None, iot_id=None, product_key=None):
        self.device_name = device_name  # type: str
        self.iot_id = iot_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.iot_id, 'iot_id')
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        _map = super(GetThingTopoResponseDataListDeviceInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class GetThingTopoResponseDataList(TeaModel):
    def __init__(self, device_info=None):
        self.device_info = device_info  # type: list[GetThingTopoResponseDataListDeviceInfo]

    def validate(self):
        self.validate_required(self.device_info, 'device_info')
        if self.device_info:
            for k in self.device_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetThingTopoResponseDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['deviceInfo'] = []
        if self.device_info is not None:
            for k in self.device_info:
                result['deviceInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.device_info = []
        if m.get('deviceInfo') is not None:
            for k in m.get('deviceInfo'):
                temp_model = GetThingTopoResponseDataListDeviceInfo()
                self.device_info.append(temp_model.from_map(k))
        return self


class GetThingTopoResponseData(TeaModel):
    def __init__(self, current_page=None, page_count=None, page_size=None, total=None, list=None):
        self.current_page = current_page  # type: int
        self.page_count = page_count  # type: long
        self.page_size = page_size  # type: int
        self.total = total  # type: long
        self.list = list  # type: GetThingTopoResponseDataList

    def validate(self):
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.page_count, 'page_count')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total, 'total')
        self.validate_required(self.list, 'list')
        if self.list:
            self.list.validate()

    def to_map(self):
        _map = super(GetThingTopoResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        if self.list is not None:
            result['List'] = self.list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('List') is not None:
            temp_model = GetThingTopoResponseDataList()
            self.list = temp_model.from_map(m['List'])
        return self


class GetThingTopoResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: GetThingTopoResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetThingTopoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetThingTopoResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GisQueryDeviceLocationRequestThingList(TeaModel):
    def __init__(self, product_key=None, device_name=None):
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GisQueryDeviceLocationRequestThingList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class GisQueryDeviceLocationRequest(TeaModel):
    def __init__(self, iot_instance_id=None, thing_list=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.thing_list = thing_list  # type: list[GisQueryDeviceLocationRequestThingList]

    def validate(self):
        self.validate_required(self.thing_list, 'thing_list')
        if self.thing_list:
            for k in self.thing_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GisQueryDeviceLocationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        result['ThingList'] = []
        if self.thing_list is not None:
            for k in self.thing_list:
                result['ThingList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        self.thing_list = []
        if m.get('ThingList') is not None:
            for k in m.get('ThingList'):
                temp_model = GisQueryDeviceLocationRequestThingList()
                self.thing_list.append(temp_model.from_map(k))
        return self


class GisQueryDeviceLocationResponseData(TeaModel):
    def __init__(self, adcode=None, city=None, coordinate_system=None, country=None, device_name=None, ip=None,
                 latitude=None, longitude=None, product_key=None, province=None):
        self.adcode = adcode  # type: long
        self.city = city  # type: str
        self.coordinate_system = coordinate_system  # type: int
        self.country = country  # type: str
        self.device_name = device_name  # type: str
        self.ip = ip  # type: str
        self.latitude = latitude  # type: float
        self.longitude = longitude  # type: float
        self.product_key = product_key  # type: str
        self.province = province  # type: str

    def validate(self):
        self.validate_required(self.adcode, 'adcode')
        self.validate_required(self.city, 'city')
        self.validate_required(self.coordinate_system, 'coordinate_system')
        self.validate_required(self.country, 'country')
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.ip, 'ip')
        self.validate_required(self.latitude, 'latitude')
        self.validate_required(self.longitude, 'longitude')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.province, 'province')

    def to_map(self):
        _map = super(GisQueryDeviceLocationResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adcode is not None:
            result['Adcode'] = self.adcode
        if self.city is not None:
            result['City'] = self.city
        if self.coordinate_system is not None:
            result['CoordinateSystem'] = self.coordinate_system
        if self.country is not None:
            result['Country'] = self.country
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.latitude is not None:
            result['Latitude'] = self.latitude
        if self.longitude is not None:
            result['Longitude'] = self.longitude
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.province is not None:
            result['Province'] = self.province
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Adcode') is not None:
            self.adcode = m.get('Adcode')
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('CoordinateSystem') is not None:
            self.coordinate_system = m.get('CoordinateSystem')
        if m.get('Country') is not None:
            self.country = m.get('Country')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Latitude') is not None:
            self.latitude = m.get('Latitude')
        if m.get('Longitude') is not None:
            self.longitude = m.get('Longitude')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Province') is not None:
            self.province = m.get('Province')
        return self


class GisQueryDeviceLocationResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: list[GisQueryDeviceLocationResponseData]

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GisQueryDeviceLocationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GisQueryDeviceLocationResponseData()
                self.data.append(temp_model.from_map(k))
        return self


class GisSearchDeviceTraceRequest(TeaModel):
    def __init__(self, map_match=None, iot_instance_id=None, end_time=None, start_time=None, product_key=None,
                 device_name=None):
        self.map_match = map_match  # type: int
        self.iot_instance_id = iot_instance_id  # type: str
        self.end_time = end_time  # type: long
        self.start_time = start_time  # type: long
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str

    def validate(self):
        self.validate_required(self.map_match, 'map_match')
        self.validate_required(self.end_time, 'end_time')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.device_name, 'device_name')

    def to_map(self):
        _map = super(GisSearchDeviceTraceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.map_match is not None:
            result['MapMatch'] = self.map_match
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MapMatch') is not None:
            self.map_match = m.get('MapMatch')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class GisSearchDeviceTraceResponseDataPoints(TeaModel):
    def __init__(self, locate_time=None, location=None):
        self.locate_time = locate_time  # type: long
        self.location = location  # type: str

    def validate(self):
        self.validate_required(self.locate_time, 'locate_time')
        self.validate_required(self.location, 'location')

    def to_map(self):
        _map = super(GisSearchDeviceTraceResponseDataPoints, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.locate_time is not None:
            result['LocateTime'] = self.locate_time
        if self.location is not None:
            result['Location'] = self.location
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LocateTime') is not None:
            self.locate_time = m.get('LocateTime')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        return self


class GisSearchDeviceTraceResponseData(TeaModel):
    def __init__(self, device_name=None, product_key=None, points=None):
        self.device_name = device_name  # type: str
        self.product_key = product_key  # type: str
        self.points = points  # type: list[GisSearchDeviceTraceResponseDataPoints]

    def validate(self):
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.points, 'points')
        if self.points:
            for k in self.points:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GisSearchDeviceTraceResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        result['Points'] = []
        if self.points is not None:
            for k in self.points:
                result['Points'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        self.points = []
        if m.get('Points') is not None:
            for k in m.get('Points'):
                temp_model = GisSearchDeviceTraceResponseDataPoints()
                self.points.append(temp_model.from_map(k))
        return self


class GisSearchDeviceTraceResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: GisSearchDeviceTraceResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GisSearchDeviceTraceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GisSearchDeviceTraceResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ImportDTDataRequestItems(TeaModel):
    def __init__(self, device_name=None, params=None):
        self.device_name = device_name  # type: str
        self.params = params  # type: str

    def validate(self):
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.params, 'params')

    def to_map(self):
        _map = super(ImportDTDataRequestItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.params is not None:
            result['Params'] = self.params
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        return self


class ImportDTDataRequest(TeaModel):
    def __init__(self, iot_instance_id=None, items=None, product_key=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.items = items  # type: list[ImportDTDataRequestItems]
        self.product_key = product_key  # type: str

    def validate(self):
        self.validate_required(self.items, 'items')
        if self.items:
            for k in self.items:
                if k:
                    k.validate()
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        _map = super(ImportDTDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = ImportDTDataRequestItems()
                self.items.append(temp_model.from_map(k))
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class ImportDTDataResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(ImportDTDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ImportDeviceRequest(TeaModel):
    def __init__(self, device_name=None, device_secret=None, iot_instance_id=None, nickname=None, product_key=None,
                 sn=None):
        self.device_name = device_name  # type: str
        self.device_secret = device_secret  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.nickname = nickname  # type: str
        self.product_key = product_key  # type: str
        self.sn = sn  # type: str

    def validate(self):
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.device_secret, 'device_secret')
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        _map = super(ImportDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_secret is not None:
            result['DeviceSecret'] = self.device_secret
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.nickname is not None:
            result['Nickname'] = self.nickname
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.sn is not None:
            result['Sn'] = self.sn
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DeviceSecret') is not None:
            self.device_secret = m.get('DeviceSecret')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Nickname') is not None:
            self.nickname = m.get('Nickname')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Sn') is not None:
            self.sn = m.get('Sn')
        return self


class ImportDeviceResponseData(TeaModel):
    def __init__(self, device_name=None, device_secret=None, iot_id=None, nickname=None, product_key=None, sn=None):
        self.device_name = device_name  # type: str
        self.device_secret = device_secret  # type: str
        self.iot_id = iot_id  # type: str
        self.nickname = nickname  # type: str
        self.product_key = product_key  # type: str
        self.sn = sn  # type: str

    def validate(self):
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.device_secret, 'device_secret')
        self.validate_required(self.iot_id, 'iot_id')
        self.validate_required(self.nickname, 'nickname')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.sn, 'sn')

    def to_map(self):
        _map = super(ImportDeviceResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_secret is not None:
            result['DeviceSecret'] = self.device_secret
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.nickname is not None:
            result['Nickname'] = self.nickname
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.sn is not None:
            result['Sn'] = self.sn
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DeviceSecret') is not None:
            self.device_secret = m.get('DeviceSecret')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('Nickname') is not None:
            self.nickname = m.get('Nickname')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Sn') is not None:
            self.sn = m.get('Sn')
        return self


class ImportDeviceResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: ImportDeviceResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ImportDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = ImportDeviceResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ImportThingModelTslRequest(TeaModel):
    def __init__(self, function_block_id=None, function_block_name=None, iot_instance_id=None, product_key=None,
                 resource_group_id=None, tsl_str=None, tsl_url=None):
        self.function_block_id = function_block_id  # type: str
        self.function_block_name = function_block_name  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.tsl_str = tsl_str  # type: str
        self.tsl_url = tsl_url  # type: str

    def validate(self):
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        _map = super(ImportThingModelTslRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        if self.function_block_name is not None:
            result['FunctionBlockName'] = self.function_block_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.tsl_str is not None:
            result['TslStr'] = self.tsl_str
        if self.tsl_url is not None:
            result['TslUrl'] = self.tsl_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        if m.get('FunctionBlockName') is not None:
            self.function_block_name = m.get('FunctionBlockName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('TslStr') is not None:
            self.tsl_str = m.get('TslStr')
        if m.get('TslUrl') is not None:
            self.tsl_url = m.get('TslUrl')
        return self


class ImportThingModelTslResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(ImportThingModelTslResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class InvokeDataAPIServiceRequestParam(TeaModel):
    def __init__(self, param_type=None, list_param_value=None, list_param_type=None, param_name=None,
                 param_value=None):
        self.param_type = param_type  # type: str
        self.list_param_value = list_param_value  # type: list[str]
        self.list_param_type = list_param_type  # type: str
        self.param_name = param_name  # type: str
        self.param_value = param_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InvokeDataAPIServiceRequestParam, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.param_type is not None:
            result['ParamType'] = self.param_type
        if self.list_param_value is not None:
            result['ListParamValue'] = self.list_param_value
        if self.list_param_type is not None:
            result['ListParamType'] = self.list_param_type
        if self.param_name is not None:
            result['ParamName'] = self.param_name
        if self.param_value is not None:
            result['ParamValue'] = self.param_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ParamType') is not None:
            self.param_type = m.get('ParamType')
        if m.get('ListParamValue') is not None:
            self.list_param_value = m.get('ListParamValue')
        if m.get('ListParamType') is not None:
            self.list_param_type = m.get('ListParamType')
        if m.get('ParamName') is not None:
            self.param_name = m.get('ParamName')
        if m.get('ParamValue') is not None:
            self.param_value = m.get('ParamValue')
        return self


class InvokeDataAPIServiceRequest(TeaModel):
    def __init__(self, api_srn=None, param=None, iot_instance_id=None):
        self.api_srn = api_srn  # type: str
        self.param = param  # type: list[InvokeDataAPIServiceRequestParam]
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        self.validate_required(self.api_srn, 'api_srn')
        if self.param:
            for k in self.param:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(InvokeDataAPIServiceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_srn is not None:
            result['ApiSrn'] = self.api_srn
        result['Param'] = []
        if self.param is not None:
            for k in self.param:
                result['Param'].append(k.to_map() if k else None)
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiSrn') is not None:
            self.api_srn = m.get('ApiSrn')
        self.param = []
        if m.get('Param') is not None:
            for k in m.get('Param'):
                temp_model = InvokeDataAPIServiceRequestParam()
                self.param.append(temp_model.from_map(k))
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class InvokeDataAPIServiceResponseDataFieldNameList(TeaModel):
    def __init__(self, field_name_list=None):
        # FieldNameList
        self.field_name_list = field_name_list  # type: list[str]

    def validate(self):
        self.validate_required(self.field_name_list, 'field_name_list')

    def to_map(self):
        _map = super(InvokeDataAPIServiceResponseDataFieldNameList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.field_name_list is not None:
            result['FieldNameList'] = self.field_name_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FieldNameList') is not None:
            self.field_name_list = m.get('FieldNameList')
        return self


class InvokeDataAPIServiceResponseDataResultList(TeaModel):
    def __init__(self, result_list=None):
        # ResultList
        self.result_list = result_list  # type: list[dict[str, any]]

    def validate(self):
        self.validate_required(self.result_list, 'result_list')

    def to_map(self):
        _map = super(InvokeDataAPIServiceResponseDataResultList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result_list is not None:
            result['ResultList'] = self.result_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResultList') is not None:
            self.result_list = m.get('ResultList')
        return self


class InvokeDataAPIServiceResponseData(TeaModel):
    def __init__(self, api_srn=None, page_no=None, page_size=None, total_size=None, field_name_list=None,
                 result_list=None):
        self.api_srn = api_srn  # type: str
        self.page_no = page_no  # type: int
        self.page_size = page_size  # type: int
        self.total_size = total_size  # type: int
        self.field_name_list = field_name_list  # type: InvokeDataAPIServiceResponseDataFieldNameList
        self.result_list = result_list  # type: InvokeDataAPIServiceResponseDataResultList

    def validate(self):
        self.validate_required(self.api_srn, 'api_srn')
        self.validate_required(self.page_no, 'page_no')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total_size, 'total_size')
        self.validate_required(self.field_name_list, 'field_name_list')
        if self.field_name_list:
            self.field_name_list.validate()
        self.validate_required(self.result_list, 'result_list')
        if self.result_list:
            self.result_list.validate()

    def to_map(self):
        _map = super(InvokeDataAPIServiceResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_srn is not None:
            result['ApiSrn'] = self.api_srn
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_size is not None:
            result['TotalSize'] = self.total_size
        if self.field_name_list is not None:
            result['FieldNameList'] = self.field_name_list.to_map()
        if self.result_list is not None:
            result['ResultList'] = self.result_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiSrn') is not None:
            self.api_srn = m.get('ApiSrn')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalSize') is not None:
            self.total_size = m.get('TotalSize')
        if m.get('FieldNameList') is not None:
            temp_model = InvokeDataAPIServiceResponseDataFieldNameList()
            self.field_name_list = temp_model.from_map(m['FieldNameList'])
        if m.get('ResultList') is not None:
            temp_model = InvokeDataAPIServiceResponseDataResultList()
            self.result_list = temp_model.from_map(m['ResultList'])
        return self


class InvokeDataAPIServiceResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: InvokeDataAPIServiceResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(InvokeDataAPIServiceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = InvokeDataAPIServiceResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class InvokeThingServiceRequest(TeaModel):
    def __init__(self, args=None, device_name=None, identifier=None, iot_id=None, iot_instance_id=None,
                 product_key=None):
        self.args = args  # type: str
        self.device_name = device_name  # type: str
        self.identifier = identifier  # type: str
        self.iot_id = iot_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        self.validate_required(self.args, 'args')
        self.validate_required(self.identifier, 'identifier')

    def to_map(self):
        _map = super(InvokeThingServiceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.args is not None:
            result['Args'] = self.args
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Args') is not None:
            self.args = m.get('Args')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class InvokeThingServiceResponseData(TeaModel):
    def __init__(self, message_id=None, result=None):
        self.message_id = message_id  # type: str
        self.result = result  # type: str

    def validate(self):
        self.validate_required(self.message_id, 'message_id')
        self.validate_required(self.result, 'result')

    def to_map(self):
        _map = super(InvokeThingServiceResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        if self.result is not None:
            result['Result'] = self.result
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        return self


class InvokeThingServiceResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: InvokeThingServiceResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(InvokeThingServiceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = InvokeThingServiceResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class InvokeThingsServiceRequest(TeaModel):
    def __init__(self, args=None, device_name=None, identifier=None, iot_instance_id=None, product_key=None):
        self.args = args  # type: str
        self.device_name = device_name  # type: list[str]
        self.identifier = identifier  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        self.validate_required(self.args, 'args')
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.identifier, 'identifier')
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        _map = super(InvokeThingsServiceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.args is not None:
            result['Args'] = self.args
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Args') is not None:
            self.args = m.get('Args')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class InvokeThingsServiceResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')

    def to_map(self):
        _map = super(InvokeThingsServiceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListAnalyticsDataRequestCondition(TeaModel):
    def __init__(self, between_end=None, between_start=None, field_name=None, operate=None, value=None):
        self.between_end = between_end  # type: str
        self.between_start = between_start  # type: str
        self.field_name = field_name  # type: str
        self.operate = operate  # type: str
        self.value = value  # type: str

    def validate(self):
        self.validate_required(self.field_name, 'field_name')
        self.validate_required(self.operate, 'operate')

    def to_map(self):
        _map = super(ListAnalyticsDataRequestCondition, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.between_end is not None:
            result['BetweenEnd'] = self.between_end
        if self.between_start is not None:
            result['BetweenStart'] = self.between_start
        if self.field_name is not None:
            result['FieldName'] = self.field_name
        if self.operate is not None:
            result['Operate'] = self.operate
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BetweenEnd') is not None:
            self.between_end = m.get('BetweenEnd')
        if m.get('BetweenStart') is not None:
            self.between_start = m.get('BetweenStart')
        if m.get('FieldName') is not None:
            self.field_name = m.get('FieldName')
        if m.get('Operate') is not None:
            self.operate = m.get('Operate')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListAnalyticsDataRequest(TeaModel):
    def __init__(self, api_path=None, condition=None, iot_instance_id=None, iso_id=None, page_num=None,
                 page_size=None):
        self.api_path = api_path  # type: str
        self.condition = condition  # type: list[ListAnalyticsDataRequestCondition]
        self.iot_instance_id = iot_instance_id  # type: str
        self.iso_id = iso_id  # type: str
        self.page_num = page_num  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        self.validate_required(self.api_path, 'api_path')
        if self.condition:
            for k in self.condition:
                if k:
                    k.validate()
        self.validate_required(self.iot_instance_id, 'iot_instance_id')

    def to_map(self):
        _map = super(ListAnalyticsDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_path is not None:
            result['ApiPath'] = self.api_path
        result['Condition'] = []
        if self.condition is not None:
            for k in self.condition:
                result['Condition'].append(k.to_map() if k else None)
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.iso_id is not None:
            result['IsoId'] = self.iso_id
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiPath') is not None:
            self.api_path = m.get('ApiPath')
        self.condition = []
        if m.get('Condition') is not None:
            for k in m.get('Condition'):
                temp_model = ListAnalyticsDataRequestCondition()
                self.condition.append(temp_model.from_map(k))
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('IsoId') is not None:
            self.iso_id = m.get('IsoId')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListAnalyticsDataResponseData(TeaModel):
    def __init__(self, count=None, has_next=None, page_num=None, page_size=None, result_json=None):
        self.count = count  # type: long
        self.has_next = has_next  # type: bool
        self.page_num = page_num  # type: int
        self.page_size = page_size  # type: int
        self.result_json = result_json  # type: str

    def validate(self):
        self.validate_required(self.count, 'count')
        self.validate_required(self.has_next, 'has_next')
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.result_json, 'result_json')

    def to_map(self):
        _map = super(ListAnalyticsDataResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.has_next is not None:
            result['HasNext'] = self.has_next
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.result_json is not None:
            result['ResultJson'] = self.result_json
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('HasNext') is not None:
            self.has_next = m.get('HasNext')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResultJson') is not None:
            self.result_json = m.get('ResultJson')
        return self


class ListAnalyticsDataResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: ListAnalyticsDataResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListAnalyticsDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = ListAnalyticsDataResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListDataSourceItemRequest(TeaModel):
    def __init__(self, data_source_id=None, iot_instance_id=None, page=None, page_size=None, search_name=None):
        self.data_source_id = data_source_id  # type: long
        self.iot_instance_id = iot_instance_id  # type: str
        self.page = page  # type: int
        self.page_size = page_size  # type: int
        self.search_name = search_name  # type: str

    def validate(self):
        self.validate_required(self.data_source_id, 'data_source_id')
        self.validate_required(self.page, 'page')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        _map = super(ListDataSourceItemRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.search_name is not None:
            result['SearchName'] = self.search_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SearchName') is not None:
            self.search_name = m.get('SearchName')
        return self


class ListDataSourceItemResponseDataSourceItemsDataSourceItem(TeaModel):
    def __init__(self, data_source_item_id=None, device_name=None, product_key=None, scope_type=None, topic=None):
        self.data_source_item_id = data_source_item_id  # type: long
        self.device_name = device_name  # type: str
        self.product_key = product_key  # type: str
        self.scope_type = scope_type  # type: str
        self.topic = topic  # type: str

    def validate(self):
        self.validate_required(self.data_source_item_id, 'data_source_item_id')
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.scope_type, 'scope_type')
        self.validate_required(self.topic, 'topic')

    def to_map(self):
        _map = super(ListDataSourceItemResponseDataSourceItemsDataSourceItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_source_item_id is not None:
            result['DataSourceItemId'] = self.data_source_item_id
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.scope_type is not None:
            result['ScopeType'] = self.scope_type
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataSourceItemId') is not None:
            self.data_source_item_id = m.get('DataSourceItemId')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ScopeType') is not None:
            self.scope_type = m.get('ScopeType')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class ListDataSourceItemResponseDataSourceItems(TeaModel):
    def __init__(self, data_source_item=None):
        self.data_source_item = data_source_item  # type: list[ListDataSourceItemResponseDataSourceItemsDataSourceItem]

    def validate(self):
        self.validate_required(self.data_source_item, 'data_source_item')
        if self.data_source_item:
            for k in self.data_source_item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListDataSourceItemResponseDataSourceItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['dataSourceItem'] = []
        if self.data_source_item is not None:
            for k in self.data_source_item:
                result['dataSourceItem'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data_source_item = []
        if m.get('dataSourceItem') is not None:
            for k in m.get('dataSourceItem'):
                temp_model = ListDataSourceItemResponseDataSourceItemsDataSourceItem()
                self.data_source_item.append(temp_model.from_map(k))
        return self


class ListDataSourceItemResponse(TeaModel):
    def __init__(self, code=None, error_message=None, page=None, page_size=None, request_id=None, success=None,
                 total=None, data_source_items=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.page = page  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.total = total  # type: int
        self.data_source_items = data_source_items  # type: ListDataSourceItemResponseDataSourceItems

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.page, 'page')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.total, 'total')
        self.validate_required(self.data_source_items, 'data_source_items')
        if self.data_source_items:
            self.data_source_items.validate()

    def to_map(self):
        _map = super(ListDataSourceItemResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        if self.data_source_items is not None:
            result['DataSourceItems'] = self.data_source_items.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('DataSourceItems') is not None:
            temp_model = ListDataSourceItemResponseDataSourceItems()
            self.data_source_items = temp_model.from_map(m['DataSourceItems'])
        return self


class ListDestinationRequest(TeaModel):
    def __init__(self, iot_instance_id=None, page=None, page_size=None, search_name=None, types=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.page = page  # type: int
        self.page_size = page_size  # type: int
        self.search_name = search_name  # type: str
        self.types = types  # type: list[str]

    def validate(self):
        self.validate_required(self.page, 'page')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        _map = super(ListDestinationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.search_name is not None:
            result['SearchName'] = self.search_name
        if self.types is not None:
            result['Types'] = self.types
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SearchName') is not None:
            self.search_name = m.get('SearchName')
        if m.get('Types') is not None:
            self.types = m.get('Types')
        return self


class ListDestinationResponseDestinationsDestinations(TeaModel):
    def __init__(self, configuration=None, description=None, destination_id=None, is_failover=None, name=None,
                 status=None, type=None, utc_created=None):
        self.configuration = configuration  # type: str
        self.description = description  # type: str
        self.destination_id = destination_id  # type: long
        self.is_failover = is_failover  # type: bool
        self.name = name  # type: str
        self.status = status  # type: str
        self.type = type  # type: str
        self.utc_created = utc_created  # type: str

    def validate(self):
        self.validate_required(self.configuration, 'configuration')
        self.validate_required(self.description, 'description')
        self.validate_required(self.destination_id, 'destination_id')
        self.validate_required(self.is_failover, 'is_failover')
        self.validate_required(self.name, 'name')
        self.validate_required(self.status, 'status')
        self.validate_required(self.type, 'type')
        self.validate_required(self.utc_created, 'utc_created')

    def to_map(self):
        _map = super(ListDestinationResponseDestinationsDestinations, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.configuration is not None:
            result['Configuration'] = self.configuration
        if self.description is not None:
            result['Description'] = self.description
        if self.destination_id is not None:
            result['DestinationId'] = self.destination_id
        if self.is_failover is not None:
            result['IsFailover'] = self.is_failover
        if self.name is not None:
            result['Name'] = self.name
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.utc_created is not None:
            result['UtcCreated'] = self.utc_created
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Configuration') is not None:
            self.configuration = m.get('Configuration')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DestinationId') is not None:
            self.destination_id = m.get('DestinationId')
        if m.get('IsFailover') is not None:
            self.is_failover = m.get('IsFailover')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UtcCreated') is not None:
            self.utc_created = m.get('UtcCreated')
        return self


class ListDestinationResponseDestinations(TeaModel):
    def __init__(self, destinations=None):
        self.destinations = destinations  # type: list[ListDestinationResponseDestinationsDestinations]

    def validate(self):
        self.validate_required(self.destinations, 'destinations')
        if self.destinations:
            for k in self.destinations:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListDestinationResponseDestinations, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['destinations'] = []
        if self.destinations is not None:
            for k in self.destinations:
                result['destinations'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.destinations = []
        if m.get('destinations') is not None:
            for k in m.get('destinations'):
                temp_model = ListDestinationResponseDestinationsDestinations()
                self.destinations.append(temp_model.from_map(k))
        return self


class ListDestinationResponse(TeaModel):
    def __init__(self, code=None, error_message=None, page=None, page_size=None, request_id=None, success=None,
                 total=None, destinations=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.page = page  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.total = total  # type: int
        self.destinations = destinations  # type: ListDestinationResponseDestinations

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.page, 'page')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.total, 'total')
        self.validate_required(self.destinations, 'destinations')
        if self.destinations:
            self.destinations.validate()

    def to_map(self):
        _map = super(ListDestinationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        if self.destinations is not None:
            result['Destinations'] = self.destinations.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Destinations') is not None:
            temp_model = ListDestinationResponseDestinations()
            self.destinations = temp_model.from_map(m['Destinations'])
        return self


class ListDeviceDistributeJobRequest(TeaModel):
    def __init__(self, target_uid=None, current_page=None, page_size=None, status=None, job_id=None, next_token=None,
                 product_key=None):
        self.target_uid = target_uid  # type: str
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.status = status  # type: int
        self.job_id = job_id  # type: str
        self.next_token = next_token  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        _map = super(ListDeviceDistributeJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.status is not None:
            result['Status'] = self.status
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class ListDeviceDistributeJobResponseDataJobInfoItemsTargetInstanceConfigsTargetInstanceConfigs(TeaModel):
    def __init__(self, target_instance_id=None, target_instance_name=None, target_region=None):
        self.target_instance_id = target_instance_id  # type: str
        self.target_instance_name = target_instance_name  # type: str
        self.target_region = target_region  # type: str

    def validate(self):
        self.validate_required(self.target_instance_id, 'target_instance_id')
        self.validate_required(self.target_instance_name, 'target_instance_name')
        self.validate_required(self.target_region, 'target_region')

    def to_map(self):
        _map = super(ListDeviceDistributeJobResponseDataJobInfoItemsTargetInstanceConfigsTargetInstanceConfigs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.target_instance_id is not None:
            result['TargetInstanceId'] = self.target_instance_id
        if self.target_instance_name is not None:
            result['TargetInstanceName'] = self.target_instance_name
        if self.target_region is not None:
            result['TargetRegion'] = self.target_region
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TargetInstanceId') is not None:
            self.target_instance_id = m.get('TargetInstanceId')
        if m.get('TargetInstanceName') is not None:
            self.target_instance_name = m.get('TargetInstanceName')
        if m.get('TargetRegion') is not None:
            self.target_region = m.get('TargetRegion')
        return self


class ListDeviceDistributeJobResponseDataJobInfoItemsTargetInstanceConfigs(TeaModel):
    def __init__(self, target_instance_configs=None):
        self.target_instance_configs = target_instance_configs  # type: list[ListDeviceDistributeJobResponseDataJobInfoItemsTargetInstanceConfigsTargetInstanceConfigs]

    def validate(self):
        self.validate_required(self.target_instance_configs, 'target_instance_configs')
        if self.target_instance_configs:
            for k in self.target_instance_configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListDeviceDistributeJobResponseDataJobInfoItemsTargetInstanceConfigs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['targetInstanceConfigs'] = []
        if self.target_instance_configs is not None:
            for k in self.target_instance_configs:
                result['targetInstanceConfigs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.target_instance_configs = []
        if m.get('targetInstanceConfigs') is not None:
            for k in m.get('targetInstanceConfigs'):
                temp_model = ListDeviceDistributeJobResponseDataJobInfoItemsTargetInstanceConfigsTargetInstanceConfigs()
                self.target_instance_configs.append(temp_model.from_map(k))
        return self


class ListDeviceDistributeJobResponseDataJobInfoItems(TeaModel):
    def __init__(self, gmt_create=None, job_id=None, product_key=None, source_instance_id=None,
                 source_instance_name=None, source_region=None, source_uid=None, status=None, strategy=None, target_uid=None, total=None,
                 target_instance_configs=None):
        self.gmt_create = gmt_create  # type: long
        self.job_id = job_id  # type: str
        self.product_key = product_key  # type: str
        self.source_instance_id = source_instance_id  # type: str
        self.source_instance_name = source_instance_name  # type: str
        self.source_region = source_region  # type: str
        self.source_uid = source_uid  # type: str
        self.status = status  # type: int
        self.strategy = strategy  # type: int
        self.target_uid = target_uid  # type: str
        self.total = total  # type: int
        self.target_instance_configs = target_instance_configs  # type: ListDeviceDistributeJobResponseDataJobInfoItemsTargetInstanceConfigs

    def validate(self):
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.job_id, 'job_id')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.source_instance_id, 'source_instance_id')
        self.validate_required(self.source_instance_name, 'source_instance_name')
        self.validate_required(self.source_region, 'source_region')
        self.validate_required(self.source_uid, 'source_uid')
        self.validate_required(self.status, 'status')
        self.validate_required(self.strategy, 'strategy')
        self.validate_required(self.target_uid, 'target_uid')
        self.validate_required(self.total, 'total')
        self.validate_required(self.target_instance_configs, 'target_instance_configs')
        if self.target_instance_configs:
            self.target_instance_configs.validate()

    def to_map(self):
        _map = super(ListDeviceDistributeJobResponseDataJobInfoItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        if self.source_instance_name is not None:
            result['SourceInstanceName'] = self.source_instance_name
        if self.source_region is not None:
            result['SourceRegion'] = self.source_region
        if self.source_uid is not None:
            result['SourceUid'] = self.source_uid
        if self.status is not None:
            result['Status'] = self.status
        if self.strategy is not None:
            result['Strategy'] = self.strategy
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        if self.total is not None:
            result['Total'] = self.total
        if self.target_instance_configs is not None:
            result['TargetInstanceConfigs'] = self.target_instance_configs.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        if m.get('SourceInstanceName') is not None:
            self.source_instance_name = m.get('SourceInstanceName')
        if m.get('SourceRegion') is not None:
            self.source_region = m.get('SourceRegion')
        if m.get('SourceUid') is not None:
            self.source_uid = m.get('SourceUid')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Strategy') is not None:
            self.strategy = m.get('Strategy')
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('TargetInstanceConfigs') is not None:
            temp_model = ListDeviceDistributeJobResponseDataJobInfoItemsTargetInstanceConfigs()
            self.target_instance_configs = temp_model.from_map(m['TargetInstanceConfigs'])
        return self


class ListDeviceDistributeJobResponseDataJobInfo(TeaModel):
    def __init__(self, items=None):
        self.items = items  # type: list[ListDeviceDistributeJobResponseDataJobInfoItems]

    def validate(self):
        self.validate_required(self.items, 'items')
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListDeviceDistributeJobResponseDataJobInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = ListDeviceDistributeJobResponseDataJobInfoItems()
                self.items.append(temp_model.from_map(k))
        return self


class ListDeviceDistributeJobResponseData(TeaModel):
    def __init__(self, next_token=None, total=None, job_info=None):
        self.next_token = next_token  # type: str
        self.total = total  # type: int
        self.job_info = job_info  # type: ListDeviceDistributeJobResponseDataJobInfo

    def validate(self):
        self.validate_required(self.next_token, 'next_token')
        self.validate_required(self.total, 'total')
        self.validate_required(self.job_info, 'job_info')
        if self.job_info:
            self.job_info.validate()

    def to_map(self):
        _map = super(ListDeviceDistributeJobResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.total is not None:
            result['Total'] = self.total
        if self.job_info is not None:
            result['JobInfo'] = self.job_info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('JobInfo') is not None:
            temp_model = ListDeviceDistributeJobResponseDataJobInfo()
            self.job_info = temp_model.from_map(m['JobInfo'])
        return self


class ListDeviceDistributeJobResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: ListDeviceDistributeJobResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListDeviceDistributeJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = ListDeviceDistributeJobResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListDistributedDeviceRequest(TeaModel):
    def __init__(self, current_page=None, device_name=None, page_size=None, product_key=None,
                 source_instance_id=None, target_uid=None):
        self.current_page = current_page  # type: int
        self.device_name = device_name  # type: str
        self.page_size = page_size  # type: int
        self.product_key = product_key  # type: str
        self.source_instance_id = source_instance_id  # type: str
        self.target_uid = target_uid  # type: str

    def validate(self):
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        _map = super(ListDistributedDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        return self


class ListDistributedDeviceResponseDataInfoItems(TeaModel):
    def __init__(self, device_name=None, gmt_create=None, gmt_modified=None, product_key=None,
                 source_instance_id=None, source_instance_name=None, source_region=None, source_uid=None, target_aliyun_id=None,
                 target_instance_id=None, target_instance_name=None, target_region=None, target_uid=None):
        self.device_name = device_name  # type: str
        self.gmt_create = gmt_create  # type: long
        self.gmt_modified = gmt_modified  # type: long
        self.product_key = product_key  # type: str
        self.source_instance_id = source_instance_id  # type: str
        self.source_instance_name = source_instance_name  # type: str
        self.source_region = source_region  # type: str
        self.source_uid = source_uid  # type: str
        self.target_aliyun_id = target_aliyun_id  # type: str
        self.target_instance_id = target_instance_id  # type: str
        self.target_instance_name = target_instance_name  # type: str
        self.target_region = target_region  # type: str
        self.target_uid = target_uid  # type: str

    def validate(self):
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.source_instance_id, 'source_instance_id')
        self.validate_required(self.source_instance_name, 'source_instance_name')
        self.validate_required(self.source_region, 'source_region')
        self.validate_required(self.source_uid, 'source_uid')
        self.validate_required(self.target_aliyun_id, 'target_aliyun_id')
        self.validate_required(self.target_instance_id, 'target_instance_id')
        self.validate_required(self.target_instance_name, 'target_instance_name')
        self.validate_required(self.target_region, 'target_region')
        self.validate_required(self.target_uid, 'target_uid')

    def to_map(self):
        _map = super(ListDistributedDeviceResponseDataInfoItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        if self.source_instance_name is not None:
            result['SourceInstanceName'] = self.source_instance_name
        if self.source_region is not None:
            result['SourceRegion'] = self.source_region
        if self.source_uid is not None:
            result['SourceUid'] = self.source_uid
        if self.target_aliyun_id is not None:
            result['TargetAliyunId'] = self.target_aliyun_id
        if self.target_instance_id is not None:
            result['TargetInstanceId'] = self.target_instance_id
        if self.target_instance_name is not None:
            result['TargetInstanceName'] = self.target_instance_name
        if self.target_region is not None:
            result['TargetRegion'] = self.target_region
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        if m.get('SourceInstanceName') is not None:
            self.source_instance_name = m.get('SourceInstanceName')
        if m.get('SourceRegion') is not None:
            self.source_region = m.get('SourceRegion')
        if m.get('SourceUid') is not None:
            self.source_uid = m.get('SourceUid')
        if m.get('TargetAliyunId') is not None:
            self.target_aliyun_id = m.get('TargetAliyunId')
        if m.get('TargetInstanceId') is not None:
            self.target_instance_id = m.get('TargetInstanceId')
        if m.get('TargetInstanceName') is not None:
            self.target_instance_name = m.get('TargetInstanceName')
        if m.get('TargetRegion') is not None:
            self.target_region = m.get('TargetRegion')
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        return self


class ListDistributedDeviceResponseDataInfo(TeaModel):
    def __init__(self, items=None):
        self.items = items  # type: list[ListDistributedDeviceResponseDataInfoItems]

    def validate(self):
        self.validate_required(self.items, 'items')
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListDistributedDeviceResponseDataInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = ListDistributedDeviceResponseDataInfoItems()
                self.items.append(temp_model.from_map(k))
        return self


class ListDistributedDeviceResponseData(TeaModel):
    def __init__(self, total=None, info=None):
        self.total = total  # type: int
        self.info = info  # type: ListDistributedDeviceResponseDataInfo

    def validate(self):
        self.validate_required(self.total, 'total')
        self.validate_required(self.info, 'info')
        if self.info:
            self.info.validate()

    def to_map(self):
        _map = super(ListDistributedDeviceResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.info is not None:
            result['Info'] = self.info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Info') is not None:
            temp_model = ListDistributedDeviceResponseDataInfo()
            self.info = temp_model.from_map(m['Info'])
        return self


class ListDistributedDeviceResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: ListDistributedDeviceResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListDistributedDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = ListDistributedDeviceResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListDistributedProductRequest(TeaModel):
    def __init__(self, page_size=None, source_instance_id=None, product_key=None, target_instance_id=None,
                 target_uid=None, current_page=None):
        self.page_size = page_size  # type: int
        self.source_instance_id = source_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.target_instance_id = target_instance_id  # type: str
        self.target_uid = target_uid  # type: str
        self.current_page = current_page  # type: int

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')

    def to_map(self):
        _map = super(ListDistributedProductRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.target_instance_id is not None:
            result['TargetInstanceId'] = self.target_instance_id
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TargetInstanceId') is not None:
            self.target_instance_id = m.get('TargetInstanceId')
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class ListDistributedProductResponseDataInfoItems(TeaModel):
    def __init__(self, gmt_create=None, product_key=None, source_instance_id=None, source_instance_name=None,
                 source_region=None, source_uid=None, target_aliyun_id=None, target_instance_id=None, target_instance_name=None,
                 target_region=None, target_uid=None):
        self.gmt_create = gmt_create  # type: long
        self.product_key = product_key  # type: str
        self.source_instance_id = source_instance_id  # type: str
        self.source_instance_name = source_instance_name  # type: str
        self.source_region = source_region  # type: str
        self.source_uid = source_uid  # type: str
        self.target_aliyun_id = target_aliyun_id  # type: str
        self.target_instance_id = target_instance_id  # type: str
        self.target_instance_name = target_instance_name  # type: str
        self.target_region = target_region  # type: str
        self.target_uid = target_uid  # type: str

    def validate(self):
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.source_instance_id, 'source_instance_id')
        self.validate_required(self.source_instance_name, 'source_instance_name')
        self.validate_required(self.source_region, 'source_region')
        self.validate_required(self.source_uid, 'source_uid')
        self.validate_required(self.target_aliyun_id, 'target_aliyun_id')
        self.validate_required(self.target_instance_id, 'target_instance_id')
        self.validate_required(self.target_instance_name, 'target_instance_name')
        self.validate_required(self.target_region, 'target_region')
        self.validate_required(self.target_uid, 'target_uid')

    def to_map(self):
        _map = super(ListDistributedProductResponseDataInfoItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        if self.source_instance_name is not None:
            result['SourceInstanceName'] = self.source_instance_name
        if self.source_region is not None:
            result['SourceRegion'] = self.source_region
        if self.source_uid is not None:
            result['SourceUid'] = self.source_uid
        if self.target_aliyun_id is not None:
            result['TargetAliyunId'] = self.target_aliyun_id
        if self.target_instance_id is not None:
            result['TargetInstanceId'] = self.target_instance_id
        if self.target_instance_name is not None:
            result['TargetInstanceName'] = self.target_instance_name
        if self.target_region is not None:
            result['TargetRegion'] = self.target_region
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        if m.get('SourceInstanceName') is not None:
            self.source_instance_name = m.get('SourceInstanceName')
        if m.get('SourceRegion') is not None:
            self.source_region = m.get('SourceRegion')
        if m.get('SourceUid') is not None:
            self.source_uid = m.get('SourceUid')
        if m.get('TargetAliyunId') is not None:
            self.target_aliyun_id = m.get('TargetAliyunId')
        if m.get('TargetInstanceId') is not None:
            self.target_instance_id = m.get('TargetInstanceId')
        if m.get('TargetInstanceName') is not None:
            self.target_instance_name = m.get('TargetInstanceName')
        if m.get('TargetRegion') is not None:
            self.target_region = m.get('TargetRegion')
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        return self


class ListDistributedProductResponseDataInfo(TeaModel):
    def __init__(self, items=None):
        self.items = items  # type: list[ListDistributedProductResponseDataInfoItems]

    def validate(self):
        self.validate_required(self.items, 'items')
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListDistributedProductResponseDataInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = ListDistributedProductResponseDataInfoItems()
                self.items.append(temp_model.from_map(k))
        return self


class ListDistributedProductResponseData(TeaModel):
    def __init__(self, total=None, info=None):
        self.total = total  # type: int
        self.info = info  # type: ListDistributedProductResponseDataInfo

    def validate(self):
        self.validate_required(self.total, 'total')
        self.validate_required(self.info, 'info')
        if self.info:
            self.info.validate()

    def to_map(self):
        _map = super(ListDistributedProductResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.info is not None:
            result['Info'] = self.info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Info') is not None:
            temp_model = ListDistributedProductResponseDataInfo()
            self.info = temp_model.from_map(m['Info'])
        return self


class ListDistributedProductResponse(TeaModel):
    def __init__(self, code=None, error_message=None, request_id=None, success=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.data = data  # type: ListDistributedProductResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListDistributedProductResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = ListDistributedProductResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListJobRequest(TeaModel):
    def __init__(self, current_page=None, iot_instance_id=None, page_size=None, status=None):
        self.current_page = current_page  # type: int
        self.iot_instance_id = iot_instance_id  # type: str
        self.page_size = page_size  # type: int
        self.status = status  # type: str

    def validate(self):
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        _map = super(ListJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListJobResponseDataData(TeaModel):
    def __init__(self, description=None, job_id=None, job_name=None, scheduled_time=None, status=None, type=None,
                 utc_create=None, utc_modified=None):
        self.description = description  # type: str
        self.job_id = job_id  # type: str
        self.job_name = job_name  # type: str
        self.scheduled_time = scheduled_time  # type: long
        self.status = status  # type: str
        self.type = type  # type: str
        self.utc_create = utc_create  # type: str
        self.utc_modified = utc_modified  # type: str

    def validate(self):
        self.validate_required(self.description, 'description')
        self.validate_required(self.job_id, 'job_id')
        self.validate_required(self.job_name, 'job_name')
        self.validate_required(self.scheduled_time, 'scheduled_time')
        self.validate_required(self.status, 'status')
        self.validate_required(self.type, 'type')
        self.validate_required(self.utc_create, 'utc_create')
        self.validate_required(self.utc_modified, 'utc_modified')

    def to_map(self):
        _map = super(ListJobResponseDataData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.scheduled_time is not None:
            result['ScheduledTime'] = self.scheduled_time
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('ScheduledTime') is not None:
            self.scheduled_time = m.get('ScheduledTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        return self


class ListJobResponseData(TeaModel):
    def __init__(self, data=None):
        self.data = data  # type: list[ListJobResponseDataData]

    def validate(self):
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListJobResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = ListJobResponseDataData()
                self.data.append(temp_model.from_map(k))
        return self


class ListJobResponse(TeaModel):
    def __init__(self, code=None, error_message=None, page=None, page_size=None, request_id=None, success=None,
                 total=None, data=None):
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.page = page  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.total = total  # type: int
        self.data = data  # type: ListJobResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.page, 'page')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.total, 'total')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Data') is not None:
            temp_model = ListJobResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListOTAFirmwareRequest(TeaModel):
    def __init__(self, current_page=None, dest_version=None, iot_instance_id=None, page_size=None, product_key=None):
        self.current_page = current_page  # type: int
        self.dest_version = dest_version  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.page_size = page_size  # type: int
        self.product_key = product_key  # type: str

    def validate(self):
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        _map = super(ListOTAFirmwareRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dest_version is not None:
            result['DestVersion'] = self.dest_version
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DestVersion') is not None:
            self.dest_version = m.get('DestVersion')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class ListOTAFirmwareResponseFirmwareInfoSimpleFirmwareInfo(TeaModel):
    def __init__(self, dest_version=None, firmware_desc=None, firmware_id=None, firmware_name=None,
                 firmware_sign=None, firmware_size=None, module_name=None, product_key=None, product_name=None, sign_method=None,
                 src_version=None, status=None, type=None, utc_create=None, utc_modified=None):
        self.dest_version = dest_version  # type: str
        self.firmware_desc = firmware_desc  # type: str
        self.firmware_id = firmware_id  # type: str
        self.firmware_name = firmware_name  # type: str
        self.firmware_sign = firmware_sign  # type: str
        self.firmware_size = firmware_size  # type: int
        self.module_name = module_name  # type: str
        self.product_key = product_key  # type: str
        self.product_name = product_name  # type: str
        self.sign_method = sign_method  # type: str
        self.src_version = src_version  # type: str
        self.status = status  # type: int
        self.type = type  # type: int
        self.utc_create = utc_create  # type: str
        self.utc_modified = utc_modified  # type: str

    def validate(self):
        self.validate_required(self.dest_version, 'dest_version')
        self.validate_required(self.firmware_desc, 'firmware_desc')
        self.validate_required(self.firmware_id, 'firmware_id')
        self.validate_required(self.firmware_name, 'firmware_name')
        self.validate_required(self.firmware_sign, 'firmware_sign')
        self.validate_required(self.firmware_size, 'firmware_size')
        self.validate_required(self.module_name, 'module_name')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.product_name, 'product_name')
        self.validate_required(self.sign_method, 'sign_method')
        self.validate_required(self.src_version, 'src_version')
        self.validate_required(self.status, 'status')
        self.validate_required(self.type, 'type')
        self.validate_required(self.utc_create, 'utc_create')
        self.validate_required(self.utc_modified, 'utc_modified')

    def to_map(self):
        _map = super(ListOTAFirmwareResponseFirmwareInfoSimpleFirmwareInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dest_version is not None:
            result['DestVersion'] = self.dest_version
        if self.firmware_desc is not None:
            result['FirmwareDesc'] = self.firmware_desc
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.firmware_name is not None:
            result['FirmwareName'] = self.firmware_name
        if self.firmware_sign is not None:
            result['FirmwareSign'] = self.firmware_sign
        if self.firmware_size is not None:
            result['FirmwareSize'] = self.firmware_size
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.sign_method is not None:
            result['SignMethod'] = self.sign_method
        if self.src_version is not None:
            result['SrcVersion'] = self.src_version
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DestVersion') is not None:
            self.dest_version = m.get('DestVersion')
        if m.get('FirmwareDesc') is not None:
            self.firmware_desc = m.get('FirmwareDesc')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('FirmwareName') is not None:
            self.firmware_name = m.get('FirmwareName')
        if m.get('FirmwareSign') is not None:
            self.firmware_sign = m.get('FirmwareSign')
        if m.get('FirmwareSize') is not None:
            self.firmware_size = m.get('FirmwareSize')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('SignMethod') is not None:
            self.sign_method = m.get('SignMethod')
        if m.get('SrcVersion') is not None:
            self.src_version = m.get('SrcVersion')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        return self


class ListOTAFirmwareResponseFirmwareInfo(TeaModel):
    def __init__(self, simple_firmware_info=None):
        self.simple_firmware_info = simple_firmware_info  # type: list[ListOTAFirmwareResponseFirmwareInfoSimpleFirmwareInfo]

    def validate(self):
        self.validate_required(self.simple_firmware_info, 'simple_firmware_info')
        if self.simple_firmware_info:
            for k in self.simple_firmware_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListOTAFirmwareResponseFirmwareInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SimpleFirmwareInfo'] = []
        if self.simple_firmware_info is not None:
            for k in self.simple_firmware_info:
                result['SimpleFirmwareInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.simple_firmware_info = []
        if m.get('SimpleFirmwareInfo') is not None:
            for k in m.get('SimpleFirmwareInfo'):
                temp_model = ListOTAFirmwareResponseFirmwareInfoSimpleFirmwareInfo()
                self.simple_firmware_info.append(temp_model.from_map(k))
        return self


class ListOTAFirmwareResponse(TeaModel):
    def __init__(self, code=None, current_page=None, error_message=None, page_count=None, page_size=None,
                 request_id=None, success=None, total=None, firmware_info=None):
        self.code = code  # type: str
        self.current_page = current_page  # type: int
        self.error_message = error_message  # type: str
        self.page_count = page_count  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.total = total  # type: int
        self.firmware_info = firmware_info  # type: ListOTAFirmwareResponseFirmwareInfo

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.page_count, 'page_count')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.total, 'total')
        self.validate_required(self.firmware_info, 'firmware_info')
        if self.firmware_info:
            self.firmware_info.validate()

    def to_map(self):
        _map = super(ListOTAFirmwareResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        if self.firmware_info is not None:
            result['FirmwareInfo'] = self.firmware_info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('FirmwareInfo') is not None:
            temp_model = ListOTAFirmwareResponseFirmwareInfo()
            self.firmware_info = temp_model.from_map(m['FirmwareInfo'])
        return self


class ListOTAJobByDeviceRequest(TeaModel):
    def __init__(self, current_page=None, device_name=None, firmware_id=None, iot_instance_id=None, page_size=None,
                 product_key=None):
        self.current_page = current_page  # type: int
        self.device_name = device_name  # type: str
        self.firmware_id = firmware_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.page_size = page_size  # type: int
        self.product_key = product_key  # type: str

    def validate(self):
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.firmware_id, 'firmware_id')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        _map = super(ListOTAJobByDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class ListOTAJobByDeviceResponseDataSimpleOTAJobInfoTagsOtaTagDTO(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        _map = super(ListOTAJobByDeviceResponseDataSimpleOTAJobInfoTagsOtaTagDTO, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListOTAJobByDeviceResponseDataSimpleOTAJobInfoTags(TeaModel):
    def __init__(self, ota_tag_dto=None):
        self.ota_tag_dto = ota_tag_dto  # type: list[ListOTAJobByDeviceResponseDataSimpleOTAJobInfoTagsOtaTagDTO]

    def validate(self):
        self.validate_required(self.ota_tag_dto, 'ota_tag_dto')
        if self.ota_tag_dto:
            for k in self.ota_tag_dto:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListOTAJobByDeviceResponseDataSimpleOTAJobInfoTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OtaTagDTO'] = []
        if self.ota_tag_dto is not None:
            for k in self.ota_tag_dto:
                result['OtaTagDTO'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.ota_tag_dto = []
        if m.get('OtaTagDTO') is not None:
            for k in m.get('OtaTagDTO'):
                temp_model = ListOTAJobByDeviceResponseDataSimpleOTAJobInfoTagsOtaTagDTO()
                self.ota_tag_dto.append(temp_model.from_map(k))
        return self


class ListOTAJobByDeviceResponseDataSimpleOTAJobInfo(TeaModel):
    def __init__(self, firmware_id=None, job_id=None, job_status=None, job_type=None, product_key=None,
                 selection_type=None, target_selection=None, utc_create=None, utc_end_time=None, utc_modified=None,
                 utc_start_time=None, tags=None):
        self.firmware_id = firmware_id  # type: str
        self.job_id = job_id  # type: str
        self.job_status = job_status  # type: str
        self.job_type = job_type  # type: str
        self.product_key = product_key  # type: str
        self.selection_type = selection_type  # type: str
        self.target_selection = target_selection  # type: str
        self.utc_create = utc_create  # type: str
        self.utc_end_time = utc_end_time  # type: str
        self.utc_modified = utc_modified  # type: str
        self.utc_start_time = utc_start_time  # type: str
        self.tags = tags  # type: ListOTAJobByDeviceResponseDataSimpleOTAJobInfoTags

    def validate(self):
        self.validate_required(self.firmware_id, 'firmware_id')
        self.validate_required(self.job_id, 'job_id')
        self.validate_required(self.job_status, 'job_status')
        self.validate_required(self.job_type, 'job_type')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.selection_type, 'selection_type')
        self.validate_required(self.target_selection, 'target_selection')
        self.validate_required(self.utc_create, 'utc_create')
        self.validate_required(self.utc_end_time, 'utc_end_time')
        self.validate_required(self.utc_modified, 'utc_modified')
        self.validate_required(self.utc_start_time, 'utc_start_time')
        self.validate_required(self.tags, 'tags')
        if self.tags:
            self.tags.validate()

    def to_map(self):
        _map = super(ListOTAJobByDeviceResponseDataSimpleOTAJobInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.job_status is not None:
            result['JobStatus'] = self.job_status
        if self.job_type is not None:
            result['JobType'] = self.job_type
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.selection_type is not None:
            result['SelectionType'] = self.selection_type
        if self.target_selection is not None:
            result['TargetSelection'] = self.target_selection
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_end_time is not None:
            result['UtcEndTime'] = self.utc_end_time
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.utc_start_time is not None:
            result['UtcStartTime'] = self.utc_start_time
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('JobStatus') is not None:
            self.job_status = m.get('JobStatus')
        if m.get('JobType') is not None:
            self.job_type = m.get('JobType')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('SelectionType') is not None:
            self.selection_type = m.get('SelectionType')
        if m.get('TargetSelection') is not None:
            self.target_selection = m.get('TargetSelection')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcEndTime') is not None:
            self.utc_end_time = m.get('UtcEndTime')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('UtcStartTime') is not None:
            self.utc_start_time = m.get('UtcStartTime')
        if m.get('Tags') is not None:
            temp_model = ListOTAJobByDeviceResponseDataSimpleOTAJobInfoTags()
            self.tags = temp_model.from_map(m['Tags'])
        return self


class ListOTAJobByDeviceResponseData(TeaModel):
    def __init__(self, simple_otajob_info=None):
        self.simple_otajob_info = simple_otajob_info  # type: list[ListOTAJobByDeviceResponseDataSimpleOTAJobInfo]

    def validate(self):
        self.validate_required(self.simple_otajob_info, 'simple_otajob_info')
        if self.simple_otajob_info:
            for k in self.simple_otajob_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListOTAJobByDeviceResponseData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SimpleOTAJobInfo'] = []
        if self.simple_otajob_info is not None:
            for k in self.simple_otajob_info:
                result['SimpleOTAJobInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.simple_otajob_info = []
        if m.get('SimpleOTAJobInfo') is not None:
            for k in m.get('SimpleOTAJobInfo'):
                temp_model = ListOTAJobByDeviceResponseDataSimpleOTAJobInfo()
                self.simple_otajob_info.append(temp_model.from_map(k))
        return self


class ListOTAJobByDeviceResponse(TeaModel):
    def __init__(self, code=None, current_page=None, error_message=None, page_count=None, page_size=None,
                 request_id=None, success=None, total=None, data=None):
        self.code = code  # type: str
        self.current_page = current_page  # type: int
        self.error_message = error_message  # type: str
        self.page_count = page_count  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.total = total  # type: int
        self.data = data  # type: ListOTAJobByDeviceResponseData

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.page_count, 'page_count')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.total, 'total')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListOTAJobByDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Data') is not None:
            temp_model = ListOTAJobByDeviceResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListOTAJobByFirmwareRequest(TeaModel):
    def __init__(self, current_page=None, firmware_id=None, iot_instance_id=None, page_size=None):
        self.current_page = current_page  # type: int
        self.firmware_id = firmware_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.page_size = page_size  # type: int

    def validate(self):
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.firmware_id, 'firmware_id')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        _map = super(ListOTAJobByFirmwareRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListOTAJobByFirmwareResponseDataSimpleOTAJobInfoTagsOtaTagDTO(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        _map = super(ListOTAJobByFirmwareResponseDataSimpleOTAJobInfoTagsOtaTagDTO, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListOTAJobByFirmwareResponseDataSimpleOTAJobInfoTags(TeaModel):
    def __init__(self, ota_tag_dto=None):
        self.ota_tag_dto = ota_tag_dto  # type: list[ListOTAJobByFirmwareResponseDataSimpleOTAJobInfoTagsOtaTagDTO]

    def validate(self):
        self.validate_required(self.ota_tag_dto, 'ota_tag_dto')
        if self.ota_tag_dto:
            for k in self.ota_tag_dto:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListOTAJobByFirmwareResponseDataSimpleOTAJobInfoTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OtaTagDTO'] = []
        if self.ota_tag_dto is not None:
            for k in self.ota_tag_dto:
                result['OtaTagDTO'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.ota_tag_dto = []
        if m.get('OtaTagDTO') is not None:
            for k in m.get('OtaTagDTO'):
                temp_model = ListOTAJo