#!/usr/bin/env python3
# vim: expandtab:ts=4:sw=4:noai

""" Setup Argpass """

import setuptools
from pcs_argpass.Param import Version

with open("pcs_argpass/README.md", "r", encoding='utf-8') as fh:
    long_description = fh.read()
Requirements = []
try:
    with open('pcs_argpass/requirements.txt','r',encoding='utf-8') as f:
        Requirements = [x for x in  [y.strip() for y in f.readlines()] if x]
except:
    pass

setuptools.setup(
    name="pcs_argpass",
    # version="0.10.9",
    python_requires='>=3.6',
    author="Rainer Pietsch",
    author_email="r.pietsch@pcs-at.com",
    description="Argument parser and checker.",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://argpass.readthedocs.io/en/latest/index.html",
    download_url="https://github.com/rpietsch1953/Argpass",
    packages=setuptools.find_packages(),
    install_requires=Requirements,
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: GNU General Public License v2 (GPLv2)",
        "Operating System :: OS Independent",
    ],
)
