#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Table 1. Primers  used  in PCR  experiments

elF-4E +    10 21 GTCGAACCGGAAACCACCCCT       60.7 1
"      -   218 23 GTGGATATGGTTGTACAGAGCCC     54.3 3
"      +   323 18 AACGGGGAGGACGATGGC          56.8 2
"      -   440 18 CAGCGCCACATACATCAT          46.9 1
"      -   695 22 TCAGCTCCCAAATCTCGATTGC      58.0 2
"      +   885 24 TACACATCCCCAGAATCCATAAAT    53.4 2
"      +  1287 18 CAAAGGTGGAATAAACAT          39.0 2
"      -  1520 24 TAACCAAAGCAAAATAACCTAAGT    48.9 2
lambda +  7131 25 GATGAGTTCGTGTCCGTACAACTGG   58.6 2
"      -  7606 25 GGTTATCGAAATCAGCCACAGCGCC   65.2 2
"      + 20161 25 CCGGCGCAGAAGCGGCATCAGCAAA   73.9 1
"      - 24182 25 TCACCAGCCAGCCGCAGCACGTTCC   72.8 1
"      + 30042 25 AGGATGGCGAACAACAAGAAACTGG   61.3 1
"      - 31017 25 GGCGAAAGCAGAAGCAGATGAGAGA   61.9 1

Table II.  The  optimal  annealing  temperature  (TaOPT)  of  PCR

323-440      135  4 50.5 (5) 1.27 50.5 0.64 0.86
10-218       227  2 54.5 (4) 0.67 53.8 1.10 1.40
1287-1520    257  2 44.0 (3) 1.54 44.1 n.d. n.d.
323-695      394  2 55.3 (6) 0.83 55.0 1.11 1.27
10-440       448  2 30.9 (7) 0.67 52.3 1.95 2.00
7131-7606    300  3 60.0 (4) 0.74 59.8 1.65 1.80
885-1520     659  2 48.4 (3) 0.55 49.2 1.70 1.78
10-695       707  2 56.0 (4) 0.38 55.8 1.67 1.77
30042-31017 1000  1 59.8 (4) 1.24 58.3 1.90 1.85
20161-24182 4046  2 59.8 (3) 1.71 61.4 1.95 0.62
20161-31017 10881 2 56.6 (3) 0.47 57.6 0.09 0.00
"""

import pandas as pd
from io import StringIO
import math

"""
>30042 61.3
AGGATGGCGAACAACAAGAAACTGG   
>31017 61.9
GGCGAAAGCAGAAGCAGATGAGAGA

==============
PCR simulation
==============

Template LAMCG 48502 nt linear:
Primer 30042 anneals at position 30065
Primer 31017 anneals reverse at position 31017

PCR product from LAMCG:

>1000bp HB6xxN81mL12Nmiq7x4mYhVlk1I
AGGATGGCGAACAACAAGAAACTGGTTTCCGTCTTCACGGACTTCGTTGCTTTCCAGTTTAGCAATACGCTTACTCCCATCCGAGATAACACCTTCGTAATACTCACGCTGCTCGTTGAGTTTTGATTTTGCTGTTTCAAGCTCAACACGCAGTTTCCCTACTGTTAGCGCAATATCCTCGTTCTCCTGGTCGCGGCGTTTGATGTATTGCTGGTTTCTTTCCCGTTCATCCAGCAGTTCCAGCACAATCGATGGTGTTACCAATTCATGGAAAAGGTCTGCGTCAAATCCCCAGTCGTCATGCATTGCCTGCTCTGCCGCTTCACGCAGTGCCTGAGAGTTAATTTCGCTCACTTCGAACCTCTCTGTTTACTGATAAGTTCCAGATCCTCCTGGCAACTTGCACAAGTCCGACAACCCTGAACGACCAGGCGTCTTCGTTCATCTATCGGATCGCCACACTCACAACAATGAGTGGCAGATATAGCCTGGTGGTTCAGGCGGCGCATTTTTATTGCTGTGTTGCGCTGTAATTCTTCTATTTCTGATGCTGAATCAATGATGTCTGCCATCTTTCATTAATCCCTGAACTGTTGGTTAATACGCTTGAGGGTGAATGCGAATAATAAAAAAGGAGCCTGTAGCTCCCTGATGATTTTGCTTTTCATGTTCATCGTTCCTTAAAGACGCCGTTTAACATGCCGATTGCCAGGCTTAAATGAGTCGGTGTGAATCCCATCAGCGTTACCGTTTCGCGGTGCTTCTTCAGTACGCTACGGCAAATGTCATCGACGTTTTTATCCGGAAACTGCTGTCTGGCTTTTTTTGATTTCAGAATTAGCCTGACGGGCAATGCTGCGAAGGGCGTTTTCCTGCTGAGGTGTCATTGAACAAGTCCCATGTCGGCAAGCATAAGCACACAGAATATGAAGCCCGCTGCCAGAAAAATGCATTCCGTGGTTGTCATACCTGGTTTCTCTCATCTGCTTCTGCTTTCGCC


5AGGATGGCGAACAACAAGAAACTGG3
 ||||||||||||||||||||||||| tm 58.0 (dbd) 72.7
5AGGATGGCGAACAACAAGAAACTGG...TCTCTCATCTGCTTCTGCTTTCGCC3
3TCCTACCGCTTGTTGTTCTTTGACC...AGAGAGTAGACGAAGACGAAAGCGG5
                             ||||||||||||||||||||||||| tm 59.1 (dbd) 73.6
                            3AGAGAGTAGACGAAGACGAAAGCGG5

suggested PCR programs

Taq (rate 30 nt/s)
Three-step|         30 cycles     |      |SantaLucia 1998
94.0°C    |94.0°C                 |      |SaltC 50mM
__________|_____          72.0°C  |72.0°C|
04min00s  |30s  \         ________|______|
          |      \ 58.0°C/ 0min30s|10min |
          |       \_____/         |      |
          |         30s           |      |4-8°C

Pfu-Sso7d (rate 15s/kb)
Two-step|    30 cycles |      |Breslauer1986,SantaLucia1998
98.0°C  |98.0C         |      |SaltC 50mM
_____ __|_____         |      |Primer1C 1000µM
00min30s|10s  \  72.0°C|72.0°C|Primer2C 1000µM
        |      \_______|______|
        |       0min15s|10min |4-8°C
"""

gc = 100 * (217 + 255) / 1000  # 1000bp HB6xxN81mL12Nmiq7x4mYhVlk1I
K = 50/1000  # M
le = 1000  # 1000bp HB6xxN81mL12Nmiq7x4mYhVlk1I
tmp = 81.5 + 0.41 * gc + 16.6 * math.log10(K) - 675/le
Ta_opt = 0.3 * 61.3 + 0.7 * tmp - 14.9

print(Ta_opt, 58.3)
