const cacheName = 'cache-v{{ version }}';
const precacheResources = [
    {% for page in pages.items %}
    '{{ page.get_url }}',
    {% endfor %}
];

self.addEventListener('install', (event) => {
  event.waitUntil(
    caches.open(cacheName)
      .then(cache => cache.addAll(precacheResources)),
  );
});

self.addEventListener('fetch', (event) => {
  event.respondWith(caches.match(event.request)
    .then((cachedResponse) => {
      if (cachedResponse) {
        return cachedResponse;
      }
      return fetch(event.request);
    }));
});
