# AUTOGENERATED! DO NOT EDIT! File to edit: 01_s3_data_utils.ipynb (unless otherwise specified).

__all__ = ['read_csv_from_s3', 'read_csv_from_s3_no_header']

# Cell
import io
import boto3
import pandas as pd
def read_csv_from_s3(source_data_bucket_name, source_data_path):
    prefix_objs = list(boto3.resource('s3').Bucket(source_data_bucket_name).objects.filter(Prefix=''.join([source_data_path])))
    df_prefix = []

    for obj in prefix_objs:
        key = obj.key
        body = obj.get()['Body'].read()
        df_chunk = pd.read_csv(io.BytesIO(body), low_memory=False, chunksize=100000)

        li = []
        counter = 1

        # Process the chunk (DataFrame)
        for chunk in df_chunk:
            print(f'Chunk no.: {counter}')
            try:
                li.append(chunk)
            except Exception as e:
                print('Exception:', e)
            counter += 1

        df_concat = pd.concat(li, axis=0, ignore_index=True, sort=True)

        df_prefix.append(df_concat)

        del df_concat  # Free-up memory.

    if len(prefix_objs) > 1:
        df = pd.concat(df_prefix, axis=0, ignore_index=True, sort=True)
    else:
        df = df_prefix[0]

    return df

# Cell
import io
import boto3
import pandas as pd
def read_csv_from_s3_no_header(source_data_bucket_name, source_data_path):
    prefix_objs = list(boto3.resource('s3').Bucket(source_data_bucket_name).objects.filter(Prefix=''.join([source_data_path])))
    df_prefix = []

    for obj in prefix_objs:
        key = obj.key
        body = obj.get()['Body'].read()
        df_chunk = pd.read_csv(io.BytesIO(body), low_memory=False, chunksize=100000)

        li = []
        counter = 1

        # Process the chunk (DataFrame)
        for chunk in df_chunk:
            print(f'Chunk no.: {counter}')
            try:
                li.append(chunk)
            except Exception as e:
                print('Exception:', e)
            counter += 1

        df_concat = pd.concat(li, axis=0, ignore_index=True)

        df_prefix.append(df_concat)

        del df_concat  # Free-up memory.

    if len(prefix_objs) > 1:
        df = pd.concat(df_prefix, axis=0, ignore_index=True)
    else:
        df = df_prefix[0]

    return df