"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
const ec2 = require("@aws-cdk/aws-ec2");
const cdk = require("@aws-cdk/core");
const index_1 = require("./index");
const app = new cdk.App();
const env = {
    region: process.env.CDK_DEFAULT_REGION,
    account: process.env.CDK_DEFAULT_ACCOUNT,
};
const subdomain = (_a = process.env.VSCODE_SUBDOMAIN) !== null && _a !== void 0 ? _a : 'vscode';
const domainName = (_b = process.env.VSCODE_DOMAIN_NAME) !== null && _b !== void 0 ? _b : 'mydomain.com';
const stack = new cdk.Stack(app, 'example-stack', {
    env,
});
const vpc = ec2.Vpc.fromLookup(stack, 'Vpc', {
    isDefault: true,
});
new index_1.VSCodeFargate(stack, 'MyVSCodeFargate', {
    domainName,
    subdomain,
    vpc,
});
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuZGVmYXVsdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9pbnRlZy5kZWZhdWx0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLHdDQUF3QztBQUN4QyxxQ0FBcUM7QUFDckMsbUNBQXdDO0FBRXhDLE1BQU0sR0FBRyxHQUFHLElBQUksR0FBRyxDQUFDLEdBQUcsRUFBRSxDQUFDO0FBRTFCLE1BQU0sR0FBRyxHQUFHO0lBQ1YsTUFBTSxFQUFFLE9BQU8sQ0FBQyxHQUFHLENBQUMsa0JBQWtCO0lBQ3RDLE9BQU8sRUFBRSxPQUFPLENBQUMsR0FBRyxDQUFDLG1CQUFtQjtDQUN6QyxDQUFDO0FBRUYsTUFBTSxTQUFTLFNBQUcsT0FBTyxDQUFDLEdBQUcsQ0FBQyxnQkFBZ0IsbUNBQUksUUFBUSxDQUFDO0FBQzNELE1BQU0sVUFBVSxTQUFHLE9BQU8sQ0FBQyxHQUFHLENBQUMsa0JBQWtCLG1DQUFJLGNBQWMsQ0FBQztBQUVwRSxNQUFNLEtBQUssR0FBRyxJQUFJLEdBQUcsQ0FBQyxLQUFLLENBQUMsR0FBRyxFQUFFLGVBQWUsRUFBRTtJQUNoRCxHQUFHO0NBQ0osQ0FBQyxDQUFDO0FBRUgsTUFBTSxHQUFHLEdBQUcsR0FBRyxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsS0FBSyxFQUFFLEtBQUssRUFBRTtJQUMzQyxTQUFTLEVBQUUsSUFBSTtDQUNoQixDQUFDLENBQUM7QUFFSCxJQUFJLHFCQUFhLENBQUMsS0FBSyxFQUFFLGlCQUFpQixFQUFFO0lBQzFDLFVBQVU7SUFDVixTQUFTO0lBQ1QsR0FBRztDQUNKLENBQUMsQ0FBQztBQUVILEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGVjMiBmcm9tICdAYXdzLWNkay9hd3MtZWMyJztcbmltcG9ydCAqIGFzIGNkayBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IFZTQ29kZUZhcmdhdGUgfSBmcm9tICcuL2luZGV4JztcblxuY29uc3QgYXBwID0gbmV3IGNkay5BcHAoKTtcblxuY29uc3QgZW52ID0ge1xuICByZWdpb246IHByb2Nlc3MuZW52LkNES19ERUZBVUxUX1JFR0lPTixcbiAgYWNjb3VudDogcHJvY2Vzcy5lbnYuQ0RLX0RFRkFVTFRfQUNDT1VOVCxcbn07XG5cbmNvbnN0IHN1YmRvbWFpbiA9IHByb2Nlc3MuZW52LlZTQ09ERV9TVUJET01BSU4gPz8gJ3ZzY29kZSc7XG5jb25zdCBkb21haW5OYW1lID0gcHJvY2Vzcy5lbnYuVlNDT0RFX0RPTUFJTl9OQU1FID8/ICdteWRvbWFpbi5jb20nO1xuXG5jb25zdCBzdGFjayA9IG5ldyBjZGsuU3RhY2soYXBwLCAnZXhhbXBsZS1zdGFjaycsIHtcbiAgZW52LFxufSk7XG5cbmNvbnN0IHZwYyA9IGVjMi5WcGMuZnJvbUxvb2t1cChzdGFjaywgJ1ZwYycsIHtcbiAgaXNEZWZhdWx0OiB0cnVlLFxufSk7XG5cbm5ldyBWU0NvZGVGYXJnYXRlKHN0YWNrLCAnTXlWU0NvZGVGYXJnYXRlJywge1xuICBkb21haW5OYW1lLFxuICBzdWJkb21haW4sXG4gIHZwYyxcbn0pO1xuXG5hcHAuc3ludGgoKTtcbiJdfQ==