
 

// This file is autogenerated. DO NOT EDIT

#pragma once
#include <robotpy_build.h>


#include <../../_impl/include/frc/controller/LinearQuadraticRegulator.h>





namespace rpygen {

using namespace frc::detail;


template <int States, int Inputs>
struct bind_frc__detail__LinearQuadraticRegulatorImpl {

    

    py::class_<typename frc::detail::LinearQuadraticRegulatorImpl<States, Inputs>> cls_LinearQuadraticRegulatorImpl;




    py::module &m;
    std::string clsName;

bind_frc__detail__LinearQuadraticRegulatorImpl(py::module &m, const char * clsName) :
    cls_LinearQuadraticRegulatorImpl(m, clsName),



    m(m),
    clsName(clsName)
{
    
}

void finish(const char * set_doc = NULL, const char * add_doc = NULL) {

    cls_LinearQuadraticRegulatorImpl.doc() =
    "Contains the controller coefficients and logic for a linear-quadratic\n"
"regulator (LQR).\n"
"LQRs use the control law u = K(r - x).\n"
"\n"
"For more on the underlying math, read\n"
"https://file.tavsys.net/control/controls-engineering-in-frc.pdf.\n"
"\n"
"@tparam States Number of states.\n"
"@tparam Inputs Number of inputs.";

  cls_LinearQuadraticRegulatorImpl
      .def(py::init<const Eigen::Matrix<double, States, States>&, const Eigen::Matrix<double, States, Inputs>&, const wpi::array<double, States>&, const wpi::array<double, Inputs>&, units::second_t>(),
      py::arg("A"), py::arg("B"), py::arg("Qelems"), py::arg("Relems"), py::arg("dt"), release_gil()    , py::keep_alive<1, 2>()    , py::keep_alive<1, 3>()    , py::keep_alive<1, 4>()    , py::keep_alive<1, 5>(), py::doc(
    "Constructs a controller with the given coefficients and plant.\n"
"\n"
":param A:      Continuous system matrix of the plant being controlled.\n"
":param B:      Continuous input matrix of the plant being controlled.\n"
":param Qelems: The maximum desired error tolerance for each state.\n"
":param Relems: The maximum desired control effort for each input.\n"
":param dt:     Discretization timestep.")
  )
    
      .def(py::init<const Eigen::Matrix<double, States, States>&, const Eigen::Matrix<double, States, Inputs>&, const Eigen::Matrix<double, States, States>&, const Eigen::Matrix<double, Inputs, Inputs>&, units::second_t>(),
      py::arg("A"), py::arg("B"), py::arg("Q"), py::arg("R"), py::arg("dt"), release_gil()    , py::keep_alive<1, 2>()    , py::keep_alive<1, 3>()    , py::keep_alive<1, 4>()    , py::keep_alive<1, 5>(), py::doc(
    "Constructs a controller with the given coefficients and plant.\n"
"\n"
":param A:  Continuous system matrix of the plant being controlled.\n"
":param B:  Continuous input matrix of the plant being controlled.\n"
":param Q:  The state cost matrix.\n"
":param R:  The input cost matrix.\n"
":param dt: Discretization timestep.")
  )
    
      .def(py::init<const Eigen::Matrix<double, States, States>&, const Eigen::Matrix<double, States, Inputs>&, const Eigen::Matrix<double, States, States>&, const Eigen::Matrix<double, Inputs, Inputs>&, const Eigen::Matrix<double, States, Inputs>&, units::second_t>(),
      py::arg("A"), py::arg("B"), py::arg("Q"), py::arg("R"), py::arg("N"), py::arg("dt"), release_gil()    , py::keep_alive<1, 2>()    , py::keep_alive<1, 3>()    , py::keep_alive<1, 4>()    , py::keep_alive<1, 5>()    , py::keep_alive<1, 6>(), py::doc(
    "Constructs a controller with the given coefficients and plant.\n"
"\n"
":param A:  Continuous system matrix of the plant being controlled.\n"
":param B:  Continuous input matrix of the plant being controlled.\n"
":param Q:  The state cost matrix.\n"
":param R:  The input cost matrix.\n"
":param N:  The state-input cross-term cost matrix.\n"
":param dt: Discretization timestep.")
  )
    
      .def("K", static_cast<const Eigen::Matrix<double, Inputs, States> & (frc::detail::LinearQuadraticRegulatorImpl<States, Inputs>::*)() const>(
&frc::detail::LinearQuadraticRegulatorImpl<States, Inputs>::K), release_gil(), py::doc(
    "Returns the controller matrix K.")
  )
    
      .def("K", static_cast<double (frc::detail::LinearQuadraticRegulatorImpl<States, Inputs>::*)(int, int) const>(
&frc::detail::LinearQuadraticRegulatorImpl<States, Inputs>::K),
      py::arg("i"), py::arg("j"), release_gil(), py::doc(
    "Returns an element of the controller matrix K.\n"
"\n"
":param i: Row of K.\n"
":param j: Column of K.")
  )
    
      .def("R", static_cast<const Eigen::Vector<double, States> & (frc::detail::LinearQuadraticRegulatorImpl<States, Inputs>::*)() const>(
&frc::detail::LinearQuadraticRegulatorImpl<States, Inputs>::R), release_gil(), py::doc(
    "Returns the reference vector r.\n"
"\n"
":returns: The reference vector.")
  )
    
      .def("R", static_cast<double (frc::detail::LinearQuadraticRegulatorImpl<States, Inputs>::*)(int) const>(
&frc::detail::LinearQuadraticRegulatorImpl<States, Inputs>::R),
      py::arg("i"), release_gil(), py::doc(
    "Returns an element of the reference vector r.\n"
"\n"
":param i: Row of r.\n"
"\n"
":returns: The row of the reference vector.")
  )
    
      .def("U", static_cast<const Eigen::Vector<double, Inputs> & (frc::detail::LinearQuadraticRegulatorImpl<States, Inputs>::*)() const>(
&frc::detail::LinearQuadraticRegulatorImpl<States, Inputs>::U), release_gil(), py::doc(
    "Returns the control input vector u.\n"
"\n"
":returns: The control input.")
  )
    
      .def("U", static_cast<double (frc::detail::LinearQuadraticRegulatorImpl<States, Inputs>::*)(int) const>(
&frc::detail::LinearQuadraticRegulatorImpl<States, Inputs>::U),
      py::arg("i"), release_gil(), py::doc(
    "Returns an element of the control input vector u.\n"
"\n"
":param i: Row of u.\n"
"\n"
":returns: The row of the control input vector.")
  )
    
      .def("reset", &frc::detail::LinearQuadraticRegulatorImpl<States, Inputs>::Reset, release_gil(), py::doc(
    "Resets the controller.")
  )
    
      .def("calculate", static_cast<Eigen::Vector<double, Inputs > (frc::detail::LinearQuadraticRegulatorImpl<States, Inputs>::*)(const Eigen::Vector<double, States>&)>(
&frc::detail::LinearQuadraticRegulatorImpl<States, Inputs>::Calculate),
      py::arg("x"), release_gil(), py::doc(
    "Returns the next output of the controller.\n"
"\n"
":param x: The current state x.")
  )
    
      .def("calculate", static_cast<Eigen::Vector<double, Inputs > (frc::detail::LinearQuadraticRegulatorImpl<States, Inputs>::*)(const Eigen::Vector<double, States>&, const Eigen::Vector<double, States>&)>(
&frc::detail::LinearQuadraticRegulatorImpl<States, Inputs>::Calculate),
      py::arg("x"), py::arg("nextR"), release_gil(), py::doc(
    "Returns the next output of the controller.\n"
"\n"
":param x:     The current state x.\n"
":param nextR: The next reference vector r.")
  )
    
;

  

    if (set_doc) {
        cls_LinearQuadraticRegulatorImpl.doc() = set_doc;
    }
    if (add_doc) {
        cls_LinearQuadraticRegulatorImpl.doc() = py::cast<std::string>(cls_LinearQuadraticRegulatorImpl.doc()) + add_doc;
    }

    cls_LinearQuadraticRegulatorImpl
  .def(py::init<const frc::LinearSystem<States, Inputs, 1>&, const wpi::array<double, States>&, const wpi::array<double, Inputs>&, units::second_t>())
  .def(py::init<const frc::LinearSystem<States, Inputs, 2>&, const wpi::array<double, States>&, const wpi::array<double, Inputs>&, units::second_t>());

}

}; // struct bind_frc__detail__LinearQuadraticRegulatorImpl

}; // namespace rpygen