
 

// This file is autogenerated. DO NOT EDIT

#pragma once
#include <robotpy_build.h>


#include <../../_impl/include/frc/trajectory/TrapezoidProfile.h>





namespace rpygen {

using namespace frc;


template <typename Distance>
struct bind_frc__TrapezoidProfile {

          using Distance_t = units::unit_t<Distance>;
      using Velocity = units::compound_unit<Distance, units::inverse<units::seconds>>;
      using Velocity_t = units::unit_t<Velocity>;
      using Acceleration = units::compound_unit<Velocity, units::inverse<units::seconds>>;
      using Acceleration_t = units::unit_t<Acceleration>;
      using State = typename frc::TrapezoidProfile<Distance>::State;


    py::class_<typename frc::TrapezoidProfile<Distance>> cls_TrapezoidProfile;


      py::class_<typename frc::TrapezoidProfile<Distance>::Constraints> cls_Constraints;



      py::class_<typename frc::TrapezoidProfile<Distance>::State> cls_State;





    py::module &m;
    std::string clsName;

bind_frc__TrapezoidProfile(py::module &m, const char * clsName) :
    cls_TrapezoidProfile(m, clsName),


    cls_Constraints(cls_TrapezoidProfile, "Constraints"),



    cls_State(cls_TrapezoidProfile, "State"),




    m(m),
    clsName(clsName)
{
    
}

void finish(const char * set_doc = NULL, const char * add_doc = NULL) {

    cls_TrapezoidProfile.doc() =
    "A trapezoid-shaped velocity profile.\n"
"\n"
"While this class can be used for a profiled movement from start to finish,\n"
"the intended usage is to filter a reference's dynamics based on trapezoidal\n"
"velocity constraints. To compute the reference obeying this constraint, do\n"
"the following.\n"
"\n"
"Initialization::\n"
"\n"
"  constraints = TrapezoidProfile.Constraints(kMaxV, kMaxA)\n"
"  previousProfiledReference = initialReference\n"
"\n"
"Run on update::\n"
"\n"
"  profile = TrapezoidProfile(constraints, unprofiledReference, previousProfiledReference)\n"
"  previousProfiledReference = profile.calculate(timeSincePreviousUpdate)\n"
"\n"
"where ``unprofiledReference`` is free to change between calls. Note that\n"
"when the unprofiled reference is within the constraints,\n"
":meth:`calculate` returns the unprofiled reference unchanged.\n"
"\n"
"Otherwise, a timer can be started to provide monotonic values for\n"
"``calculate()`` and to determine when the profile has completed via\n"
":meth:`isFinished`.\n";

  cls_TrapezoidProfile
      .def(py::init<typename TrapezoidProfile<Distance>::Constraints, typename TrapezoidProfile<Distance>::State, typename TrapezoidProfile<Distance>::State>(),
      py::arg("constraints"), py::arg("goal"), py::arg("initial")=State{ Distance_t ( 0 ), Velocity_t ( 0 )}, release_gil(), py::doc(
    "Construct a TrapezoidProfile.\n"
"\n"
":param constraints: The constraints on the profile, like maximum velocity.\n"
":param goal:        The desired state when the profile is complete.\n"
":param initial:     The initial state (usually the current state).")
  )
    
      .def("calculate", &frc::TrapezoidProfile<Distance>::Calculate,
      py::arg("t"), release_gil(), py::doc(
    "Calculate the correct position and velocity for the profile at a time t\n"
"where the beginning of the profile was at time t = 0.\n"
"\n"
":param t: The time since the beginning of the profile.")
  )
    
      .def("timeLeftUntil", &frc::TrapezoidProfile<Distance>::TimeLeftUntil,
      py::arg("target"), release_gil(), py::doc(
    "Returns the time left until a target distance in the profile is reached.\n"
"\n"
":param target: The target distance.")
  )
    
      .def("totalTime", &frc::TrapezoidProfile<Distance>::TotalTime, release_gil(), py::doc(
    "Returns the total time the profile takes to reach the goal.")
  )
    
      .def("isFinished", &frc::TrapezoidProfile<Distance>::IsFinished,
      py::arg("t"), release_gil(), py::doc(
    "Returns true if the profile has reached the goal.\n"
"\n"
"The profile has reached the goal if the time since the profile started\n"
"has exceeded the profile's total time.\n"
"\n"
":param t: The time since the beginning of the profile.")
  )
    
;

    

  cls_Constraints
      .def(py::init<units::unit_t<Velocity >, units::unit_t<Acceleration >>(),
      py::arg("maxVelocity")=0, py::arg("maxAcceleration")=0, release_gil()
  )
    
;

  
  

  cls_State
      .def(py::self == State()
  )
    
      .def(py::self != State()
  )
    
;

  


    if (set_doc) {
        cls_TrapezoidProfile.doc() = set_doc;
    }
    if (add_doc) {
        cls_TrapezoidProfile.doc() = py::cast<std::string>(cls_TrapezoidProfile.doc()) + add_doc;
    }

    std::string clsNameCopy = clsName;

cls_State
  .def(
    py::init<Distance_t, Velocity_t>(),
    py::arg("position") = 0,
    py::arg("velocity") = 0
  )
  .def_readwrite("position", &frc::TrapezoidProfile<Distance>::State::position)
  .def_readwrite("velocity", &frc::TrapezoidProfile<Distance>::State::velocity)
  .def("__repr__", [clsNameCopy](const State &self) {
    return clsNameCopy + ".State("
      "position=" + std::to_string(self.position()) + ", "
      "velocity=" + std::to_string(self.velocity()) + ")";
  });

}

}; // struct bind_frc__TrapezoidProfile

}; // namespace rpygen