
 

// This file is autogenerated. DO NOT EDIT

#pragma once
#include <robotpy_build.h>


#include <../../_impl/include/frc/controller/SimpleMotorFeedforward.h>

#include <units/dimensionless.h>




namespace rpygen {

using namespace frc;


template <typename Distance>
struct bind_frc__SimpleMotorFeedforward {

          using Velocity = typename frc::SimpleMotorFeedforward<Distance>::Velocity;
      using Acceleration = typename frc::SimpleMotorFeedforward<Distance>::Acceleration;
      using kv_unit = typename frc::SimpleMotorFeedforward<Distance>::kv_unit;
      using ka_unit = typename frc::SimpleMotorFeedforward<Distance>::ka_unit;


    py::class_<typename frc::SimpleMotorFeedforward<Distance>> cls_SimpleMotorFeedforward;




    py::module &m;
    std::string clsName;

bind_frc__SimpleMotorFeedforward(py::module &m, const char * clsName) :
    cls_SimpleMotorFeedforward(m, clsName),



    m(m),
    clsName(clsName)
{
    
}

void finish(const char * set_doc = NULL, const char * add_doc = NULL) {

    cls_SimpleMotorFeedforward.doc() =
    "A helper class that computes feedforward voltages for a simple\n"
"permanent-magnet DC motor.";

  cls_SimpleMotorFeedforward
      .def(py::init<>(), release_gil()
  )
    
      .def(py::init<units::volt_t, units::unit_t<kv_unit >, units::unit_t<ka_unit >>(),
      py::arg("kS"), py::arg("kV"), py::arg("kA")=units::unit_t<ka_unit> ( 0 ), release_gil(), py::doc(
    "Creates a new SimpleMotorFeedforward with the specified gains.\n"
"\n"
":param kS: The static gain, in volts.\n"
":param kV: The velocity gain, in volt seconds per distance.\n"
":param kA: The acceleration gain, in volt seconds^2 per distance.")
  )
    
      .def("calculate", static_cast<units::volt_t (frc::SimpleMotorFeedforward<Distance>::*)(units::unit_t<Velocity >, units::unit_t<Acceleration >) const>(
&frc::SimpleMotorFeedforward<Distance>::Calculate),
      py::arg("velocity"), py::arg("acceleration")=units::unit_t<Acceleration> ( 0 ), release_gil(), py::doc(
    "Calculates the feedforward from the gains and setpoints.\n"
"\n"
":param velocity:     The velocity setpoint, in distance per second.\n"
":param acceleration: The acceleration setpoint, in distance per second^2.\n"
"\n"
":returns: The computed feedforward, in volts.")
  )
    
      .def("calculate", static_cast<units::volt_t (frc::SimpleMotorFeedforward<Distance>::*)(units::unit_t<Velocity >, units::unit_t<Velocity >, units::second_t) const>(
&frc::SimpleMotorFeedforward<Distance>::Calculate),
      py::arg("currentVelocity"), py::arg("nextVelocity"), py::arg("dt"), release_gil(), py::doc(
    "Calculates the feedforward from the gains and setpoints.\n"
"\n"
":param currentVelocity: The current velocity setpoint, in distance per\n"
"                        second.\n"
":param nextVelocity:    The next velocity setpoint, in distance per second.\n"
":param dt:              Time between velocity setpoints in seconds.\n"
"\n"
":returns: The computed feedforward, in volts.")
  )
    
      .def("maxAchievableVelocity", &frc::SimpleMotorFeedforward<Distance>::MaxAchievableVelocity,
      py::arg("maxVoltage"), py::arg("acceleration"), release_gil(), py::doc(
    "Calculates the maximum achievable velocity given a maximum voltage supply\n"
"and an acceleration.  Useful for ensuring that velocity and\n"
"acceleration constraints for a trapezoidal profile are simultaneously\n"
"achievable - enter the acceleration constraint, and this will give you\n"
"a simultaneously-achievable velocity constraint.\n"
"\n"
":param maxVoltage:   The maximum voltage that can be supplied to the motor.\n"
":param acceleration: The acceleration of the motor.\n"
"\n"
":returns: The maximum possible velocity at the given acceleration.")
  )
    
      .def("minAchievableVelocity", &frc::SimpleMotorFeedforward<Distance>::MinAchievableVelocity,
      py::arg("maxVoltage"), py::arg("acceleration"), release_gil(), py::doc(
    "Calculates the minimum achievable velocity given a maximum voltage supply\n"
"and an acceleration.  Useful for ensuring that velocity and\n"
"acceleration constraints for a trapezoidal profile are simultaneously\n"
"achievable - enter the acceleration constraint, and this will give you\n"
"a simultaneously-achievable velocity constraint.\n"
"\n"
":param maxVoltage:   The maximum voltage that can be supplied to the motor.\n"
":param acceleration: The acceleration of the motor.\n"
"\n"
":returns: The minimum possible velocity at the given acceleration.")
  )
    
      .def("maxAchievableAcceleration", &frc::SimpleMotorFeedforward<Distance>::MaxAchievableAcceleration,
      py::arg("maxVoltage"), py::arg("velocity"), release_gil(), py::doc(
    "Calculates the maximum achievable acceleration given a maximum voltage\n"
"supply and a velocity. Useful for ensuring that velocity and\n"
"acceleration constraints for a trapezoidal profile are simultaneously\n"
"achievable - enter the velocity constraint, and this will give you\n"
"a simultaneously-achievable acceleration constraint.\n"
"\n"
":param maxVoltage: The maximum voltage that can be supplied to the motor.\n"
":param velocity:   The velocity of the motor.\n"
"\n"
":returns: The maximum possible acceleration at the given velocity.")
  )
    
      .def("minAchievableAcceleration", &frc::SimpleMotorFeedforward<Distance>::MinAchievableAcceleration,
      py::arg("maxVoltage"), py::arg("velocity"), release_gil(), py::doc(
    "Calculates the minimum achievable acceleration given a maximum voltage\n"
"supply and a velocity. Useful for ensuring that velocity and\n"
"acceleration constraints for a trapezoidal profile are simultaneously\n"
"achievable - enter the velocity constraint, and this will give you\n"
"a simultaneously-achievable acceleration constraint.\n"
"\n"
":param maxVoltage: The maximum voltage that can be supplied to the motor.\n"
":param velocity:   The velocity of the motor.\n"
"\n"
":returns: The minimum possible acceleration at the given velocity.")
  )
    
;

  

    if (set_doc) {
        cls_SimpleMotorFeedforward.doc() = set_doc;
    }
    if (add_doc) {
        cls_SimpleMotorFeedforward.doc() = py::cast<std::string>(cls_SimpleMotorFeedforward.doc()) + add_doc;
    }

    cls_SimpleMotorFeedforward
  .def_readwrite("kS", &SimpleMotorFeedforward<Distance>::kS)
  .def_readwrite("kV", &SimpleMotorFeedforward<Distance>::kV)
  .def_readwrite("kA", &SimpleMotorFeedforward<Distance>::kA);

}

}; // struct bind_frc__SimpleMotorFeedforward

}; // namespace rpygen