
 

// This file is autogenerated. DO NOT EDIT

#pragma once
#include <robotpy_build.h>


#include <../../_impl/include/frc/estimator/ExtendedKalmanFilter.h>





namespace rpygen {

using namespace frc;


template <int States, int Inputs, int Outputs>
struct bind_frc__ExtendedKalmanFilter {

    

    py::class_<typename frc::ExtendedKalmanFilter<States, Inputs, Outputs>> cls_ExtendedKalmanFilter;




    py::module &m;
    std::string clsName;

bind_frc__ExtendedKalmanFilter(py::module &m, const char * clsName) :
    cls_ExtendedKalmanFilter(m, clsName),



    m(m),
    clsName(clsName)
{
    
}

void finish(const char * set_doc = NULL, const char * add_doc = NULL) {

    cls_ExtendedKalmanFilter.doc() =
    "A Kalman filter combines predictions from a model and measurements to give an\n"
"estimate of the true system state. This is useful because many states cannot\n"
"be measured directly as a result of sensor noise, or because the state is\n"
"\"hidden\".\n"
"\n"
"Kalman filters use a K gain matrix to determine whether to trust the model or\n"
"measurements more. Kalman filter theory uses statistics to compute an optimal\n"
"K gain which minimizes the sum of squares error in the state estimate. This K\n"
"gain is used to correct the state estimate by some amount of the difference\n"
"between the actual measurements and the measurements predicted by the model.\n"
"\n"
"An extended Kalman filter supports nonlinear state and measurement models. It\n"
"propagates the error covariance by linearizing the models around the state\n"
"estimate, then applying the linear Kalman filter equations.\n"
"\n"
"For more on the underlying math, read\n"
"https://file.tavsys.net/control/controls-engineering-in-frc.pdf chapter 9\n"
"\"Stochastic control theory\".\n"
"\n"
"@tparam States The number of states.\n"
"@tparam Inputs The number of inputs.\n"
"@tparam Outputs The number of outputs.";

  cls_ExtendedKalmanFilter
      .def(py::init<std::function<Eigen::Vector<double, States> ( const Eigen::Vector<double, States> &, const Eigen::Vector<double, Inputs> & )>, std::function<Eigen::Vector<double, Outputs> ( const Eigen::Vector<double, States> &, const Eigen::Vector<double, Inputs> & )>, const wpi::array<double, States>&, const wpi::array<double, Outputs>&, units::second_t>(),
      py::arg("f"), py::arg("h"), py::arg("stateStdDevs"), py::arg("measurementStdDevs"), py::arg("dt"), release_gil()    , py::keep_alive<1, 4>()    , py::keep_alive<1, 5>(), py::doc(
    "Constructs an extended Kalman filter.\n"
"\n"
":param f:                  A vector-valued function of x and u that returns\n"
"                           the derivative of the state vector.\n"
":param h:                  A vector-valued function of x and u that returns\n"
"                           the measurement vector.\n"
":param stateStdDevs:       Standard deviations of model states.\n"
":param measurementStdDevs: Standard deviations of measurements.\n"
":param dt:                 Nominal discretization timestep.")
  )
    
      .def(py::init<std::function<Eigen::Vector<double, States> ( const Eigen::Vector<double, States> &, const Eigen::Vector<double, Inputs> & )>, std::function<Eigen::Vector<double, Outputs> ( const Eigen::Vector<double, States> &, const Eigen::Vector<double, Inputs> & )>, const wpi::array<double, States>&, const wpi::array<double, Outputs>&, std::function<Eigen::Vector<double, Outputs> ( const Eigen::Vector<double, Outputs> &, const Eigen::Vector<double, Outputs> & )>, std::function<Eigen::Vector<double, States> ( const Eigen::Vector<double, States> &, const Eigen::Vector<double, States> & )>, units::second_t>(),
      py::arg("f"), py::arg("h"), py::arg("stateStdDevs"), py::arg("measurementStdDevs"), py::arg("residualFuncY"), py::arg("addFuncX"), py::arg("dt"), release_gil()    , py::keep_alive<1, 4>()    , py::keep_alive<1, 5>(), py::doc(
    "Constructs an extended Kalman filter.\n"
"\n"
":param f:                  A vector-valued function of x and u that returns\n"
"                           the derivative of the state vector.\n"
":param h:                  A vector-valued function of x and u that returns\n"
"                           the measurement vector.\n"
":param stateStdDevs:       Standard deviations of model states.\n"
":param measurementStdDevs: Standard deviations of measurements.\n"
":param residualFuncY:      A function that computes the residual of two\n"
"                           measurement vectors (i.e. it subtracts them.)\n"
":param addFuncX:           A function that adds two state vectors.\n"
":param dt:                 Nominal discretization timestep.")
  )
    
      .def("P", static_cast<const Eigen::Matrix<double, States, States> & (frc::ExtendedKalmanFilter<States, Inputs, Outputs>::*)() const>(
&frc::ExtendedKalmanFilter<States, Inputs, Outputs>::P), release_gil(), py::doc(
    "Returns the error covariance matrix P.")
  )
    
      .def("P", static_cast<double (frc::ExtendedKalmanFilter<States, Inputs, Outputs>::*)(int, int) const>(
&frc::ExtendedKalmanFilter<States, Inputs, Outputs>::P),
      py::arg("i"), py::arg("j"), release_gil(), py::doc(
    "Returns an element of the error covariance matrix P.\n"
"\n"
":param i: Row of P.\n"
":param j: Column of P.")
  )
    
      .def("setP", &frc::ExtendedKalmanFilter<States, Inputs, Outputs>::SetP,
      py::arg("P"), release_gil(), py::doc(
    "Set the current error covariance matrix P.\n"
"\n"
":param P: The error covariance matrix P.")
  )
    
      .def("xhat", static_cast<const Eigen::Vector<double, States> & (frc::ExtendedKalmanFilter<States, Inputs, Outputs>::*)() const>(
&frc::ExtendedKalmanFilter<States, Inputs, Outputs>::Xhat), release_gil(), py::doc(
    "Returns the state estimate x-hat.")
  )
    
      .def("xhat", static_cast<double (frc::ExtendedKalmanFilter<States, Inputs, Outputs>::*)(int) const>(
&frc::ExtendedKalmanFilter<States, Inputs, Outputs>::Xhat),
      py::arg("i"), release_gil(), py::doc(
    "Returns an element of the state estimate x-hat.\n"
"\n"
":param i: Row of x-hat.")
  )
    
      .def("setXhat", static_cast<void (frc::ExtendedKalmanFilter<States, Inputs, Outputs>::*)(const Eigen::Vector<double, States>&)>(
&frc::ExtendedKalmanFilter<States, Inputs, Outputs>::SetXhat),
      py::arg("xHat"), release_gil(), py::doc(
    "Set initial state estimate x-hat.\n"
"\n"
":param xHat: The state estimate x-hat.")
  )
    
      .def("setXhat", static_cast<void (frc::ExtendedKalmanFilter<States, Inputs, Outputs>::*)(int, double)>(
&frc::ExtendedKalmanFilter<States, Inputs, Outputs>::SetXhat),
      py::arg("i"), py::arg("value"), release_gil(), py::doc(
    "Set an element of the initial state estimate x-hat.\n"
"\n"
":param i:     Row of x-hat.\n"
":param value: Value for element of x-hat.")
  )
    
      .def("reset", &frc::ExtendedKalmanFilter<States, Inputs, Outputs>::Reset, release_gil(), py::doc(
    "Resets the observer.")
  )
    
      .def("predict", &frc::ExtendedKalmanFilter<States, Inputs, Outputs>::Predict,
      py::arg("u"), py::arg("dt"), release_gil(), py::doc(
    "Project the model into the future with a new control input u.\n"
"\n"
":param u:  New control input from controller.\n"
":param dt: Timestep for prediction.")
  )
    
      .def("correct", static_cast<void (frc::ExtendedKalmanFilter<States, Inputs, Outputs>::*)(const Eigen::Vector<double, Inputs>&, const Eigen::Vector<double, Outputs>&)>(
&frc::ExtendedKalmanFilter<States, Inputs, Outputs>::Correct),
      py::arg("u"), py::arg("y"), release_gil(), py::doc(
    "Correct the state estimate x-hat using the measurements in y.\n"
"\n"
":param u: Same control input used in the predict step.\n"
":param y: Measurement vector.")
  )
    
;

  

    if (set_doc) {
        cls_ExtendedKalmanFilter.doc() = set_doc;
    }
    if (add_doc) {
        cls_ExtendedKalmanFilter.doc() = py::cast<std::string>(cls_ExtendedKalmanFilter.doc()) + add_doc;
    }

    
}

}; // struct bind_frc__ExtendedKalmanFilter

}; // namespace rpygen