
 

// This file is autogenerated. DO NOT EDIT

#pragma once
#include <robotpy_build.h>


#include <../../_impl/include/frc/controller/ElevatorFeedforward.h>

#include <units/dimensionless.h>




namespace rpygen {

using namespace frc;


template <typename Distance>
struct bind_frc__ElevatorFeedforward {

          using Acceleration = typename frc::ElevatorFeedforward<Distance>::Acceleration;
      using kv_unit = typename frc::ElevatorFeedforward<Distance>::kv_unit;
      using ka_unit = typename frc::ElevatorFeedforward<Distance>::ka_unit;


    py::class_<typename frc::ElevatorFeedforward<Distance>> cls_ElevatorFeedforward;




    py::module &m;
    std::string clsName;

bind_frc__ElevatorFeedforward(py::module &m, const char * clsName) :
    cls_ElevatorFeedforward(m, clsName),



    m(m),
    clsName(clsName)
{
    
}

void finish(const char * set_doc = NULL, const char * add_doc = NULL) {

    cls_ElevatorFeedforward.doc() =
    "A helper class that computes feedforward outputs for a simple elevator\n"
"(modeled as a motor acting against the force of gravity).";

  cls_ElevatorFeedforward
      .def(py::init<>(), release_gil()
  )
    
      .def(py::init<units::volt_t, units::volt_t, units::unit_t<kv_unit >, units::unit_t<ka_unit >>(),
      py::arg("kS"), py::arg("kG"), py::arg("kV"), py::arg("kA")=units::unit_t<ka_unit> ( 0 ), release_gil(), py::doc(
    "Creates a new ElevatorFeedforward with the specified gains.\n"
"\n"
":param kS: The static gain, in volts.\n"
":param kG: The gravity gain, in volts.\n"
":param kV: The velocity gain, in volt seconds per distance.\n"
":param kA: The acceleration gain, in volt seconds^2 per distance.")
  )
    
      .def("calculate", &frc::ElevatorFeedforward<Distance>::Calculate,
      py::arg("velocity"), py::arg("acceleration")=units::unit_t<Acceleration> ( 0 ), release_gil(), py::doc(
    "Calculates the feedforward from the gains and setpoints.\n"
"\n"
":param velocity:     The velocity setpoint, in distance per second.\n"
":param acceleration: The acceleration setpoint, in distance per second^2.\n"
"\n"
":returns: The computed feedforward, in volts.")
  )
    
      .def("maxAchievableVelocity", &frc::ElevatorFeedforward<Distance>::MaxAchievableVelocity,
      py::arg("maxVoltage"), py::arg("acceleration"), release_gil(), py::doc(
    "Calculates the maximum achievable velocity given a maximum voltage supply\n"
"and an acceleration.  Useful for ensuring that velocity and\n"
"acceleration constraints for a trapezoidal profile are simultaneously\n"
"achievable - enter the acceleration constraint, and this will give you\n"
"a simultaneously-achievable velocity constraint.\n"
"\n"
":param maxVoltage:   The maximum voltage that can be supplied to the elevator.\n"
":param acceleration: The acceleration of the elevator.\n"
"\n"
":returns: The maximum possible velocity at the given acceleration.")
  )
    
      .def("minAchievableVelocity", &frc::ElevatorFeedforward<Distance>::MinAchievableVelocity,
      py::arg("maxVoltage"), py::arg("acceleration"), release_gil(), py::doc(
    "Calculates the minimum achievable velocity given a maximum voltage supply\n"
"and an acceleration.  Useful for ensuring that velocity and\n"
"acceleration constraints for a trapezoidal profile are simultaneously\n"
"achievable - enter the acceleration constraint, and this will give you\n"
"a simultaneously-achievable velocity constraint.\n"
"\n"
":param maxVoltage:   The maximum voltage that can be supplied to the elevator.\n"
":param acceleration: The acceleration of the elevator.\n"
"\n"
":returns: The minimum possible velocity at the given acceleration.")
  )
    
      .def("maxAchievableAcceleration", &frc::ElevatorFeedforward<Distance>::MaxAchievableAcceleration,
      py::arg("maxVoltage"), py::arg("velocity"), release_gil(), py::doc(
    "Calculates the maximum achievable acceleration given a maximum voltage\n"
"supply and a velocity. Useful for ensuring that velocity and\n"
"acceleration constraints for a trapezoidal profile are simultaneously\n"
"achievable - enter the velocity constraint, and this will give you\n"
"a simultaneously-achievable acceleration constraint.\n"
"\n"
":param maxVoltage: The maximum voltage that can be supplied to the elevator.\n"
":param velocity:   The velocity of the elevator.\n"
"\n"
":returns: The maximum possible acceleration at the given velocity.")
  )
    
      .def("minAchievableAcceleration", &frc::ElevatorFeedforward<Distance>::MinAchievableAcceleration,
      py::arg("maxVoltage"), py::arg("velocity"), release_gil(), py::doc(
    "Calculates the minimum achievable acceleration given a maximum voltage\n"
"supply and a velocity. Useful for ensuring that velocity and\n"
"acceleration constraints for a trapezoidal profile are simultaneously\n"
"achievable - enter the velocity constraint, and this will give you\n"
"a simultaneously-achievable acceleration constraint.\n"
"\n"
":param maxVoltage: The maximum voltage that can be supplied to the elevator.\n"
":param velocity:   The velocity of the elevator.\n"
"\n"
":returns: The minimum possible acceleration at the given velocity.")
  )
    
;

  

    if (set_doc) {
        cls_ElevatorFeedforward.doc() = set_doc;
    }
    if (add_doc) {
        cls_ElevatorFeedforward.doc() = py::cast<std::string>(cls_ElevatorFeedforward.doc()) + add_doc;
    }

    cls_ElevatorFeedforward
  .def_readwrite("kS", &ElevatorFeedforward<Distance>::kS)
  .def_readwrite("kG", &ElevatorFeedforward<Distance>::kG)
  .def_readwrite("kV", &ElevatorFeedforward<Distance>::kV)
  .def_readwrite("kA", &ElevatorFeedforward<Distance>::kA);

}

}; // struct bind_frc__ElevatorFeedforward

}; // namespace rpygen