<%!
from pyramid_helpers.funcs.articles import build_search_query
%>\
<% route_name = request.matched_route.name if request.matched_route else '' %>\
<%def name="head()">
</%def>\
<!DOCTYPE html>
<html>
<head>
    <title>The Pyramid Web Application Development Framework</title>
    <meta charset="utf-8">

    <!-- jQuery -->
    <script type="text/javascript" src="${request.static_url('pyramid_helpers:static/lib/jquery-2.1.0.min.js')}"></script>

    <!-- Boostrap -->
    <link rel="stylesheet" href="${request.static_url('pyramid_helpers:static/lib/bootstrap-3.3.2-dist/css/bootstrap.min.css')}" type="text/css" media="screen" />
    <script type="text/javascript" src="${request.static_url('pyramid_helpers:static/lib/bootstrap-3.3.2-dist/js/bootstrap.min.js')}"></script>

    <!-- Pyramid Helpers -->
    <link rel="stylesheet" href="${request.static_url('pyramid_helpers:static/css/pyramid-helpers.css')}" type="text/css" media="screen" />
    <script type="text/javascript" src="${request.static_url('pyramid_helpers:static/js/pyramid-helpers.js', version=2014040501)}"></script>

${self.head()}
</head>

<body>
    <header>
        <nav class="navbar navbar-inverse navbar-fixed-top">
            <a class="navbar-brand" href="${request.route_path('index')}">Pyramid Helpers</a>
            <ul class="nav navbar-nav">
                <li${' class="active"' if route_name.startswith('articles.') else '' | n}><a href="${request.route_path('articles.search')}">${_('Articles')}</a></li>
                <li${' class="active"' if route_name == 'validators' else '' | n}><a href="${request.route_path('validators')}">${_('Validators')}</a></li>
% if authenticated_user is not None:
                <li${' class="active"' if route_name == 'api-doc' else '' | n}><a href="${request.route_path('api-doc')}">${_('API Doc')}</a></li>
% endif
            </ul><!-- /.navbar-nav -->
            <div class="nav navbar-nav navbar-right">
% if authenticated_user is None:
                <a class="btn btn-primary navbar-btn" href="${request.route_path('login')}" title="${_('Login')}">${_('login')}</a>
% else:
                <p class="navbar-text">${authenticated_user.fullname}</p>
    % if has_permission('articles.create'):
                <a class="btn btn-success navbar-btn" href="${request.route_path('articles.create')}" title="${_('New article')}">${_('New article')}</a>
    % endif
                <a class="btn btn-primary navbar-btn" href="${request.route_path('logout')}" title="${_('Logout')}">${_('logout')}</a>
% endif
            </div>
        </nav>
    </header>

    <div class="container">
% if route_name in ('api-doc', 'validators'):
        <div class="row">
            <div class="col-md-12">
% else:
        <div class="jumbotron">
            <h1>${_('Welcome to {0}!').format('Pyramid Helpers')}</h1>
            <p>${_('This application is generated by the Pyramid web application development framework.')}</p>
            <p class="text-right"><a class="btn btn-primary btn-lg" href="#" role="button">${_('Learn more...')}</a></p>
        </div>

    <% query = build_search_query(order='desc', sort='id', status='published') %>
        <div class="row">
            <div class="col-md-3">
                <aside>
                    <div class="panel panel-primary">
                        <div class="panel-heading">
                            ${_('News')}
                            <span class="badge pull-right">${query.order_by(None).count()}</span>
                        </div>
                        <div class="list-group">
    % for article in query.limit(10):
                            <a class="list-group-item" href="${request.route_path('articles.visual', article=article.id)}" title="${_('View article "{0}"').format(article.title)}">${article.title}</a>
    % endfor
                        </div><!-- /.list-group -->
                    </div><!-- /.panel -->
                </aside>
            </div><!-- /.col -->

            <div class="col-md-9">
% endif
% if breadcrumb:
                <ol class="breadcrumb">
    % for name, url in breadcrumb[:-1]:
                    <li><a href="${url}">${name}</a></li>
    % endfor
    <% name, url = breadcrumb[-1] %>
                    <li class="active">${name}</li>
                </ol>
% endif
                <section>
${self.body()}
                </section>
            </div><!-- /.col -->
        </div><!-- /.row -->
    </div><!-- /.container -->

    <footer>
        <div class="text-center">&copy; Copyright 2011-2021 Cyril Lacoux, <a href="http://easter-eggs.com">Easter-eggs</a>.</div>
    </footer>
</body>
</html>
