# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class TimeZoneMappingPreview(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        TimeZoneMappingPreview - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'contact_list': 'DomainEntityRef',
            'contacts_per_time_zone': 'dict(str, int)',
            'contacts_mapped_using_zip_code': 'dict(str, int)',
            'contacts_mapped_to_a_single_zone': 'int',
            'contacts_mapped_to_a_single_zone_using_zip_code': 'int',
            'contacts_mapped_to_multiple_zones': 'int',
            'contacts_mapped_to_multiple_zones_using_zip_code': 'int',
            'contacts_in_default_window': 'int',
            'contact_list_size': 'int'
        }

        self.attribute_map = {
            'contact_list': 'contactList',
            'contacts_per_time_zone': 'contactsPerTimeZone',
            'contacts_mapped_using_zip_code': 'contactsMappedUsingZipCode',
            'contacts_mapped_to_a_single_zone': 'contactsMappedToASingleZone',
            'contacts_mapped_to_a_single_zone_using_zip_code': 'contactsMappedToASingleZoneUsingZipCode',
            'contacts_mapped_to_multiple_zones': 'contactsMappedToMultipleZones',
            'contacts_mapped_to_multiple_zones_using_zip_code': 'contactsMappedToMultipleZonesUsingZipCode',
            'contacts_in_default_window': 'contactsInDefaultWindow',
            'contact_list_size': 'contactListSize'
        }

        self._contact_list = None
        self._contacts_per_time_zone = None
        self._contacts_mapped_using_zip_code = None
        self._contacts_mapped_to_a_single_zone = None
        self._contacts_mapped_to_a_single_zone_using_zip_code = None
        self._contacts_mapped_to_multiple_zones = None
        self._contacts_mapped_to_multiple_zones_using_zip_code = None
        self._contacts_in_default_window = None
        self._contact_list_size = None

    @property
    def contact_list(self):
        """
        Gets the contact_list of this TimeZoneMappingPreview.
        The associated ContactList

        :return: The contact_list of this TimeZoneMappingPreview.
        :rtype: DomainEntityRef
        """
        return self._contact_list

    @contact_list.setter
    def contact_list(self, contact_list):
        """
        Sets the contact_list of this TimeZoneMappingPreview.
        The associated ContactList

        :param contact_list: The contact_list of this TimeZoneMappingPreview.
        :type: DomainEntityRef
        """
        
        self._contact_list = contact_list

    @property
    def contacts_per_time_zone(self):
        """
        Gets the contacts_per_time_zone of this TimeZoneMappingPreview.
        The number of contacts per time zone that mapped to only that time zone

        :return: The contacts_per_time_zone of this TimeZoneMappingPreview.
        :rtype: dict(str, int)
        """
        return self._contacts_per_time_zone

    @contacts_per_time_zone.setter
    def contacts_per_time_zone(self, contacts_per_time_zone):
        """
        Sets the contacts_per_time_zone of this TimeZoneMappingPreview.
        The number of contacts per time zone that mapped to only that time zone

        :param contacts_per_time_zone: The contacts_per_time_zone of this TimeZoneMappingPreview.
        :type: dict(str, int)
        """
        
        self._contacts_per_time_zone = contacts_per_time_zone

    @property
    def contacts_mapped_using_zip_code(self):
        """
        Gets the contacts_mapped_using_zip_code of this TimeZoneMappingPreview.
        The number of contacts per time zone that mapped to only that time zone and were mapped using the zip code column

        :return: The contacts_mapped_using_zip_code of this TimeZoneMappingPreview.
        :rtype: dict(str, int)
        """
        return self._contacts_mapped_using_zip_code

    @contacts_mapped_using_zip_code.setter
    def contacts_mapped_using_zip_code(self, contacts_mapped_using_zip_code):
        """
        Sets the contacts_mapped_using_zip_code of this TimeZoneMappingPreview.
        The number of contacts per time zone that mapped to only that time zone and were mapped using the zip code column

        :param contacts_mapped_using_zip_code: The contacts_mapped_using_zip_code of this TimeZoneMappingPreview.
        :type: dict(str, int)
        """
        
        self._contacts_mapped_using_zip_code = contacts_mapped_using_zip_code

    @property
    def contacts_mapped_to_a_single_zone(self):
        """
        Gets the contacts_mapped_to_a_single_zone of this TimeZoneMappingPreview.
        The total number of contacts that mapped to a single time zone

        :return: The contacts_mapped_to_a_single_zone of this TimeZoneMappingPreview.
        :rtype: int
        """
        return self._contacts_mapped_to_a_single_zone

    @contacts_mapped_to_a_single_zone.setter
    def contacts_mapped_to_a_single_zone(self, contacts_mapped_to_a_single_zone):
        """
        Sets the contacts_mapped_to_a_single_zone of this TimeZoneMappingPreview.
        The total number of contacts that mapped to a single time zone

        :param contacts_mapped_to_a_single_zone: The contacts_mapped_to_a_single_zone of this TimeZoneMappingPreview.
        :type: int
        """
        
        self._contacts_mapped_to_a_single_zone = contacts_mapped_to_a_single_zone

    @property
    def contacts_mapped_to_a_single_zone_using_zip_code(self):
        """
        Gets the contacts_mapped_to_a_single_zone_using_zip_code of this TimeZoneMappingPreview.
        The total number of contacts that mapped to a single time zone and were mapped using the zip code column

        :return: The contacts_mapped_to_a_single_zone_using_zip_code of this TimeZoneMappingPreview.
        :rtype: int
        """
        return self._contacts_mapped_to_a_single_zone_using_zip_code

    @contacts_mapped_to_a_single_zone_using_zip_code.setter
    def contacts_mapped_to_a_single_zone_using_zip_code(self, contacts_mapped_to_a_single_zone_using_zip_code):
        """
        Sets the contacts_mapped_to_a_single_zone_using_zip_code of this TimeZoneMappingPreview.
        The total number of contacts that mapped to a single time zone and were mapped using the zip code column

        :param contacts_mapped_to_a_single_zone_using_zip_code: The contacts_mapped_to_a_single_zone_using_zip_code of this TimeZoneMappingPreview.
        :type: int
        """
        
        self._contacts_mapped_to_a_single_zone_using_zip_code = contacts_mapped_to_a_single_zone_using_zip_code

    @property
    def contacts_mapped_to_multiple_zones(self):
        """
        Gets the contacts_mapped_to_multiple_zones of this TimeZoneMappingPreview.
        The total number of contacts that mapped to multiple time zones

        :return: The contacts_mapped_to_multiple_zones of this TimeZoneMappingPreview.
        :rtype: int
        """
        return self._contacts_mapped_to_multiple_zones

    @contacts_mapped_to_multiple_zones.setter
    def contacts_mapped_to_multiple_zones(self, contacts_mapped_to_multiple_zones):
        """
        Sets the contacts_mapped_to_multiple_zones of this TimeZoneMappingPreview.
        The total number of contacts that mapped to multiple time zones

        :param contacts_mapped_to_multiple_zones: The contacts_mapped_to_multiple_zones of this TimeZoneMappingPreview.
        :type: int
        """
        
        self._contacts_mapped_to_multiple_zones = contacts_mapped_to_multiple_zones

    @property
    def contacts_mapped_to_multiple_zones_using_zip_code(self):
        """
        Gets the contacts_mapped_to_multiple_zones_using_zip_code of this TimeZoneMappingPreview.
        The total number of contacts that mapped to multiple time zones and were mapped using the zip code column

        :return: The contacts_mapped_to_multiple_zones_using_zip_code of this TimeZoneMappingPreview.
        :rtype: int
        """
        return self._contacts_mapped_to_multiple_zones_using_zip_code

    @contacts_mapped_to_multiple_zones_using_zip_code.setter
    def contacts_mapped_to_multiple_zones_using_zip_code(self, contacts_mapped_to_multiple_zones_using_zip_code):
        """
        Sets the contacts_mapped_to_multiple_zones_using_zip_code of this TimeZoneMappingPreview.
        The total number of contacts that mapped to multiple time zones and were mapped using the zip code column

        :param contacts_mapped_to_multiple_zones_using_zip_code: The contacts_mapped_to_multiple_zones_using_zip_code of this TimeZoneMappingPreview.
        :type: int
        """
        
        self._contacts_mapped_to_multiple_zones_using_zip_code = contacts_mapped_to_multiple_zones_using_zip_code

    @property
    def contacts_in_default_window(self):
        """
        Gets the contacts_in_default_window of this TimeZoneMappingPreview.
        The total number of contacts that will be dialed during the default window

        :return: The contacts_in_default_window of this TimeZoneMappingPreview.
        :rtype: int
        """
        return self._contacts_in_default_window

    @contacts_in_default_window.setter
    def contacts_in_default_window(self, contacts_in_default_window):
        """
        Sets the contacts_in_default_window of this TimeZoneMappingPreview.
        The total number of contacts that will be dialed during the default window

        :param contacts_in_default_window: The contacts_in_default_window of this TimeZoneMappingPreview.
        :type: int
        """
        
        self._contacts_in_default_window = contacts_in_default_window

    @property
    def contact_list_size(self):
        """
        Gets the contact_list_size of this TimeZoneMappingPreview.
        The total number of contacts in the contact list

        :return: The contact_list_size of this TimeZoneMappingPreview.
        :rtype: int
        """
        return self._contact_list_size

    @contact_list_size.setter
    def contact_list_size(self, contact_list_size):
        """
        Sets the contact_list_size of this TimeZoneMappingPreview.
        The total number of contacts in the contact list

        :param contact_list_size: The contact_list_size of this TimeZoneMappingPreview.
        :type: int
        """
        
        self._contact_list_size = contact_list_size

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

