# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class RecordingEventRecording(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        RecordingEventRecording - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'conversation_id': 'str',
            'file_state': 'str',
            'media_uris': 'list[RecordingEventMediaResult]',
            'estimated_transcode_time_ms': 'int',
            'actual_transcode_time_ms': 'int'
        }

        self.attribute_map = {
            'id': 'id',
            'conversation_id': 'conversationId',
            'file_state': 'fileState',
            'media_uris': 'mediaUris',
            'estimated_transcode_time_ms': 'estimatedTranscodeTimeMs',
            'actual_transcode_time_ms': 'actualTranscodeTimeMs'
        }

        self._id = None
        self._conversation_id = None
        self._file_state = None
        self._media_uris = None
        self._estimated_transcode_time_ms = None
        self._actual_transcode_time_ms = None

    @property
    def id(self):
        """
        Gets the id of this RecordingEventRecording.


        :return: The id of this RecordingEventRecording.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this RecordingEventRecording.


        :param id: The id of this RecordingEventRecording.
        :type: str
        """
        
        self._id = id

    @property
    def conversation_id(self):
        """
        Gets the conversation_id of this RecordingEventRecording.


        :return: The conversation_id of this RecordingEventRecording.
        :rtype: str
        """
        return self._conversation_id

    @conversation_id.setter
    def conversation_id(self, conversation_id):
        """
        Sets the conversation_id of this RecordingEventRecording.


        :param conversation_id: The conversation_id of this RecordingEventRecording.
        :type: str
        """
        
        self._conversation_id = conversation_id

    @property
    def file_state(self):
        """
        Gets the file_state of this RecordingEventRecording.


        :return: The file_state of this RecordingEventRecording.
        :rtype: str
        """
        return self._file_state

    @file_state.setter
    def file_state(self, file_state):
        """
        Sets the file_state of this RecordingEventRecording.


        :param file_state: The file_state of this RecordingEventRecording.
        :type: str
        """
        
        self._file_state = file_state

    @property
    def media_uris(self):
        """
        Gets the media_uris of this RecordingEventRecording.


        :return: The media_uris of this RecordingEventRecording.
        :rtype: list[RecordingEventMediaResult]
        """
        return self._media_uris

    @media_uris.setter
    def media_uris(self, media_uris):
        """
        Sets the media_uris of this RecordingEventRecording.


        :param media_uris: The media_uris of this RecordingEventRecording.
        :type: list[RecordingEventMediaResult]
        """
        
        self._media_uris = media_uris

    @property
    def estimated_transcode_time_ms(self):
        """
        Gets the estimated_transcode_time_ms of this RecordingEventRecording.


        :return: The estimated_transcode_time_ms of this RecordingEventRecording.
        :rtype: int
        """
        return self._estimated_transcode_time_ms

    @estimated_transcode_time_ms.setter
    def estimated_transcode_time_ms(self, estimated_transcode_time_ms):
        """
        Sets the estimated_transcode_time_ms of this RecordingEventRecording.


        :param estimated_transcode_time_ms: The estimated_transcode_time_ms of this RecordingEventRecording.
        :type: int
        """
        
        self._estimated_transcode_time_ms = estimated_transcode_time_ms

    @property
    def actual_transcode_time_ms(self):
        """
        Gets the actual_transcode_time_ms of this RecordingEventRecording.


        :return: The actual_transcode_time_ms of this RecordingEventRecording.
        :rtype: int
        """
        return self._actual_transcode_time_ms

    @actual_transcode_time_ms.setter
    def actual_transcode_time_ms(self, actual_transcode_time_ms):
        """
        Sets the actual_transcode_time_ms of this RecordingEventRecording.


        :param actual_transcode_time_ms: The actual_transcode_time_ms of this RecordingEventRecording.
        :type: int
        """
        
        self._actual_transcode_time_ms = actual_transcode_time_ms

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

