# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class InitiateScreenRecording(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        InitiateScreenRecording - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'record_acw': 'bool',
            'archive_retention': 'ArchiveRetention',
            'delete_retention': 'DeleteRetention'
        }

        self.attribute_map = {
            'record_acw': 'recordACW',
            'archive_retention': 'archiveRetention',
            'delete_retention': 'deleteRetention'
        }

        self._record_acw = None
        self._archive_retention = None
        self._delete_retention = None

    @property
    def record_acw(self):
        """
        Gets the record_acw of this InitiateScreenRecording.


        :return: The record_acw of this InitiateScreenRecording.
        :rtype: bool
        """
        return self._record_acw

    @record_acw.setter
    def record_acw(self, record_acw):
        """
        Sets the record_acw of this InitiateScreenRecording.


        :param record_acw: The record_acw of this InitiateScreenRecording.
        :type: bool
        """
        
        self._record_acw = record_acw

    @property
    def archive_retention(self):
        """
        Gets the archive_retention of this InitiateScreenRecording.


        :return: The archive_retention of this InitiateScreenRecording.
        :rtype: ArchiveRetention
        """
        return self._archive_retention

    @archive_retention.setter
    def archive_retention(self, archive_retention):
        """
        Sets the archive_retention of this InitiateScreenRecording.


        :param archive_retention: The archive_retention of this InitiateScreenRecording.
        :type: ArchiveRetention
        """
        
        self._archive_retention = archive_retention

    @property
    def delete_retention(self):
        """
        Gets the delete_retention of this InitiateScreenRecording.


        :return: The delete_retention of this InitiateScreenRecording.
        :rtype: DeleteRetention
        """
        return self._delete_retention

    @delete_retention.setter
    def delete_retention(self, delete_retention):
        """
        Sets the delete_retention of this InitiateScreenRecording.


        :param delete_retention: The delete_retention of this InitiateScreenRecording.
        :type: DeleteRetention
        """
        
        self._delete_retention = delete_retention

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

