# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class AdherenceSettings(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        AdherenceSettings - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'severe_alert_threshold_minutes': 'int',
            'adherence_target_percent': 'int',
            'adherence_exception_threshold_seconds': 'int',
            'non_on_queue_activities_equivalent': 'bool',
            'track_on_queue_activity': 'bool',
            'ignored_activity_categories': 'IgnoredActivityCategories'
        }

        self.attribute_map = {
            'severe_alert_threshold_minutes': 'severeAlertThresholdMinutes',
            'adherence_target_percent': 'adherenceTargetPercent',
            'adherence_exception_threshold_seconds': 'adherenceExceptionThresholdSeconds',
            'non_on_queue_activities_equivalent': 'nonOnQueueActivitiesEquivalent',
            'track_on_queue_activity': 'trackOnQueueActivity',
            'ignored_activity_categories': 'ignoredActivityCategories'
        }

        self._severe_alert_threshold_minutes = None
        self._adherence_target_percent = None
        self._adherence_exception_threshold_seconds = None
        self._non_on_queue_activities_equivalent = None
        self._track_on_queue_activity = None
        self._ignored_activity_categories = None

    @property
    def severe_alert_threshold_minutes(self):
        """
        Gets the severe_alert_threshold_minutes of this AdherenceSettings.
        The threshold in minutes where an alert will be triggered when an agent is considered severely out of adherence

        :return: The severe_alert_threshold_minutes of this AdherenceSettings.
        :rtype: int
        """
        return self._severe_alert_threshold_minutes

    @severe_alert_threshold_minutes.setter
    def severe_alert_threshold_minutes(self, severe_alert_threshold_minutes):
        """
        Sets the severe_alert_threshold_minutes of this AdherenceSettings.
        The threshold in minutes where an alert will be triggered when an agent is considered severely out of adherence

        :param severe_alert_threshold_minutes: The severe_alert_threshold_minutes of this AdherenceSettings.
        :type: int
        """
        
        self._severe_alert_threshold_minutes = severe_alert_threshold_minutes

    @property
    def adherence_target_percent(self):
        """
        Gets the adherence_target_percent of this AdherenceSettings.
        Target adherence percentage

        :return: The adherence_target_percent of this AdherenceSettings.
        :rtype: int
        """
        return self._adherence_target_percent

    @adherence_target_percent.setter
    def adherence_target_percent(self, adherence_target_percent):
        """
        Sets the adherence_target_percent of this AdherenceSettings.
        Target adherence percentage

        :param adherence_target_percent: The adherence_target_percent of this AdherenceSettings.
        :type: int
        """
        
        self._adherence_target_percent = adherence_target_percent

    @property
    def adherence_exception_threshold_seconds(self):
        """
        Gets the adherence_exception_threshold_seconds of this AdherenceSettings.
        The threshold in seconds for which agents should not be penalized for being momentarily out of adherence

        :return: The adherence_exception_threshold_seconds of this AdherenceSettings.
        :rtype: int
        """
        return self._adherence_exception_threshold_seconds

    @adherence_exception_threshold_seconds.setter
    def adherence_exception_threshold_seconds(self, adherence_exception_threshold_seconds):
        """
        Sets the adherence_exception_threshold_seconds of this AdherenceSettings.
        The threshold in seconds for which agents should not be penalized for being momentarily out of adherence

        :param adherence_exception_threshold_seconds: The adherence_exception_threshold_seconds of this AdherenceSettings.
        :type: int
        """
        
        self._adherence_exception_threshold_seconds = adherence_exception_threshold_seconds

    @property
    def non_on_queue_activities_equivalent(self):
        """
        Gets the non_on_queue_activities_equivalent of this AdherenceSettings.
        Whether to treat all non-on-queue activities as equivalent for adherence purposes

        :return: The non_on_queue_activities_equivalent of this AdherenceSettings.
        :rtype: bool
        """
        return self._non_on_queue_activities_equivalent

    @non_on_queue_activities_equivalent.setter
    def non_on_queue_activities_equivalent(self, non_on_queue_activities_equivalent):
        """
        Sets the non_on_queue_activities_equivalent of this AdherenceSettings.
        Whether to treat all non-on-queue activities as equivalent for adherence purposes

        :param non_on_queue_activities_equivalent: The non_on_queue_activities_equivalent of this AdherenceSettings.
        :type: bool
        """
        
        self._non_on_queue_activities_equivalent = non_on_queue_activities_equivalent

    @property
    def track_on_queue_activity(self):
        """
        Gets the track_on_queue_activity of this AdherenceSettings.
        Whether to track on-queue activities

        :return: The track_on_queue_activity of this AdherenceSettings.
        :rtype: bool
        """
        return self._track_on_queue_activity

    @track_on_queue_activity.setter
    def track_on_queue_activity(self, track_on_queue_activity):
        """
        Sets the track_on_queue_activity of this AdherenceSettings.
        Whether to track on-queue activities

        :param track_on_queue_activity: The track_on_queue_activity of this AdherenceSettings.
        :type: bool
        """
        
        self._track_on_queue_activity = track_on_queue_activity

    @property
    def ignored_activity_categories(self):
        """
        Gets the ignored_activity_categories of this AdherenceSettings.
        Activity categories that should be ignored for adherence purposes

        :return: The ignored_activity_categories of this AdherenceSettings.
        :rtype: IgnoredActivityCategories
        """
        return self._ignored_activity_categories

    @ignored_activity_categories.setter
    def ignored_activity_categories(self, ignored_activity_categories):
        """
        Sets the ignored_activity_categories of this AdherenceSettings.
        Activity categories that should be ignored for adherence purposes

        :param ignored_activity_categories: The ignored_activity_categories of this AdherenceSettings.
        :type: IgnoredActivityCategories
        """
        
        self._ignored_activity_categories = ignored_activity_categories

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

