"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecureFlowLogBucket = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_secure_log_bucket_1 = require("@gammarer/aws-secure-log-bucket");
const cdk = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
class SecureFlowLogBucket extends aws_secure_log_bucket_1.SecureLogBucket {
    constructor(scope, id, props) {
        super(scope, id, props);
        // 👇Get current account
        const account = cdk.Stack.of(this).account;
        // 👇バケットACLアクセス権
        this.addToResourcePolicy(new iam.PolicyStatement({
            effect: iam.Effect.ALLOW,
            actions: ['s3:GetBucketAcl'],
            principals: [
                new iam.ServicePrincipal('delivery.logs.amazonaws.com'),
            ],
            resources: [this.bucketArn],
        }));
        // 👇バケット書き込みアクセス権
        this.addToResourcePolicy(new iam.PolicyStatement({
            effect: iam.Effect.ALLOW,
            actions: ['s3:PutObject'],
            principals: [
                new iam.ServicePrincipal('delivery.logs.amazonaws.com'),
            ],
            //resources: [`${this.bucketArn}/AWSLogs/${account}/*`],
            resources: (() => {
                if (props?.keyPrefixes && props.keyPrefixes.length > 0) {
                    const resources = [];
                    for (const keyPrefix of props.keyPrefixes) {
                        resources.push(`${this.bucketArn}/${keyPrefix}/AWSLogs/${account}/*`);
                    }
                    return resources;
                }
                return [`${this.bucketArn}/AWSLogs/${account}/*`];
            })(),
            conditions: {
                StringEquals: {
                    's3:x-amz-acl': 'bucket-owner-full-control',
                },
            },
        }));
    }
}
_a = JSII_RTTI_SYMBOL_1;
SecureFlowLogBucket[_a] = { fqn: "@gammarer/aws-secure-flow-log-bucket.SecureFlowLogBucket", version: "0.5.4" };
exports.SecureFlowLogBucket = SecureFlowLogBucket;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSwyRUFBd0Y7QUFDeEYsbUNBQW1DO0FBQ25DLDJDQUEyQztBQU8zQyxNQUFhLG1CQUFvQixTQUFRLHVDQUFlO0lBQ3RELFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBZ0M7UUFDeEUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFFeEIsd0JBQXdCO1FBQ3hCLE1BQU0sT0FBTyxHQUFHLEdBQUcsQ0FBQyxLQUFLLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLE9BQU8sQ0FBQztRQUUzQyxpQkFBaUI7UUFDakIsSUFBSSxDQUFDLG1CQUFtQixDQUFDLElBQUksR0FBRyxDQUFDLGVBQWUsQ0FBQztZQUMvQyxNQUFNLEVBQUUsR0FBRyxDQUFDLE1BQU0sQ0FBQyxLQUFLO1lBQ3hCLE9BQU8sRUFBRSxDQUFDLGlCQUFpQixDQUFDO1lBQzVCLFVBQVUsRUFBRTtnQkFDVixJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyw2QkFBNkIsQ0FBQzthQUN4RDtZQUNELFNBQVMsRUFBRSxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUM7U0FDNUIsQ0FBQyxDQUFDLENBQUM7UUFFSixrQkFBa0I7UUFDbEIsSUFBSSxDQUFDLG1CQUFtQixDQUFDLElBQUksR0FBRyxDQUFDLGVBQWUsQ0FBQztZQUMvQyxNQUFNLEVBQUUsR0FBRyxDQUFDLE1BQU0sQ0FBQyxLQUFLO1lBQ3hCLE9BQU8sRUFBRSxDQUFDLGNBQWMsQ0FBQztZQUN6QixVQUFVLEVBQUU7Z0JBQ1YsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsNkJBQTZCLENBQUM7YUFDeEQ7WUFDRCx3REFBd0Q7WUFDeEQsU0FBUyxFQUFFLENBQUMsR0FBRyxFQUFFO2dCQUNmLElBQUksS0FBSyxFQUFFLFdBQVcsSUFBSSxLQUFLLENBQUMsV0FBVyxDQUFDLE1BQU0sR0FBRyxDQUFDLEVBQUU7b0JBQ3RELE1BQU0sU0FBUyxHQUFrQixFQUFFLENBQUM7b0JBQ3BDLEtBQUssTUFBTSxTQUFTLElBQUksS0FBSyxDQUFDLFdBQVcsRUFBRTt3QkFDekMsU0FBUyxDQUFDLElBQUksQ0FBQyxHQUFHLElBQUksQ0FBQyxTQUFTLElBQUksU0FBUyxZQUFZLE9BQU8sSUFBSSxDQUFDLENBQUM7cUJBQ3ZFO29CQUNELE9BQU8sU0FBUyxDQUFDO2lCQUNsQjtnQkFDRCxPQUFPLENBQUMsR0FBRyxJQUFJLENBQUMsU0FBUyxZQUFZLE9BQU8sSUFBSSxDQUFDLENBQUM7WUFDcEQsQ0FBQyxDQUFDLEVBQUU7WUFDSixVQUFVLEVBQUU7Z0JBQ1YsWUFBWSxFQUFFO29CQUNaLGNBQWMsRUFBRSwyQkFBMkI7aUJBQzVDO2FBQ0Y7U0FDRixDQUFDLENBQUMsQ0FBQztJQUVOLENBQUM7Ozs7QUExQ1Usa0RBQW1CIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgU2VjdXJlTG9nQnVja2V0LCBTZWN1cmVMb2dCdWNrZXRQcm9wcyB9IGZyb20gJ0BnYW1tYXJlci9hd3Mtc2VjdXJlLWxvZy1idWNrZXQnO1xuaW1wb3J0ICogYXMgY2RrIGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCAqIGFzIGlhbSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtaWFtJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuXG5leHBvcnQgaW50ZXJmYWNlIFNlY3VyZUZsb3dMb2dCdWNrZXRQcm9wcyBleHRlbmRzIFNlY3VyZUxvZ0J1Y2tldFByb3BzIHtcbiAgcmVhZG9ubHkga2V5UHJlZml4ZXM/OiBzdHJpbmdbXTtcbn1cblxuZXhwb3J0IGNsYXNzIFNlY3VyZUZsb3dMb2dCdWNrZXQgZXh0ZW5kcyBTZWN1cmVMb2dCdWNrZXQge1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wcz86IFNlY3VyZUZsb3dMb2dCdWNrZXRQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwgcHJvcHMpO1xuXG4gICAgLy8g8J+Rh0dldCBjdXJyZW50IGFjY291bnRcbiAgICBjb25zdCBhY2NvdW50ID0gY2RrLlN0YWNrLm9mKHRoaXMpLmFjY291bnQ7XG5cbiAgICAvLyDwn5GH44OQ44Kx44OD44OIQUNM44Ki44Kv44K744K55qipXG4gICAgdGhpcy5hZGRUb1Jlc291cmNlUG9saWN5KG5ldyBpYW0uUG9saWN5U3RhdGVtZW50KHtcbiAgICAgIGVmZmVjdDogaWFtLkVmZmVjdC5BTExPVyxcbiAgICAgIGFjdGlvbnM6IFsnczM6R2V0QnVja2V0QWNsJ10sXG4gICAgICBwcmluY2lwYWxzOiBbXG4gICAgICAgIG5ldyBpYW0uU2VydmljZVByaW5jaXBhbCgnZGVsaXZlcnkubG9ncy5hbWF6b25hd3MuY29tJyksXG4gICAgICBdLFxuICAgICAgcmVzb3VyY2VzOiBbdGhpcy5idWNrZXRBcm5dLFxuICAgIH0pKTtcblxuICAgIC8vIPCfkYfjg5DjgrHjg4Pjg4jmm7jjgY3ovrzjgb/jgqLjgq/jgrvjgrnmqKlcbiAgICB0aGlzLmFkZFRvUmVzb3VyY2VQb2xpY3kobmV3IGlhbS5Qb2xpY3lTdGF0ZW1lbnQoe1xuICAgICAgZWZmZWN0OiBpYW0uRWZmZWN0LkFMTE9XLFxuICAgICAgYWN0aW9uczogWydzMzpQdXRPYmplY3QnXSxcbiAgICAgIHByaW5jaXBhbHM6IFtcbiAgICAgICAgbmV3IGlhbS5TZXJ2aWNlUHJpbmNpcGFsKCdkZWxpdmVyeS5sb2dzLmFtYXpvbmF3cy5jb20nKSxcbiAgICAgIF0sXG4gICAgICAvL3Jlc291cmNlczogW2Ake3RoaXMuYnVja2V0QXJufS9BV1NMb2dzLyR7YWNjb3VudH0vKmBdLFxuICAgICAgcmVzb3VyY2VzOiAoKCkgPT4ge1xuICAgICAgICBpZiAocHJvcHM/LmtleVByZWZpeGVzICYmIHByb3BzLmtleVByZWZpeGVzLmxlbmd0aCA+IDApIHtcbiAgICAgICAgICBjb25zdCByZXNvdXJjZXM6IEFycmF5PHN0cmluZz4gPSBbXTtcbiAgICAgICAgICBmb3IgKGNvbnN0IGtleVByZWZpeCBvZiBwcm9wcy5rZXlQcmVmaXhlcykge1xuICAgICAgICAgICAgcmVzb3VyY2VzLnB1c2goYCR7dGhpcy5idWNrZXRBcm59LyR7a2V5UHJlZml4fS9BV1NMb2dzLyR7YWNjb3VudH0vKmApO1xuICAgICAgICAgIH1cbiAgICAgICAgICByZXR1cm4gcmVzb3VyY2VzO1xuICAgICAgICB9XG4gICAgICAgIHJldHVybiBbYCR7dGhpcy5idWNrZXRBcm59L0FXU0xvZ3MvJHthY2NvdW50fS8qYF07XG4gICAgICB9KSgpLFxuICAgICAgY29uZGl0aW9uczoge1xuICAgICAgICBTdHJpbmdFcXVhbHM6IHtcbiAgICAgICAgICAnczM6eC1hbXotYWNsJzogJ2J1Y2tldC1vd25lci1mdWxsLWNvbnRyb2wnLFxuICAgICAgICB9LFxuICAgICAgfSxcbiAgICB9KSk7XG5cbiAgfVxufSJdfQ==