import { Duration } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { ICluster } from './cluster';
import { Construct as CoreConstruct } from '@aws-cdk/core';
/**
 * (experimental) Helm Chart options.
 *
 * @experimental
 */
export interface HelmChartOptions {
    /**
     * (experimental) The name of the chart.
     *
     * @experimental
     */
    readonly chart: string;
    /**
     * (experimental) The name of the release.
     *
     * @default - If no release name is given, it will use the last 53 characters of the node's unique id.
     * @experimental
     */
    readonly release?: string;
    /**
     * (experimental) The chart version to install.
     *
     * @default - If this is not specified, the latest version is installed
     * @experimental
     */
    readonly version?: string;
    /**
     * (experimental) The repository which contains the chart.
     *
     * For example: https://kubernetes-charts.storage.googleapis.com/
     *
     * @default - No repository will be used, which means that the chart needs to be an absolute URL.
     * @experimental
     */
    readonly repository?: string;
    /**
     * (experimental) The Kubernetes namespace scope of the requests.
     *
     * @default default
     * @experimental
     */
    readonly namespace?: string;
    /**
     * (experimental) The values to be used by the chart.
     *
     * @default - No values are provided to the chart.
     * @experimental
     */
    readonly values?: {
        [key: string]: any;
    };
    /**
     * (experimental) Whether or not Helm should wait until all Pods, PVCs, Services, and minimum number of Pods of a Deployment, StatefulSet, or ReplicaSet are in a ready state before marking the release as successful.
     *
     * @default - Helm will not wait before marking release as successful
     * @experimental
     */
    readonly wait?: boolean;
    /**
     * (experimental) Amount of time to wait for any individual Kubernetes operation.
     *
     * Maximum 15 minutes.
     *
     * @default Duration.minutes(5)
     * @experimental
     */
    readonly timeout?: Duration;
    /**
     * (experimental) create namespace if not exist.
     *
     * @default true
     * @experimental
     */
    readonly createNamespace?: boolean;
}
/**
 * (experimental) Helm Chart properties.
 *
 * @experimental
 */
export interface HelmChartProps extends HelmChartOptions {
    /**
     * (experimental) The EKS cluster to apply this configuration to.
     *
     * [disable-awslint:ref-via-interface]
     *
     * @experimental
     */
    readonly cluster: ICluster;
}
/**
 * (experimental) Represents a helm chart within the Kubernetes system.
 *
 * Applies/deletes the resources using `kubectl` in sync with the resource.
 *
 * @experimental
 */
export declare class HelmChart extends CoreConstruct {
    /**
     * (experimental) The CloudFormation resource type.
     *
     * @experimental
     */
    static readonly RESOURCE_TYPE = "Custom::AWSCDK-EKS-HelmChart";
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: HelmChartProps);
}
