# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['nonebot_plugin_naturel_gpt']

package_data = \
{'': ['*']}

install_requires = \
['jieba>=0.42.1,<0.43.0',
 'nonebot-adapter-onebot>=2.2.1,<3.0.0',
 'nonebot2>=2.0.0rc3,<3.0.0',
 'numpy>=1.21.3,<2.0.0',
 'openai>=0.27.0',
 'transformers>=4.26.0,<5.0.0']

setup_kwargs = {
    'name': 'nonebot-plugin-naturel-gpt',
    'version': '1.5.1',
    'description': '一个基于NoneBot框架的Ai聊天插件，对接OpenAi文本生成接口',
    'long_description': '<div align="center">\n  <a href="https://v2.nonebot.dev/store"><img src="./image/README/nbp_logo.png" width="180" height="180" alt="NoneBotPluginLogo"></a>\n  <br>\n  <p><img src="./image/README/NoneBotPlugin.svg" width="240" alt="NoneBotPluginText"></p>\n</div>\n\n<div align="center">\n    ✨ 更人性化(拟人)的GPT聊天Ai插件! ✨<br/>\n    🧬 支持多个人格自定义 / 切换 | 尽情发挥你的想象力吧！ ⚙️<br/>\n    🎆 如果喜欢请点个⭐吧！您的支持就是我持续更新的动力 🎉<br/>\n    <a href="./LICENSE">\n        <img src="https://img.shields.io/badge/license-Apache 2.0-6cg.svg" alt="license">\n    </a>\n    <a href="https://pypi.python.org/pypi/nonebot-plugin-naturel-gpt">\n        <img src="https://img.shields.io/pypi/v/nonebot-plugin-naturel-gpt.svg" alt="pypi">\n    </a>\n    <img src="https://img.shields.io/badge/python-3.8+-6a9.svg" alt="python">\n    <a href="https://jq.qq.com/?_wv=1027&k=71t9iCT7">\n        <img src="https://img.shields.io/badge/加入交流群-636925153-c42.svg" alt="python">\n    </a>\n    <h2>✏️ [2023/3/2] v1.4 更新: 支持ChatGPT模型 ✏️</h2>\n    <p>本次更新后插件开始支持官方ChatGPT模型接口，token定价仅为GPT3的 1/10, 回复质量更高 响应速度更快</p>\n    <h2>🧩 [2023/2/18] v1.3 更新: 自定义拓展支持 🧩</h2>\n    <p>本次更新后插件开始支持自定义拓展，您可以直接通过自然语言直接调用多种拓展功能，包括 文本/图片/语音/邮件...</p>\n    <p>提供了一些<a href="#%E5%AE%98%E6%96%B9%E6%8B%93%E5%B1%95%E5%88%97%E8%A1%A8">样例拓展(点击前往)</a>，支持仅使用少量的代码就能实现各种自定义功能</p>\n    <p>!  <strong><a href="#-%E8%87%AA%E5%AE%9A%E4%B9%89%E6%8B%93%E5%B1%95"> 点击前往 -> 自定义拓展 </a></strong> !</p>\n</div>\n\n## 💡 功能列表\n\n> 以下未勾选功能仅表示未来可能开发的方向，不代表实际规划进度，具体开发事项可能随时变动\n> 勾选: 已实现功能；未勾选: 正在开发 / 计划开发 / 待定设计\n\n* [X] 自动切换api_key: 支持同时使用多个openai_api_key，失效时自动切换\n* [X] 自定义人格预设: 可自定义的人格预设，打造属于你的个性化的TA\n* [X] 聊天基本上下文关联: 群聊场景短期记忆上下文关联，尽力避免聊天出戏\n* [X] 聊天记录总结记忆: 自动总结聊天记忆，具有一定程度的长期记忆能力\n* [X] 用户印象记忆: 每个人格对每个用户单独记忆印象，让TA能够记住你\n* [X] 数据持久化存储: 重启后TA也不会忘记你（使用pickle保存文件）\n* [X] 人格切换: 可随时切换不同人格，更多不一样的TA\n* [X] 新增/编辑人格: 使用指令随时编辑TA的性格\n* [X] 自定义触发词: 希望TA更主动一点？或者更有目标一点？\n* [X] 自定义屏蔽词: 不想让TA学坏？需要更安全一点？\n* [X] 随机参与聊天: 希望TA主动一些？TA会偶然在你的群组中冒泡……\n* [X] 异步支持：赋予TA更强大的消息处理能力！\n* [X] 可拓展功能: 厌倦了单调的问答AI？为TA解锁超能力吧！TA能够根据你的语言主动调用拓展模块 (如:发送图片、语音、邮件等) TA的上限取决于你的想象\n* [X] 多段回复能力: 厌倦了传统一问一答的问答式聊天？TA能够做得更好！\n* [X] 主动欢迎新群友: 24小时工作的全自动欢迎姬(?)\n* [X] TTS文字转语音: 让TA开口说话！(可通过拓展模块实现，需自行准备提供TTS的API)\n* [X] 主动记忆和记忆管理功能: 让TA主动记住点什么吧！hmm让我康康你记住了什么 (主动记忆需要拓展支持)\n* [ ] 潜在人格唤醒机制: 一定条件下，潜在人格会被主动唤醒\n* [ ] 主动聊天参与逻辑: 尽力模仿人类的聊天参与逻辑，目标是让TA能够真正融入你的群组\n* [ ] 回忆录生成: 记录你们之间的点点滴滴，获取你与TA的专属回忆\n\n## 📕 使用方式\n\n1. 安装本插件并启用，详见NoneBot关于插件安装的说明\n2. 加载插件并启动一次NoneBot服务\n3. 查看自动生成的 `config/naturel_gpt.config.yml` ，并填入你的OpenAi_Api_key\n4. 在机器人所在的群组或者私聊窗口@TA或者 `提到`TA当前的 `人格名` 即开始聊天\n5. 使用命令 `rg / 人格设定 / 人格 / identity` 即可查看bot信息和相关指令\n6. 启用后bot会开始监听所有消息并适时作出记录和回应，如果你不希望bot处理某条消息，请在消息前加上忽视符（默认为 `#` ，可在配置文件中修改）\n\n## 🛠️ 参数说明 — `config/naturel_gpt.config.yml`\n\n<details> <summary>🔍点击查看可配置的参数说明</summary> <pre><code>\n\n| 参数名                        | 类型  | 释义                                       | 默认值                         | 编辑建议                                                                             |\n| ----------------------------- | ----- | ------------------------------------------ | ------------------------------ | ------------------------------------------------------------------------------------ |\n| ADMIN_USERID                  | array | 管理员id，以字符串列表方式填入             | [\'\']                           | 只有管理员可删除预设                                                                 |\n| OPENAI_API_KEYS               | array | OpenAi的 `Api_Key，以字符串列表方式填入    | [\'sak-xxxx\']                   | 请自行替换为你的Api_Key                                                              |\n| OPENAI_TIMEOUT                | int   | 请求OpenAi的超时时间 / 秒                  | 30                             |                                                                                      |\n| CHAT_ENABLE_SUMMARY_CHAT      | bool  | 是否开启会话聊天记忆总结                   | False                          | 开启后能够一定程度增强bot对话记忆能力，但也会增加token消耗                           |\n| CHAT_ENABLE_RECORD_ORTHER     | bool  | 是否参考非bot相关的上下文对话              | True                           | 开启后bot回复会参考近几条非bot相关信息                                               |\n| MEMORY_ACTIVE                 | bool  | 是否开启主动记忆（需要同时启用记忆拓展）   | False                          | 开启后bot会自行管理记忆                                                              |\n| MEMORY_MAX_LENGTH             | int   | 主动记忆最大条数                           | False                          | 主动记忆最大条数                                                                     |\n| MEMORY_ENHANCE_THRESHOLD      | float | 记忆强化阈值                               | 0.8                            | 响应内容与记忆信息匹配达到阈值(0-1)时会强化记忆                                      |\n| CHAT_HISTORY_MAX_TOKENS       | int   | 上下文聊天记录最大token数                  | 2048                           |                                                                                      |\n| CHAT_MAX_SUMMARY_TOKENS       | int   | 聊天记录总结最大token数                    | 512                            |                                                                                      |\n| REPLY_MAX_TOKENS              | int   | 生成回复的最大token数                      | 1024                           |                                                                                      |\n| REQ_MAX_TOKENS                | int   | 发起请求的最大token数（即请求+回复）       | 4096                           |                                                                                      |\n| CHAT_MEMORY_MAX_LENGTH        | int   | 聊天记忆最大条数                           | 16                             | 超出此长度后会进行记忆总结并删除更早的记录                                           |\n| CHAT_MEMORY_SHORT_LENGTH      | int   | 短期聊天记忆参考条数                       | 8                              |                                                                                      |\n| CHAT_MODEL                    | str   | 聊天生成的语言模型                         | gpt-3.5-turbo                  | 默认使用GPT3.5的模型(推荐)                                                           |\n| CHAT_FREQUENCY_PENALTY        | float | 回复内容复读惩罚                           | 0.6                            | 范围(-2~2) 越高产生的回复内容越多样化                                                |\n| CHAT_PRESENCE_PENALTY         | float | 回复主题重复惩罚                           | 0.6                            | 范围(-2~2) 越高越倾向于产生新的话题                                                  |\n| CHAT_TEMPERATURE              | float | 聊天生成温度: 越高越随机                   | 0.6                            |                                                                                      |\n| CHAT_TOP_P                    | float | 聊天信息采样率                             | 1                              |                                                                                      |\n| IGNORE_PREFIX                 | str   | 忽略前置修饰：添加此修饰的聊天信息将被忽略 | #                              |                                                                                      |\n| USER_MEMORY_SUMMARY_THRESHOLD | int   | 用户聊天印象总结触发阈值                   | 16                             | 越小触发越频繁，推荐10-20                                                            |\n| REPLY_ON_AT                   | bool  | 在被 `@TA` 时回复                          | True                           |                                                                                      |\n| REPLY_ON_NAME_MENTION         | bool  | 在被 `提及` 时回复                         | True                           | `提及` 即用户发言中含有当前bot人格名                                                 |\n| REPLY_ON_WELCOME              | bool  | 在 `新成员加入` 时回复                     | True                           |                                                                                      |\n| RANDOM_CHAT_PROBABILITY       | float | 随机触发聊天概率，设为0禁用                | 0                              | 调整范围[0~1]，设置过高回复频繁，会大量消耗token                                     |\n| PRESETS                       | dict  | 人格预设集合                               | 略                             | 默认有四个预设，详见生成的配置文件                                                   |\n| NG_DATA_PATH                  | str   | 数据文件目录                               | ./data/naturel_gpt/            | 保存实现数据持久化                                                                   |\n| NG_ENABLE_EXT                 | bool  | 是否启用聊天自定义拓展                     | True                           | 开启后bot可使用拓展功能，会额外消耗token（取决于拓展描述，如未安装任何拓展务必关闭） |\n| NG_EXT_PATH                   | str   | 拓展脚本文件目录                           | ./data/naturel_gpt/extensions/ | 用于保存拓展脚本的路径                                                               |\n| NG_EXT_LOAD_LIST              | str   | 加载拓展列表                               |                                | 只有在此列表中的拓展会被bot使用                                                      |\n| WORD_FOR_FORBIDDEN            | array | 自定义禁止触发词，以字符串列表方式填入     | []                             | 消息中含有列表中的词将呗拒绝唤醒bot（优先级高于触发词）                              |\n| WORD_FOR_WAKE_UP              | array | 自定义触发词，以字符串列表方式填入         | []                             | 消息中含有列表中的词将唤醒bot                                                        |\n| NG_MSG_PRIORITY               | int   | 消息响应优先级                             | 99                             | 大于1，数值越大优先级越低                                                            |\n| NG_BLOCK_OTHERS               | bool  | 是否拦截其它插件的响应                     | False                          | 开启后可能导致优先级低于本插件的其他插件不响应                                       |\n| NG_MAX_RESPONSE_PER_MSG       | int   | 每条消息最大回复次数                       | 5                              | 限制bot针对每条信息最大回复次数，避免封禁                                            |\n| NG_ENABLE_MSG_SPLIT           | bool  | 是否允许消息分割发送                       | True                           | 如果允许，bot有可能会在一次回复中发送多条消息                                        |\n| FORBIDDEN_USERS               | array | 黑名单用户id，以字符串列表方式填入         | [\'\']                           | 黑名单中的用户消息不会被记录和响应设                                                 |\n| OPENAI_PROXY_SERVER           | str   | 请求OpenAI的代理服务器                     | \'\'                             | 填写示例 \'127.0.0.1:1234\' 或 \'username:password@127.0.0.1:1234\'                      |\n| \\_\\_DEBUG\\_\\_                 | bool  | 是否开启DEBUG输出                          | False                          | 开启可查看prompt模板输出                                                             |\n\n</code> </pre> </details>\n\n## 🪄 指令说明\n\n### 基本命令——"rg"(需要加上在NoneBot中设定的指令前缀)\n\n- 别称: "人格"、"人格设定"、"identity"\n- 功能: 查看当前可用人格预设列表和基本的插件帮助\n- (*) 管理员帮助命令——"rg admin"\n\n### 完整命令列表/示例\n\n<details> <summary>🔍点击展开查看完整命令和示例</summary> <pre> <code>\n\n- 查询基本信息——"rg <?admin>"\n  + 功能: 用于查看插件当前状态和指令表\n  + 使用示例: `rg ` (查看插件当前状态和指令表) | `rg admin` (查看插件当前状态和管理员指令表)\n- 切换人格——"rg 设定 <-all>"\n  + 别称: set\n  + 功能: 用于切换当前bot人格\n  + 使用示例: `rg set 白羽` (切换当前人格至白羽) | `rg set 白羽 -all` (切换并应用到所有会话)\n- 查询人格——"rg 查询"\n  + 别称: query\n  + 功能: 用于查询bot人格预设信息\n  + 使用示例: `rg query 白羽` (查询白羽的人格预设)\n- 更新人格——"rg 更新"\n  + 别称: update\n  + 功能: 用于 更新/修改 指定bot人格预设\n  + 使用示例: `rg update 白羽 白羽是一只可爱的喵星人...` (修改白羽的人格预设信息)\n- 添加人格——"rg 添加"\n  + 别称: new\n  + 功能: 用于添加指定bot人格预设\n  + 使用示例: `rg new 白羽 白羽是一只可爱的喵星人...` (新增名为"白羽"的人格预设信息)\n- 删除人格——"rg 删除" (仅限bot管理员使用)\n  + 别称: del\n  + 功能: 用于删除指定人格预设，同时会删除该人格的相关记忆！\n  + 使用示例: `rg del 白羽` (删除白羽人格预设)\n- 锁定人格——"rg 锁定" (仅限bot管理员使用)\n  + 别称: lock\n  + 功能: 用于锁定指定人格预设，锁定后非管理员无法修改该预设\n  + 使用示例: `rg lock 白羽` (锁定白羽人格预设)\n- 解锁人格——"rg 解锁" (仅限bot管理员使用)\n  + 别称: unlock\n  + 功能: 用于解锁指定人格预设，解锁后允许所有用户修改此预设\n  + 使用示例: `rg unlock 白羽` (解锁白羽人格预设)\n- 查询拓展——"rg 拓展" (仅限bot管理员使用)\n  + 别称: ext\n  + 功能: 用于查询当前正常加载的所有拓展信息\n  + 使用示例: `rg ext`\n- 查询所有会话——"rg 会话" (仅限bot管理员使用)\n  + 别称: chats\n  + 功能: 用于查询当前所有会话状态\n  + 使用示例: `rg chats`\n- 开启会话——"rg 开启 <-all>" (仅限bot管理员或群组管理员使用)\n  + 别称: on\n  + 功能: 用于开启会话，开启后bot会开始按预定程序进行消息回应\n  + 使用示例: `rg on` (开启当前会话) | `rg on -all` (开启所有会话)\n- 停止会话——"rg 停止 <-all>" (仅限bot管理员或群组管理员使用)\n  + 别称: off\n  + 功能: 用于停止会话，停止后bot不再响应任何回复(包括记录消息)\n  + 使用示例: `rg off` (关闭当前会话) | `rg off -all` (关闭所有会话)\n- 重置会话——"rg 重置 [预设名]" (仅限bot管理员或群组管理员使用)\n  + 别称: reset\n  + 功能: 用于重置当前会话bot人格，包括当前人格的记忆和聊天记录等 (注: 不可撤回！)\n  + 使用示例: `rg reset -all` (重置当前会话中的所有人格记忆) | `rg reset 白羽` (重置当前会话中的所有人格记忆)\n- 查询记忆——"rg 记忆"\n  + 别称: memory\n  + 功能: 用于查询bot当前会话记忆\n  + 使用示例: `rg memory` (查询当前会话的人格记忆)\n- 更新记忆——"rg memory 编辑"\n  + 别称: edit\n  + 功能: 用于 编辑 当前bot会话的人格记忆\n  + 使用示例: `rg memory edit fact 水是无毒的` (修改当前人格的记忆信息，`fact` 为记忆的键)\n- 删除记忆——"rg 删除" (仅限bot管理员使用)\n  + 别称: del\n  + 功能: 用于删除指定记忆，同时会删除该记忆的相关记忆！\n  + 使用示例: `rg memory del fact` (删除白羽记忆)\n\n</code> </pre> </details>\n\n\n## 🤖 行为逻辑QA\n\n<details> <summary>🔍点击展开查看行为逻辑QA</summary> <pre> <code>\n\nQ: 如何区分会话？\n\nA: 根据群组(群聊场景)、私聊(个人)区分会话，即同一群组内共享一个会话，私聊窗口独占一个会话；不同人格的会话和记忆完全独立\n\n---\n\nQ: TA是如何产生回复的？\n\nA: TA会根据 对话上下文(即最近几条聊天记录 不论是否与TA相关)、过往记忆(过去聊天记录的总结)、发起 `@`或 `提及`的用户印象(根据与该用户的聊天记录总结) 生成prompt模板，然后通过 OpenAi 的接口产生对应的回复发送，并且把产生的回复再填加入相应的聊天记录中\n\n---\n\nQ: TA如何记忆用户印象？\n\nA: TA根据用户的id(通常是qq号)的 对TA发起 `@`或 `提及`的聊天记录、响应和历史印象 自动总结产生bot对每个用户的印象，该印象记录与会话无关(即多个会话共享)，但各个人格之间信息相互独立\n\n---\n\nQ: 插件如何实现记录持久化保存？\n\nA: 由于本项目的记忆保存与人格预设存在一定耦合，故使用了pickle直接对程序中使用的数据信息进行序列化后保存为本地文件，然后在程序启动的时候使用pickle加载，这样做的好处是代码实现简便，但由于运行过程数据信息几乎都保存在内存中，如果您的bot活跃用户过多(>1k)、或者人格预设过多(>100)，可能会造成一定的性能负担，敬请见谅！\n\n---\n\nQ: 为什么我在编辑了配置文件中的人格预设信息后重载插件，编辑没有生效？\n\nA: 由于用户数据信息与人格预设信息高度绑定，如果已经生成过pickle文件后程序不会再响应配置文件中人格预设的修改，而是会直接读取已有的pickle文件中的信息，您可以尝试使用 `!rg` 指令根据响应提示直接进行编辑，或者直接删除数据目录中的 `.pkl` 文件(注意：会造成bot记忆丢失)后重载程序重新生成\n\n</code> </pre> </details>\n\n## 🧩 自定义拓展\n\n> 自定义拓展指的是本插件所提供的一个拓展接口，支持加载其它自定义脚本提供的功能，并且提供一套引导流程来 `教会` Bot使用这个功能，从而在bot在与用户通过自然语言聊天时能够根据场景情况主动调用对应的拓展功能\n\n- 拓展模块存放目录(默认): `./data/naturel_gpt/extensions/` (启动加载一次本插件会自动创建)\n- 注意：启用拓展后会自动在 nonebot 根目录下创建一个名为 `ext_cache` 的文件夹，该文件夹用于暂存加载的拓展包，请不要 存入/删除 其中的文件！否则可能导致 文件被误删/插件运行出错！\n\n### 使用自定义拓展\n\n> 你可以使用任意来源于本仓库 `/extensions/` 目录下的拓展，也可使用其它用户自行编写的拓展，但是请注意仅从你信任的来源获取，否则可能包含危险程序！\n\n1. 生成拓展模块存放目录(启动一次插件)\n2. 将你需要安装的拓展 (通常是 `ext_xxx.py`) 放入拓展模块存放目录(默认 `./data/naturel_gpt/extensions/`)\n3. 在本插件的配置文件中正确填写以下内容( `#` 号 后内容为注释)\n\n```yaml\n    NG_EXT_LOAD_LIST:\n    - EXT_NAME: ext_random  # 拓展文件名 (不含\'.py\')\n      IS_ACTIVE: true   # 是否启用\n      EXT_CONFIG: {}  # 拓展配置 如该拓展插件无要求可为空\n    - ... # 可填写多项\n```\n\n4. 重新加载本插件自动加载拓展\n\n### 官方拓展列表\n> 带 `*` 号的配置项为必填\n#### > 随机数生成器\n\n- 拓展文件: ext_random.py\n- 说明: 一个示例拓展，用于引导bot调用并生成随机数（仅供测试使用，不建议日常开启）\n\n#### > 发送随机二次元图片\n\n- 拓展文件: ext_random_pic.py\n- 说明: 调用 `api.ixiaowai.cn` 的接口获取一张二次元图片并发送\n\n#### > 发送表情包\n\n- 拓展文件: ext_emoticon.py\n- 说明: 调用 `alapi` 接口，搜索指定关键字(由bot自主决定)的表情包并发送\n- 配置项:\n  + token*: 平台 token (需自行申请)\n\n#### > 发送语音消息（测试中）\n\n- 拓展文件: ext_voice.py\n- 说明: 调用语音生成接口实现语音回复 (需自行准备语音合成api接口)\n\n#### > 使用网易邮箱向指定地址发送邮件\n\n- 拓展文件: ext_email.py\n- 说明: 向指定邮箱地址发送邮件\n- 配置项: \n  + SMTP_CODE: 邮箱SMTP授权码\n  + SENDER_ADDR: 邮箱地址\n\n#### > 主动记忆能力拓展模块\n\n- 拓展文件: ext_remember.py & ext_forget.py\n- 说明: 赋予bot主动管理记忆的能力，使用时请同时启用 记忆|遗忘 拓展\n\n### 编写自定义拓展\n\n> 自行编写拓展需要具有一定的 Python 编程基础，如果您有相关能力可直接参考本仓库 `/extensions/` 目录下的拓展进行编写(非常简单！) 自行编写的拓展安装流程与上述相同\n> 注意：该功能尚处于早期阶段，拓展编写在未来版本有可能随时变化！\n\n✨ 如果您想分享您自行开发的拓展，可向本仓库提交pr，将您的拓展命名为 `share_ext_xxx.py`(\'xxx\'部分可自行命名，请勿与已存在的拓展名冲突) 并上传至本仓库的 `/share_exts/` 目录下，欢迎您成为本项目的贡献者！\n\n#### 基本的拓展模块模板\n<details> <summary>🔍点击查看拓展模块编写模板</summary> <pre><code>\n\n```python\nfrom .Extension import Extension\n\n# 拓展的配置信息，用于ai理解拓展的功能 *必填*\next_config:dict = {\n    "name": "ExtensionName",   # 拓展名称，用于标识拓展，尽量简短\n    "arguments": {  \n        "arg1": "int",   # 填写期望的参数类型，尽量使用简单类型，便于ai理解含义使用\n        "arg2": "int",   # 注意：实际接收到的参数类型为str(由ai生成)，需要自行转换\n    },\n    # 拓展的描述信息，用于提示ai理解拓展的功能 *必填* 尽量简短 使用英文更节省token，添加使用示例可提高bot调用的准确度\n    "description": "send ... (use eg: /#Send&xxx#/)",\n    # 参考词，用于上下文参考使用，为空则每次都会被参考(消耗token)\n    "refer_word": [\'use extension\'],\n    # 每次消息回复中最大调用次数，不填则默认为99\n    "max_call_times_per_msg": 99,\n    # 作者信息\n    "author": "",\n    # 版本\n    "version": "0.0.1"\n    # 拓展简介\n    "intro": "简介信息（查看拓展详情显示）",\n}\n\nclass CustomExtension(Extension):\n    async def call(self, arg_dict: dict, ctx_data: dict) -> dict:\n        """ 当拓展被调用时执行的函数 *由拓展自行实现*\n\n        参数:\n            arg_dict: dict, 由ai解析的参数字典 {参数名: 参数值}\n        """\n        custom_config:dict = self.get_custom_config()  # 获取yaml中的配置信息\n\n        ### 在这里处理主要的自定义逻辑\n\n        return {  # 返回的信息将会被发送到会话中\n            \'text\': f"[来自拓展的消息]...", # 文字信息\n            \'image\': f"http://...",  # 图片url\n            \'voice\': f"http://...",  # 语音url\n        }\n\n    def __init__(self, custom_config: dict):\n        super().__init__(ext_config.copy(), custom_config)\n```\n\n</code></pre> </details>\n\n## 🎢 更新日志\n\n## [2023/3/6] v1.5.1\n\n- 语音合成拓展提供接入腾讯翻译api(可选开关) (感谢 [@tonato-01](https://github.com/) 提供pr) \n- 修复部分情况下bot回答时会带上自己的人称问题\n- 修复插件调用次数限制不生效\n- 优化bot调用拓展时的分段问题\n- 修复记忆管理的编辑指令错误的问题\n- 优化记忆强化功能的文本匹配规则\n\n## [2023/3/5] v1.5.0\n\n- 增加了bot记忆管理能力支持和记忆管理相关指令，允许bot主动 记忆/遗忘 信息，并且能自动对记忆信息进行增强以尽可能延长记忆有效时间\n- 新增了两个主动记忆管理拓展(记忆和忘却模块，推荐组合使用)\n- 根据GPT3.5对话模型的特点重写了prompt提示，提高bot对拓展指令识别率\n\n## [2023/3/3] v1.4.4\n\n- 修复了修改配置文件目录后无法读取的问题 (感谢 [@he0119](https://github.com/) 提供pr) \n- 将获取响应实现将放入线程池，减少请求超时卡死 (感谢 [@he0119](https://github.com/) 提供pr) \n- 为群聊管理员增加了bot的会话管理权限 (感谢 [@HMScygnet](https://github.com/) 提供pr)\n- 优化多段回复预处理，减少了自动续写出后续无关对话的频率\n- 调整指令生成匹配正则，略微放宽bot调用拓展的规范程度\n- 更新代理服务器时将自动补充http协议头\n- 优化对话提示prompt，提高回复质量\n- 新增了一个发送邮件拓展\n\n## [2023/3/3] v1.4.3\n\n- 禁用了huggingface 的 tokenizer的分支化，避免死锁问题\n\n## [2023/3/3] v1.4.2\n\n- 修复ChatGPT模型请求时间过长不会timeout的问题，提供一个配置项，可自行指定超时时间\n- 增加了一个可控制是否记录参考非bot相关消息上下文的配置选项\n- 为几种常见报错增加了更直观的提示\n- 修复了一个拓展模块调用出错的问题\n- 调整prompt，优化bot回复质量\n\n## [2023/3/2] v1.4.1\n\n- 修复一个prompt描述错误\n- 修复一个对话过长死循环卡死的bug\n\n## [2023/3/2] v1.4.0 ChatGpt模型更新\n> 本次更新后需要更新 OpenAi SDK 至 0.27.0 版本或以上才能使用ChatGPT系列模型\n\n- 增加了ChatGPT系列模型的支持，并针对其特点优化了prompt设置\n- 增加自动欢迎新成员可关闭的配置项\n- 优化了聊天内容分段输出的逻辑\n- 修复了一个聊天单条消息过长导致卡死循环的bug\n- 修复代理服务器配置异常(感谢 @HMScygnet 提供的修复代码)\n\n## [2023/3/1] v1.3.7 勤俭持家 | 代理服务更新\n\n- 优化prompt生成，为总结聊天记忆功能增加了可选开关，关闭后可降低约30%的token消耗（经过反馈该功能在较多场景下适用性有限，总体上高成本低回报，故增加了可选关闭，用户印象总结仍然保留开启）\n- 增加了拓展模块传递信息，拓展模块可获得原始请求触发信息、回复信息、bot预设名，便于实现更复杂的拓展需求\n- 增加了自动欢迎新入群成员的功能\n- 增加代理服务器配置\n\n## [2023/2/25] v1.3.6\n\n- 修复了 `rg set` 指令出错的问题\n\n## [2023/2/24] v1.3.5 黑名单 | 指令更新\n\n- 修复了因唤醒词设置类型不规范问题导致偶发错误的问题\n- 修复第一次启动自动创建数据文件夹目录失败的问题\n- 为更换人格预设增加了批量操作 `-all` 指令（限管理员可用）\n- 增加了 `chats` 指令，用于查看所有会话状态\n- 优化 README.md 文档\n- 增加了是否开启消息切分多条发送的配置项（默认开启）\n- 增加了黑名单功能，在黑名单中的用户消息不会被记录和响应\n\n## [2023/2/20] v1.3.3 拓展 | 多段发送更新\n\n- 优化了不启用拓展模块时bot的回复质量，减少虚空调用拓展的情况\n- 优化对话生成prompt，增强了bot发送多段聊天的能力\n- 增加了bot感知当前时间的能力\n- 从bot的发言记录中将错误的调用指令去除，避免bot重复学习错误的拓展指令使用\n- 将大多数文本生成的prompt改为英文描述，尽量降低部分tokens消耗\n- 新增了一个表情包拓展模块\n\n## [2023/2/19] v1.3.2\n\n- 修复了yaml配置中设置禁用拓展不生效的问题\n- 持续优化对话生成prompt，提高bot理解使用拓展的能力\n- 为 开启/关闭 会话的指令增加了 `-all` 选项，可一次性 开启/关闭 所有会话\n\n## [2023/2/19] v1.3.1\n\n- 优化拓展模块的参数传递\n- 修改了一些拓展插件提示，更便于bot理解拓展使用方式\n\n## [2023/2/18] v1.3.0 拓展模块功能更新\n\n- *拓展支持：增加了插件拓展支持(插件的插件？)，支持使用自然语言自定义拓展更多功能，提供了两个示例拓展\n- 多处细节优化\n\n## [2023/2/16] v1.2.0 异步更新\n\n> 本次更新增加了异步能力，功能可能尚不稳定，如要继续使用旧版的记忆文件请做好备份\n\n- 异步更新：bot的回复生成开始支持异步请求，提高了消息处理速度\n- 移除双回车符的停用词限制，优化了ai对长文本的输出能力\n- 优化错误输出，在api请求出错时会在控制台显示错误信息以供排查\n- 优化记忆逻辑，bot在请求文本错误时不会把错误提示信息一并存入记忆\n\n### [2023/2/12] v1.1.6\n\n- 增加切换会话是否启用的开关功能\n- 增加了记忆重置功能，可指定重置当前会话的所有人格或特定人格\n- 消息拦截响应、消息处理优先级支持自定义配置\n- 简化帮助命令输出，分离管理员命令的帮助信息到 `rg admin` 中\n\n### [2023/2/9] v1.1.5 唤醒词 | 屏蔽词功能更新\n\n- 修复未创建对话前调用bot指令报错的问题\n- 增加自定义触发词唤醒的功能\n- 增加自定义屏蔽词拒绝回复的功能\n- 增加bot随机参与聊天功能，可选择启用\n- 优化了手动 `@bot` 时的信息的聊天prompt生成逻辑，使bot回复更具有指向性\n- 优化配置文件管理逻辑，更新后可继续沿用原配置文件，程序加载后会自动补充更新配置文件字段\n\n### [2023/2/6] v1.1.4\n\n> 注意：本次更新需要删除原bot记忆文件重新生成(即./data/naturel_gpt文件夹)，否则可能产生无法预计的错误\n\n- 修复了bot记忆串线的问题(多个群组同时使用场景下记忆混乱)\n- 优化bot生成记忆和印象摘要的逻辑，提高了bot回复的速度\n- 优化了控制台输出\n\n### [2023/2/5] v1.1.2\n\n- 新增了人格预设的 锁定/解锁 功能，锁定后非管理员无法编辑该预设\n- 更新README文档\n- 优化rg命令显示格式\n- 微调了 `config.py` 中的一些默认参数\n- 修复本插件拦截其它插件响应的问题，降低了本插件的响应优先级\n- 更新了交流群信息(见本文档开头)，欢迎各路大佬加入互相学习、一同探讨更新方向、分享更多玩法等\n\n### [2023/2/2] v1.1.1\n\n- 修复查询人格错误的问题\n\n### [2023/2/2] v1.1.0\n\n> 注意：本次更新需要删除原bot记忆文件重新生成(即./data/naturel_gpt文件夹)，否则可能产生无法预计的错误\n\n- 新增了预设编辑功能\n- 新增自定义管理员id功能，管理员可以删除预设 / 修改锁定的预设\n- 增加debug开关控制生成文本时的控制台输出（默认关闭）\n\n## ⭐ Star 历史趋势图\n\n[![Stargazers over time](https://starchart.cc/KroMiose/nonebot_plugin_naturel_gpt.svg)](https://starchart.cc/KroMiose/nonebot_plugin_naturel_gpt)',
    'author': 'KroMiose',
    'author_email': 'None',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
