# coding: utf-8

"""
Influx API Service.

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

OpenAPI spec version: 0.1.0
Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from influxdb_client.api_client import ApiClient


class UsersService(object):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):  # noqa: E501,D401,D403
        """UsersService - a operation defined in OpenAPI."""
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_buckets_id_members_id(self, user_id, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """Remove a member from a bucket.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_buckets_id_members_id(user_id, bucket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the member to remove. (required)
        :param str bucket_id: The bucket ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_buckets_id_members_id_with_http_info(user_id, bucket_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_buckets_id_members_id_with_http_info(user_id, bucket_id, **kwargs)  # noqa: E501
            return data

    def delete_buckets_id_members_id_with_http_info(self, user_id, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """Remove a member from a bucket.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_buckets_id_members_id_with_http_info(user_id, bucket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the member to remove. (required)
        :param str bucket_id: The bucket ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['user_id', 'bucket_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_buckets_id_members_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_buckets_id_members_id`")  # noqa: E501
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in local_var_params or
                local_var_params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `delete_buckets_id_members_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501
        if 'bucket_id' in local_var_params:
            path_params['bucketID'] = local_var_params['bucket_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/buckets/{bucketID}/members/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def delete_buckets_id_owners_id(self, user_id, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """Remove an owner from a bucket.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_buckets_id_owners_id(user_id, bucket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the owner to remove. (required)
        :param str bucket_id: The bucket ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_buckets_id_owners_id_with_http_info(user_id, bucket_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_buckets_id_owners_id_with_http_info(user_id, bucket_id, **kwargs)  # noqa: E501
            return data

    def delete_buckets_id_owners_id_with_http_info(self, user_id, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """Remove an owner from a bucket.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_buckets_id_owners_id_with_http_info(user_id, bucket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the owner to remove. (required)
        :param str bucket_id: The bucket ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['user_id', 'bucket_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_buckets_id_owners_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_buckets_id_owners_id`")  # noqa: E501
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in local_var_params or
                local_var_params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `delete_buckets_id_owners_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501
        if 'bucket_id' in local_var_params:
            path_params['bucketID'] = local_var_params['bucket_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/buckets/{bucketID}/owners/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def delete_dashboards_id_members_id(self, user_id, dashboard_id, **kwargs):  # noqa: E501,D401,D403
        """Remove a member from a dashboard.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dashboards_id_members_id(user_id, dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the member to remove. (required)
        :param str dashboard_id: The dashboard ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_dashboards_id_members_id_with_http_info(user_id, dashboard_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_dashboards_id_members_id_with_http_info(user_id, dashboard_id, **kwargs)  # noqa: E501
            return data

    def delete_dashboards_id_members_id_with_http_info(self, user_id, dashboard_id, **kwargs):  # noqa: E501,D401,D403
        """Remove a member from a dashboard.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dashboards_id_members_id_with_http_info(user_id, dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the member to remove. (required)
        :param str dashboard_id: The dashboard ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['user_id', 'dashboard_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_dashboards_id_members_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_dashboards_id_members_id`")  # noqa: E501
        # verify the required parameter 'dashboard_id' is set
        if ('dashboard_id' not in local_var_params or
                local_var_params['dashboard_id'] is None):
            raise ValueError("Missing the required parameter `dashboard_id` when calling `delete_dashboards_id_members_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501
        if 'dashboard_id' in local_var_params:
            path_params['dashboardID'] = local_var_params['dashboard_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/dashboards/{dashboardID}/members/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def delete_dashboards_id_owners_id(self, user_id, dashboard_id, **kwargs):  # noqa: E501,D401,D403
        """Remove an owner from a dashboard.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dashboards_id_owners_id(user_id, dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the owner to remove. (required)
        :param str dashboard_id: The dashboard ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_dashboards_id_owners_id_with_http_info(user_id, dashboard_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_dashboards_id_owners_id_with_http_info(user_id, dashboard_id, **kwargs)  # noqa: E501
            return data

    def delete_dashboards_id_owners_id_with_http_info(self, user_id, dashboard_id, **kwargs):  # noqa: E501,D401,D403
        """Remove an owner from a dashboard.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dashboards_id_owners_id_with_http_info(user_id, dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the owner to remove. (required)
        :param str dashboard_id: The dashboard ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['user_id', 'dashboard_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_dashboards_id_owners_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_dashboards_id_owners_id`")  # noqa: E501
        # verify the required parameter 'dashboard_id' is set
        if ('dashboard_id' not in local_var_params or
                local_var_params['dashboard_id'] is None):
            raise ValueError("Missing the required parameter `dashboard_id` when calling `delete_dashboards_id_owners_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501
        if 'dashboard_id' in local_var_params:
            path_params['dashboardID'] = local_var_params['dashboard_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/dashboards/{dashboardID}/owners/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def delete_orgs_id_members_id(self, user_id, org_id, **kwargs):  # noqa: E501,D401,D403
        """Remove a member from an organization.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_orgs_id_members_id(user_id, org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the member to remove. (required)
        :param str org_id: The organization ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_orgs_id_members_id_with_http_info(user_id, org_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_orgs_id_members_id_with_http_info(user_id, org_id, **kwargs)  # noqa: E501
            return data

    def delete_orgs_id_members_id_with_http_info(self, user_id, org_id, **kwargs):  # noqa: E501,D401,D403
        """Remove a member from an organization.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_orgs_id_members_id_with_http_info(user_id, org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the member to remove. (required)
        :param str org_id: The organization ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['user_id', 'org_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_orgs_id_members_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_orgs_id_members_id`")  # noqa: E501
        # verify the required parameter 'org_id' is set
        if ('org_id' not in local_var_params or
                local_var_params['org_id'] is None):
            raise ValueError("Missing the required parameter `org_id` when calling `delete_orgs_id_members_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501
        if 'org_id' in local_var_params:
            path_params['orgID'] = local_var_params['org_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/orgs/{orgID}/members/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def delete_orgs_id_owners_id(self, user_id, org_id, **kwargs):  # noqa: E501,D401,D403
        """Remove an owner from an organization.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_orgs_id_owners_id(user_id, org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the owner to remove. (required)
        :param str org_id: The organization ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_orgs_id_owners_id_with_http_info(user_id, org_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_orgs_id_owners_id_with_http_info(user_id, org_id, **kwargs)  # noqa: E501
            return data

    def delete_orgs_id_owners_id_with_http_info(self, user_id, org_id, **kwargs):  # noqa: E501,D401,D403
        """Remove an owner from an organization.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_orgs_id_owners_id_with_http_info(user_id, org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the owner to remove. (required)
        :param str org_id: The organization ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['user_id', 'org_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_orgs_id_owners_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_orgs_id_owners_id`")  # noqa: E501
        # verify the required parameter 'org_id' is set
        if ('org_id' not in local_var_params or
                local_var_params['org_id'] is None):
            raise ValueError("Missing the required parameter `org_id` when calling `delete_orgs_id_owners_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501
        if 'org_id' in local_var_params:
            path_params['orgID'] = local_var_params['org_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/orgs/{orgID}/owners/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def delete_scrapers_id_members_id(self, user_id, scraper_target_id, **kwargs):  # noqa: E501,D401,D403
        """Remove a member from a scraper target.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_scrapers_id_members_id(user_id, scraper_target_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of member to remove. (required)
        :param str scraper_target_id: The scraper target ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_scrapers_id_members_id_with_http_info(user_id, scraper_target_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_scrapers_id_members_id_with_http_info(user_id, scraper_target_id, **kwargs)  # noqa: E501
            return data

    def delete_scrapers_id_members_id_with_http_info(self, user_id, scraper_target_id, **kwargs):  # noqa: E501,D401,D403
        """Remove a member from a scraper target.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_scrapers_id_members_id_with_http_info(user_id, scraper_target_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of member to remove. (required)
        :param str scraper_target_id: The scraper target ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['user_id', 'scraper_target_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_scrapers_id_members_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_scrapers_id_members_id`")  # noqa: E501
        # verify the required parameter 'scraper_target_id' is set
        if ('scraper_target_id' not in local_var_params or
                local_var_params['scraper_target_id'] is None):
            raise ValueError("Missing the required parameter `scraper_target_id` when calling `delete_scrapers_id_members_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501
        if 'scraper_target_id' in local_var_params:
            path_params['scraperTargetID'] = local_var_params['scraper_target_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}/members/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def delete_scrapers_id_owners_id(self, user_id, scraper_target_id, **kwargs):  # noqa: E501,D401,D403
        """Remove an owner from a scraper target.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_scrapers_id_owners_id(user_id, scraper_target_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of owner to remove. (required)
        :param str scraper_target_id: The scraper target ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_scrapers_id_owners_id_with_http_info(user_id, scraper_target_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_scrapers_id_owners_id_with_http_info(user_id, scraper_target_id, **kwargs)  # noqa: E501
            return data

    def delete_scrapers_id_owners_id_with_http_info(self, user_id, scraper_target_id, **kwargs):  # noqa: E501,D401,D403
        """Remove an owner from a scraper target.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_scrapers_id_owners_id_with_http_info(user_id, scraper_target_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of owner to remove. (required)
        :param str scraper_target_id: The scraper target ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['user_id', 'scraper_target_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_scrapers_id_owners_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_scrapers_id_owners_id`")  # noqa: E501
        # verify the required parameter 'scraper_target_id' is set
        if ('scraper_target_id' not in local_var_params or
                local_var_params['scraper_target_id'] is None):
            raise ValueError("Missing the required parameter `scraper_target_id` when calling `delete_scrapers_id_owners_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501
        if 'scraper_target_id' in local_var_params:
            path_params['scraperTargetID'] = local_var_params['scraper_target_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}/owners/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def delete_tasks_id_members_id(self, user_id, task_id, **kwargs):  # noqa: E501,D401,D403
        """Remove a member from a task.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tasks_id_members_id(user_id, task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the member to remove. (required)
        :param str task_id: The task ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_tasks_id_members_id_with_http_info(user_id, task_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_tasks_id_members_id_with_http_info(user_id, task_id, **kwargs)  # noqa: E501
            return data

    def delete_tasks_id_members_id_with_http_info(self, user_id, task_id, **kwargs):  # noqa: E501,D401,D403
        """Remove a member from a task.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tasks_id_members_id_with_http_info(user_id, task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the member to remove. (required)
        :param str task_id: The task ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['user_id', 'task_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_tasks_id_members_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_tasks_id_members_id`")  # noqa: E501
        # verify the required parameter 'task_id' is set
        if ('task_id' not in local_var_params or
                local_var_params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `delete_tasks_id_members_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501
        if 'task_id' in local_var_params:
            path_params['taskID'] = local_var_params['task_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/tasks/{taskID}/members/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def delete_tasks_id_owners_id(self, user_id, task_id, **kwargs):  # noqa: E501,D401,D403
        """Remove an owner from a task.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tasks_id_owners_id(user_id, task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the owner to remove. (required)
        :param str task_id: The task ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_tasks_id_owners_id_with_http_info(user_id, task_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_tasks_id_owners_id_with_http_info(user_id, task_id, **kwargs)  # noqa: E501
            return data

    def delete_tasks_id_owners_id_with_http_info(self, user_id, task_id, **kwargs):  # noqa: E501,D401,D403
        """Remove an owner from a task.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tasks_id_owners_id_with_http_info(user_id, task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the owner to remove. (required)
        :param str task_id: The task ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['user_id', 'task_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_tasks_id_owners_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_tasks_id_owners_id`")  # noqa: E501
        # verify the required parameter 'task_id' is set
        if ('task_id' not in local_var_params or
                local_var_params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `delete_tasks_id_owners_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501
        if 'task_id' in local_var_params:
            path_params['taskID'] = local_var_params['task_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/tasks/{taskID}/owners/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def delete_telegrafs_id_members_id(self, user_id, telegraf_id, **kwargs):  # noqa: E501,D401,D403
        """Remove a member from a Telegraf config.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_telegrafs_id_members_id(user_id, telegraf_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the member to remove. (required)
        :param str telegraf_id: The Telegraf config ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_telegrafs_id_members_id_with_http_info(user_id, telegraf_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_telegrafs_id_members_id_with_http_info(user_id, telegraf_id, **kwargs)  # noqa: E501
            return data

    def delete_telegrafs_id_members_id_with_http_info(self, user_id, telegraf_id, **kwargs):  # noqa: E501,D401,D403
        """Remove a member from a Telegraf config.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_telegrafs_id_members_id_with_http_info(user_id, telegraf_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the member to remove. (required)
        :param str telegraf_id: The Telegraf config ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['user_id', 'telegraf_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_telegrafs_id_members_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_telegrafs_id_members_id`")  # noqa: E501
        # verify the required parameter 'telegraf_id' is set
        if ('telegraf_id' not in local_var_params or
                local_var_params['telegraf_id'] is None):
            raise ValueError("Missing the required parameter `telegraf_id` when calling `delete_telegrafs_id_members_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501
        if 'telegraf_id' in local_var_params:
            path_params['telegrafID'] = local_var_params['telegraf_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/telegrafs/{telegrafID}/members/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def delete_telegrafs_id_owners_id(self, user_id, telegraf_id, **kwargs):  # noqa: E501,D401,D403
        """Remove an owner from a Telegraf config.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_telegrafs_id_owners_id(user_id, telegraf_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the owner to remove. (required)
        :param str telegraf_id: The Telegraf config ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_telegrafs_id_owners_id_with_http_info(user_id, telegraf_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_telegrafs_id_owners_id_with_http_info(user_id, telegraf_id, **kwargs)  # noqa: E501
            return data

    def delete_telegrafs_id_owners_id_with_http_info(self, user_id, telegraf_id, **kwargs):  # noqa: E501,D401,D403
        """Remove an owner from a Telegraf config.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_telegrafs_id_owners_id_with_http_info(user_id, telegraf_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the owner to remove. (required)
        :param str telegraf_id: The Telegraf config ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['user_id', 'telegraf_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_telegrafs_id_owners_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_telegrafs_id_owners_id`")  # noqa: E501
        # verify the required parameter 'telegraf_id' is set
        if ('telegraf_id' not in local_var_params or
                local_var_params['telegraf_id'] is None):
            raise ValueError("Missing the required parameter `telegraf_id` when calling `delete_telegrafs_id_owners_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501
        if 'telegraf_id' in local_var_params:
            path_params['telegrafID'] = local_var_params['telegraf_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/telegrafs/{telegrafID}/owners/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def delete_users_id(self, user_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_users_id(user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the user to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_users_id_with_http_info(user_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_users_id_with_http_info(user_id, **kwargs)  # noqa: E501
            return data

    def delete_users_id_with_http_info(self, user_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_users_id_with_http_info(user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the user to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['user_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_users_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_users_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/users/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def get_buckets_id_members(self, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """List all users with member privileges for a bucket.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_buckets_id_members(bucket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The bucket ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMembers
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_buckets_id_members_with_http_info(bucket_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_buckets_id_members_with_http_info(bucket_id, **kwargs)  # noqa: E501
            return data

    def get_buckets_id_members_with_http_info(self, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """List all users with member privileges for a bucket.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_buckets_id_members_with_http_info(bucket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The bucket ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMembers
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['bucket_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_buckets_id_members" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in local_var_params or
                local_var_params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `get_buckets_id_members`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bucket_id' in local_var_params:
            path_params['bucketID'] = local_var_params['bucket_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/buckets/{bucketID}/members', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceMembers',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def get_buckets_id_owners(self, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """List all owners of a bucket.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_buckets_id_owners(bucket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The bucket ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwners
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_buckets_id_owners_with_http_info(bucket_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_buckets_id_owners_with_http_info(bucket_id, **kwargs)  # noqa: E501
            return data

    def get_buckets_id_owners_with_http_info(self, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """List all owners of a bucket.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_buckets_id_owners_with_http_info(bucket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The bucket ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwners
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['bucket_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_buckets_id_owners" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in local_var_params or
                local_var_params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `get_buckets_id_owners`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bucket_id' in local_var_params:
            path_params['bucketID'] = local_var_params['bucket_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/buckets/{bucketID}/owners', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceOwners',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def get_dashboards_id_members(self, dashboard_id, **kwargs):  # noqa: E501,D401,D403
        """List all dashboard members.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dashboards_id_members(dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: The dashboard ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMembers
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dashboards_id_members_with_http_info(dashboard_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_dashboards_id_members_with_http_info(dashboard_id, **kwargs)  # noqa: E501
            return data

    def get_dashboards_id_members_with_http_info(self, dashboard_id, **kwargs):  # noqa: E501,D401,D403
        """List all dashboard members.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dashboards_id_members_with_http_info(dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: The dashboard ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMembers
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['dashboard_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dashboards_id_members" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'dashboard_id' is set
        if ('dashboard_id' not in local_var_params or
                local_var_params['dashboard_id'] is None):
            raise ValueError("Missing the required parameter `dashboard_id` when calling `get_dashboards_id_members`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dashboard_id' in local_var_params:
            path_params['dashboardID'] = local_var_params['dashboard_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/dashboards/{dashboardID}/members', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceMembers',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def get_dashboards_id_owners(self, dashboard_id, **kwargs):  # noqa: E501,D401,D403
        """List all dashboard owners.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dashboards_id_owners(dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: The dashboard ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwners
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dashboards_id_owners_with_http_info(dashboard_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_dashboards_id_owners_with_http_info(dashboard_id, **kwargs)  # noqa: E501
            return data

    def get_dashboards_id_owners_with_http_info(self, dashboard_id, **kwargs):  # noqa: E501,D401,D403
        """List all dashboard owners.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dashboards_id_owners_with_http_info(dashboard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: The dashboard ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwners
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['dashboard_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dashboards_id_owners" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'dashboard_id' is set
        if ('dashboard_id' not in local_var_params or
                local_var_params['dashboard_id'] is None):
            raise ValueError("Missing the required parameter `dashboard_id` when calling `get_dashboards_id_owners`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dashboard_id' in local_var_params:
            path_params['dashboardID'] = local_var_params['dashboard_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/dashboards/{dashboardID}/owners', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceOwners',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def get_me(self, **kwargs):  # noqa: E501,D401,D403
        """Return the current authenticated user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_me(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_me_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_me_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_me_with_http_info(self, **kwargs):  # noqa: E501,D401,D403
        """Return the current authenticated user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_me_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_me" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/me', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='User',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def get_orgs_id_members(self, org_id, **kwargs):  # noqa: E501,D401,D403
        """List all members of an organization.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_orgs_id_members(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: The organization ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMembers
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_orgs_id_members_with_http_info(org_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_orgs_id_members_with_http_info(org_id, **kwargs)  # noqa: E501
            return data

    def get_orgs_id_members_with_http_info(self, org_id, **kwargs):  # noqa: E501,D401,D403
        """List all members of an organization.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_orgs_id_members_with_http_info(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: The organization ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMembers
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['org_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_orgs_id_members" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'org_id' is set
        if ('org_id' not in local_var_params or
                local_var_params['org_id'] is None):
            raise ValueError("Missing the required parameter `org_id` when calling `get_orgs_id_members`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org_id' in local_var_params:
            path_params['orgID'] = local_var_params['org_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/orgs/{orgID}/members', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceMembers',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def get_orgs_id_owners(self, org_id, **kwargs):  # noqa: E501,D401,D403
        """List all owners of an organization.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_orgs_id_owners(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: The organization ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwners
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_orgs_id_owners_with_http_info(org_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_orgs_id_owners_with_http_info(org_id, **kwargs)  # noqa: E501
            return data

    def get_orgs_id_owners_with_http_info(self, org_id, **kwargs):  # noqa: E501,D401,D403
        """List all owners of an organization.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_orgs_id_owners_with_http_info(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: The organization ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwners
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['org_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_orgs_id_owners" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'org_id' is set
        if ('org_id' not in local_var_params or
                local_var_params['org_id'] is None):
            raise ValueError("Missing the required parameter `org_id` when calling `get_orgs_id_owners`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org_id' in local_var_params:
            path_params['orgID'] = local_var_params['org_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/orgs/{orgID}/owners', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceOwners',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def get_scrapers_id_members(self, scraper_target_id, **kwargs):  # noqa: E501,D401,D403
        """List all users with member privileges for a scraper target.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scrapers_id_members(scraper_target_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMembers
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_scrapers_id_members_with_http_info(scraper_target_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_scrapers_id_members_with_http_info(scraper_target_id, **kwargs)  # noqa: E501
            return data

    def get_scrapers_id_members_with_http_info(self, scraper_target_id, **kwargs):  # noqa: E501,D401,D403
        """List all users with member privileges for a scraper target.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scrapers_id_members_with_http_info(scraper_target_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMembers
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['scraper_target_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_scrapers_id_members" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'scraper_target_id' is set
        if ('scraper_target_id' not in local_var_params or
                local_var_params['scraper_target_id'] is None):
            raise ValueError("Missing the required parameter `scraper_target_id` when calling `get_scrapers_id_members`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'scraper_target_id' in local_var_params:
            path_params['scraperTargetID'] = local_var_params['scraper_target_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}/members', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceMembers',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def get_scrapers_id_owners(self, scraper_target_id, **kwargs):  # noqa: E501,D401,D403
        """List all owners of a scraper target.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scrapers_id_owners(scraper_target_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwners
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_scrapers_id_owners_with_http_info(scraper_target_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_scrapers_id_owners_with_http_info(scraper_target_id, **kwargs)  # noqa: E501
            return data

    def get_scrapers_id_owners_with_http_info(self, scraper_target_id, **kwargs):  # noqa: E501,D401,D403
        """List all owners of a scraper target.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scrapers_id_owners_with_http_info(scraper_target_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwners
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['scraper_target_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_scrapers_id_owners" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'scraper_target_id' is set
        if ('scraper_target_id' not in local_var_params or
                local_var_params['scraper_target_id'] is None):
            raise ValueError("Missing the required parameter `scraper_target_id` when calling `get_scrapers_id_owners`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'scraper_target_id' in local_var_params:
            path_params['scraperTargetID'] = local_var_params['scraper_target_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}/owners', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceOwners',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def get_tasks_id_members(self, task_id, **kwargs):  # noqa: E501,D401,D403
        """List all task members.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tasks_id_members(task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: The task ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMembers
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tasks_id_members_with_http_info(task_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tasks_id_members_with_http_info(task_id, **kwargs)  # noqa: E501
            return data

    def get_tasks_id_members_with_http_info(self, task_id, **kwargs):  # noqa: E501,D401,D403
        """List all task members.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tasks_id_members_with_http_info(task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: The task ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMembers
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['task_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tasks_id_members" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'task_id' is set
        if ('task_id' not in local_var_params or
                local_var_params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `get_tasks_id_members`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_id' in local_var_params:
            path_params['taskID'] = local_var_params['task_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/tasks/{taskID}/members', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceMembers',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def get_tasks_id_owners(self, task_id, **kwargs):  # noqa: E501,D401,D403
        """List all owners of a task.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tasks_id_owners(task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: The task ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwners
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tasks_id_owners_with_http_info(task_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tasks_id_owners_with_http_info(task_id, **kwargs)  # noqa: E501
            return data

    def get_tasks_id_owners_with_http_info(self, task_id, **kwargs):  # noqa: E501,D401,D403
        """List all owners of a task.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tasks_id_owners_with_http_info(task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: The task ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwners
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['task_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tasks_id_owners" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'task_id' is set
        if ('task_id' not in local_var_params or
                local_var_params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `get_tasks_id_owners`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_id' in local_var_params:
            path_params['taskID'] = local_var_params['task_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/tasks/{taskID}/owners', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceOwners',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def get_telegrafs_id_members(self, telegraf_id, **kwargs):  # noqa: E501,D401,D403
        """List all users with member privileges for a Telegraf config.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_telegrafs_id_members(telegraf_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMembers
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_telegrafs_id_members_with_http_info(telegraf_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_telegrafs_id_members_with_http_info(telegraf_id, **kwargs)  # noqa: E501
            return data

    def get_telegrafs_id_members_with_http_info(self, telegraf_id, **kwargs):  # noqa: E501,D401,D403
        """List all users with member privileges for a Telegraf config.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_telegrafs_id_members_with_http_info(telegraf_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMembers
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['telegraf_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telegrafs_id_members" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'telegraf_id' is set
        if ('telegraf_id' not in local_var_params or
                local_var_params['telegraf_id'] is None):
            raise ValueError("Missing the required parameter `telegraf_id` when calling `get_telegrafs_id_members`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'telegraf_id' in local_var_params:
            path_params['telegrafID'] = local_var_params['telegraf_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/telegrafs/{telegrafID}/members', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceMembers',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def get_telegrafs_id_owners(self, telegraf_id, **kwargs):  # noqa: E501,D401,D403
        """List all owners of a Telegraf config.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_telegrafs_id_owners(telegraf_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwners
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_telegrafs_id_owners_with_http_info(telegraf_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_telegrafs_id_owners_with_http_info(telegraf_id, **kwargs)  # noqa: E501
            return data

    def get_telegrafs_id_owners_with_http_info(self, telegraf_id, **kwargs):  # noqa: E501,D401,D403
        """List all owners of a Telegraf config.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_telegrafs_id_owners_with_http_info(telegraf_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwners
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['telegraf_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telegrafs_id_owners" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'telegraf_id' is set
        if ('telegraf_id' not in local_var_params or
                local_var_params['telegraf_id'] is None):
            raise ValueError("Missing the required parameter `telegraf_id` when calling `get_telegrafs_id_owners`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'telegraf_id' in local_var_params:
            path_params['telegrafID'] = local_var_params['telegraf_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/telegrafs/{telegrafID}/owners', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceOwners',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def get_users(self, **kwargs):  # noqa: E501,D401,D403
        """List all users.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_users(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :return: Users
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_users_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_users_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_users_with_http_info(self, **kwargs):  # noqa: E501,D401,D403
        """List all users.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_users_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :return: Users
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_users" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/users', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Users',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def get_users_id(self, user_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_users_id(user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The user ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_users_id_with_http_info(user_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_users_id_with_http_info(user_id, **kwargs)  # noqa: E501
            return data

    def get_users_id_with_http_info(self, user_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_users_id_with_http_info(user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The user ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['user_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_users_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_users_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/users/{userID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='User',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def patch_users_id(self, user_id, user, **kwargs):  # noqa: E501,D401,D403
        """Update a user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_users_id(user_id, user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the user to update. (required)
        :param User user: User update to apply (required)
        :param str zap_trace_span: OpenTracing span context
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_users_id_with_http_info(user_id, user, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_users_id_with_http_info(user_id, user, **kwargs)  # noqa: E501
            return data

    def patch_users_id_with_http_info(self, user_id, user, **kwargs):  # noqa: E501,D401,D403
        """Update a user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_users_id_with_http_info(user_id, user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the user to update. (required)
        :param User user: User update to apply (required)
        :param str zap_trace_span: OpenTracing span context
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['user_id', 'user', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_users_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `patch_users_id`")  # noqa: E501
        # verify the required parameter 'user' is set
        if ('user' not in local_var_params or
                local_var_params['user'] is None):
            raise ValueError("Missing the required parameter `user` when calling `patch_users_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'user' in local_var_params:
            body_params = local_var_params['user']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/users/{userID}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='User',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def post_buckets_id_members(self, bucket_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add a member to a bucket.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_buckets_id_members(bucket_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The bucket ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as member (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMember
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_buckets_id_members_with_http_info(bucket_id, add_resource_member_request_body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_buckets_id_members_with_http_info(bucket_id, add_resource_member_request_body, **kwargs)  # noqa: E501
            return data

    def post_buckets_id_members_with_http_info(self, bucket_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add a member to a bucket.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_buckets_id_members_with_http_info(bucket_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The bucket ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as member (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMember
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['bucket_id', 'add_resource_member_request_body', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_buckets_id_members" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in local_var_params or
                local_var_params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `post_buckets_id_members`")  # noqa: E501
        # verify the required parameter 'add_resource_member_request_body' is set
        if ('add_resource_member_request_body' not in local_var_params or
                local_var_params['add_resource_member_request_body'] is None):
            raise ValueError("Missing the required parameter `add_resource_member_request_body` when calling `post_buckets_id_members`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bucket_id' in local_var_params:
            path_params['bucketID'] = local_var_params['bucket_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'add_resource_member_request_body' in local_var_params:
            body_params = local_var_params['add_resource_member_request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/buckets/{bucketID}/members', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceMember',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def post_buckets_id_owners(self, bucket_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add an owner to a bucket.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_buckets_id_owners(bucket_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The bucket ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as owner (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwner
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_buckets_id_owners_with_http_info(bucket_id, add_resource_member_request_body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_buckets_id_owners_with_http_info(bucket_id, add_resource_member_request_body, **kwargs)  # noqa: E501
            return data

    def post_buckets_id_owners_with_http_info(self, bucket_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add an owner to a bucket.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_buckets_id_owners_with_http_info(bucket_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The bucket ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as owner (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwner
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['bucket_id', 'add_resource_member_request_body', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_buckets_id_owners" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in local_var_params or
                local_var_params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `post_buckets_id_owners`")  # noqa: E501
        # verify the required parameter 'add_resource_member_request_body' is set
        if ('add_resource_member_request_body' not in local_var_params or
                local_var_params['add_resource_member_request_body'] is None):
            raise ValueError("Missing the required parameter `add_resource_member_request_body` when calling `post_buckets_id_owners`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bucket_id' in local_var_params:
            path_params['bucketID'] = local_var_params['bucket_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'add_resource_member_request_body' in local_var_params:
            body_params = local_var_params['add_resource_member_request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/buckets/{bucketID}/owners', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceOwner',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def post_dashboards_id_members(self, dashboard_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add a member to a dashboard.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_dashboards_id_members(dashboard_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: The dashboard ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as member (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMember
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_dashboards_id_members_with_http_info(dashboard_id, add_resource_member_request_body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_dashboards_id_members_with_http_info(dashboard_id, add_resource_member_request_body, **kwargs)  # noqa: E501
            return data

    def post_dashboards_id_members_with_http_info(self, dashboard_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add a member to a dashboard.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_dashboards_id_members_with_http_info(dashboard_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: The dashboard ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as member (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMember
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['dashboard_id', 'add_resource_member_request_body', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_dashboards_id_members" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'dashboard_id' is set
        if ('dashboard_id' not in local_var_params or
                local_var_params['dashboard_id'] is None):
            raise ValueError("Missing the required parameter `dashboard_id` when calling `post_dashboards_id_members`")  # noqa: E501
        # verify the required parameter 'add_resource_member_request_body' is set
        if ('add_resource_member_request_body' not in local_var_params or
                local_var_params['add_resource_member_request_body'] is None):
            raise ValueError("Missing the required parameter `add_resource_member_request_body` when calling `post_dashboards_id_members`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dashboard_id' in local_var_params:
            path_params['dashboardID'] = local_var_params['dashboard_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'add_resource_member_request_body' in local_var_params:
            body_params = local_var_params['add_resource_member_request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/dashboards/{dashboardID}/members', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceMember',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def post_dashboards_id_owners(self, dashboard_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add an owner to a dashboard.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_dashboards_id_owners(dashboard_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: The dashboard ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as owner (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwner
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_dashboards_id_owners_with_http_info(dashboard_id, add_resource_member_request_body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_dashboards_id_owners_with_http_info(dashboard_id, add_resource_member_request_body, **kwargs)  # noqa: E501
            return data

    def post_dashboards_id_owners_with_http_info(self, dashboard_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add an owner to a dashboard.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_dashboards_id_owners_with_http_info(dashboard_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dashboard_id: The dashboard ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as owner (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwner
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['dashboard_id', 'add_resource_member_request_body', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_dashboards_id_owners" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'dashboard_id' is set
        if ('dashboard_id' not in local_var_params or
                local_var_params['dashboard_id'] is None):
            raise ValueError("Missing the required parameter `dashboard_id` when calling `post_dashboards_id_owners`")  # noqa: E501
        # verify the required parameter 'add_resource_member_request_body' is set
        if ('add_resource_member_request_body' not in local_var_params or
                local_var_params['add_resource_member_request_body'] is None):
            raise ValueError("Missing the required parameter `add_resource_member_request_body` when calling `post_dashboards_id_owners`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dashboard_id' in local_var_params:
            path_params['dashboardID'] = local_var_params['dashboard_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'add_resource_member_request_body' in local_var_params:
            body_params = local_var_params['add_resource_member_request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/dashboards/{dashboardID}/owners', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceOwner',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def post_orgs_id_members(self, org_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add a member to an organization.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_orgs_id_members(org_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: The organization ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as member (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMember
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_orgs_id_members_with_http_info(org_id, add_resource_member_request_body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_orgs_id_members_with_http_info(org_id, add_resource_member_request_body, **kwargs)  # noqa: E501
            return data

    def post_orgs_id_members_with_http_info(self, org_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add a member to an organization.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_orgs_id_members_with_http_info(org_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: The organization ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as member (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMember
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['org_id', 'add_resource_member_request_body', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_orgs_id_members" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'org_id' is set
        if ('org_id' not in local_var_params or
                local_var_params['org_id'] is None):
            raise ValueError("Missing the required parameter `org_id` when calling `post_orgs_id_members`")  # noqa: E501
        # verify the required parameter 'add_resource_member_request_body' is set
        if ('add_resource_member_request_body' not in local_var_params or
                local_var_params['add_resource_member_request_body'] is None):
            raise ValueError("Missing the required parameter `add_resource_member_request_body` when calling `post_orgs_id_members`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org_id' in local_var_params:
            path_params['orgID'] = local_var_params['org_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'add_resource_member_request_body' in local_var_params:
            body_params = local_var_params['add_resource_member_request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/orgs/{orgID}/members', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceMember',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def post_orgs_id_owners(self, org_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add an owner to an organization.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_orgs_id_owners(org_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: The organization ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as owner (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwner
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_orgs_id_owners_with_http_info(org_id, add_resource_member_request_body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_orgs_id_owners_with_http_info(org_id, add_resource_member_request_body, **kwargs)  # noqa: E501
            return data

    def post_orgs_id_owners_with_http_info(self, org_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add an owner to an organization.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_orgs_id_owners_with_http_info(org_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: The organization ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as owner (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwner
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['org_id', 'add_resource_member_request_body', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_orgs_id_owners" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'org_id' is set
        if ('org_id' not in local_var_params or
                local_var_params['org_id'] is None):
            raise ValueError("Missing the required parameter `org_id` when calling `post_orgs_id_owners`")  # noqa: E501
        # verify the required parameter 'add_resource_member_request_body' is set
        if ('add_resource_member_request_body' not in local_var_params or
                local_var_params['add_resource_member_request_body'] is None):
            raise ValueError("Missing the required parameter `add_resource_member_request_body` when calling `post_orgs_id_owners`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org_id' in local_var_params:
            path_params['orgID'] = local_var_params['org_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'add_resource_member_request_body' in local_var_params:
            body_params = local_var_params['add_resource_member_request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/orgs/{orgID}/owners', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceOwner',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def post_scrapers_id_members(self, scraper_target_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add a member to a scraper target.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_scrapers_id_members(scraper_target_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as member (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMember
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_scrapers_id_members_with_http_info(scraper_target_id, add_resource_member_request_body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_scrapers_id_members_with_http_info(scraper_target_id, add_resource_member_request_body, **kwargs)  # noqa: E501
            return data

    def post_scrapers_id_members_with_http_info(self, scraper_target_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add a member to a scraper target.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_scrapers_id_members_with_http_info(scraper_target_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as member (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMember
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['scraper_target_id', 'add_resource_member_request_body', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_scrapers_id_members" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'scraper_target_id' is set
        if ('scraper_target_id' not in local_var_params or
                local_var_params['scraper_target_id'] is None):
            raise ValueError("Missing the required parameter `scraper_target_id` when calling `post_scrapers_id_members`")  # noqa: E501
        # verify the required parameter 'add_resource_member_request_body' is set
        if ('add_resource_member_request_body' not in local_var_params or
                local_var_params['add_resource_member_request_body'] is None):
            raise ValueError("Missing the required parameter `add_resource_member_request_body` when calling `post_scrapers_id_members`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'scraper_target_id' in local_var_params:
            path_params['scraperTargetID'] = local_var_params['scraper_target_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'add_resource_member_request_body' in local_var_params:
            body_params = local_var_params['add_resource_member_request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}/members', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceMember',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def post_scrapers_id_owners(self, scraper_target_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add an owner to a scraper target.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_scrapers_id_owners(scraper_target_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as owner (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwner
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_scrapers_id_owners_with_http_info(scraper_target_id, add_resource_member_request_body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_scrapers_id_owners_with_http_info(scraper_target_id, add_resource_member_request_body, **kwargs)  # noqa: E501
            return data

    def post_scrapers_id_owners_with_http_info(self, scraper_target_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add an owner to a scraper target.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_scrapers_id_owners_with_http_info(scraper_target_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as owner (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwner
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['scraper_target_id', 'add_resource_member_request_body', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_scrapers_id_owners" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'scraper_target_id' is set
        if ('scraper_target_id' not in local_var_params or
                local_var_params['scraper_target_id'] is None):
            raise ValueError("Missing the required parameter `scraper_target_id` when calling `post_scrapers_id_owners`")  # noqa: E501
        # verify the required parameter 'add_resource_member_request_body' is set
        if ('add_resource_member_request_body' not in local_var_params or
                local_var_params['add_resource_member_request_body'] is None):
            raise ValueError("Missing the required parameter `add_resource_member_request_body` when calling `post_scrapers_id_owners`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'scraper_target_id' in local_var_params:
            path_params['scraperTargetID'] = local_var_params['scraper_target_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'add_resource_member_request_body' in local_var_params:
            body_params = local_var_params['add_resource_member_request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}/owners', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceOwner',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def post_tasks_id_members(self, task_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add a member to a task.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_tasks_id_members(task_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: The task ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as member (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMember
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_tasks_id_members_with_http_info(task_id, add_resource_member_request_body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_tasks_id_members_with_http_info(task_id, add_resource_member_request_body, **kwargs)  # noqa: E501
            return data

    def post_tasks_id_members_with_http_info(self, task_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add a member to a task.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_tasks_id_members_with_http_info(task_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: The task ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as member (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMember
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['task_id', 'add_resource_member_request_body', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_tasks_id_members" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'task_id' is set
        if ('task_id' not in local_var_params or
                local_var_params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `post_tasks_id_members`")  # noqa: E501
        # verify the required parameter 'add_resource_member_request_body' is set
        if ('add_resource_member_request_body' not in local_var_params or
                local_var_params['add_resource_member_request_body'] is None):
            raise ValueError("Missing the required parameter `add_resource_member_request_body` when calling `post_tasks_id_members`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_id' in local_var_params:
            path_params['taskID'] = local_var_params['task_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'add_resource_member_request_body' in local_var_params:
            body_params = local_var_params['add_resource_member_request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/tasks/{taskID}/members', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceMember',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def post_tasks_id_owners(self, task_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add an owner to a task.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_tasks_id_owners(task_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: The task ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as owner (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwner
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_tasks_id_owners_with_http_info(task_id, add_resource_member_request_body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_tasks_id_owners_with_http_info(task_id, add_resource_member_request_body, **kwargs)  # noqa: E501
            return data

    def post_tasks_id_owners_with_http_info(self, task_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add an owner to a task.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_tasks_id_owners_with_http_info(task_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: The task ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as owner (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwner
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['task_id', 'add_resource_member_request_body', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_tasks_id_owners" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'task_id' is set
        if ('task_id' not in local_var_params or
                local_var_params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `post_tasks_id_owners`")  # noqa: E501
        # verify the required parameter 'add_resource_member_request_body' is set
        if ('add_resource_member_request_body' not in local_var_params or
                local_var_params['add_resource_member_request_body'] is None):
            raise ValueError("Missing the required parameter `add_resource_member_request_body` when calling `post_tasks_id_owners`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_id' in local_var_params:
            path_params['taskID'] = local_var_params['task_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'add_resource_member_request_body' in local_var_params:
            body_params = local_var_params['add_resource_member_request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/tasks/{taskID}/owners', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceOwner',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def post_telegrafs_id_members(self, telegraf_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add a member to a Telegraf config.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_telegrafs_id_members(telegraf_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as member (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMember
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_telegrafs_id_members_with_http_info(telegraf_id, add_resource_member_request_body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_telegrafs_id_members_with_http_info(telegraf_id, add_resource_member_request_body, **kwargs)  # noqa: E501
            return data

    def post_telegrafs_id_members_with_http_info(self, telegraf_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add a member to a Telegraf config.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_telegrafs_id_members_with_http_info(telegraf_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as member (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMember
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['telegraf_id', 'add_resource_member_request_body', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_telegrafs_id_members" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'telegraf_id' is set
        if ('telegraf_id' not in local_var_params or
                local_var_params['telegraf_id'] is None):
            raise ValueError("Missing the required parameter `telegraf_id` when calling `post_telegrafs_id_members`")  # noqa: E501
        # verify the required parameter 'add_resource_member_request_body' is set
        if ('add_resource_member_request_body' not in local_var_params or
                local_var_params['add_resource_member_request_body'] is None):
            raise ValueError("Missing the required parameter `add_resource_member_request_body` when calling `post_telegrafs_id_members`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'telegraf_id' in local_var_params:
            path_params['telegrafID'] = local_var_params['telegraf_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'add_resource_member_request_body' in local_var_params:
            body_params = local_var_params['add_resource_member_request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/telegrafs/{telegrafID}/members', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceMember',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def post_telegrafs_id_owners(self, telegraf_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add an owner to a Telegraf config.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_telegrafs_id_owners(telegraf_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as owner (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwner
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_telegrafs_id_owners_with_http_info(telegraf_id, add_resource_member_request_body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_telegrafs_id_owners_with_http_info(telegraf_id, add_resource_member_request_body, **kwargs)  # noqa: E501
            return data

    def post_telegrafs_id_owners_with_http_info(self, telegraf_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add an owner to a Telegraf config.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_telegrafs_id_owners_with_http_info(telegraf_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str telegraf_id: The Telegraf config ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as owner (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwner
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['telegraf_id', 'add_resource_member_request_body', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_telegrafs_id_owners" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'telegraf_id' is set
        if ('telegraf_id' not in local_var_params or
                local_var_params['telegraf_id'] is None):
            raise ValueError("Missing the required parameter `telegraf_id` when calling `post_telegrafs_id_owners`")  # noqa: E501
        # verify the required parameter 'add_resource_member_request_body' is set
        if ('add_resource_member_request_body' not in local_var_params or
                local_var_params['add_resource_member_request_body'] is None):
            raise ValueError("Missing the required parameter `add_resource_member_request_body` when calling `post_telegrafs_id_owners`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'telegraf_id' in local_var_params:
            path_params['telegrafID'] = local_var_params['telegraf_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'add_resource_member_request_body' in local_var_params:
            body_params = local_var_params['add_resource_member_request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/telegrafs/{telegrafID}/owners', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceOwner',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def post_users(self, user, **kwargs):  # noqa: E501,D401,D403
        """Create a user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_users(user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param User user: User to create (required)
        :param str zap_trace_span: OpenTracing span context
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_users_with_http_info(user, **kwargs)  # noqa: E501
        else:
            (data) = self.post_users_with_http_info(user, **kwargs)  # noqa: E501
            return data

    def post_users_with_http_info(self, user, **kwargs):  # noqa: E501,D401,D403
        """Create a user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_users_with_http_info(user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param User user: User to create (required)
        :param str zap_trace_span: OpenTracing span context
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['user', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_users" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user' is set
        if ('user' not in local_var_params or
                local_var_params['user'] is None):
            raise ValueError("Missing the required parameter `user` when calling `post_users`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'user' in local_var_params:
            body_params = local_var_params['user']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/users', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='User',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def post_users_id_password(self, user_id, password_reset_body, **kwargs):  # noqa: E501,D401,D403
        """Update a password.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_users_id_password(user_id, password_reset_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The user ID. (required)
        :param PasswordResetBody password_reset_body: New password (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_users_id_password_with_http_info(user_id, password_reset_body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_users_id_password_with_http_info(user_id, password_reset_body, **kwargs)  # noqa: E501
            return data

    def post_users_id_password_with_http_info(self, user_id, password_reset_body, **kwargs):  # noqa: E501,D401,D403
        """Update a password.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_users_id_password_with_http_info(user_id, password_reset_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The user ID. (required)
        :param PasswordResetBody password_reset_body: New password (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['user_id', 'password_reset_body', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_users_id_password" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `post_users_id_password`")  # noqa: E501
        # verify the required parameter 'password_reset_body' is set
        if ('password_reset_body' not in local_var_params or
                local_var_params['password_reset_body'] is None):
            raise ValueError("Missing the required parameter `password_reset_body` when calling `post_users_id_password`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'password_reset_body' in local_var_params:
            body_params = local_var_params['password_reset_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth']  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/users/{userID}/password', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def put_me_password(self, password_reset_body, **kwargs):  # noqa: E501,D401,D403
        """Update a password.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_me_password(password_reset_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PasswordResetBody password_reset_body: New password (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_me_password_with_http_info(password_reset_body, **kwargs)  # noqa: E501
        else:
            (data) = self.put_me_password_with_http_info(password_reset_body, **kwargs)  # noqa: E501
            return data

    def put_me_password_with_http_info(self, password_reset_body, **kwargs):  # noqa: E501,D401,D403
        """Update a password.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_me_password_with_http_info(password_reset_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PasswordResetBody password_reset_body: New password (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['password_reset_body', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_me_password" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'password_reset_body' is set
        if ('password_reset_body' not in local_var_params or
                local_var_params['password_reset_body'] is None):
            raise ValueError("Missing the required parameter `password_reset_body` when calling `put_me_password`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'password_reset_body' in local_var_params:
            body_params = local_var_params['password_reset_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BasicAuth']  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/me/password', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)
