# coding: utf-8

"""
Influx API Service.

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

OpenAPI spec version: 0.1.0
Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from influxdb_client.api_client import ApiClient


class BucketsService(object):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):  # noqa: E501,D401,D403
        """BucketsService - a operation defined in OpenAPI."""
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_buckets_id(self, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a bucket.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_buckets_id(bucket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The ID of the bucket to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_buckets_id_with_http_info(bucket_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_buckets_id_with_http_info(bucket_id, **kwargs)  # noqa: E501
            return data

    def delete_buckets_id_with_http_info(self, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a bucket.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_buckets_id_with_http_info(bucket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The ID of the bucket to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['bucket_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_buckets_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in local_var_params or
                local_var_params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `delete_buckets_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bucket_id' in local_var_params:
            path_params['bucketID'] = local_var_params['bucket_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/buckets/{bucketID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def delete_buckets_id_labels_id(self, bucket_id, label_id, **kwargs):  # noqa: E501,D401,D403
        """delete a label from a bucket.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_buckets_id_labels_id(bucket_id, label_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The bucket ID. (required)
        :param str label_id: The ID of the label to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_buckets_id_labels_id_with_http_info(bucket_id, label_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_buckets_id_labels_id_with_http_info(bucket_id, label_id, **kwargs)  # noqa: E501
            return data

    def delete_buckets_id_labels_id_with_http_info(self, bucket_id, label_id, **kwargs):  # noqa: E501,D401,D403
        """delete a label from a bucket.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_buckets_id_labels_id_with_http_info(bucket_id, label_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The bucket ID. (required)
        :param str label_id: The ID of the label to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['bucket_id', 'label_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_buckets_id_labels_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in local_var_params or
                local_var_params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `delete_buckets_id_labels_id`")  # noqa: E501
        # verify the required parameter 'label_id' is set
        if ('label_id' not in local_var_params or
                local_var_params['label_id'] is None):
            raise ValueError("Missing the required parameter `label_id` when calling `delete_buckets_id_labels_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bucket_id' in local_var_params:
            path_params['bucketID'] = local_var_params['bucket_id']  # noqa: E501
        if 'label_id' in local_var_params:
            path_params['labelID'] = local_var_params['label_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/buckets/{bucketID}/labels/{labelID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def delete_buckets_id_members_id(self, user_id, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """Remove a member from a bucket.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_buckets_id_members_id(user_id, bucket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the member to remove. (required)
        :param str bucket_id: The bucket ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_buckets_id_members_id_with_http_info(user_id, bucket_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_buckets_id_members_id_with_http_info(user_id, bucket_id, **kwargs)  # noqa: E501
            return data

    def delete_buckets_id_members_id_with_http_info(self, user_id, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """Remove a member from a bucket.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_buckets_id_members_id_with_http_info(user_id, bucket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the member to remove. (required)
        :param str bucket_id: The bucket ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['user_id', 'bucket_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_buckets_id_members_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_buckets_id_members_id`")  # noqa: E501
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in local_var_params or
                local_var_params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `delete_buckets_id_members_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501
        if 'bucket_id' in local_var_params:
            path_params['bucketID'] = local_var_params['bucket_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/buckets/{bucketID}/members/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def delete_buckets_id_owners_id(self, user_id, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """Remove an owner from a bucket.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_buckets_id_owners_id(user_id, bucket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the owner to remove. (required)
        :param str bucket_id: The bucket ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_buckets_id_owners_id_with_http_info(user_id, bucket_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_buckets_id_owners_id_with_http_info(user_id, bucket_id, **kwargs)  # noqa: E501
            return data

    def delete_buckets_id_owners_id_with_http_info(self, user_id, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """Remove an owner from a bucket.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_buckets_id_owners_id_with_http_info(user_id, bucket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the owner to remove. (required)
        :param str bucket_id: The bucket ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['user_id', 'bucket_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_buckets_id_owners_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_buckets_id_owners_id`")  # noqa: E501
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in local_var_params or
                local_var_params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `delete_buckets_id_owners_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501
        if 'bucket_id' in local_var_params:
            path_params['bucketID'] = local_var_params['bucket_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/buckets/{bucketID}/owners/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def get_buckets(self, **kwargs):  # noqa: E501,D401,D403
        """List all buckets.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_buckets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :param int offset:
        :param int limit:
        :param str after: The last resource ID from which to seek from (but not including). This is to be used instead of `offset`.
        :param str org: The organization name.
        :param str org_id: The organization ID.
        :param str name: Only returns buckets with a specific name.
        :return: Buckets
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_buckets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_buckets_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_buckets_with_http_info(self, **kwargs):  # noqa: E501,D401,D403
        """List all buckets.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_buckets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :param int offset:
        :param int limit:
        :param str after: The last resource ID from which to seek from (but not including). This is to be used instead of `offset`.
        :param str org: The organization name.
        :param str org_id: The organization ID.
        :param str name: Only returns buckets with a specific name.
        :return: Buckets
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['zap_trace_span', 'offset', 'limit', 'after', 'org', 'org_id', 'name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_buckets" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if 'offset' in local_var_params and local_var_params['offset'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `offset` when calling `get_buckets`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] > 100:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_buckets`, must be a value less than or equal to `100`")  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_buckets`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offset' in local_var_params:
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'limit' in local_var_params:
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'after' in local_var_params:
            query_params.append(('after', local_var_params['after']))  # noqa: E501
        if 'org' in local_var_params:
            query_params.append(('org', local_var_params['org']))  # noqa: E501
        if 'org_id' in local_var_params:
            query_params.append(('orgID', local_var_params['org_id']))  # noqa: E501
        if 'name' in local_var_params:
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/buckets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Buckets',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def get_buckets_id(self, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a bucket.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_buckets_id(bucket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The bucket ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Bucket
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_buckets_id_with_http_info(bucket_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_buckets_id_with_http_info(bucket_id, **kwargs)  # noqa: E501
            return data

    def get_buckets_id_with_http_info(self, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a bucket.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_buckets_id_with_http_info(bucket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The bucket ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Bucket
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['bucket_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_buckets_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in local_var_params or
                local_var_params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `get_buckets_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bucket_id' in local_var_params:
            path_params['bucketID'] = local_var_params['bucket_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/buckets/{bucketID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Bucket',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def get_buckets_id_labels(self, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """List all labels for a bucket.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_buckets_id_labels(bucket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The bucket ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_buckets_id_labels_with_http_info(bucket_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_buckets_id_labels_with_http_info(bucket_id, **kwargs)  # noqa: E501
            return data

    def get_buckets_id_labels_with_http_info(self, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """List all labels for a bucket.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_buckets_id_labels_with_http_info(bucket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The bucket ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['bucket_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_buckets_id_labels" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in local_var_params or
                local_var_params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `get_buckets_id_labels`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bucket_id' in local_var_params:
            path_params['bucketID'] = local_var_params['bucket_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/buckets/{bucketID}/labels', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LabelsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def get_buckets_id_members(self, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """List all users with member privileges for a bucket.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_buckets_id_members(bucket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The bucket ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMembers
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_buckets_id_members_with_http_info(bucket_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_buckets_id_members_with_http_info(bucket_id, **kwargs)  # noqa: E501
            return data

    def get_buckets_id_members_with_http_info(self, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """List all users with member privileges for a bucket.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_buckets_id_members_with_http_info(bucket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The bucket ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMembers
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['bucket_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_buckets_id_members" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in local_var_params or
                local_var_params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `get_buckets_id_members`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bucket_id' in local_var_params:
            path_params['bucketID'] = local_var_params['bucket_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/buckets/{bucketID}/members', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceMembers',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def get_buckets_id_owners(self, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """List all owners of a bucket.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_buckets_id_owners(bucket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The bucket ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwners
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_buckets_id_owners_with_http_info(bucket_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_buckets_id_owners_with_http_info(bucket_id, **kwargs)  # noqa: E501
            return data

    def get_buckets_id_owners_with_http_info(self, bucket_id, **kwargs):  # noqa: E501,D401,D403
        """List all owners of a bucket.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_buckets_id_owners_with_http_info(bucket_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The bucket ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwners
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['bucket_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_buckets_id_owners" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in local_var_params or
                local_var_params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `get_buckets_id_owners`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bucket_id' in local_var_params:
            path_params['bucketID'] = local_var_params['bucket_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/buckets/{bucketID}/owners', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceOwners',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def get_sources_id_buckets(self, source_id, **kwargs):  # noqa: E501,D401,D403
        """Get buckets in a source.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sources_id_buckets(source_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str source_id: The source ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str org: The organization name.
        :return: Buckets
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_sources_id_buckets_with_http_info(source_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_sources_id_buckets_with_http_info(source_id, **kwargs)  # noqa: E501
            return data

    def get_sources_id_buckets_with_http_info(self, source_id, **kwargs):  # noqa: E501,D401,D403
        """Get buckets in a source.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sources_id_buckets_with_http_info(source_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str source_id: The source ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str org: The organization name.
        :return: Buckets
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['source_id', 'zap_trace_span', 'org']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sources_id_buckets" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'source_id' is set
        if ('source_id' not in local_var_params or
                local_var_params['source_id'] is None):
            raise ValueError("Missing the required parameter `source_id` when calling `get_sources_id_buckets`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'source_id' in local_var_params:
            path_params['sourceID'] = local_var_params['source_id']  # noqa: E501

        query_params = []
        if 'org' in local_var_params:
            query_params.append(('org', local_var_params['org']))  # noqa: E501

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/sources/{sourceID}/buckets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Buckets',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def patch_buckets_id(self, bucket_id, bucket, **kwargs):  # noqa: E501,D401,D403
        """Update a bucket.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_buckets_id(bucket_id, bucket, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The bucket ID. (required)
        :param Bucket bucket: Bucket update to apply (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Bucket
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_buckets_id_with_http_info(bucket_id, bucket, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_buckets_id_with_http_info(bucket_id, bucket, **kwargs)  # noqa: E501
            return data

    def patch_buckets_id_with_http_info(self, bucket_id, bucket, **kwargs):  # noqa: E501,D401,D403
        """Update a bucket.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_buckets_id_with_http_info(bucket_id, bucket, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The bucket ID. (required)
        :param Bucket bucket: Bucket update to apply (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Bucket
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['bucket_id', 'bucket', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_buckets_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in local_var_params or
                local_var_params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `patch_buckets_id`")  # noqa: E501
        # verify the required parameter 'bucket' is set
        if ('bucket' not in local_var_params or
                local_var_params['bucket'] is None):
            raise ValueError("Missing the required parameter `bucket` when calling `patch_buckets_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bucket_id' in local_var_params:
            path_params['bucketID'] = local_var_params['bucket_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'bucket' in local_var_params:
            body_params = local_var_params['bucket']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/buckets/{bucketID}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Bucket',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def post_buckets(self, post_bucket_request, **kwargs):  # noqa: E501,D401,D403
        """Create a bucket.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_buckets(post_bucket_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostBucketRequest post_bucket_request: Bucket to create (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Bucket
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_buckets_with_http_info(post_bucket_request, **kwargs)  # noqa: E501
        else:
            (data) = self.post_buckets_with_http_info(post_bucket_request, **kwargs)  # noqa: E501
            return data

    def post_buckets_with_http_info(self, post_bucket_request, **kwargs):  # noqa: E501,D401,D403
        """Create a bucket.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_buckets_with_http_info(post_bucket_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostBucketRequest post_bucket_request: Bucket to create (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Bucket
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['post_bucket_request', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_buckets" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'post_bucket_request' is set
        if ('post_bucket_request' not in local_var_params or
                local_var_params['post_bucket_request'] is None):
            raise ValueError("Missing the required parameter `post_bucket_request` when calling `post_buckets`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'post_bucket_request' in local_var_params:
            body_params = local_var_params['post_bucket_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/buckets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Bucket',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def post_buckets_id_labels(self, bucket_id, label_mapping, **kwargs):  # noqa: E501,D401,D403
        """Add a label to a bucket.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_buckets_id_labels(bucket_id, label_mapping, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The bucket ID. (required)
        :param LabelMapping label_mapping: Label to add (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_buckets_id_labels_with_http_info(bucket_id, label_mapping, **kwargs)  # noqa: E501
        else:
            (data) = self.post_buckets_id_labels_with_http_info(bucket_id, label_mapping, **kwargs)  # noqa: E501
            return data

    def post_buckets_id_labels_with_http_info(self, bucket_id, label_mapping, **kwargs):  # noqa: E501,D401,D403
        """Add a label to a bucket.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_buckets_id_labels_with_http_info(bucket_id, label_mapping, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The bucket ID. (required)
        :param LabelMapping label_mapping: Label to add (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['bucket_id', 'label_mapping', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_buckets_id_labels" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in local_var_params or
                local_var_params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `post_buckets_id_labels`")  # noqa: E501
        # verify the required parameter 'label_mapping' is set
        if ('label_mapping' not in local_var_params or
                local_var_params['label_mapping'] is None):
            raise ValueError("Missing the required parameter `label_mapping` when calling `post_buckets_id_labels`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bucket_id' in local_var_params:
            path_params['bucketID'] = local_var_params['bucket_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'label_mapping' in local_var_params:
            body_params = local_var_params['label_mapping']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/buckets/{bucketID}/labels', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LabelResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def post_buckets_id_members(self, bucket_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add a member to a bucket.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_buckets_id_members(bucket_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The bucket ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as member (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMember
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_buckets_id_members_with_http_info(bucket_id, add_resource_member_request_body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_buckets_id_members_with_http_info(bucket_id, add_resource_member_request_body, **kwargs)  # noqa: E501
            return data

    def post_buckets_id_members_with_http_info(self, bucket_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add a member to a bucket.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_buckets_id_members_with_http_info(bucket_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The bucket ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as member (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMember
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['bucket_id', 'add_resource_member_request_body', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_buckets_id_members" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in local_var_params or
                local_var_params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `post_buckets_id_members`")  # noqa: E501
        # verify the required parameter 'add_resource_member_request_body' is set
        if ('add_resource_member_request_body' not in local_var_params or
                local_var_params['add_resource_member_request_body'] is None):
            raise ValueError("Missing the required parameter `add_resource_member_request_body` when calling `post_buckets_id_members`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bucket_id' in local_var_params:
            path_params['bucketID'] = local_var_params['bucket_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'add_resource_member_request_body' in local_var_params:
            body_params = local_var_params['add_resource_member_request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/buckets/{bucketID}/members', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceMember',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def post_buckets_id_owners(self, bucket_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add an owner to a bucket.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_buckets_id_owners(bucket_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The bucket ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as owner (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwner
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_buckets_id_owners_with_http_info(bucket_id, add_resource_member_request_body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_buckets_id_owners_with_http_info(bucket_id, add_resource_member_request_body, **kwargs)  # noqa: E501
            return data

    def post_buckets_id_owners_with_http_info(self, bucket_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add an owner to a bucket.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_buckets_id_owners_with_http_info(bucket_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The bucket ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as owner (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwner
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['bucket_id', 'add_resource_member_request_body', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_buckets_id_owners" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in local_var_params or
                local_var_params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `post_buckets_id_owners`")  # noqa: E501
        # verify the required parameter 'add_resource_member_request_body' is set
        if ('add_resource_member_request_body' not in local_var_params or
                local_var_params['add_resource_member_request_body'] is None):
            raise ValueError("Missing the required parameter `add_resource_member_request_body` when calling `post_buckets_id_owners`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bucket_id' in local_var_params:
            path_params['bucketID'] = local_var_params['bucket_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'add_resource_member_request_body' in local_var_params:
            body_params = local_var_params['add_resource_member_request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/buckets/{bucketID}/owners', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceOwner',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)
