"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaFunctionAction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * The action to invoke an AWS Lambda function, passing in an MQTT message.
 */
class LambdaFunctionAction {
    /**
     * @param func The lambda function to be invoked by this action
     */
    constructor(func) {
        this.func = func;
    }
    /**
     * @internal
     */
    _bind(topicRule) {
        this.func.addPermission(`${aws_cdk_lib_1.Names.nodeUniqueId(topicRule.node)}:IotLambdaFunctionAction`, {
            action: 'lambda:InvokeFunction',
            principal: new iam.ServicePrincipal('iot.amazonaws.com'),
            sourceAccount: topicRule.env.account,
            sourceArn: topicRule.topicRuleArn,
        });
        return {
            configuration: {
                lambda: {
                    functionArn: this.func.functionArn,
                },
            },
        };
    }
}
exports.LambdaFunctionAction = LambdaFunctionAction;
_a = JSII_RTTI_SYMBOL_1;
LambdaFunctionAction[_a] = { fqn: "@aws-cdk/aws-iot-actions-alpha.LambdaFunctionAction", version: "2.44.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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