#!/usr/bin/env python3

# Note: To use the 'upload' functionality of this file, you must:
#   $ pip install twine

import os
from pathlib import Path
import re
import sys
from shutil import rmtree

from setuptools import setup, Command

# Package meta-data.
NAME = 'eac_logchecker'
DESCRIPTION = 'Logchecker for logs generated by EAC'
URL = 'https://github.com/OPSnet/eac_logchecker.py'
EMAIL = 'noreply@mail.orpheus.network'
AUTHOR = 'OPS'
REQUIRES_PYTHON = '>=3.5.0'

setup_dir = Path(__file__).resolve().parent
version = re.search(
    r"__version__ = '(.*)'",
    Path(setup_dir, 'eac_logchecker.py').read_text()
)
if version is None:
    raise SystemExit("Could not determine version to use")
VERSION = version.group(1)


class UploadCommand(Command):
    """Support setup.py upload."""

    description = 'Build and publish the package.'
    user_options = []

    @staticmethod
    def status(s):
        """Prints things in bold."""
        print('\033[1m{0}\033[0m'.format(s))

    def initialize_options(self):
        pass

    def finalize_options(self):
        pass

    def run(self):
        try:
            self.status('Removing previous builds…')
            rmtree(Path(setup_dir, 'dist'))
        except OSError:
            pass

        self.status('Building Source and Wheel (universal) distribution…')
        os.system(
            '{0} setup.py sdist bdist_wheel --universal'.format(sys.executable)
        )

        self.status('Uploading the package to PyPI via Twine…')
        os.system('twine upload dist/*')

        sys.exit()


setup(
    name=NAME,
    version=VERSION,
    description=DESCRIPTION,
    long_description=Path(setup_dir, 'README.md').read_text(),
    long_description_content_type='text/markdown',
    author=AUTHOR,
    author_email=EMAIL,
    python_requires=REQUIRES_PYTHON,
    url=URL,
    py_modules=['eac_logchecker'],
    entry_points={
        'console_scripts': [
             'eac_logchecker = eac_logchecker:main'
        ]
    },
    install_requires=['pprp==0.2.6'],
    tests_require=['pytest'],
    license='MIT',
    classifiers=[
        'Development Status :: 5 - Production/Stable',
        'License :: OSI Approved :: MIT License',
        'Programming Language :: Python',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.5',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
    ],
    # $ setup.py publish support.
    cmdclass={
        'upload': UploadCommand,
    },
)
