from typing import Any, Dict, List, Type, TypeVar

import attr

from ..models.users_usage import UsersUsage

T = TypeVar("T", bound="Usage")


@attr.s(auto_attribs=True)
class Usage:
    """
    Attributes:
        users (UsersUsage):
    """

    users: UsersUsage
    additional_properties: Dict[str, Any] = attr.ib(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        users = self.users.to_dict()

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "users": users,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        users = UsersUsage.from_dict(d.pop("users"))

        usage = cls(
            users=users,
        )

        usage.additional_properties = d
        return usage

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
