""" Contains all the data models used in inputs/outputs """

from .activity import Activity
from .activity_object import ActivityObject
from .activity_payload import ActivityPayload
from .activity_related_object import ActivityRelatedObject
from .activity_request import ActivityRequest
from .activity_request_payload import ActivityRequestPayload
from .activity_target import ActivityTarget
from .admin_get_accounts_type import AdminGetAccountsType
from .admin_get_artists_content_category import AdminGetArtistsContentCategory
from .admin_get_libraries_ordering_item import AdminGetLibrariesOrderingItem
from .admin_get_libraries_privacy_level import AdminGetLibrariesPrivacyLevel
from .admin_get_uploads_import_status import AdminGetUploadsImportStatus
from .admin_get_uploads_ordering_item import AdminGetUploadsOrderingItem
from .admin_get_users_privacy_level import AdminGetUsersPrivacyLevel
from .album import Album
from .album_create import AlbumCreate
from .album_create_request import AlbumCreateRequest
from .album_request import AlbumRequest
from .all_favorite import AllFavorite
from .all_subscriptions import AllSubscriptions
from .allow_list_stat import AllowListStat
from .api_actor import APIActor
from .api_actor_request import APIActorRequest
from .api_mutation import APIMutation
from .api_mutation_payload import APIMutationPayload
from .api_mutation_previous_state import APIMutationPreviousState
from .api_mutation_target import APIMutationTarget
from .application import Application
from .application_request import ApplicationRequest
from .artist_album import ArtistAlbum
from .artist_album_request import ArtistAlbumRequest
from .artist_with_albums import ArtistWithAlbums
from .artist_with_albums_inline_channel import ArtistWithAlbumsInlineChannel
from .artist_with_albums_inline_channel_request import ArtistWithAlbumsInlineChannelRequest
from .artist_with_albums_request import ArtistWithAlbumsRequest
from .attachment import Attachment
from .attachment_request import AttachmentRequest
from .attachment_urls import AttachmentUrls
from .channel import Channel
from .channel_create import ChannelCreate
from .channel_create_metadata import ChannelCreateMetadata
from .channel_create_request import ChannelCreateRequest
from .channel_create_request_metadata import ChannelCreateRequestMetadata
from .channel_metadata import ChannelMetadata
from .channel_update import ChannelUpdate
from .channel_update_metadata import ChannelUpdateMetadata
from .channel_update_request import ChannelUpdateRequest
from .channel_update_request_metadata import ChannelUpdateRequestMetadata
from .content import Content
from .content_category_enum import ContentCategoryEnum
from .content_request import ContentRequest
from .content_type_enum import ContentTypeEnum
from .cover_field import CoverField
from .cover_field_request import CoverFieldRequest
from .cover_field_urls import CoverFieldUrls
from .create_application import CreateApplication
from .create_application_request import CreateApplicationRequest
from .domain import Domain
from .endpoints import Endpoints
from .federation_choice_enum import FederationChoiceEnum
from .fetch import Fetch
from .fetch_detail import FetchDetail
from .fetch_request import FetchRequest
from .fetch_status_enum import FetchStatusEnum
from .filter_ import Filter
from .full_actor import FullActor
from .get_album_fetches_ordering_item import GetAlbumFetchesOrderingItem
from .get_album_libraries_ordering_item import GetAlbumLibrariesOrderingItem
from .get_album_mutations_ordering_item import GetAlbumMutationsOrderingItem
from .get_albums_ordering_item import GetAlbumsOrderingItem
from .get_artist_fetches_ordering_item import GetArtistFetchesOrderingItem
from .get_artist_libraries_ordering_item import GetArtistLibrariesOrderingItem
from .get_artist_mutations_ordering_item import GetArtistMutationsOrderingItem
from .get_artists_ordering_item import GetArtistsOrderingItem
from .get_channels_ordering_item import GetChannelsOrderingItem
from .get_libraries_privacy_level import GetLibrariesPrivacyLevel
from .get_library_follows_privacy_level import GetLibraryFollowsPrivacyLevel
from .get_tags_ordering_item import GetTagsOrderingItem
from .get_track_fetches_ordering_item import GetTrackFetchesOrderingItem
from .get_track_libraries_ordering_item import GetTrackLibrariesOrderingItem
from .get_track_mutations_ordering_item import GetTrackMutationsOrderingItem
from .get_tracks_ordering_item import GetTracksOrderingItem
from .get_uploads_import_status_item import GetUploadsImportStatusItem
from .global_preference import GlobalPreference
from .global_preference_request import GlobalPreferenceRequest
from .ident import Ident
from .import_status_enum import ImportStatusEnum
from .inbox_item import InboxItem
from .inbox_item_request import InboxItemRequest
from .inbox_item_type_enum import InboxItemTypeEnum
from .inline_actor import InlineActor
from .inline_actor_request import InlineActorRequest
from .inline_subscription import InlineSubscription
from .library import Library
from .library_follow import LibraryFollow
from .library_follow_request import LibraryFollowRequest
from .library_for_owner import LibraryForOwner
from .library_for_owner_request import LibraryForOwnerRequest
from .library_privacy_level_enum import LibraryPrivacyLevelEnum
from .library_request import LibraryRequest
from .library_scan import LibraryScan
from .library_scan_request import LibraryScanRequest
from .license_ import License
from .listening import Listening
from .listening_write import ListeningWrite
from .listening_write_request import ListeningWriteRequest
from .manage_actor import ManageActor
from .manage_actor_request import ManageActorRequest
from .manage_album import ManageAlbum
from .manage_album_request import ManageAlbumRequest
from .manage_artist import ManageArtist
from .manage_artist_request import ManageArtistRequest
from .manage_base_actor import ManageBaseActor
from .manage_base_actor_request import ManageBaseActorRequest
from .manage_base_note import ManageBaseNote
from .manage_base_note_request import ManageBaseNoteRequest
from .manage_channel import ManageChannel
from .manage_channel_metadata import ManageChannelMetadata
from .manage_domain import ManageDomain
from .manage_domain_nodeinfo import ManageDomainNodeinfo
from .manage_domain_request import ManageDomainRequest
from .manage_domain_update import ManageDomainUpdate
from .manage_domain_update_nodeinfo import ManageDomainUpdateNodeinfo
from .manage_domain_update_request import ManageDomainUpdateRequest
from .manage_instance_policy import ManageInstancePolicy
from .manage_instance_policy_request import ManageInstancePolicyRequest
from .manage_invitation import ManageInvitation
from .manage_invitation_request import ManageInvitationRequest
from .manage_library import ManageLibrary
from .manage_library_request import ManageLibraryRequest
from .manage_nested_artist import ManageNestedArtist
from .manage_nested_artist_request import ManageNestedArtistRequest
from .manage_nested_library import ManageNestedLibrary
from .manage_nested_library_request import ManageNestedLibraryRequest
from .manage_nested_track import ManageNestedTrack
from .manage_nested_track_request import ManageNestedTrackRequest
from .manage_note import ManageNote
from .manage_note_request import ManageNoteRequest
from .manage_note_request_target import ManageNoteRequestTarget
from .manage_note_target import ManageNoteTarget
from .manage_report import ManageReport
from .manage_report_request import ManageReportRequest
from .manage_report_request_target import ManageReportRequestTarget
from .manage_report_target import ManageReportTarget
from .manage_report_target_state import ManageReportTargetState
from .manage_tag import ManageTag
from .manage_tag_request import ManageTagRequest
from .manage_target import ManageTarget
from .manage_target_request import ManageTargetRequest
from .manage_target_type_enum import ManageTargetTypeEnum
from .manage_track import ManageTrack
from .manage_track_album import ManageTrackAlbum
from .manage_track_album_request import ManageTrackAlbumRequest
from .manage_track_request import ManageTrackRequest
from .manage_upload import ManageUpload
from .manage_upload_import_details import ManageUploadImportDetails
from .manage_upload_import_metadata import ManageUploadImportMetadata
from .manage_upload_metadata import ManageUploadMetadata
from .manage_upload_request import ManageUploadRequest
from .manage_upload_request_import_details import ManageUploadRequestImportDetails
from .manage_upload_request_import_metadata import ManageUploadRequestImportMetadata
from .manage_upload_request_metadata import ManageUploadRequestMetadata
from .manage_user import ManageUser
from .manage_user_actor import ManageUserActor
from .manage_user_request import ManageUserRequest
from .manage_user_request_request import ManageUserRequestRequest
from .manage_user_request_status_enum import ManageUserRequestStatusEnum
from .manage_user_request_type_enum import ManageUserRequestTypeEnum
from .manage_user_simple import ManageUserSimple
from .manage_user_simple_request import ManageUserSimpleRequest
from .metadata import Metadata
from .metadata_usage import MetadataUsage
from .metadata_usage_favorite import MetadataUsageFavorite
from .moderation_get_reports_type import ModerationGetReportsType
from .moderation_get_requests_status import ModerationGetRequestsStatus
from .moderation_get_requests_type import ModerationGetRequestsType
from .moderation_target import ModerationTarget
from .moderation_target_request import ModerationTargetRequest
from .moderation_target_type_enum import ModerationTargetTypeEnum
from .nested_library_follow import NestedLibraryFollow
from .nested_library_follow_request import NestedLibraryFollowRequest
from .node_info_20 import NodeInfo20
from .paginated_album_list import PaginatedAlbumList
from .paginated_api_mutation_list import PaginatedAPIMutationList
from .paginated_application_list import PaginatedApplicationList
from .paginated_artist_with_albums_list import PaginatedArtistWithAlbumsList
from .paginated_channel_list import PaginatedChannelList
from .paginated_domain_list import PaginatedDomainList
from .paginated_fetch_list import PaginatedFetchList
from .paginated_inbox_item_list import PaginatedInboxItemList
from .paginated_library_follow_list import PaginatedLibraryFollowList
from .paginated_library_for_owner_list import PaginatedLibraryForOwnerList
from .paginated_library_list import PaginatedLibraryList
from .paginated_license_list import PaginatedLicenseList
from .paginated_listening_list import PaginatedListeningList
from .paginated_manage_actor_list import PaginatedManageActorList
from .paginated_manage_album_list import PaginatedManageAlbumList
from .paginated_manage_artist_list import PaginatedManageArtistList
from .paginated_manage_channel_list import PaginatedManageChannelList
from .paginated_manage_domain_list import PaginatedManageDomainList
from .paginated_manage_instance_policy_list import PaginatedManageInstancePolicyList
from .paginated_manage_invitation_list import PaginatedManageInvitationList
from .paginated_manage_library_list import PaginatedManageLibraryList
from .paginated_manage_note_list import PaginatedManageNoteList
from .paginated_manage_report_list import PaginatedManageReportList
from .paginated_manage_tag_list import PaginatedManageTagList
from .paginated_manage_track_list import PaginatedManageTrackList
from .paginated_manage_upload_list import PaginatedManageUploadList
from .paginated_manage_user_list import PaginatedManageUserList
from .paginated_manage_user_request_list import PaginatedManageUserRequestList
from .paginated_playlist_list import PaginatedPlaylistList
from .paginated_playlist_track_list import PaginatedPlaylistTrackList
from .paginated_radio_list import PaginatedRadioList
from .paginated_subscription_list import PaginatedSubscriptionList
from .paginated_tag_list import PaginatedTagList
from .paginated_track_list import PaginatedTrackList
from .paginated_upload_for_owner_list import PaginatedUploadForOwnerList
from .paginated_user_filter_list import PaginatedUserFilterList
from .paginated_user_track_favorite_list import PaginatedUserTrackFavoriteList
from .password_change import PasswordChange
from .password_change_request import PasswordChangeRequest
from .password_reset import PasswordReset
from .password_reset_confirm import PasswordResetConfirm
from .password_reset_confirm_request import PasswordResetConfirmRequest
from .password_reset_request import PasswordResetRequest
from .patched_application_request import PatchedApplicationRequest
from .patched_channel_update_request import PatchedChannelUpdateRequest
from .patched_channel_update_request_metadata import PatchedChannelUpdateRequestMetadata
from .patched_global_preference_request import PatchedGlobalPreferenceRequest
from .patched_inbox_item_request import PatchedInboxItemRequest
from .patched_library_for_owner_request import PatchedLibraryForOwnerRequest
from .patched_manage_domain_update_request import PatchedManageDomainUpdateRequest
from .patched_manage_instance_policy_request import PatchedManageInstancePolicyRequest
from .patched_manage_invitation_request import PatchedManageInvitationRequest
from .patched_manage_library_request import PatchedManageLibraryRequest
from .patched_manage_report_request import PatchedManageReportRequest
from .patched_manage_report_request_target import PatchedManageReportRequestTarget
from .patched_manage_user_request import PatchedManageUserRequest
from .patched_manage_user_request_request import PatchedManageUserRequestRequest
from .patched_playlist_request import PatchedPlaylistRequest
from .patched_radio_request import PatchedRadioRequest
from .patched_radio_request_config import PatchedRadioRequestConfig
from .patched_upload_for_owner_request import PatchedUploadForOwnerRequest
from .patched_upload_for_owner_request_import_metadata import PatchedUploadForOwnerRequestImportMetadata
from .patched_user_details_request import PatchedUserDetailsRequest
from .patched_user_write_request import PatchedUserWriteRequest
from .playlist import Playlist
from .playlist_add_many_request import PlaylistAddManyRequest
from .playlist_request import PlaylistRequest
from .playlist_track import PlaylistTrack
from .privacy_level_enum import PrivacyLevelEnum
from .radio import Radio
from .radio_config import RadioConfig
from .radio_request import RadioRequest
from .radio_request_config import RadioRequestConfig
from .radio_session import RadioSession
from .radio_session_config import RadioSessionConfig
from .radio_session_request import RadioSessionRequest
from .radio_session_request_config import RadioSessionRequestConfig
from .radio_session_track_serializer_create import RadioSessionTrackSerializerCreate
from .radio_session_track_serializer_create_request import RadioSessionTrackSerializerCreateRequest
from .rate_limit import RateLimit
from .register import Register
from .register_request import RegisterRequest
from .report import Report
from .report_request import ReportRequest
from .report_request_target import ReportRequestTarget
from .report_target import ReportTarget
from .report_type import ReportType
from .report_type_enum import ReportTypeEnum
from .scopes import Scopes
from .services import Services
from .simple_artist import SimpleArtist
from .simple_artist_request import SimpleArtistRequest
from .simple_favorite import SimpleFavorite
from .software import Software
from .subscription import Subscription
from .tag import Tag
from .total_count import TotalCount
from .track import Track
from .track_album import TrackAlbum
from .track_album_request import TrackAlbumRequest
from .track_metadata import TrackMetadata
from .track_request import TrackRequest
from .track_uploads_item import TrackUploadsItem
from .upload_for_owner import UploadForOwner
from .upload_for_owner_import_details import UploadForOwnerImportDetails
from .upload_for_owner_import_metadata import UploadForOwnerImportMetadata
from .upload_for_owner_metadata import UploadForOwnerMetadata
from .upload_for_owner_request import UploadForOwnerRequest
from .upload_for_owner_request_import_metadata import UploadForOwnerRequestImportMetadata
from .usage import Usage
from .user_basic import UserBasic
from .user_basic_request import UserBasicRequest
from .user_details import UserDetails
from .user_details_request import UserDetailsRequest
from .user_filter import UserFilter
from .user_filter_request import UserFilterRequest
from .user_track_favorite import UserTrackFavorite
from .user_track_favorite_write import UserTrackFavoriteWrite
from .user_track_favorite_write_request import UserTrackFavoriteWriteRequest
from .user_write import UserWrite
from .user_write_request import UserWriteRequest
from .users_usage import UsersUsage
from .verify_email import VerifyEmail
from .verify_email_request import VerifyEmailRequest
