/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole.command;

import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.creole.command.Command;
import net.sourceforge.plantuml.creole.command.CommandCreoleCache;
import net.sourceforge.plantuml.creole.legacy.StripeSimple;
import net.sourceforge.plantuml.graphic.FontStyle;

public class CommandCreoleStyle2
extends CommandCreoleCache
implements Command {
    public static Command createCreole(FontStyle style) {
        return new CommandCreoleStyle2("^(" + style.getCreoleSyntax() + "(.+?)" + style.getCreoleSyntax() + ")", style);
    }

    public static Command createLegacy(FontStyle style) {
        return new CommandCreoleStyle2("^((" + style.getActivationPattern() + ")(.+?)" + style.getDeactivationPattern() + ")", style);
    }

    public static Command createLegacyEol(FontStyle style) {
        return new CommandCreoleStyle2("^((" + style.getActivationPattern() + ")(.+))$", style);
    }

    private CommandCreoleStyle2(String p, FontStyle style) {
        super(p);
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) {
        Matcher2 m = this.mypattern.matcher(line);
        if (!m.find()) {
            throw new IllegalStateException();
        }
        int groupCount = m.groupCount();
        String part1 = m.group(groupCount);
        String part2 = line.substring(m.group(1).length());
        return '\ueef2' + part1 + '\ueef1' + part2;
    }

    @Override
    public int matchingSize(String line) {
        Matcher2 m = this.mypattern.matcher(line);
        if (!m.find()) {
            return 0;
        }
        return m.group(1).length();
    }
}

