#!/usr/bin/env python3
# coding = utf8
"""
@ Author : ZeroSeeker
@ e-mail : zeroseeker@foxmail.com
@ GitHub : https://github.com/ZeroSeeker
@ Gitee : https://gitee.com/ZeroSeeker
"""
from urllib import parse


def dict_list_ranker_x(dict_list, rank_by_list):
    """
    对dict组成的list按照某个元素重新排序
    可对多个元素排序,目前支持2个
    rank_by_list：[['a','asc']]
    :return:
    """
    ranker_res_list = list()
    for each_dict in dict_list:
        each_rank_by_value_1 = each_dict.get(rank_by_list[0][0])
        each_rank_by_value_2 = each_dict.get(rank_by_list[1][0])
        if len(ranker_res_list) == 0:
            ranker_res_list.append(each_dict)
        else:
            pos_num = 0
            for each_ranker_res in ranker_res_list:
                each_ranker_res_rank_by_value_1 = each_ranker_res.get(rank_by_list[0][0])
                each_ranker_res_rank_by_value_2 = each_ranker_res.get(rank_by_list[1][0])
                if rank_by_list[0][1].lower() == 'asc' and rank_by_list[1][1].lower() == 'desc':
                    if each_rank_by_value_1 > each_ranker_res_rank_by_value_1:
                        pos_num += 1
                    elif each_rank_by_value_1 == each_ranker_res_rank_by_value_1:
                        if each_rank_by_value_2 < each_ranker_res_rank_by_value_2:
                            pos_num += 1
                        else:
                            pass
                    elif each_rank_by_value_1 < each_ranker_res_rank_by_value_1:
                        pass
            ranker_res_list.insert(pos_num, each_dict)
    return ranker_res_list


def dict_list_ranker(dict_list, rank_by_list):
    """
    对dict组成的list按照某个元素重新排序
    可对多个元素排序,目前支持1个
    rank_by_list：[['a','asc']]
    :return:
    """
    ranker_res_list = list()
    for each_dict in dict_list:
        each_rank_by_value_1 = each_dict.get(rank_by_list[0][0])
        if len(ranker_res_list) == 0:  # 如果结果列表为空，放入初始值
            ranker_res_list.append(each_dict)
        else:
            pos_num = 0
            for each_ranker_res in ranker_res_list:
                each_ranker_res_rank_by_value_1 = each_ranker_res.get(rank_by_list[0][0])
                if each_rank_by_value_1 > each_ranker_res_rank_by_value_1:
                    pos_num += 1
                else:
                    pass
            ranker_res_list.insert(pos_num, each_dict)
    if rank_by_list[0][1].lower() == 'asc':
        return ranker_res_list
    else:
        ranker_res_list.reverse()
        return ranker_res_list


def dict_list_group(list_in, by):
    """
    将dict组成的list按照某个key的值分组，分组后组成新的dict嵌套list
    :param list_in:
    :param by:
    :return:
    """
    by_list = list()
    for each_dict in list_in:
        by_value = each_dict.get(by)
        by_list.append(by_value)
    by_set = set(by_list)
    group_dict = dict()
    for each_by in by_set:
        group_dict[each_by] = list()
    for each_dict in list_in:
        by_value = each_dict.get(by)
        group_dict[by_value].extend([each_dict])
    return group_dict


def dict_key_f(in_dict):
    """
    将以驼峰方式命名的dict转换为下划线方式
    """
    out_dict = dict()
    for key, value in in_dict.items():
        # key_split = list(key)
        # print(key, key_split)
        key_split_new = list()
        for index, temp_key in enumerate(key):
            if temp_key.isupper() is True:
                if index == 0:
                    key_split_new.append(temp_key.lower())
                else:
                    key_split_new.append('_')
                    key_split_new.append(temp_key.lower())
            else:
                key_split_new.append(temp_key)
        key_new = ''.join(key_split_new)
        # print(key_new, key_split_new)
        out_dict[key_new] = value
    return out_dict


def list_dict_key_f(in_list):
    """
    将以驼峰方式命名的list嵌套dict转换为下划线方式
    """
    out_list = list()
    for each_dict in in_list:
        out_dict = dict_key_f(each_dict)
        out_list.append(out_dict)
    return out_list


def dict_value_parse(dict_in):
    # 对字典的值进行解码
    dict_out = dict()
    for key, value in dict_in.items():
        if isinstance(value, str):
            dict_out[key] = parse.unquote(value)
        else:
            dict_out[key] = value
    return dict_out


def list_dict_value_parse(list_in):
    # 在dict上面封装一层list，解码
    list_out = list()
    for each_list_in in list_in:
        dict_out = dict_value_parse(dict_in=each_list_in)
        list_out.append(dict_out)
    return list_out


def dict_tiler(dict_in, connector_str='-'):
    """
    字典展开器
    只展开一层
    将嵌套了一层的dict铺展开，键值之间用"-"连接
    针对纯dict形式
    :param dict_in: 输入一个待处理的dict
    :param connector_str: 输入连接符
    :return: 输出处理好的dict
    """
    dict_f = dict()
    if dict_in is None:
        return
    elif len(dict_in) == 0:
        return
    else:
        for key in dict_in:
            value = dict_in.get(key)
            if isinstance(value, dict):  # 如果某个key的值是dict，则展开这组
                for each_value_key in value:
                    dict_f['%s%s%s' % (key, connector_str, each_value_key)] = value.get(each_value_key)
            else:
                dict_f[key] = value
        return dict_f


def list_dict_tiler(list_in, connector_str='-'):
    list_out = list()
    for each in list_in:
        dict_f = dict_tiler(dict_in=each, connector_str=connector_str)
        list_out.append(dict_f)
    return list_out
