# This Python file uses the following encoding: utf-8
"""autogenerated by genpy from spencer_tracking_msgs/TrackedGroup.msg. Do not edit."""
import sys
python3 = True if sys.hexversion > 0x03000000 else False
import genpy
import struct

import geometry_msgs.msg
import genpy

class TrackedGroup(genpy.Message):
  _md5sum = "6a5318bfb8e49948a4dc15c1267f7e54"
  _type = "spencer_tracking_msgs/TrackedGroup"
  _has_header = False #flag to mark the presence of a Header object
  _full_text = """# Message defining a tracked group
#

uint64      group_id        # unique identifier of the target, consistent over time

duration    age             # age of the group

geometry_msgs/PoseWithCovariance    centerOfGravity   # mean and covariance of the group (calculated from its person tracks)

uint64[]    track_ids       # IDs of the tracked persons in this group. See srl_tracking_msgs/TrackedPersons
================================================================================
MSG: geometry_msgs/PoseWithCovariance
# This represents a pose in free space with uncertainty.

Pose pose

# Row-major representation of the 6x6 covariance matrix
# The orientation parameters use a fixed-axis representation.
# In order, the parameters are:
# (x, y, z, rotation about X axis, rotation about Y axis, rotation about Z axis)
float64[36] covariance

================================================================================
MSG: geometry_msgs/Pose
# A representation of pose in free space, composed of position and orientation. 
Point position
Quaternion orientation

================================================================================
MSG: geometry_msgs/Point
# This contains the position of a point in free space
float64 x
float64 y
float64 z

================================================================================
MSG: geometry_msgs/Quaternion
# This represents an orientation in free space in quaternion form.

float64 x
float64 y
float64 z
float64 w
"""
  __slots__ = ['group_id','age','centerOfGravity','track_ids']
  _slot_types = ['uint64','duration','geometry_msgs/PoseWithCovariance','uint64[]']

  def __init__(self, *args, **kwds):
    """
    Constructor. Any message fields that are implicitly/explicitly
    set to None will be assigned a default value. The recommend
    use is keyword arguments as this is more robust to future message
    changes.  You cannot mix in-order arguments and keyword arguments.

    The available fields are:
       group_id,age,centerOfGravity,track_ids

    :param args: complete set of field values, in .msg order
    :param kwds: use keyword arguments corresponding to message field names
    to set specific fields.
    """
    if args or kwds:
      super(TrackedGroup, self).__init__(*args, **kwds)
      #message fields cannot be None, assign default values for those that are
      if self.group_id is None:
        self.group_id = 0
      if self.age is None:
        self.age = genpy.Duration()
      if self.centerOfGravity is None:
        self.centerOfGravity = geometry_msgs.msg.PoseWithCovariance()
      if self.track_ids is None:
        self.track_ids = []
    else:
      self.group_id = 0
      self.age = genpy.Duration()
      self.centerOfGravity = geometry_msgs.msg.PoseWithCovariance()
      self.track_ids = []

  def _get_types(self):
    """
    internal API method
    """
    return self._slot_types

  def serialize(self, buff):
    """
    serialize message into buffer
    :param buff: buffer, ``StringIO``
    """
    try:
      _x = self
      buff.write(_get_struct_Q2i7d().pack(_x.group_id, _x.age.secs, _x.age.nsecs, _x.centerOfGravity.pose.position.x, _x.centerOfGravity.pose.position.y, _x.centerOfGravity.pose.position.z, _x.centerOfGravity.pose.orientation.x, _x.centerOfGravity.pose.orientation.y, _x.centerOfGravity.pose.orientation.z, _x.centerOfGravity.pose.orientation.w))
      buff.write(_get_struct_36d().pack(*self.centerOfGravity.covariance))
      length = len(self.track_ids)
      buff.write(_struct_I.pack(length))
      pattern = '<%sQ'%length
      buff.write(struct.pack(pattern, *self.track_ids))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize(self, str):
    """
    unpack serialized message in str into this message instance
    :param str: byte array of serialized message, ``str``
    """
    try:
      if self.age is None:
        self.age = genpy.Duration()
      if self.centerOfGravity is None:
        self.centerOfGravity = geometry_msgs.msg.PoseWithCovariance()
      end = 0
      _x = self
      start = end
      end += 72
      (_x.group_id, _x.age.secs, _x.age.nsecs, _x.centerOfGravity.pose.position.x, _x.centerOfGravity.pose.position.y, _x.centerOfGravity.pose.position.z, _x.centerOfGravity.pose.orientation.x, _x.centerOfGravity.pose.orientation.y, _x.centerOfGravity.pose.orientation.z, _x.centerOfGravity.pose.orientation.w,) = _get_struct_Q2i7d().unpack(str[start:end])
      start = end
      end += 288
      self.centerOfGravity.covariance = _get_struct_36d().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      pattern = '<%sQ'%length
      start = end
      end += struct.calcsize(pattern)
      self.track_ids = struct.unpack(pattern, str[start:end])
      self.age.canon()
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e) #most likely buffer underfill


  def serialize_numpy(self, buff, numpy):
    """
    serialize message with numpy array types into buffer
    :param buff: buffer, ``StringIO``
    :param numpy: numpy python module
    """
    try:
      _x = self
      buff.write(_get_struct_Q2i7d().pack(_x.group_id, _x.age.secs, _x.age.nsecs, _x.centerOfGravity.pose.position.x, _x.centerOfGravity.pose.position.y, _x.centerOfGravity.pose.position.z, _x.centerOfGravity.pose.orientation.x, _x.centerOfGravity.pose.orientation.y, _x.centerOfGravity.pose.orientation.z, _x.centerOfGravity.pose.orientation.w))
      buff.write(self.centerOfGravity.covariance.tostring())
      length = len(self.track_ids)
      buff.write(_struct_I.pack(length))
      pattern = '<%sQ'%length
      buff.write(self.track_ids.tostring())
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize_numpy(self, str, numpy):
    """
    unpack serialized message in str into this message instance using numpy for array types
    :param str: byte array of serialized message, ``str``
    :param numpy: numpy python module
    """
    try:
      if self.age is None:
        self.age = genpy.Duration()
      if self.centerOfGravity is None:
        self.centerOfGravity = geometry_msgs.msg.PoseWithCovariance()
      end = 0
      _x = self
      start = end
      end += 72
      (_x.group_id, _x.age.secs, _x.age.nsecs, _x.centerOfGravity.pose.position.x, _x.centerOfGravity.pose.position.y, _x.centerOfGravity.pose.position.z, _x.centerOfGravity.pose.orientation.x, _x.centerOfGravity.pose.orientation.y, _x.centerOfGravity.pose.orientation.z, _x.centerOfGravity.pose.orientation.w,) = _get_struct_Q2i7d().unpack(str[start:end])
      start = end
      end += 288
      self.centerOfGravity.covariance = numpy.frombuffer(str[start:end], dtype=numpy.float64, count=36)
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      pattern = '<%sQ'%length
      start = end
      end += struct.calcsize(pattern)
      self.track_ids = numpy.frombuffer(str[start:end], dtype=numpy.uint64, count=length)
      self.age.canon()
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e) #most likely buffer underfill

_struct_I = genpy.struct_I
def _get_struct_I():
    global _struct_I
    return _struct_I
_struct_Q2i7d = None
def _get_struct_Q2i7d():
    global _struct_Q2i7d
    if _struct_Q2i7d is None:
        _struct_Q2i7d = struct.Struct("<Q2i7d")
    return _struct_Q2i7d
_struct_36d = None
def _get_struct_36d():
    global _struct_36d
    if _struct_36d is None:
        _struct_36d = struct.Struct("<36d")
    return _struct_36d
