# This Python file uses the following encoding: utf-8
"""autogenerated by genpy from spencer_tracking_msgs/ImmDebugInfos.msg. Do not edit."""
import sys
python3 = True if sys.hexversion > 0x03000000 else False
import genpy
import struct

import spencer_tracking_msgs.msg
import std_msgs.msg

class ImmDebugInfos(genpy.Message):
  _md5sum = "ce7fa675b582455db7386ac3eaa36b5b"
  _type = "spencer_tracking_msgs/ImmDebugInfos"
  _has_header = True #flag to mark the presence of a Header object
  _full_text = """# Message with all debug infos per frame
#

Header              header      # Header containing timestamp etc. of this message
ImmDebugInfo[]      infos      # All persons that are currently being tracked
================================================================================
MSG: std_msgs/Header
# Standard metadata for higher-level stamped data types.
# This is generally used to communicate timestamped data 
# in a particular coordinate frame.
# 
# sequence ID: consecutively increasing ID 
uint32 seq
#Two-integer timestamp that is expressed as:
# * stamp.sec: seconds (stamp_secs) since epoch (in Python the variable is called 'secs')
# * stamp.nsec: nanoseconds since stamp_secs (in Python the variable is called 'nsecs')
# time-handling sugar is provided by the client library
time stamp
#Frame this data is associated with
string frame_id

================================================================================
MSG: spencer_tracking_msgs/ImmDebugInfo
# Message for passing debug information of filter performance
#

uint64      track_id        # unique identifier of the target, consistent over time
float64      innovation      # innovation of prediction and associated observation
float64      CpXX            # variance of prediction acc. to x
float64      CpYY            # variance of prediction acc. to y
float64      CXX             # variance of state acc. to x
float64      CYY             # variance of state acc. to y
float64[]    modeProbabilities# array containing mode probabilities"""
  __slots__ = ['header','infos']
  _slot_types = ['std_msgs/Header','spencer_tracking_msgs/ImmDebugInfo[]']

  def __init__(self, *args, **kwds):
    """
    Constructor. Any message fields that are implicitly/explicitly
    set to None will be assigned a default value. The recommend
    use is keyword arguments as this is more robust to future message
    changes.  You cannot mix in-order arguments and keyword arguments.

    The available fields are:
       header,infos

    :param args: complete set of field values, in .msg order
    :param kwds: use keyword arguments corresponding to message field names
    to set specific fields.
    """
    if args or kwds:
      super(ImmDebugInfos, self).__init__(*args, **kwds)
      #message fields cannot be None, assign default values for those that are
      if self.header is None:
        self.header = std_msgs.msg.Header()
      if self.infos is None:
        self.infos = []
    else:
      self.header = std_msgs.msg.Header()
      self.infos = []

  def _get_types(self):
    """
    internal API method
    """
    return self._slot_types

  def serialize(self, buff):
    """
    serialize message into buffer
    :param buff: buffer, ``StringIO``
    """
    try:
      _x = self
      buff.write(_get_struct_3I().pack(_x.header.seq, _x.header.stamp.secs, _x.header.stamp.nsecs))
      _x = self.header.frame_id
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.pack('<I%ss'%length, length, _x))
      length = len(self.infos)
      buff.write(_struct_I.pack(length))
      for val1 in self.infos:
        _x = val1
        buff.write(_get_struct_Q5d().pack(_x.track_id, _x.innovation, _x.CpXX, _x.CpYY, _x.CXX, _x.CYY))
        length = len(val1.modeProbabilities)
        buff.write(_struct_I.pack(length))
        pattern = '<%sd'%length
        buff.write(struct.pack(pattern, *val1.modeProbabilities))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize(self, str):
    """
    unpack serialized message in str into this message instance
    :param str: byte array of serialized message, ``str``
    """
    try:
      if self.header is None:
        self.header = std_msgs.msg.Header()
      if self.infos is None:
        self.infos = None
      end = 0
      _x = self
      start = end
      end += 12
      (_x.header.seq, _x.header.stamp.secs, _x.header.stamp.nsecs,) = _get_struct_3I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.header.frame_id = str[start:end].decode('utf-8')
      else:
        self.header.frame_id = str[start:end]
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.infos = []
      for i in range(0, length):
        val1 = spencer_tracking_msgs.msg.ImmDebugInfo()
        _x = val1
        start = end
        end += 48
        (_x.track_id, _x.innovation, _x.CpXX, _x.CpYY, _x.CXX, _x.CYY,) = _get_struct_Q5d().unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sd'%length
        start = end
        end += struct.calcsize(pattern)
        val1.modeProbabilities = struct.unpack(pattern, str[start:end])
        self.infos.append(val1)
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e) #most likely buffer underfill


  def serialize_numpy(self, buff, numpy):
    """
    serialize message with numpy array types into buffer
    :param buff: buffer, ``StringIO``
    :param numpy: numpy python module
    """
    try:
      _x = self
      buff.write(_get_struct_3I().pack(_x.header.seq, _x.header.stamp.secs, _x.header.stamp.nsecs))
      _x = self.header.frame_id
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.pack('<I%ss'%length, length, _x))
      length = len(self.infos)
      buff.write(_struct_I.pack(length))
      for val1 in self.infos:
        _x = val1
        buff.write(_get_struct_Q5d().pack(_x.track_id, _x.innovation, _x.CpXX, _x.CpYY, _x.CXX, _x.CYY))
        length = len(val1.modeProbabilities)
        buff.write(_struct_I.pack(length))
        pattern = '<%sd'%length
        buff.write(val1.modeProbabilities.tostring())
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize_numpy(self, str, numpy):
    """
    unpack serialized message in str into this message instance using numpy for array types
    :param str: byte array of serialized message, ``str``
    :param numpy: numpy python module
    """
    try:
      if self.header is None:
        self.header = std_msgs.msg.Header()
      if self.infos is None:
        self.infos = None
      end = 0
      _x = self
      start = end
      end += 12
      (_x.header.seq, _x.header.stamp.secs, _x.header.stamp.nsecs,) = _get_struct_3I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.header.frame_id = str[start:end].decode('utf-8')
      else:
        self.header.frame_id = str[start:end]
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.infos = []
      for i in range(0, length):
        val1 = spencer_tracking_msgs.msg.ImmDebugInfo()
        _x = val1
        start = end
        end += 48
        (_x.track_id, _x.innovation, _x.CpXX, _x.CpYY, _x.CXX, _x.CYY,) = _get_struct_Q5d().unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sd'%length
        start = end
        end += struct.calcsize(pattern)
        val1.modeProbabilities = numpy.frombuffer(str[start:end], dtype=numpy.float64, count=length)
        self.infos.append(val1)
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e) #most likely buffer underfill

_struct_I = genpy.struct_I
def _get_struct_I():
    global _struct_I
    return _struct_I
_struct_3I = None
def _get_struct_3I():
    global _struct_3I
    if _struct_3I is None:
        _struct_3I = struct.Struct("<3I")
    return _struct_3I
_struct_Q5d = None
def _get_struct_Q5d():
    global _struct_Q5d
    if _struct_Q5d is None:
        _struct_Q5d = struct.Struct("<Q5d")
    return _struct_Q5d
