# This Python file uses the following encoding: utf-8
"""autogenerated by genpy from spencer_tracking_msgs/CompositeDetectedPerson.msg. Do not edit."""
import sys
python3 = True if sys.hexversion > 0x03000000 else False
import genpy
import struct

import geometry_msgs.msg
import spencer_tracking_msgs.msg

class CompositeDetectedPerson(genpy.Message):
  _md5sum = "10e83f06a9bfbf6da1ae6f0fcdbe2cc4"
  _type = "spencer_tracking_msgs/CompositeDetectedPerson"
  _has_header = False #flag to mark the presence of a Header object
  _full_text = """# Specifies which detected persons have been merged into a composite detection by the spencer_detected_person_association module.

# TODO: Do we need a composite person-specific timestamp (or even a full message header including frame ID)?
# Having a separate timestamp per person could be useful if the timestamps of the merged DetectedPersons messages vary a lot,
# and some persons are only seen by a single sensor (so averaging over all input timestamps would have a detrimental effect). 

uint64      composite_detection_id          # ID of the fused detection

float64     mean_confidence                 # mean of the confidences of the original detections
float64     max_confidence                  # maximum confidence of original detections
float64     min_confidence                  # minimum confidence of original detections


geometry_msgs/PoseWithCovariance    pose    # Merged 3D pose (position + orientation) of the detection center
                                            # check covariance to see which dimensions are actually set!
                                            # unset dimensions shall have a covariance > 9999

DetectedPerson[] original_detections        # The original detections from individual sensor-specific detectors that have been combined into a composite detection
                                            # We are copying the entire DetectedPersons messages, *with poses transformed into the target frame*, such that subscribers
                                            # do not have to subscribe to all the original DetectedPersons topics.
================================================================================
MSG: geometry_msgs/PoseWithCovariance
# This represents a pose in free space with uncertainty.

Pose pose

# Row-major representation of the 6x6 covariance matrix
# The orientation parameters use a fixed-axis representation.
# In order, the parameters are:
# (x, y, z, rotation about X axis, rotation about Y axis, rotation about Z axis)
float64[36] covariance

================================================================================
MSG: geometry_msgs/Pose
# A representation of pose in free space, composed of position and orientation. 
Point position
Quaternion orientation

================================================================================
MSG: geometry_msgs/Point
# This contains the position of a point in free space
float64 x
float64 y
float64 z

================================================================================
MSG: geometry_msgs/Quaternion
# This represents an orientation in free space in quaternion form.

float64 x
float64 y
float64 z
float64 w

================================================================================
MSG: spencer_tracking_msgs/DetectedPerson
# Message describing a detection of a person
#

# Unique id of the detection, monotonically increasing over time
uint64          detection_id

# (Pseudo-)probabilistic value between 0.0 and 1.0 describing the detector's confidence in the detection
float64         confidence

# 3D pose (position + orientation) of the *center* of the detection
# check covariance to see which dimensions are actually set! unset dimensions shall have a covariance > 9999
geometry_msgs/PoseWithCovariance    pose    

# Sensor modality / detector type, see example constants below. 
# used e.g. later in tracking to check which tracks have been visually confirmed
string          modality            

                                    
string          MODALITY_GENERIC_LASER_2D = laser2d
string          MODALITY_GENERIC_LASER_3D = laser3d
string          MODALITY_GENERIC_MONOCULAR_VISION = mono
string          MODALITY_GENERIC_STEREO_VISION = stereo
string          MODALITY_GENERIC_RGBD = rgbd
"""
  __slots__ = ['composite_detection_id','mean_confidence','max_confidence','min_confidence','pose','original_detections']
  _slot_types = ['uint64','float64','float64','float64','geometry_msgs/PoseWithCovariance','spencer_tracking_msgs/DetectedPerson[]']

  def __init__(self, *args, **kwds):
    """
    Constructor. Any message fields that are implicitly/explicitly
    set to None will be assigned a default value. The recommend
    use is keyword arguments as this is more robust to future message
    changes.  You cannot mix in-order arguments and keyword arguments.

    The available fields are:
       composite_detection_id,mean_confidence,max_confidence,min_confidence,pose,original_detections

    :param args: complete set of field values, in .msg order
    :param kwds: use keyword arguments corresponding to message field names
    to set specific fields.
    """
    if args or kwds:
      super(CompositeDetectedPerson, self).__init__(*args, **kwds)
      #message fields cannot be None, assign default values for those that are
      if self.composite_detection_id is None:
        self.composite_detection_id = 0
      if self.mean_confidence is None:
        self.mean_confidence = 0.
      if self.max_confidence is None:
        self.max_confidence = 0.
      if self.min_confidence is None:
        self.min_confidence = 0.
      if self.pose is None:
        self.pose = geometry_msgs.msg.PoseWithCovariance()
      if self.original_detections is None:
        self.original_detections = []
    else:
      self.composite_detection_id = 0
      self.mean_confidence = 0.
      self.max_confidence = 0.
      self.min_confidence = 0.
      self.pose = geometry_msgs.msg.PoseWithCovariance()
      self.original_detections = []

  def _get_types(self):
    """
    internal API method
    """
    return self._slot_types

  def serialize(self, buff):
    """
    serialize message into buffer
    :param buff: buffer, ``StringIO``
    """
    try:
      _x = self
      buff.write(_get_struct_Q10d().pack(_x.composite_detection_id, _x.mean_confidence, _x.max_confidence, _x.min_confidence, _x.pose.pose.position.x, _x.pose.pose.position.y, _x.pose.pose.position.z, _x.pose.pose.orientation.x, _x.pose.pose.orientation.y, _x.pose.pose.orientation.z, _x.pose.pose.orientation.w))
      buff.write(_get_struct_36d().pack(*self.pose.covariance))
      length = len(self.original_detections)
      buff.write(_struct_I.pack(length))
      for val1 in self.original_detections:
        _x = val1
        buff.write(_get_struct_Qd().pack(_x.detection_id, _x.confidence))
        _v1 = val1.pose
        _v2 = _v1.pose
        _v3 = _v2.position
        _x = _v3
        buff.write(_get_struct_3d().pack(_x.x, _x.y, _x.z))
        _v4 = _v2.orientation
        _x = _v4
        buff.write(_get_struct_4d().pack(_x.x, _x.y, _x.z, _x.w))
        buff.write(_get_struct_36d().pack(*_v1.covariance))
        _x = val1.modality
        length = len(_x)
        if python3 or type(_x) == unicode:
          _x = _x.encode('utf-8')
          length = len(_x)
        buff.write(struct.pack('<I%ss'%length, length, _x))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize(self, str):
    """
    unpack serialized message in str into this message instance
    :param str: byte array of serialized message, ``str``
    """
    try:
      if self.pose is None:
        self.pose = geometry_msgs.msg.PoseWithCovariance()
      if self.original_detections is None:
        self.original_detections = None
      end = 0
      _x = self
      start = end
      end += 88
      (_x.composite_detection_id, _x.mean_confidence, _x.max_confidence, _x.min_confidence, _x.pose.pose.position.x, _x.pose.pose.position.y, _x.pose.pose.position.z, _x.pose.pose.orientation.x, _x.pose.pose.orientation.y, _x.pose.pose.orientation.z, _x.pose.pose.orientation.w,) = _get_struct_Q10d().unpack(str[start:end])
      start = end
      end += 288
      self.pose.covariance = _get_struct_36d().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.original_detections = []
      for i in range(0, length):
        val1 = spencer_tracking_msgs.msg.DetectedPerson()
        _x = val1
        start = end
        end += 16
        (_x.detection_id, _x.confidence,) = _get_struct_Qd().unpack(str[start:end])
        _v5 = val1.pose
        _v6 = _v5.pose
        _v7 = _v6.position
        _x = _v7
        start = end
        end += 24
        (_x.x, _x.y, _x.z,) = _get_struct_3d().unpack(str[start:end])
        _v8 = _v6.orientation
        _x = _v8
        start = end
        end += 32
        (_x.x, _x.y, _x.z, _x.w,) = _get_struct_4d().unpack(str[start:end])
        start = end
        end += 288
        _v5.covariance = _get_struct_36d().unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          val1.modality = str[start:end].decode('utf-8')
        else:
          val1.modality = str[start:end]
        self.original_detections.append(val1)
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e) #most likely buffer underfill


  def serialize_numpy(self, buff, numpy):
    """
    serialize message with numpy array types into buffer
    :param buff: buffer, ``StringIO``
    :param numpy: numpy python module
    """
    try:
      _x = self
      buff.write(_get_struct_Q10d().pack(_x.composite_detection_id, _x.mean_confidence, _x.max_confidence, _x.min_confidence, _x.pose.pose.position.x, _x.pose.pose.position.y, _x.pose.pose.position.z, _x.pose.pose.orientation.x, _x.pose.pose.orientation.y, _x.pose.pose.orientation.z, _x.pose.pose.orientation.w))
      buff.write(self.pose.covariance.tostring())
      length = len(self.original_detections)
      buff.write(_struct_I.pack(length))
      for val1 in self.original_detections:
        _x = val1
        buff.write(_get_struct_Qd().pack(_x.detection_id, _x.confidence))
        _v9 = val1.pose
        _v10 = _v9.pose
        _v11 = _v10.position
        _x = _v11
        buff.write(_get_struct_3d().pack(_x.x, _x.y, _x.z))
        _v12 = _v10.orientation
        _x = _v12
        buff.write(_get_struct_4d().pack(_x.x, _x.y, _x.z, _x.w))
        buff.write(_v9.covariance.tostring())
        _x = val1.modality
        length = len(_x)
        if python3 or type(_x) == unicode:
          _x = _x.encode('utf-8')
          length = len(_x)
        buff.write(struct.pack('<I%ss'%length, length, _x))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize_numpy(self, str, numpy):
    """
    unpack serialized message in str into this message instance using numpy for array types
    :param str: byte array of serialized message, ``str``
    :param numpy: numpy python module
    """
    try:
      if self.pose is None:
        self.pose = geometry_msgs.msg.PoseWithCovariance()
      if self.original_detections is None:
        self.original_detections = None
      end = 0
      _x = self
      start = end
      end += 88
      (_x.composite_detection_id, _x.mean_confidence, _x.max_confidence, _x.min_confidence, _x.pose.pose.position.x, _x.pose.pose.position.y, _x.pose.pose.position.z, _x.pose.pose.orientation.x, _x.pose.pose.orientation.y, _x.pose.pose.orientation.z, _x.pose.pose.orientation.w,) = _get_struct_Q10d().unpack(str[start:end])
      start = end
      end += 288
      self.pose.covariance = numpy.frombuffer(str[start:end], dtype=numpy.float64, count=36)
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.original_detections = []
      for i in range(0, length):
        val1 = spencer_tracking_msgs.msg.DetectedPerson()
        _x = val1
        start = end
        end += 16
        (_x.detection_id, _x.confidence,) = _get_struct_Qd().unpack(str[start:end])
        _v13 = val1.pose
        _v14 = _v13.pose
        _v15 = _v14.position
        _x = _v15
        start = end
        end += 24
        (_x.x, _x.y, _x.z,) = _get_struct_3d().unpack(str[start:end])
        _v16 = _v14.orientation
        _x = _v16
        start = end
        end += 32
        (_x.x, _x.y, _x.z, _x.w,) = _get_struct_4d().unpack(str[start:end])
        start = end
        end += 288
        _v13.covariance = numpy.frombuffer(str[start:end], dtype=numpy.float64, count=36)
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          val1.modality = str[start:end].decode('utf-8')
        else:
          val1.modality = str[start:end]
        self.original_detections.append(val1)
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e) #most likely buffer underfill

_struct_I = genpy.struct_I
def _get_struct_I():
    global _struct_I
    return _struct_I
_struct_4d = None
def _get_struct_4d():
    global _struct_4d
    if _struct_4d is None:
        _struct_4d = struct.Struct("<4d")
    return _struct_4d
_struct_Q10d = None
def _get_struct_Q10d():
    global _struct_Q10d
    if _struct_Q10d is None:
        _struct_Q10d = struct.Struct("<Q10d")
    return _struct_Q10d
_struct_3d = None
def _get_struct_3d():
    global _struct_3d
    if _struct_3d is None:
        _struct_3d = struct.Struct("<3d")
    return _struct_3d
_struct_36d = None
def _get_struct_36d():
    global _struct_36d
    if _struct_36d is None:
        _struct_36d = struct.Struct("<36d")
    return _struct_36d
_struct_Qd = None
def _get_struct_Qd():
    global _struct_Qd
    if _struct_Qd is None:
        _struct_Qd = struct.Struct("<Qd")
    return _struct_Qd
