# Generated by Django 3.2.14 on 2022-07-21 18:36


from django.db import migrations

from inventory.parent_tree import ValuesListTree


def update_model(apps, model_name):
    MyModel = apps.get_model('inventory', model_name)

    values = MyModel.objects.all().values('pk', 'name', 'parent__pk', 'path')
    tree = ValuesListTree(values=values)

    for node in tree.nodes:
        instance = MyModel.objects.get(pk=node.pk)
        instance.path = node.path
        instance.path_str = '/'.join(node.path)
        instance.level = len(node.path)
        instance.save(update_fields=('path', 'path_str', 'level'))


def forward_code(apps, schema_editor):
    update_model(apps, model_name='locationmodel')
    update_model(apps, model_name='itemmodel')


class Migration(migrations.Migration):

    dependencies = [
        ('inventory', '0011_parent_tree1'),
    ]

    operations = [
        migrations.RunPython(forward_code, reverse_code=migrations.RunPython.noop),
    ]
