/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.fed;

import java.util.ArrayList;
import java.util.concurrent.Future;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.fedplanner.FTypes;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.apache.sysds.runtime.controlprogram.federated.FederationMap;
import org.apache.sysds.runtime.controlprogram.federated.FederationUtils;
import org.apache.sysds.runtime.controlprogram.federated.MatrixLineagePair;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.DoubleObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;
import org.apache.sysds.runtime.instructions.fed.QuaternaryFEDInstruction;
import org.apache.sysds.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.matrix.operators.QuaternaryOperator;

public class QuaternaryWCeMMFEDInstruction
extends QuaternaryFEDInstruction {
    protected QuaternaryWCeMMFEDInstruction(Operator operator, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand in4, CPOperand out, String opcode, String instruction_str) {
        super(FEDInstruction.FEDType.Quaternary, operator, in1, in2, in3, in4, out, opcode, instruction_str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        CPOperand[] cPOperandArray;
        long[] varNewIn;
        ArrayList<FederatedRequest> frB;
        FederatedRequest[] frSliced;
        FederationMap fedMap;
        QuaternaryOperator qop = (QuaternaryOperator)this._optr;
        MatrixObject X = ec.getMatrixObject(this.input1);
        MatrixLineagePair U = ec.getMatrixLineagePair(this.input2);
        MatrixLineagePair V = ec.getMatrixLineagePair(this.input3);
        ScalarObject eps = null;
        if (qop.hasFourInputs()) {
            ScalarObject scalarObject = eps = this._input4.getDataType() == Types.DataType.SCALAR ? ec.getScalarInput(this._input4) : new DoubleObject(ec.getMatrixInput(this._input4.getName()).quickGetValue(0, 0));
        }
        if (X.isFederated()) {
            FederatedRequest tmpFr;
            fedMap = X.getFedMapping();
            frSliced = null;
            frB = new ArrayList<FederatedRequest>();
            varNewIn = new long[eps != null ? 4 : 3];
            varNewIn[0] = fedMap.getID();
            if (X.isFederated(FTypes.FType.ROW)) {
                if (U.isFederated(FTypes.FType.ROW) && fedMap.isAligned(U.getFedMapping(), FTypes.AlignType.ROW)) {
                    varNewIn[1] = U.getFedMapping().getID();
                } else {
                    frSliced = fedMap.broadcastSliced(U, false);
                    varNewIn[1] = frSliced[0].getID();
                }
                tmpFr = fedMap.broadcast(V);
                varNewIn[2] = tmpFr.getID();
                frB.add(tmpFr);
            } else if (X.isFederated(FTypes.FType.COL)) {
                tmpFr = fedMap.broadcast(U);
                varNewIn[1] = tmpFr.getID();
                frB.add(tmpFr);
                if (V.isFederated() && fedMap.isAligned(V.getFedMapping(), FTypes.AlignType.COL, FTypes.AlignType.COL_T)) {
                    varNewIn[2] = V.getFedMapping().getID();
                } else {
                    frSliced = fedMap.broadcastSliced(V, true);
                    varNewIn[2] = frSliced[0].getID();
                }
            } else {
                throw new DMLRuntimeException("Federated WCeMM only supported for ROW or COLUMN partitioned federated data.");
            }
            if (eps != null) {
                tmpFr = fedMap.broadcast(eps);
                varNewIn[3] = tmpFr.getID();
                frB.add(tmpFr);
                this.instString = this.instString.replace("true", "false");
            }
            if (eps == null) {
                CPOperand[] cPOperandArray2 = new CPOperand[3];
                cPOperandArray2[0] = this.input1;
                cPOperandArray2[1] = this.input2;
                cPOperandArray = cPOperandArray2;
                cPOperandArray2[2] = this.input3;
            } else {
                CPOperand[] cPOperandArray3 = new CPOperand[4];
                cPOperandArray3[0] = this.input1;
                cPOperandArray3[1] = this.input2;
                cPOperandArray3[2] = this.input3;
                cPOperandArray = cPOperandArray3;
                cPOperandArray3[3] = this._input4;
            }
        } else {
            throw new DMLRuntimeException("Unsupported federated inputs (X, U, V) = (" + X.isFederated() + ", " + U.isFederated() + ", " + V.isFederated() + ")");
        }
        FederatedRequest frComp = FederationUtils.callInstruction(this.instString, this.output, cPOperandArray, varNewIn);
        FederatedRequest frGet = new FederatedRequest(FederatedRequest.RequestType.GET_VAR, frComp.getID());
        ArrayList<FederatedRequest> frC = new ArrayList<FederatedRequest>();
        frC.add(fedMap.cleanup(this.getTID(), frComp.getID()));
        FederatedRequest[] frAll = (FederatedRequest[])ArrayUtils.addAll((Object[])((FederatedRequest[])ArrayUtils.addAll((Object[])frB.toArray(new FederatedRequest[0]), (Object[])new FederatedRequest[]{frComp, frGet})), (Object[])frC.toArray(new FederatedRequest[0]));
        Future<FederatedResponse>[] response = frSliced == null ? fedMap.execute(this.getTID(), true, frAll) : fedMap.execute(this.getTID(), true, frSliced, frAll);
        AggregateUnaryOperator aop = InstructionUtils.parseBasicAggregateUnaryOperator("uak+");
        ec.setVariable(this.output.getName(), FederationUtils.aggScalar(aop, response));
    }
}

