/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.caching;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.ByteBuffer;
import org.apache.sysds.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysds.runtime.controlprogram.caching.CacheEvictionQueue;
import org.apache.sysds.runtime.controlprogram.caching.CacheMaintenanceService;
import org.apache.sysds.runtime.controlprogram.caching.CacheStatistics;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.caching.LazyWriteBuffer;
import org.apache.sysds.runtime.util.LocalFileUtils;

public class UnifiedMemoryManager {
    private static long _limit;
    private static long _totCachedSize;
    private static long _opMemLimit;
    private static final List<String> _pinnedEntries;
    private static CacheEvictionQueue _mQueue;
    private static CacheMaintenanceService _fClean;
    private static long _pinnedPhysicalMemSize;
    private static long _pinnedVirtualMemSize;

    public static void pin(CacheableData<?> cd) {
        if (!CacheableData.isCachingActive()) {
            return;
        }
        long estimatedSize = OptimizerUtils.estimateSize(cd.getDataCharacteristics());
        if (UnifiedMemoryManager.probe(cd)) {
            _pinnedVirtualMemSize += estimatedSize;
        } else {
            UnifiedMemoryManager.makeSpace(estimatedSize);
            _pinnedPhysicalMemSize += estimatedSize;
        }
        _pinnedEntries.add(cd.getCacheFilePathAndName());
        UnifiedMemoryManager.reserveOutputMem();
    }

    public static void reserveOutputMem() {
        if (!OptimizerUtils.isUMMEnabled() || !CacheableData.isCachingActive()) {
            return;
        }
        long maxOutputSize = _opMemLimit - (_pinnedVirtualMemSize + _pinnedPhysicalMemSize);
        UnifiedMemoryManager.makeSpace(maxOutputSize);
    }

    public static void unpin(CacheableData<?> cd) {
        if (!CacheableData.isCachingActive()) {
            return;
        }
        if (!_pinnedEntries.contains(cd.getCacheFilePathAndName())) {
            return;
        }
        long estimatedSize = OptimizerUtils.estimateSize(cd.getDataCharacteristics());
        if (UnifiedMemoryManager.probe(cd)) {
            _pinnedVirtualMemSize -= estimatedSize;
        } else {
            _pinnedPhysicalMemSize -= estimatedSize;
        }
        _pinnedEntries.remove(cd.getCacheFilePathAndName());
    }

    public static void init() {
        _mQueue = new CacheEvictionQueue();
        _fClean = new CacheMaintenanceService();
        _limit = OptimizerUtils.getBufferPoolLimit();
        _opMemLimit = (long)OptimizerUtils.getLocalMemBudget();
        _totCachedSize = 0L;
        _pinnedPhysicalMemSize = 0L;
        _pinnedVirtualMemSize = 0L;
    }

    public static void cleanup() {
        if (_mQueue != null) {
            _mQueue.clear();
        }
        if (_fClean != null) {
            _fClean.close();
        }
        _totCachedSize = 0L;
        _pinnedPhysicalMemSize = 0L;
        _pinnedVirtualMemSize = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printStatus(String operation) {
        System.out.println("UMM STATUS AT " + operation + " --");
        CacheEvictionQueue cacheEvictionQueue = _mQueue;
        synchronized (cacheEvictionQueue) {
            System.out.println("\tUMM: Meta Data: UMM limit=" + _limit + ", size[bytes]=" + _totCachedSize + ", size[elements]=" + _mQueue.size() + ", pinned[elements]=" + _pinnedEntries.size() + ", pinned[bytes]=" + _pinnedPhysicalMemSize);
            int count = _mQueue.size();
            for (Map.Entry entry : _mQueue.entrySet()) {
                String fname = (String)entry.getKey();
                ByteBuffer bbuff = (ByteBuffer)entry.getValue();
                System.out.println("\tUMM: Cached element (" + count + "): " + fname + ", " + (bbuff.isShallow() ? bbuff._cdata.getClass().getSimpleName() : "?") + ", " + bbuff.getSize() + ", " + bbuff.isShallow());
                --count;
            }
        }
    }

    public static void setUMMLimit(long val) {
        _limit = val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getUMMSize() {
        CacheEvictionQueue cacheEvictionQueue = _mQueue;
        synchronized (cacheEvictionQueue) {
            return _limit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getUMMFree() {
        CacheEvictionQueue cacheEvictionQueue = _mQueue;
        synchronized (cacheEvictionQueue) {
            return _limit - (_totCachedSize + _pinnedPhysicalMemSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheBlock readBlock(String fname, boolean matrix) throws IOException {
        CacheBlock cb = null;
        ByteBuffer ldata = null;
        CacheEvictionQueue cacheEvictionQueue = _mQueue;
        synchronized (cacheEvictionQueue) {
            ldata = (ByteBuffer)_mQueue.get(fname);
            if (CacheableData.CACHING_BUFFER_POLICY == LazyWriteBuffer.RPolicy.LRU && ldata != null) {
                _mQueue.remove(fname);
                _mQueue.addLast(fname, ldata);
            }
        }
        if (ldata != null) {
            cb = ldata.deserializeBlock();
            if (DMLScript.STATISTICS) {
                CacheStatistics.incrementFSBuffHits();
            }
        } else {
            cb = LocalFileUtils.readCacheBlockFromLocal(fname, matrix);
            if (DMLScript.STATISTICS) {
                CacheStatistics.incrementFSHits();
            }
        }
        return cb;
    }

    public static boolean probe(CacheableData<?> cd) {
        String filePath = cd.getCacheFilePathAndName();
        return _mQueue.containsKey(filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int makeSpace(long reqSpace) {
        int numEvicted = 0;
        if (UnifiedMemoryManager.getUMMFree() > reqSpace) {
            return numEvicted;
        }
        try {
            CacheEvictionQueue cacheEvictionQueue = _mQueue;
            synchronized (cacheEvictionQueue) {
                while (UnifiedMemoryManager.getUMMFree() < reqSpace && !_mQueue.isEmpty()) {
                    Map.Entry<String, ByteBuffer> entry = _mQueue.removeFirstUnpinned(_pinnedEntries);
                    String ftmp = entry.getKey();
                    ByteBuffer bb = entry.getValue();
                    if (bb == null) continue;
                    bb.checkSerialized();
                    bb.evictBuffer(ftmp);
                    bb.freeMemory();
                    _totCachedSize -= bb.getSize();
                    ++numEvicted;
                }
            }
        }
        catch (Exception e) {
            throw new DMLRuntimeException("Eviction request of size " + (reqSpace - UnifiedMemoryManager.getUMMFree()) + " in the UMM failed.", e);
        }
        if (DMLScript.STATISTICS) {
            CacheStatistics.incrementFSWrites(numEvicted);
        }
        return numEvicted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int writeBlock(String fname, CacheBlock cb) throws IOException {
        long lSize = UnifiedMemoryManager.getCacheBlockSize(cb);
        boolean requiresWrite = lSize > _limit || !ByteBuffer.isValidCapacity(lSize, cb);
        int numEvicted = 0;
        if (!requiresWrite) {
            ByteBuffer bbuff = new ByteBuffer(lSize);
            CacheEvictionQueue cacheEvictionQueue = _mQueue;
            synchronized (cacheEvictionQueue) {
                numEvicted += UnifiedMemoryManager.makeSpace(lSize);
                _mQueue.addLast(fname, bbuff);
                _totCachedSize += lSize;
            }
            _fClean.serializeData(bbuff, cb);
            if (DMLScript.STATISTICS) {
                CacheStatistics.incrementBPoolWrites();
            }
        } else {
            LocalFileUtils.writeCacheBlockToLocal(fname, cb);
            if (DMLScript.STATISTICS) {
                CacheStatistics.incrementFSWrites();
            }
            ++numEvicted;
        }
        return numEvicted;
    }

    public static long getCacheBlockSize(CacheBlock cb) {
        return cb.isShallowSerialize() ? cb.getInMemorySize() : cb.getExactSerializedSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteBlock(String fname) {
        boolean requiresDelete = true;
        CacheEvictionQueue cacheEvictionQueue = _mQueue;
        synchronized (cacheEvictionQueue) {
            ByteBuffer ldata = (ByteBuffer)_mQueue.remove(fname);
            if (ldata != null) {
                _totCachedSize -= ldata.getSize();
                requiresDelete = false;
                ldata.freeMemory();
            }
        }
        if (requiresDelete) {
            _fClean.deleteFile(fname);
        }
    }

    public void deleteAll() {
        throw new NotImplementedException();
    }

    public static void forceEviction() throws IOException {
        while (!_mQueue.isEmpty()) {
            Map.Entry<String, ByteBuffer> entry = _mQueue.removeFirst();
            ByteBuffer tmp = entry.getValue();
            if (tmp == null) continue;
            tmp.checkSerialized();
            tmp.evictBuffer(entry.getKey());
            tmp.freeMemory();
        }
    }

    static {
        _pinnedEntries = new ArrayList<String>();
        _pinnedPhysicalMemSize = 0L;
        _pinnedVirtualMemSize = 0L;
    }
}

